/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.validator;

import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.Proprietario;
import com.google.common.base.Strings;
import java.util.List;
import org.springframework.validation.Errors;

/*
 * Exception performing whole class analysis ignored.
 */
public final class CadastroGeralValidator {
    private CadastroGeralValidator() {
    }

    public static void validaCepCadastro(Errors errors, Long cep, Boolean validaCepCadastro) {
        if (validaCepCadastro.booleanValue() && cep == null) {
            errors.reject("CEP nulo", "Valor do CEP n\u00e3o pode ser nulo.");
        }
    }

    public static void validaEnderecoEntregaCarneAnual(Errors errors, CadastroGeral cadastroGeral) {
        if (cadastroGeral.getEnderecoEntregaCarneAnual().booleanValue()) {
            CadastroGeralValidator.validaEnderecoCorrespondencia((Errors)errors, (CadastroGeral)cadastroGeral);
            CadastroGeralValidator.validaNumeroCorrespondencia((Errors)errors, (CadastroGeral)cadastroGeral);
            CadastroGeralValidator.validaBairroCorrespondencia((Errors)errors, (CadastroGeral)cadastroGeral);
            CadastroGeralValidator.validaCepCorrespondencia((Errors)errors, (CadastroGeral)cadastroGeral);
            CadastroGeralValidator.validaCidadeCorrespondencia((Errors)errors, (CadastroGeral)cadastroGeral);
        }
    }

    public static void validaPessoaIgualProprietarioPrincipal(Errors errors, CadastroGeral cadastroGeral) {
        cadastroGeral.getProprietarios().stream().filter(proprietario -> proprietario.getPrincipal() != false && !proprietario.getPessoa().equals((Object)cadastroGeral.getPessoa())).findFirst().ifPresent(proprietario -> errors.reject("Pessoa incorreta", "A pessoa do cadastro geral deve ser a mesma marcada como principal nos propriet\u00e1rios."));
    }

    public static void validaProprietarioPrincipal(Errors errors, List<Proprietario> proprietarios) {
        if (!proprietarios.stream().filter(Proprietario::getPrincipal).findFirst().isPresent()) {
            errors.reject("Propriet\u00e1rio principal n\u00e3o informado.", "Informar o propriet\u00e1rio principal.");
        }
    }

    public static void validaTamanhoCadastroGeral(Errors errors, Long cadastroGeral, Long tamanhoCadastroGeral) {
        if ((long)cadastroGeral.toString().length() > tamanhoCadastroGeral) {
            errors.reject("Tamanho do Cadastro Geral inv\u00e1lido", "O c\u00f3digo do cadastro ultrapassa a quantidade de digitos permitido.");
        }
    }

    private static void validaCidadeCorrespondencia(Errors errors, CadastroGeral cadastroGeral) {
        if (Strings.isNullOrEmpty((String)cadastroGeral.getCidadeUfCorrespondencia())) {
            errors.reject("Cidade/UF Correspond\u00eancia Nulo", "Informe o campo Cidade/UF correspond\u00eancia.");
        }
    }

    private static void validaCepCorrespondencia(Errors errors, CadastroGeral cadastroGeral) {
        if (Strings.isNullOrEmpty((String)cadastroGeral.getCepCorrespondencia())) {
            errors.reject("CEP Correspond\u00eancia Nulo", "Informe o campo CEP correspond\u00eancia.");
        }
    }

    private static void validaBairroCorrespondencia(Errors errors, CadastroGeral cadastroGeral) {
        if (Strings.isNullOrEmpty((String)cadastroGeral.getBairroCorrespondencia())) {
            errors.reject("Bairro Correspond\u00eancia Nulo", "Informe o campo bairro correspond\u00eancia.");
        }
    }

    private static void validaNumeroCorrespondencia(Errors errors, CadastroGeral cadastroGeral) {
        if (Strings.isNullOrEmpty((String)cadastroGeral.getNumeroCorrespondencia())) {
            errors.reject("N\u00famero Correspond\u00eancia Nulo", "Informe o campo n\u00famero correspond\u00eancia.");
        }
    }

    private static void validaEnderecoCorrespondencia(Errors errors, CadastroGeral cadastroGeral) {
        if (Strings.isNullOrEmpty((String)cadastroGeral.getEnderecoCorrespondencia())) {
            errors.reject("Endere\u00e7o Correspond\u00eancia Nulo", "Informe o campo endere\u00e7o correspond\u00eancia.");
        }
    }
}

