/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.ws.rest;

import br.com.elotech.tributos.config.HttpEntityFactory;
import br.com.elotech.tributos.config.TributosProperties;
import br.com.elotech.tributos.domain.Bloqueto;
import br.com.elotech.tributos.dto.DebitoDTO;
import br.com.elotech.tributos.dto.mobile.DebitoBloquetoMobileDTO;
import br.com.elotech.tributos.repository.BloquetoRepository;
import br.com.elotech.tributos.service.AiseBloquetoService;
import br.com.elotech.tributos.service.mobile.DebitoMobileService;
import br.com.elotech.tributos.service.ws.AisePdfService;
import br.com.elotech.tributos.service.ws.rest.AiseLoginServiceRest;
import br.com.elotech.tributos.ws.domain.LoginRespostaRest;
import br.com.elotech.tributos.ws.mapper.AiseWSMapper;
import br.com.elotech.tributos.ws.rest.dto.BloquetoDTO;
import br.com.elotech.tributos.ws.rest.dto.DebitoItbiDTO;
import java.time.LocalDate;
import java.util.List;
import org.springframework.context.annotation.Profile;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
@Profile(value={"rest"})
public class AiseBloquetoServiceRest
implements AiseBloquetoService {
    private final RestTemplate restTemplate;
    private final AiseLoginServiceRest aiseLoginServiceRest;
    private final AiseWSMapper aiseWSMapper;
    private final DebitoMobileService debitoMobileService;
    private final AisePdfService aisePdfService;
    private final BloquetoRepository bloquetoRepository;
    private final String urlGeracaoBloqueto;

    public AiseBloquetoServiceRest(RestTemplate restTemplate, AiseLoginServiceRest aiseLoginServiceRest, TributosProperties tributosProperties, AiseWSMapper aiseWSMapper, DebitoMobileService debitoMobileService, AisePdfService aisePdfService, BloquetoRepository bloquetoRepository) {
        this.restTemplate = restTemplate;
        this.aiseLoginServiceRest = aiseLoginServiceRest;
        this.aiseWSMapper = aiseWSMapper;
        this.debitoMobileService = debitoMobileService;
        this.aisePdfService = aisePdfService;
        this.bloquetoRepository = bloquetoRepository;
        this.urlGeracaoBloqueto = tributosProperties.getAise().getBaseUrl() + "/datasnap/rest/tbloquetos/gerar/";
    }

    public BloquetoDTO geraBloqueto(List<DebitoDTO> debitosMarcados) {
        LoginRespostaRest loginResposta = this.aiseLoginServiceRest.login();
        HttpHeaders headers = this.getHttpHeaders(loginResposta);
        String debitosDelphi = this.aiseWSMapper.toEnvioRest(debitosMarcados);
        ResponseEntity response = this.geraDebitoAise(headers, debitosDelphi);
        BloquetoDTO bloquetoDTO = (BloquetoDTO)response.getBody();
        bloquetoDTO.setUrlImpressao(this.getUrlImpressao(bloquetoDTO.getBloqueto()));
        return bloquetoDTO;
    }

    private String getUrlImpressao(Long bloqueto) {
        return this.aisePdfService.fetchBloqueto(bloqueto);
    }

    public BloquetoDTO geraBloquetoPorListaDebito(List<DebitoBloquetoMobileDTO> debitosSelecionados) {
        LoginRespostaRest loginResposta = this.aiseLoginServiceRest.login();
        HttpHeaders headers = this.getHttpHeaders(loginResposta);
        List debitos = this.debitoMobileService.getDebitoBloquetoPorListaDebito(debitosSelecionados);
        String debitosDelphi = this.aiseWSMapper.toEnvioRest(debitos);
        ResponseEntity response = this.restTemplate.exchange(this.urlGeracaoBloqueto, HttpMethod.POST, HttpEntityFactory.createHttpEntity((Object)debitosDelphi, (HttpHeaders)headers), BloquetoDTO.class, new Object[0]);
        BloquetoDTO bloquetoDTO = (BloquetoDTO)response.getBody();
        bloquetoDTO.setUrlImpressao(this.getUrlImpressao(bloquetoDTO.getBloqueto()));
        Bloqueto bloqueto = this.bloquetoRepository.findByBloqueto(bloquetoDTO.getEntidade(), bloquetoDTO.getExercicioBloqueto(), bloquetoDTO.getBloqueto());
        bloquetoDTO.setId(bloqueto.getId());
        bloquetoDTO.setCodigoValidacao(bloqueto.getCodigoValidacao());
        return bloquetoDTO;
    }

    private HttpHeaders getHttpHeaders(LoginRespostaRest loginResposta) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("Authorization", "Bearer " + loginResposta.getIdToken());
        return headers;
    }

    public BloquetoDTO geraBloquetoPorDataPagamento(List<DebitoDTO> debitosMarcados, LocalDate dataPagamento) {
        LoginRespostaRest loginResposta = this.aiseLoginServiceRest.login();
        HttpHeaders headers = this.getHttpHeaders(loginResposta);
        String debitosDelphi = this.aiseWSMapper.toEnvioRest(debitosMarcados, dataPagamento);
        ResponseEntity response = this.geraDebitoAise(headers, debitosDelphi);
        BloquetoDTO bloquetoDTO = (BloquetoDTO)response.getBody();
        bloquetoDTO.setUrlImpressao(this.getUrlImpressao(bloquetoDTO.getBloqueto()));
        return bloquetoDTO;
    }

    private ResponseEntity<BloquetoDTO> geraDebitoAise(HttpHeaders headers, String debitosDelphi) {
        return this.restTemplate.exchange(this.urlGeracaoBloqueto, HttpMethod.POST, HttpEntityFactory.createHttpEntity((Object)debitosDelphi, (HttpHeaders)headers), BloquetoDTO.class, new Object[0]);
    }

    public BloquetoDTO geraBloquetoItbi(DebitoItbiDTO debitoItbi) {
        LoginRespostaRest loginResposta = this.aiseLoginServiceRest.login();
        HttpHeaders headers = this.getHttpHeaders(loginResposta);
        List debitos = this.debitoMobileService.getDebitoBloquetoPorIdDebito(DebitoBloquetoMobileDTO.from((DebitoItbiDTO)debitoItbi));
        String debitosDelphi = this.aiseWSMapper.toEnvioRest(debitos);
        BloquetoDTO bloquetoDTO = (BloquetoDTO)this.restTemplate.exchange(this.urlGeracaoBloqueto, HttpMethod.POST, HttpEntityFactory.createHttpEntity((Object)debitosDelphi, (HttpHeaders)headers), BloquetoDTO.class, new Object[0]).getBody();
        Bloqueto bloqueto = this.bloquetoRepository.findByBloqueto(bloquetoDTO.getEntidade(), bloquetoDTO.getExercicioBloqueto(), bloquetoDTO.getBloqueto());
        bloquetoDTO.setUrlImpressao(this.aisePdfService.fetchBloquetoItbi(bloquetoDTO.getBloqueto(), debitoItbi.getIdSequencia(), debitoItbi.getTipoRelatorioBloqueto().getTipo(), debitoItbi.getRelatorioBloqueto()));
        bloquetoDTO.setId(bloqueto.getId());
        bloquetoDTO.setCodigoValidacao(bloqueto.getCodigoValidacao());
        return bloquetoDTO;
    }
}

