/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.ws.impl;

import br.com.elotech.tributos.dto.DebitoAutomaticoDTO;
import br.com.elotech.tributos.dto.DebitoDTO;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;

public class DebitosToDebitoAutomatico
implements Function<DebitoDTO, DebitoAutomaticoDTO> {
    @Override
    public DebitoAutomaticoDTO apply(DebitoDTO debitoDTO) {
        DebitoAutomaticoDTO.DebitoAutomaticoPKDTO pk = DebitoAutomaticoDTO.DebitoAutomaticoPKDTO.builder().tipoCadastro(debitoDTO.getTipoCadastro()).cadastroGeral(debitoDTO.getCadastroGeral()).entidade(debitoDTO.getEntidade()).exercicio(debitoDTO.getExercicio()).guiaRecolhimento(debitoDTO.getGuiaRecolhimento()).subDivida(debitoDTO.getSubDivida()).build();
        return DebitoAutomaticoDTO.builder().pk(pk).descricaoGuia(debitoDTO.getDescricaoGuia()).nome(debitoDTO.getNome()).pessoa(debitoDTO.getPessoa()).valor(debitoDTO.getValor()).build();
    }

    public List<DebitoAutomaticoDTO> agruparESomar(List<DebitoDTO> debitosDto) {
        Comparator<DebitoAutomaticoDTO> orderComparator = Comparator.comparing(DebitoAutomaticoDTO::getExercicio).thenComparing(DebitoAutomaticoDTO::getGuiaRecolhimento).thenComparing(DebitoAutomaticoDTO::getSubDivida);
        return debitosDto.stream().map(arg_0 -> this.apply(arg_0)).collect(Collectors.groupingBy(DebitoAutomaticoDTO::getPk, this.somandoValor())).values().stream().map(Optional::get).sorted(orderComparator).collect(Collectors.toList());
    }

    private Collector<DebitoAutomaticoDTO, ?, Optional<DebitoAutomaticoDTO>> somandoValor() {
        return Collectors.reducing((t, u) -> {
            t.setValor(t.getValor().add(u.getValor()));
            return t;
        });
    }
}

