/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.ws.impl;

import br.com.elotech.core.exception.JsonFormatException;
import br.com.elotech.tributos.dto.DebitoDTO;
import br.com.elotech.tributos.dto.DebitoHandler;
import br.com.elotech.tributos.dto.IdDebitoDTO;
import br.com.elotech.tributos.dto.mobile.DebitoMobileDTO;
import br.com.elotech.tributos.dto.mobile.DebitoParcelaMobileDTO;
import br.com.elotech.tributos.params.CadastroGeralParams;
import br.com.elotech.tributos.service.CadastroGeralService;
import br.com.elotech.tributos.service.DebitoService;
import br.com.elotech.tributos.service.ws.AiseLoginService;
import br.com.elotech.tributos.util.LoggerPrototype;
import br.com.elotech.tributos.ws.domain.GetDebitosEnvio;
import br.com.elotech.tributos.ws.domain.GetDebitosResposta;
import br.com.elotech.tributos.ws.domain.LoginResposta;
import br.com.elotech.tributos.ws.rest.dto.DebitoMapper;
import br.com.elotech.tributos.ws.rest.dto.DebitoTransportDTO;
import br.com.elotech.tributos.ws.rest.dto.GerarDebitoRequestDTO;
import br.com.elotech.tributos.ws.rest.dto.GerarDebitoResponseDTO;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Service;
import org.springframework.ws.client.core.WebServiceTemplate;

@Service
@Profile(value={"!rest"})
public class AiseDebitosServiceImpl
implements LoggerPrototype,
DebitoService {
    private final WebServiceTemplate aiseWebServiceTemplate;
    private final ObjectMapper objectMapper;
    private final DebitoMapper debitoMapper;
    private final AiseLoginService aiseLoginService;
    private final CadastroGeralService cadastroGeralService;
    private static final String METODO_NAO_IMPLEMENTADO = "Unsupported Operation.";

    public AiseDebitosServiceImpl(WebServiceTemplate aiseWebServiceTemplate, ObjectMapper objectMapper, DebitoMapper debitoMapper, AiseLoginService aiseLoginService, CadastroGeralService cadastroGeralService) {
        this.aiseWebServiceTemplate = aiseWebServiceTemplate;
        this.objectMapper = objectMapper;
        this.debitoMapper = debitoMapper;
        this.aiseLoginService = aiseLoginService;
        this.cadastroGeralService = cadastroGeralService;
    }

    public List<DebitoDTO> getDebitosAgrupados(CadastroGeralParams params) {
        LoginResposta loginResposta = this.aiseLoginService.login();
        this.cadastroGeralService.validaCadastroGeral(params.getTipoCadastro(), params.getCadastroGeral());
        GetDebitosEnvio wsParams = new GetDebitosEnvio();
        wsParams.setTipoCadastro(params.getTipoCadastro());
        wsParams.setCadastroGeral(params.getCadastroGeral());
        wsParams.setUserKey(loginResposta.getUserKey());
        List debitos = this.retornoAsObject((GetDebitosResposta)this.aiseWebServiceTemplate.marshalSendAndReceive((Object)wsParams));
        return DebitoHandler.agrupaContratoParcela((List)debitos);
    }

    public List<DebitoDTO> getDebitos(CadastroGeralParams params) {
        LoginResposta loginResposta = this.aiseLoginService.login();
        this.cadastroGeralService.validaCadastroGeral(params.getTipoCadastro(), params.getCadastroGeral());
        GetDebitosEnvio wsParams = new GetDebitosEnvio();
        wsParams.setTipoCadastro(params.getTipoCadastro());
        wsParams.setCadastroGeral(params.getCadastroGeral());
        wsParams.setUserKey(loginResposta.getUserKey());
        return this.retornoAsObject((GetDebitosResposta)this.aiseWebServiceTemplate.marshalSendAndReceive((Object)wsParams));
    }

    private List<DebitoDTO> retornoAsObject(GetDebitosResposta getDebitosResposta) {
        DebitoTransportDTO transport = null;
        try {
            transport = (DebitoTransportDTO)this.objectMapper.readValue(getDebitosResposta.getRetorno(), DebitoTransportDTO.class);
        }
        catch (IOException e) {
            this.logError(e.getLocalizedMessage(), (Throwable)e);
            throw new JsonFormatException("Erro recuperando objeto da mensagem", (Throwable)e);
        }
        return transport.getList().getItems().stream().map(arg_0 -> ((DebitoMapper)this.debitoMapper).toDebitoDTO(arg_0)).collect(Collectors.toList());
    }

    public List<DebitoMobileDTO> getDebitosMobile(CadastroGeralParams params) {
        throw new UnsupportedOperationException(METODO_NAO_IMPLEMENTADO);
    }

    public List<DebitoParcelaMobileDTO> getParcelas(Long idDebito) {
        throw new UnsupportedOperationException(METODO_NAO_IMPLEMENTADO);
    }

    public List<DebitoParcelaMobileDTO> getParcelasParcelamento(Long idParcelamento) {
        throw new UnsupportedOperationException(METODO_NAO_IMPLEMENTADO);
    }

    public GerarDebitoResponseDTO geraDebito(GerarDebitoRequestDTO debito) {
        throw new UnsupportedOperationException(METODO_NAO_IMPLEMENTADO);
    }

    public List<IdDebitoDTO> verificarPagos(List<IdDebitoDTO> listIdDebito) {
        throw new UnsupportedOperationException(METODO_NAO_IMPLEMENTADO);
    }
}

