/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.ws.impl;

import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.dto.DebitoAutomaticoDTO;
import br.com.elotech.tributos.dto.DebitoDTO;
import br.com.elotech.tributos.params.CadastroGeralParams;
import br.com.elotech.tributos.service.CadastroGeralService;
import br.com.elotech.tributos.service.DebitoAutomaticoService;
import br.com.elotech.tributos.service.ws.AiseLoginService;
import br.com.elotech.tributos.service.ws.impl.DebitosToDebitoAutomatico;
import br.com.elotech.tributos.util.LoggerPrototype;
import br.com.elotech.tributos.ws.domain.GetDebitosDebitoAutomaticoEnvio;
import br.com.elotech.tributos.ws.domain.GetDebitosDebitoAutomaticoResposta;
import br.com.elotech.tributos.ws.domain.LoginResposta;
import br.com.elotech.tributos.ws.rest.dto.DebitoMapper;
import br.com.elotech.tributos.ws.rest.dto.DebitoTransportDTO;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Service;
import org.springframework.ws.client.core.WebServiceTemplate;

@Service
@Profile(value={"!rest"})
public class AiseDebitosDebitoAutomaticoServiceImpl
implements LoggerPrototype,
DebitoAutomaticoService {
    private final WebServiceTemplate aiseWebServiceTemplate;
    private final ObjectMapper objectMapper;
    private final DebitoMapper debitoMapper;
    private final AiseLoginService aiseLoginService;
    private final CadastroGeralService cadastroGeralService;

    public AiseDebitosDebitoAutomaticoServiceImpl(WebServiceTemplate aiseWebServiceTemplate, ObjectMapper objectMapper, DebitoMapper debitoMapper, AiseLoginService aiseLoginService, CadastroGeralService cadastroGeralService) {
        this.aiseWebServiceTemplate = aiseWebServiceTemplate;
        this.objectMapper = objectMapper;
        this.debitoMapper = debitoMapper;
        this.aiseLoginService = aiseLoginService;
        this.cadastroGeralService = cadastroGeralService;
    }

    private List<DebitoDTO> getDebitos(CadastroGeralParams params) {
        LoginResposta loginResposta = this.aiseLoginService.login();
        this.cadastroGeralService.validaCadastroGeral(params.getTipoCadastro(), params.getCadastroGeral());
        GetDebitosDebitoAutomaticoEnvio wsParams = new GetDebitosDebitoAutomaticoEnvio();
        wsParams.setTipoCadastro(params.getTipoCadastro());
        wsParams.setCadastroGeral(params.getCadastroGeral());
        wsParams.setUserKey(loginResposta.getUserKey());
        return this.retornoAsObject((GetDebitosDebitoAutomaticoResposta)this.aiseWebServiceTemplate.marshalSendAndReceive((Object)wsParams));
    }

    private List<DebitoDTO> retornoAsObject(GetDebitosDebitoAutomaticoResposta getDebitosDebitoAutomaticoResposta) {
        DebitoTransportDTO transport = (DebitoTransportDTO)this.objectMapper.readValue(getDebitosDebitoAutomaticoResposta.getRetorno(), DebitoTransportDTO.class);
        if (transport == null) {
            return new ArrayList<DebitoDTO>();
        }
        return transport.getList().getItems().stream().map(arg_0 -> ((DebitoMapper)this.debitoMapper).toDebitoDTO(arg_0)).collect(Collectors.toList());
    }

    public List<DebitoAutomaticoDTO> getDebitosPassiveisDebitosAutomatico(CadastroGeralParams params) {
        List debitosDto = this.getDebitos(params);
        return new DebitosToDebitoAutomatico().agruparESomar(debitosDto);
    }

    public DebitoAutomaticoDTO getDebitoAutomatico(Long exercicio, TipoCadastro tipoCadastro, Long cadastroGeral, Long guiaRecolhimento, Long subDivida) {
        DebitoAutomaticoDTO debitoAutomaticoResult = new DebitoAutomaticoDTO();
        CadastroGeralParams params = new CadastroGeralParams();
        params.setTipoCadastro(tipoCadastro);
        params.setCadastroGeral(cadastroGeral);
        List listDebitoAutomatico = this.getDebitosPassiveisDebitosAutomatico(params);
        for (DebitoAutomaticoDTO debitoAutomaticoDTO : listDebitoAutomatico) {
            if (debitoAutomaticoDTO.getPk().getExercicio().longValue() != exercicio.longValue() || debitoAutomaticoDTO.getPk().getTipoCadastro().intValue() != tipoCadastro.getValue().intValue() || debitoAutomaticoDTO.getPk().getCadastroGeral().longValue() != cadastroGeral.longValue() || debitoAutomaticoDTO.getPk().getGuiaRecolhimento().longValue() != guiaRecolhimento.longValue() || debitoAutomaticoDTO.getPk().getSubDivida().longValue() != subDivida.longValue()) continue;
            debitoAutomaticoResult = debitoAutomaticoDTO;
        }
        return debitoAutomaticoResult;
    }
}

