/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.mobile;

import br.com.elotech.tributos.util.CalculoValoresResources;
import java.math.BigDecimal;

public class DebitoParcelaReceitaDTO {
    private Long idDebitoParcelaReceita;
    private Integer entidade;
    private Integer exercicio;
    private Integer tipoCadastro;
    private Integer cadastroGeral;
    private Integer guiaRecolhimento;
    private Integer subDivida;
    private Integer parcela;
    private String receita;
    private BigDecimal valor = BigDecimal.ZERO;
    private BigDecimal valorJuros = BigDecimal.ZERO;
    private BigDecimal valorMulta = BigDecimal.ZERO;
    private BigDecimal valorCorrecao = BigDecimal.ZERO;
    private BigDecimal valorDesconto = BigDecimal.ZERO;
    private BigDecimal valorDescontoJuros = BigDecimal.ZERO;
    private BigDecimal valorDescontoMulta = BigDecimal.ZERO;
    private BigDecimal valorDescontoCorrecao = BigDecimal.ZERO;
    private static final BigDecimal CEM = BigDecimal.valueOf(100L);

    public Long getIdDebitoParcelaReceita() {
        return this.idDebitoParcelaReceita;
    }

    public void setIdDebitoParcelaReceita(Long idDebitoParcelaReceita) {
        this.idDebitoParcelaReceita = idDebitoParcelaReceita;
    }

    public Integer getEntidade() {
        return this.entidade;
    }

    public void setEntidade(Integer entidade) {
        this.entidade = entidade;
    }

    public Integer getExercicio() {
        return this.exercicio;
    }

    public void setExercicio(Integer exercicio) {
        this.exercicio = exercicio;
    }

    public Integer getTipoCadastro() {
        return this.tipoCadastro;
    }

    public void setTipoCadastro(Integer tipoCadastro) {
        this.tipoCadastro = tipoCadastro;
    }

    public Integer getCadastroGeral() {
        return this.cadastroGeral;
    }

    public void setCadastroGeral(Integer cadastroGeral) {
        this.cadastroGeral = cadastroGeral;
    }

    public Integer getGuiaRecolhimento() {
        return this.guiaRecolhimento;
    }

    public void setGuiaRecolhimento(Integer guiaRecolhimento) {
        this.guiaRecolhimento = guiaRecolhimento;
    }

    public Integer getSubDivida() {
        return this.subDivida;
    }

    public void setSubDivida(Integer subDivida) {
        this.subDivida = subDivida;
    }

    public Integer getParcela() {
        return this.parcela;
    }

    public void setParcela(Integer parcela) {
        this.parcela = parcela;
    }

    public String getReceita() {
        return this.receita;
    }

    public void setReceita(String receita) {
        this.receita = receita;
    }

    public BigDecimal getValor() {
        return this.valor;
    }

    public void setValor(BigDecimal valor) {
        this.valor = valor;
    }

    public BigDecimal getValorJuros() {
        return this.valorJuros;
    }

    public void setValorJuros(BigDecimal valorJuros) {
        this.valorJuros = valorJuros;
    }

    public BigDecimal getValorMulta() {
        return this.valorMulta;
    }

    public void setValorMulta(BigDecimal valorMulta) {
        this.valorMulta = valorMulta;
    }

    public BigDecimal getValorCorrecao() {
        return this.valorCorrecao;
    }

    public void setValorCorrecao(BigDecimal valorCorrecao) {
        this.valorCorrecao = valorCorrecao;
    }

    public BigDecimal getValorDesconto() {
        return this.valorDesconto;
    }

    public void setValorDesconto(BigDecimal valorDesconto) {
        this.valorDesconto = valorDesconto;
    }

    public BigDecimal getValorDescontoJuros() {
        return this.valorDescontoJuros;
    }

    public void setValorDescontoJuros(BigDecimal valorDescontoJuros) {
        this.valorDescontoJuros = valorDescontoJuros;
    }

    public BigDecimal getValorDescontoMulta() {
        return this.valorDescontoMulta;
    }

    public void setValorDescontoMulta(BigDecimal valorDescontoMulta) {
        this.valorDescontoMulta = valorDescontoMulta;
    }

    public BigDecimal getValorDescontoCorrecao() {
        return this.valorDescontoCorrecao;
    }

    public void setValorDescontoCorrecao(BigDecimal valorDescontoCorrecao) {
        this.valorDescontoCorrecao = valorDescontoCorrecao;
    }

    public void applyDescontoPrincipal(BigDecimal percentualDesconto) {
        this.valorDesconto = this.calculaDesconto(this.valor, percentualDesconto);
    }

    public void applyDescontoJuros(BigDecimal percentualDesconto) {
        this.valorDescontoJuros = this.calculaDesconto(this.valorJuros, percentualDesconto);
    }

    public void applyDescontoMulta(BigDecimal percentualDesconto) {
        this.valorDescontoMulta = this.calculaDesconto(this.valorMulta, percentualDesconto);
    }

    public void applyDescontoCorrecao(BigDecimal percentualDesconto) {
        this.valorDescontoCorrecao = this.calculaDesconto(this.valorCorrecao, percentualDesconto);
    }

    private BigDecimal calculaDesconto(BigDecimal valor, BigDecimal percentualDesconto) {
        if (percentualDesconto.compareTo(BigDecimal.ZERO) > 0) {
            return valor.multiply(percentualDesconto).divide(CEM).setScale((int)CalculoValoresResources.QUANTIDADE_CASAS_DECIMAIS, 6);
        }
        return BigDecimal.ZERO;
    }

    public BigDecimal getValorTotal() {
        return this.valor.add(this.valorJuros).add(this.valorMulta).add(this.valorCorrecao).subtract(this.valorDesconto).subtract(this.valorDescontoJuros).subtract(this.valorDescontoMulta).subtract(this.valorDescontoCorrecao);
    }

    public BigDecimal getValorTotalSemDesconto() {
        return this.valor.add(this.valorJuros).add(this.valorMulta).add(this.valorCorrecao);
    }
}

