/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.impl;

import br.com.elotech.core.common.dto.EntidadeInfo;
import br.com.elotech.core.common.service.EntidadeService;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.Entidade;
import br.com.elotech.tributos.repository.EntidadeRepository;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.springframework.stereotype.Service;

@Service
public class EntidadeServiceImpl
extends CrudService<Entidade, Long>
implements EntidadeService {
    private final EntidadeRepository entidades;

    public EntidadeServiceImpl(EntidadeRepository entidades) {
        this.entidades = entidades;
    }

    public Optional<Entidade> getEntidadePrincipal() {
        List entidadesPrincipais = this.entidades.findEntidadesPrincipais();
        return entidadesPrincipais.stream().findFirst();
    }

    public EntidadeInfo findEntidadePrincipal() {
        EntidadeInfo dto = new EntidadeInfo();
        Entidade entidade = this.getEntidadePrincipal().orElse(null);
        if (Objects.nonNull(entidade)) {
            dto.setId(entidade.getId());
            dto.setDescricao(entidade.getNome());
            dto.setPrincipal(Boolean.valueOf(true));
        }
        return dto;
    }
}

