/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.repository.CadastroGeralRepository;
import br.com.elotech.tributos.repository.projections.SituacaoCadastroProjection;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SituacaoCadastralService {
    private final CadastroGeralRepository cadastroGeralRepository;

    @Autowired
    public SituacaoCadastralService(CadastroGeralRepository cadastroGeralRepository) {
        this.cadastroGeralRepository = cadastroGeralRepository;
    }

    public Optional<SituacaoCadastroProjection> getSituacaoCadastral(TipoCadastro tipoCadastro, Long cadastroGeral) {
        if (tipoCadastro == TipoCadastro.IMOBILIARIO) {
            return this.cadastroGeralRepository.findSituacaoCadastroImobiliario(tipoCadastro.getValue(), cadastroGeral).findFirst();
        }
        if (tipoCadastro == TipoCadastro.MOBILIARIO) {
            return this.cadastroGeralRepository.findSituacaoCadastroMobiliario(tipoCadastro.getValue(), cadastroGeral).findFirst();
        }
        return Optional.empty();
    }
}

