/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.security;

import br.com.elotech.core.security.Http401UnauthorizedEntryPoint;
import br.com.elotech.core.security.SecurityConfigurationOverride;
import br.com.elotech.core.security.authorization.AuthorizationInterApiProvider;
import br.com.elotech.core.security.jwt.TokenProvider;
import br.com.elotech.core.security.jwt.filter.SecurityFiltersConfigurer;
import javax.inject.Inject;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpMethod;
import org.springframework.security.config.annotation.SecurityConfigurerAdapter;
import org.springframework.security.config.annotation.method.configuration.EnableGlobalMethodSecurity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ChannelSecurityConfigurer;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.data.repository.query.SecurityEvaluationContextExtension;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.web.filter.CorsFilter;

@Configuration
@EnableGlobalMethodSecurity(prePostEnabled=true, securedEnabled=true, jsr250Enabled=true)
@Order(value=1)
@ConditionalOnProperty(name={"elotech.security.enabled"}, havingValue="true", matchIfMissing=true)
public class TributosSecurityConfiguration
extends WebSecurityConfigurerAdapter
implements SecurityConfigurationOverride {
    @Inject
    private Http401UnauthorizedEntryPoint authenticationEntryPoint;
    @Inject
    private TokenProvider tokenProvider;
    @Value(value="${security.require_ssl:false}")
    private Boolean requireSsl;
    @Inject
    private CorsFilter corsFilter;
    @Inject
    private AuthorizationInterApiProvider authorizationInterApiProvider;

    public void configure(WebSecurity web) {
        ((WebSecurity.IgnoredRequestConfigurer)web.ignoring().antMatchers(HttpMethod.OPTIONS, new String[]{"/**"})).antMatchers(new String[]{"/h2-console/**"});
    }

    protected void configure(HttpSecurity http) {
        if (this.requireSsl.booleanValue()) {
            ((ChannelSecurityConfigurer.RequiresChannelUrl)http.requiresChannel().anyRequest()).requiresSecure().and();
        }
        ((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((HttpSecurity)((HttpSecurity)http.exceptionHandling().authenticationEntryPoint((AuthenticationEntryPoint)this.authenticationEntryPoint).and()).csrf().disable()).formLogin().disable()).authorizeRequests().antMatchers(new String[]{"/api/imprimirdebitos/**"})).permitAll().antMatchers(new String[]{"/api/imprimirbloqueto/**"})).permitAll().antMatchers(new String[]{"/api/imprimircarne/**"})).permitAll().antMatchers(new String[]{"/api/debitos/**"})).permitAll().antMatchers(new String[]{"/api/debitos-cpf/**"})).permitAll().antMatchers(new String[]{"/api/debitosCarne/**"})).permitAll().antMatchers(new String[]{"/api/bloqueto/**"})).permitAll().antMatchers(new String[]{"/api/carne/**"})).permitAll().antMatchers(new String[]{"/api/heroes/**"})).permitAll().antMatchers(new String[]{"/api/certidao/**"})).permitAll().antMatchers(new String[]{"/api/imobiliario-avaliacao/**"})).permitAll().antMatchers(new String[]{"/api/laudoavaliacao/**"})).permitAll().antMatchers(new String[]{"/api/debitos-debitoautomatico/**"})).permitAll().antMatchers(new String[]{"/api/registro-tributos/**"})).permitAll().anyRequest()).permitAll().and()).apply((SecurityConfigurerAdapter)this.securityConfigurerAdapter());
    }

    private SecurityFiltersConfigurer securityConfigurerAdapter() {
        return new SecurityFiltersConfigurer(this.tokenProvider, this.corsFilter, this.authorizationInterApiProvider);
    }

    @Bean
    public SecurityEvaluationContextExtension securityEvaluationContextExtension() {
        return new SecurityEvaluationContextExtension();
    }
}

