/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource;

import br.com.elotech.core.resource.support.CrudResource;
import br.com.elotech.tributos.domain.Servico;
import br.com.elotech.tributos.repository.ServicoRepository;
import java.time.LocalDate;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/servicos-mobiliario"})
public class ServicoResource
extends CrudResource<Servico, Long> {
    private final ServicoRepository servicoRepository;

    public ServicoResource(ServicoRepository servicoRepository) {
        this.servicoRepository = servicoRepository;
    }

    @GetMapping(value={"/servico/{servico}"})
    public ResponseEntity<Servico> findOneNaturalKey(@PathVariable(value="servico") Long servico, @RequestHeader(value="entidade") Long entidade) {
        Long exercicio = LocalDate.now().getYear();
        Servico servicoEntity = this.servicoRepository.findByEntidadeAndExercicioAndServico(entidade, exercicio, servico);
        return ResponseEntity.ok((Object)servicoEntity);
    }
}

