/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource;

import br.com.elotech.core.resource.support.CrudResource;
import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.dto.PessoaDTO;
import br.com.elotech.tributos.service.PessoaService;
import br.com.elotech.tributos.ws.rest.dto.pessoa.IncluirPessoaRequestDTO;
import br.com.elotech.tributos.ws.rest.dto.pessoa.IncluirPessoaResponseDTO;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/pessoa"})
public class PessoaResource
extends CrudResource<Pessoa, Long> {
    private final PessoaService pessoaService;

    public PessoaResource(PessoaService pessoaService) {
        this.pessoaService = pessoaService;
    }

    @GetMapping(params={"cnpjCpf"})
    public ResponseEntity<Pessoa> getByCnpjCpf(@RequestParam(value="cnpjCpf") String cnpjCpf) {
        return ResponseEntity.ok().body((Object)this.pessoaService.findByCnpjCpf(cnpjCpf));
    }

    @PostMapping(value={"/incluir"})
    public ResponseEntity<IncluirPessoaResponseDTO> save(@RequestBody PessoaDTO pessoaDTO) {
        return ResponseEntity.ok().body((Object)this.pessoaService.incluirPessoa(IncluirPessoaRequestDTO.from((PessoaDTO)pessoaDTO)));
    }
}

