/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource;

import br.com.elotech.core.resource.support.CrudResource;
import br.com.elotech.tributos.domain.ParametroEntidadeExercicio;
import br.com.elotech.tributos.repository.ParametroEntidadeExercicioRepository;
import java.time.LocalDate;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/parametros-entidade-exercicio"})
public class ParametroEntidadeExercicioResource
extends CrudResource<ParametroEntidadeExercicio, Long> {
    private final ParametroEntidadeExercicioRepository paramEntidadeExercRepository;

    public ParametroEntidadeExercicioResource(ParametroEntidadeExercicioRepository paramEntidadeExercRepository) {
        this.paramEntidadeExercRepository = paramEntidadeExercRepository;
    }

    @GetMapping(params={"modulo", "parametro"})
    public ResponseEntity<ParametroEntidadeExercicio> findOne(@RequestParam(value="modulo") String modulo, @RequestParam(value="parametro") String parametro, @RequestHeader(value="entidade") Long entidade) {
        Long exercicio = LocalDate.now().getYear();
        ParametroEntidadeExercicio parametroEntidadeExercicio = this.paramEntidadeExercRepository.findByKey(entidade, exercicio, modulo, parametro);
        return ResponseEntity.ok((Object)parametroEntidadeExercicio);
    }
}

