/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource;

import br.com.elotech.core.resource.support.CrudResource;
import br.com.elotech.tributos.domain.Entidade;
import br.com.elotech.tributos.service.impl.EntidadeServiceImpl;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.OutputStream;
import java.util.Optional;
import javax.imageio.ImageIO;
import org.apache.tomcat.util.http.fileupload.ByteArrayOutputStream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/entidades"})
public class EntidadeResource
extends CrudResource<Entidade, Long> {
    @Autowired
    private EntidadeServiceImpl entidaService;

    public void setEntidaService(EntidadeServiceImpl entidaService) {
        this.entidaService = entidaService;
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/principal/brasao"}, produces={"image/jpeg"})
    public ResponseEntity<?> getBrasaoPrincipal() {
        Optional entidadePrincipal = this.entidaService.getEntidadePrincipal();
        if (entidadePrincipal.isPresent()) {
            if (((Entidade)entidadePrincipal.get()).getBrasao() == null) {
                return ResponseEntity.notFound().build();
            }
            BufferedImage bufferedImage = ImageIO.read(new ByteArrayInputStream(((Entidade)entidadePrincipal.get()).getBrasao()));
            ByteArrayOutputStream outputJpg = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)bufferedImage, "jpg", (OutputStream)outputJpg);
            return ResponseEntity.ok((Object)outputJpg.toByteArray());
        }
        return ResponseEntity.notFound().build();
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/principal/entidade"})
    public ResponseEntity<?> getEntidadePrincipal() {
        Optional entidadePrincipal = this.entidaService.getEntidadePrincipal();
        if (entidadePrincipal.isPresent()) {
            return ResponseEntity.ok(entidadePrincipal.get());
        }
        return ResponseEntity.notFound().build();
    }
}

