/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource;

import br.com.elotech.core.exception.RestException;
import br.com.elotech.tributos.domain.Bloqueto;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.dto.DocumentoAutenticadoDTO;
import br.com.elotech.tributos.params.CadastroGeralParams;
import br.com.elotech.tributos.repository.BloquetoRepository;
import br.com.elotech.tributos.repository.projections.DocumentoProjection;
import br.com.elotech.tributos.service.DocumentoService;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/documentos"})
public class DocumentoResource {
    private final DocumentoService documentoService;
    private final BloquetoRepository bloquetoRepository;

    public DocumentoResource(DocumentoService documentoService, BloquetoRepository bloquetoRepository) {
        this.documentoService = documentoService;
        this.bloquetoRepository = bloquetoRepository;
    }

    @GetMapping(value={"/autenticidade/{codigovalidacao}"})
    public ResponseEntity<DocumentoAutenticadoDTO> getAutenticidade(@PathVariable(value="codigovalidacao") String payload) {
        DocumentoAutenticadoDTO dto = null;
        String codigo = StringUtils.replaceAll((String)payload, (String)"\\.", (String)"");
        DocumentoProjection documento = this.documentoService.getDTO(codigo);
        if (Objects.nonNull(documento)) {
            dto = DocumentoAutenticadoDTO.from((DocumentoProjection)documento);
        } else {
            Bloqueto bloqueto = this.bloquetoRepository.findByCodigoValidacao(codigo);
            if (Objects.nonNull(bloqueto)) {
                dto = DocumentoAutenticadoDTO.from((Bloqueto)bloqueto);
            }
        }
        if (Objects.isNull(dto)) {
            throw RestException.notFound();
        }
        return ResponseEntity.ok().body((Object)dto);
    }

    @GetMapping(params={"tipoCadastro", "cadastroGeral"})
    public ResponseEntity<List<DocumentoProjection>> getListDocumentos(CadastroGeralParams params) {
        List listDto = this.loadListDocumentoDTO(params.getTipoCadastro(), params.getCadastroGeral());
        return ResponseEntity.ok().body((Object)listDto);
    }

    private List<DocumentoProjection> loadListDocumentoDTO(TipoCadastro tipoCadastro, Long cadastroGeral) {
        List listDto = this.documentoService.getListDocumentoDTO(tipoCadastro, cadastroGeral);
        return Optional.ofNullable(listDto).orElseThrow(() -> RestException.notFound());
    }
}

