/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource;

import br.com.elotech.tributos.dto.DebitoDTO;
import br.com.elotech.tributos.dto.IdDebitoDTO;
import br.com.elotech.tributos.dto.mobile.DebitoMobileDTO;
import br.com.elotech.tributos.dto.mobile.DebitoParcelaMobileDTO;
import br.com.elotech.tributos.params.CadastroGeralParams;
import br.com.elotech.tributos.service.DebitoService;
import br.com.elotech.tributos.ws.rest.dto.GerarDebitoRequestDTO;
import br.com.elotech.tributos.ws.rest.dto.GerarDebitoResponseDTO;
import java.util.List;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/debitos"})
@CrossOrigin
public class DebitosResource {
    private final DebitoService debitoService;

    public DebitosResource(DebitoService debitoService) {
        this.debitoService = debitoService;
    }

    @GetMapping(path={"/agrupados"}, params={"tipoCadastro", "cadastroGeral"})
    public ResponseEntity<List<DebitoDTO>> getDebitosAgrupados(CadastroGeralParams params) {
        return ResponseEntity.ok().body((Object)this.debitoService.getDebitosAgrupados(params));
    }

    @GetMapping(params={"tipoCadastro", "cadastroGeral"})
    public ResponseEntity<List<DebitoDTO>> getDebitos(CadastroGeralParams params) {
        return ResponseEntity.ok().body((Object)this.debitoService.getDebitos(params));
    }

    @GetMapping(path={"/agrupados-mobile"}, params={"tipoCadastro", "cadastroGeral"})
    public ResponseEntity<List<DebitoMobileDTO>> getDebitosResumo(CadastroGeralParams params) {
        return ResponseEntity.ok().body((Object)this.debitoService.getDebitosMobile(params));
    }

    @GetMapping(path={"/{id}/parcelas"})
    public ResponseEntity<List<DebitoParcelaMobileDTO>> getParcelas(@PathVariable(value="id") Long id) {
        return ResponseEntity.ok().body((Object)this.debitoService.getParcelas(id));
    }

    @GetMapping(path={"/{id}/parcelas-parcelamento"})
    public ResponseEntity<List<DebitoParcelaMobileDTO>> getParcelasParcelamento(@PathVariable(value="id") Long id) {
        return ResponseEntity.ok().body((Object)this.debitoService.getParcelasParcelamento(id));
    }

    @PostMapping
    public ResponseEntity<GerarDebitoResponseDTO> gerarDebito(@RequestBody GerarDebitoRequestDTO debito) {
        return ResponseEntity.ok().body((Object)this.debitoService.geraDebito(debito));
    }

    @PostMapping(value={"/verificar-pagos"})
    public ResponseEntity<List<IdDebitoDTO>> verificarPagos(@RequestBody List<IdDebitoDTO> listIdDebito) {
        return ResponseEntity.ok((Object)this.debitoService.verificarPagos(listIdDebito));
    }
}

