/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.repository.mobile;

import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.dto.mobile.DebitoMobileDTO;
import br.com.elotech.tributos.dto.mobile.DebitoParcelaMobileDTO;
import br.com.elotech.tributos.dto.mobile.EnderecoMobileDTO;
import br.com.elotech.tributos.dto.mobile.PropriedadeMobileDTO;
import br.com.elotech.tributos.dto.mobile.TipoCadastroMobileDTO;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Repository;

@Repository
public class PropriedadeMobileRepository {
    private static final String COLUMN_DATAVENCIMENTO = "datavencimento";
    private static final String COLUMN_DESCRICAO = "descricao";
    private static final String COLUMN_VALOR = "valor";
    private static final String COLUMN_PARCELA = "parcela";
    private static final String COLUMN_ID_DEBITO = "idDebito";
    private static final String COLUMN_ESTADO = "estado";
    private static final String COLUMN_CEP = "cep";
    private static final String COLUMN_COMPLEMENTO = "complemento";
    private static final String COLUMN_NUMERO = "numero";
    private static final String COLUMN_RUA = "rua";
    private static final String COLUMN_CIDADE = "cidade";
    private static final String COLUMN_NOME = "nome";
    private static final String COLUMN_CPF_CNPJ = "cpfCnpj";
    private static final String COLUMN_CADASTROGERAL = "cadastrogeral";
    private static final String COLUMN_TIPOCADASTRO = "tipocadastro";
    @Autowired
    private JdbcTemplate jdbcTemplate;
    private static final String SQL_DEBITO_ABERTO = "br/com/elotech/tributos/repository/mobile/findPropriedadesComDebitoEmAberto.sql";
    private static final String SQL_PROPRIEDADE_BY_TIPO_AND_CODIGO = "br/com/elotech/tributos/repository/mobile/findPropriedadeByTipoAndCodigo.sql";
    private static final String SQL_TIPOCADASTRO_CPFCNPJ = "br/com/elotech/tributos/repository/mobile/findTipoCadastroByCpfCnpj.sql";
    private static final String SQL_PROPRIEDADES_CPFCNPJ = "br/com/elotech/tributos/repository/mobile/findPropriedadesByCpfCnpj.sql";
    private static final String SQL_DEBITO_ABERTO_PERIODO = "br/com/elotech/tributos/repository/mobile/findPropriedadeComDebitoEmAbertoPorPeriodo.sql";

    public List<PropriedadeMobileDTO> findPropriedadesDebitoEmAberto(String cpfCnpj) {
        String sql = FileUtils.readResourceAsString((String)SQL_DEBITO_ABERTO);
        return this.jdbcTemplate.query(sql, new Object[]{cpfCnpj}, (rs, rowNum) -> this.setPropriedadeMobileDTO(rs));
    }

    public PropriedadeMobileDTO findPropriedadeByTipoAndCodigo(Integer tipoCadastro, Long cadastroGeral) {
        String sql = FileUtils.readResourceAsString((String)SQL_PROPRIEDADE_BY_TIPO_AND_CODIGO);
        return (PropriedadeMobileDTO)this.jdbcTemplate.queryForObject(sql, new Object[]{tipoCadastro, cadastroGeral}, (rs, rowNum) -> this.setPropriedadeMobileDTO(rs));
    }

    public List<TipoCadastroMobileDTO> findTipoCadastroByCpfCnpj(String cpfCnpj) {
        String sql = FileUtils.readResourceAsString((String)SQL_TIPOCADASTRO_CPFCNPJ);
        return this.jdbcTemplate.query(sql, new Object[]{cpfCnpj}, (rs, rowNum) -> {
            TipoCadastro tipoCadastro = TipoCadastro.fromValue((Long)rs.getLong(COLUMN_TIPOCADASTRO));
            return new TipoCadastroMobileDTO(tipoCadastro.getValue(), tipoCadastro.getDescricao());
        });
    }

    public List<PropriedadeMobileDTO> findPropriedadesByCpfCnpjAndTipoCadastro(String cpfCnpj, Long tipoCadastro) {
        StringBuilder sql = new StringBuilder(FileUtils.readResourceAsString((String)SQL_PROPRIEDADES_CPFCNPJ));
        sql.append(" AND ger.tipocadastro = ? ");
        return this.jdbcTemplate.query(sql.toString(), new Object[]{cpfCnpj, tipoCadastro}, (rs, rowNum) -> this.setPropriedadeMobileDTO(rs));
    }

    public List<PropriedadeMobileDTO> findPropriedadesByCpfCnpj(String cpfCnpj) {
        String sql = FileUtils.readResourceAsString((String)SQL_PROPRIEDADES_CPFCNPJ);
        return this.jdbcTemplate.query(sql, new Object[]{cpfCnpj}, (rs, rowNum) -> this.setPropriedadeMobileDTO(rs));
    }

    private PropriedadeMobileDTO setPropriedadeMobileDTO(ResultSet rs) throws SQLException {
        PropriedadeMobileDTO prop = new PropriedadeMobileDTO();
        prop.setTipoCadastro(Integer.valueOf(rs.getInt(COLUMN_TIPOCADASTRO)));
        prop.setCadastroGeral(Long.valueOf(rs.getLong(COLUMN_CADASTROGERAL)));
        prop.setCpfCnpj(rs.getString(COLUMN_CPF_CNPJ));
        prop.setNome(rs.getString(COLUMN_NOME));
        prop.setPossuiCotaUnica(Boolean.valueOf(false));
        EnderecoMobileDTO endereco = new EnderecoMobileDTO();
        endereco.setCidade(rs.getString(COLUMN_CIDADE));
        endereco.setRua(rs.getString(COLUMN_RUA));
        endereco.setNumero(rs.getString(COLUMN_NUMERO));
        endereco.setComplemento(rs.getString(COLUMN_COMPLEMENTO));
        endereco.setCep(rs.getString(COLUMN_CEP));
        endereco.setEstado(rs.getString(COLUMN_ESTADO));
        EnderecoMobileDTO enderecoEntrega = new EnderecoMobileDTO();
        enderecoEntrega.setCidade(rs.getString(COLUMN_CIDADE));
        enderecoEntrega.setRua(rs.getString(COLUMN_RUA));
        enderecoEntrega.setNumero(rs.getString(COLUMN_NUMERO));
        enderecoEntrega.setComplemento(rs.getString(COLUMN_COMPLEMENTO));
        enderecoEntrega.setCep(rs.getString(COLUMN_CEP));
        enderecoEntrega.setCep(rs.getString(COLUMN_ESTADO));
        prop.setEndereco(endereco);
        prop.setEnderecoCorrespondencia(enderecoEntrega);
        return prop;
    }

    public List<PropriedadeMobileDTO> findPropriedadesDebitoEmAbertoByCpfCnpjAndDataVencimento(String cpfCnpj, Date ... vencimentos) {
        StringBuilder sql = new StringBuilder(FileUtils.readResourceAsString((String)SQL_DEBITO_ABERTO_PERIODO));
        sql.append(" and ( ").append(this.getFiltroVencimento(vencimentos)).append(" ) ");
        Object[] parameters = this.getParametersFindByCpfCnpjAndDataVencimento(cpfCnpj, vencimentos);
        return this.jdbcTemplate.query(sql.toString(), parameters, (rs, rowNum) -> this.setPropriedadeDebitoMobileDTO(rs));
    }

    private Object[] getParametersFindByCpfCnpjAndDataVencimento(String cpfCnpj, Date ... vencimentos) {
        Integer quantidadeParametros = vencimentos.length + 1;
        Object[] parameters = new Object[quantidadeParametros.intValue()];
        parameters[0] = cpfCnpj;
        System.arraycopy(vencimentos, 0, parameters, 1, vencimentos.length);
        return parameters;
    }

    private String getFiltroVencimento(Date ... vencimentos) {
        StringBuilder filtro = new StringBuilder();
        for (int i = 0; i < vencimentos.length; ++i) {
            if (filtro.length() == 0) {
                filtro.append(" par.datavencimento = ? ");
                continue;
            }
            filtro.append(" or par.datavencimento = ? ");
        }
        return filtro.toString();
    }

    private PropriedadeMobileDTO setPropriedadeDebitoMobileDTO(ResultSet rs) throws SQLException {
        PropriedadeMobileDTO prop = new PropriedadeMobileDTO();
        prop.setTipoCadastro(Integer.valueOf(rs.getInt(COLUMN_TIPOCADASTRO)));
        prop.setCadastroGeral(Long.valueOf(rs.getLong(COLUMN_CADASTROGERAL)));
        prop.setCpfCnpj(rs.getString(COLUMN_CPF_CNPJ));
        prop.setNome(rs.getString(COLUMN_NOME));
        DebitoMobileDTO debito = new DebitoMobileDTO();
        debito.setIdDebito(Long.valueOf(rs.getLong(COLUMN_ID_DEBITO)));
        debito.setDescricaoVisualizacao(rs.getString(COLUMN_DESCRICAO));
        DebitoParcelaMobileDTO parcela = new DebitoParcelaMobileDTO();
        parcela.setIdDebito(Long.valueOf(rs.getLong(COLUMN_ID_DEBITO)));
        parcela.setParcela(Integer.valueOf(rs.getInt(COLUMN_PARCELA)));
        parcela.setValor(rs.getBigDecimal(COLUMN_VALOR));
        parcela.setVencimento(rs.getDate(COLUMN_DATAVENCIMENTO));
        debito.setParcelas(new ArrayList<DebitoParcelaMobileDTO>(Arrays.asList(parcela)));
        prop.setDebitos(new ArrayList<DebitoMobileDTO>(Arrays.asList(debito)));
        return prop;
    }
}

