/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto.mobile;

import br.com.elotech.core.enumerable.common.TipoPessoa;
import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.Documento;
import java.time.LocalDate;

public class DocumentoMobileDTO {
    private static final String SITUACAO_POSITIVA = "P";
    private static final String SITUACAO_NEGATIVA = "N";
    private static final String SITUACAO_POSITIVA_EFEITO_NEGATIVA = "X";
    private final Documento documento;
    private final String urlImpressao;

    public DocumentoMobileDTO(Documento documento, String urlImpressao) {
        this.documento = documento;
        this.urlImpressao = urlImpressao;
    }

    public String getUrlImpressao() {
        return this.urlImpressao;
    }

    public String getSituacao() {
        switch (this.documento.getSubTipo()) {
            case "P": {
                return "Positiva";
            }
            case "N": {
                return "Negativa";
            }
            case "X": {
                return "Positiva com efeito de negativa";
            }
        }
        return "";
    }

    public Long getExercicio() {
        return this.documento.getEntidadeTributacao().getExercicio();
    }

    public String getDescricao() {
        return this.documento.getTipoDocumento().getDescricao();
    }

    public Long getDocumento() {
        return this.documento.getDocumento();
    }

    public Long getTipoDocumento() {
        return this.documento.getTipoDocumento().getId();
    }

    public String getCnpjCpf() {
        return this.documento.getCnpjCpf();
    }

    public LocalDate getDataEmissao() {
        return this.documento.getDataEmissao();
    }

    public LocalDate getDataValidade() {
        return this.documento.getDataValidade();
    }

    public String getFinalidade() {
        return this.documento.getSequenciaFinalidade().getDescricao();
    }

    public String getOutraFinalidade() {
        return this.documento.getOutraFinalidade();
    }

    public CadastroGeral getCadastroGeral() {
        return this.documento.getCadastroGeral();
    }

    public String getRequerente() {
        return this.documento.getRequerente();
    }

    public String getCpfRequerente() {
        return this.documento.getCpfRequerente();
    }

    public TipoPessoa getTipoPessoaRequerente() {
        return this.documento.getTipoPessoaRequerente();
    }
}

