/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto;

import br.com.elotech.core.enumerable.common.TipoPessoa;
import br.com.elotech.tributos.domain.Bloqueto;
import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.repository.projections.DocumentoProjection;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;

public class DocumentoAutenticadoDTO {
    private static final Long TIPODOCUMENTO_BLOQUETO = 100L;
    private Long exercicio;
    private String descricao;
    private String documento;
    private Long tipoDocumento;
    private String cnpjCpf;
    private LocalDate dataEmissao;
    private LocalDate dataValidade;
    private String finalidade;
    private String outraFinalidade;
    private CadastroGeral cadastroGeral;
    private String requerente;
    private String cpfRequerente;
    private TipoPessoa tipoPessoaRequerente;
    private String subTipo;
    private Boolean impressaoWeb;
    private String codigoBarras;
    private BigDecimal valorBloqueto = BigDecimal.ZERO;

    public static DocumentoAutenticadoDTO from(DocumentoProjection documentoProjection) {
        DocumentoAutenticadoDTO documentoAutenticado = new DocumentoAutenticadoDTO();
        Optional.ofNullable(documentoProjection.getExercicio()).ifPresent(arg_0 -> documentoAutenticado.setExercicio(arg_0));
        Optional.ofNullable(documentoProjection.getDescricao()).ifPresent(arg_0 -> documentoAutenticado.setDescricao(arg_0));
        Optional.ofNullable(documentoProjection.getTipoDocumento()).ifPresent(arg_0 -> documentoAutenticado.setTipoDocumento(arg_0));
        if (Optional.ofNullable(documentoProjection.getDocumento()).isPresent()) {
            documentoAutenticado.setDocumento(Long.toString(documentoProjection.getDocumento()));
        }
        Optional.ofNullable(documentoProjection.getCnpjCpf()).ifPresent(arg_0 -> documentoAutenticado.setCnpjCpf(arg_0));
        Optional.ofNullable(documentoProjection.getDataEmissao()).ifPresent(arg_0 -> documentoAutenticado.setDataEmissao(arg_0));
        Optional.ofNullable(documentoProjection.getDataValidade()).ifPresent(arg_0 -> documentoAutenticado.setDataValidade(arg_0));
        Optional.ofNullable(documentoProjection.getFinalidade()).ifPresent(arg_0 -> documentoAutenticado.setFinalidade(arg_0));
        Optional.ofNullable(documentoProjection.getOutraFinalidade()).ifPresent(arg_0 -> documentoAutenticado.setOutraFinalidade(arg_0));
        Optional.ofNullable(documentoProjection.getRequerente()).ifPresent(arg_0 -> documentoAutenticado.setRequerente(arg_0));
        Optional.ofNullable(documentoProjection.getCpfRequerente()).ifPresent(arg_0 -> documentoAutenticado.setCpfRequerente(arg_0));
        Optional.ofNullable(documentoProjection.getSubTipo()).ifPresent(arg_0 -> documentoAutenticado.setSubTipo(arg_0));
        Optional.ofNullable(documentoProjection.getImpressaoWeb()).ifPresent(arg_0 -> documentoAutenticado.setImpressaoWeb(arg_0));
        Optional.ofNullable(documentoProjection.getCadastroGeral()).ifPresent(arg_0 -> documentoAutenticado.setCadastroGeral(arg_0));
        Optional.ofNullable(documentoProjection.getTipoPessoaRequerente()).ifPresent(arg_0 -> documentoAutenticado.setTipoPessoaRequerente(arg_0));
        return documentoAutenticado;
    }

    public static DocumentoAutenticadoDTO from(Bloqueto bloqueto) {
        DocumentoAutenticadoDTO documentoAutenticado = new DocumentoAutenticadoDTO();
        Optional.ofNullable(bloqueto.getExercicioBloqueto()).ifPresent(arg_0 -> documentoAutenticado.setExercicio(arg_0));
        documentoAutenticado.setTipoDocumento(TIPODOCUMENTO_BLOQUETO);
        documentoAutenticado.setDescricao("BLOQUETO");
        Optional.ofNullable(bloqueto.getNossoNumero()).ifPresent(arg_0 -> documentoAutenticado.setDocumento(arg_0));
        if (Objects.nonNull(bloqueto.getPessoa())) {
            Optional.ofNullable(bloqueto.getPessoa().getNome()).ifPresent(arg_0 -> documentoAutenticado.setRequerente(arg_0));
            Optional.ofNullable(bloqueto.getPessoa().getCnpjCpf()).ifPresent(arg_0 -> documentoAutenticado.setCpfRequerente(arg_0));
        }
        Optional.ofNullable(bloqueto.getDataEmissao()).ifPresent(arg_0 -> documentoAutenticado.setDataEmissao(arg_0));
        Optional.ofNullable(bloqueto.getDataVencimento()).ifPresent(arg_0 -> documentoAutenticado.setDataValidade(arg_0));
        Optional.ofNullable(bloqueto.getCodigoBarras()).ifPresent(arg_0 -> documentoAutenticado.setCodigoBarras(arg_0));
        documentoAutenticado.setValorBloqueto(bloqueto.getValorBloqueto());
        return documentoAutenticado;
    }

    @Generated
    public DocumentoAutenticadoDTO() {
    }

    @Generated
    public Long getExercicio() {
        return this.exercicio;
    }

    @Generated
    public String getDescricao() {
        return this.descricao;
    }

    @Generated
    public String getDocumento() {
        return this.documento;
    }

    @Generated
    public Long getTipoDocumento() {
        return this.tipoDocumento;
    }

    @Generated
    public String getCnpjCpf() {
        return this.cnpjCpf;
    }

    @Generated
    public LocalDate getDataEmissao() {
        return this.dataEmissao;
    }

    @Generated
    public LocalDate getDataValidade() {
        return this.dataValidade;
    }

    @Generated
    public String getFinalidade() {
        return this.finalidade;
    }

    @Generated
    public String getOutraFinalidade() {
        return this.outraFinalidade;
    }

    @Generated
    public CadastroGeral getCadastroGeral() {
        return this.cadastroGeral;
    }

    @Generated
    public String getRequerente() {
        return this.requerente;
    }

    @Generated
    public String getCpfRequerente() {
        return this.cpfRequerente;
    }

    @Generated
    public TipoPessoa getTipoPessoaRequerente() {
        return this.tipoPessoaRequerente;
    }

    @Generated
    public String getSubTipo() {
        return this.subTipo;
    }

    @Generated
    public Boolean getImpressaoWeb() {
        return this.impressaoWeb;
    }

    @Generated
    public String getCodigoBarras() {
        return this.codigoBarras;
    }

    @Generated
    public BigDecimal getValorBloqueto() {
        return this.valorBloqueto;
    }

    @Generated
    public void setExercicio(Long exercicio) {
        this.exercicio = exercicio;
    }

    @Generated
    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Generated
    public void setDocumento(String documento) {
        this.documento = documento;
    }

    @Generated
    public void setTipoDocumento(Long tipoDocumento) {
        this.tipoDocumento = tipoDocumento;
    }

    @Generated
    public void setCnpjCpf(String cnpjCpf) {
        this.cnpjCpf = cnpjCpf;
    }

    @Generated
    public void setDataEmissao(LocalDate dataEmissao) {
        this.dataEmissao = dataEmissao;
    }

    @Generated
    public void setDataValidade(LocalDate dataValidade) {
        this.dataValidade = dataValidade;
    }

    @Generated
    public void setFinalidade(String finalidade) {
        this.finalidade = finalidade;
    }

    @Generated
    public void setOutraFinalidade(String outraFinalidade) {
        this.outraFinalidade = outraFinalidade;
    }

    @Generated
    public void setCadastroGeral(CadastroGeral cadastroGeral) {
        this.cadastroGeral = cadastroGeral;
    }

    @Generated
    public void setRequerente(String requerente) {
        this.requerente = requerente;
    }

    @Generated
    public void setCpfRequerente(String cpfRequerente) {
        this.cpfRequerente = cpfRequerente;
    }

    @Generated
    public void setTipoPessoaRequerente(TipoPessoa tipoPessoaRequerente) {
        this.tipoPessoaRequerente = tipoPessoaRequerente;
    }

    @Generated
    public void setSubTipo(String subTipo) {
        this.subTipo = subTipo;
    }

    @Generated
    public void setImpressaoWeb(Boolean impressaoWeb) {
        this.impressaoWeb = impressaoWeb;
    }

    @Generated
    public void setCodigoBarras(String codigoBarras) {
        this.codigoBarras = codigoBarras;
    }

    @Generated
    public void setValorBloqueto(BigDecimal valorBloqueto) {
        this.valorBloqueto = valorBloqueto;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DocumentoAutenticadoDTO)) {
            return false;
        }
        DocumentoAutenticadoDTO other = (DocumentoAutenticadoDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$exercicio = this.getExercicio();
        Long other$exercicio = other.getExercicio();
        if (this$exercicio == null ? other$exercicio != null : !((Object)this$exercicio).equals(other$exercicio)) {
            return false;
        }
        String this$descricao = this.getDescricao();
        String other$descricao = other.getDescricao();
        if (this$descricao == null ? other$descricao != null : !this$descricao.equals(other$descricao)) {
            return false;
        }
        String this$documento = this.getDocumento();
        String other$documento = other.getDocumento();
        if (this$documento == null ? other$documento != null : !this$documento.equals(other$documento)) {
            return false;
        }
        Long this$tipoDocumento = this.getTipoDocumento();
        Long other$tipoDocumento = other.getTipoDocumento();
        if (this$tipoDocumento == null ? other$tipoDocumento != null : !((Object)this$tipoDocumento).equals(other$tipoDocumento)) {
            return false;
        }
        String this$cnpjCpf = this.getCnpjCpf();
        String other$cnpjCpf = other.getCnpjCpf();
        if (this$cnpjCpf == null ? other$cnpjCpf != null : !this$cnpjCpf.equals(other$cnpjCpf)) {
            return false;
        }
        LocalDate this$dataEmissao = this.getDataEmissao();
        LocalDate other$dataEmissao = other.getDataEmissao();
        if (this$dataEmissao == null ? other$dataEmissao != null : !((Object)this$dataEmissao).equals(other$dataEmissao)) {
            return false;
        }
        LocalDate this$dataValidade = this.getDataValidade();
        LocalDate other$dataValidade = other.getDataValidade();
        if (this$dataValidade == null ? other$dataValidade != null : !((Object)this$dataValidade).equals(other$dataValidade)) {
            return false;
        }
        String this$finalidade = this.getFinalidade();
        String other$finalidade = other.getFinalidade();
        if (this$finalidade == null ? other$finalidade != null : !this$finalidade.equals(other$finalidade)) {
            return false;
        }
        String this$outraFinalidade = this.getOutraFinalidade();
        String other$outraFinalidade = other.getOutraFinalidade();
        if (this$outraFinalidade == null ? other$outraFinalidade != null : !this$outraFinalidade.equals(other$outraFinalidade)) {
            return false;
        }
        CadastroGeral this$cadastroGeral = this.getCadastroGeral();
        CadastroGeral other$cadastroGeral = other.getCadastroGeral();
        if (this$cadastroGeral == null ? other$cadastroGeral != null : !this$cadastroGeral.equals(other$cadastroGeral)) {
            return false;
        }
        String this$requerente = this.getRequerente();
        String other$requerente = other.getRequerente();
        if (this$requerente == null ? other$requerente != null : !this$requerente.equals(other$requerente)) {
            return false;
        }
        String this$cpfRequerente = this.getCpfRequerente();
        String other$cpfRequerente = other.getCpfRequerente();
        if (this$cpfRequerente == null ? other$cpfRequerente != null : !this$cpfRequerente.equals(other$cpfRequerente)) {
            return false;
        }
        TipoPessoa this$tipoPessoaRequerente = this.getTipoPessoaRequerente();
        TipoPessoa other$tipoPessoaRequerente = other.getTipoPessoaRequerente();
        if (this$tipoPessoaRequerente == null ? other$tipoPessoaRequerente != null : !this$tipoPessoaRequerente.equals(other$tipoPessoaRequerente)) {
            return false;
        }
        String this$subTipo = this.getSubTipo();
        String other$subTipo = other.getSubTipo();
        if (this$subTipo == null ? other$subTipo != null : !this$subTipo.equals(other$subTipo)) {
            return false;
        }
        Boolean this$impressaoWeb = this.getImpressaoWeb();
        Boolean other$impressaoWeb = other.getImpressaoWeb();
        if (this$impressaoWeb == null ? other$impressaoWeb != null : !((Object)this$impressaoWeb).equals(other$impressaoWeb)) {
            return false;
        }
        String this$codigoBarras = this.getCodigoBarras();
        String other$codigoBarras = other.getCodigoBarras();
        if (this$codigoBarras == null ? other$codigoBarras != null : !this$codigoBarras.equals(other$codigoBarras)) {
            return false;
        }
        BigDecimal this$valorBloqueto = this.getValorBloqueto();
        BigDecimal other$valorBloqueto = other.getValorBloqueto();
        return !(this$valorBloqueto == null ? other$valorBloqueto != null : !((Object)this$valorBloqueto).equals(other$valorBloqueto));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DocumentoAutenticadoDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $exercicio = this.getExercicio();
        result = result * 59 + ($exercicio == null ? 43 : ((Object)$exercicio).hashCode());
        String $descricao = this.getDescricao();
        result = result * 59 + ($descricao == null ? 43 : $descricao.hashCode());
        String $documento = this.getDocumento();
        result = result * 59 + ($documento == null ? 43 : $documento.hashCode());
        Long $tipoDocumento = this.getTipoDocumento();
        result = result * 59 + ($tipoDocumento == null ? 43 : ((Object)$tipoDocumento).hashCode());
        String $cnpjCpf = this.getCnpjCpf();
        result = result * 59 + ($cnpjCpf == null ? 43 : $cnpjCpf.hashCode());
        LocalDate $dataEmissao = this.getDataEmissao();
        result = result * 59 + ($dataEmissao == null ? 43 : ((Object)$dataEmissao).hashCode());
        LocalDate $dataValidade = this.getDataValidade();
        result = result * 59 + ($dataValidade == null ? 43 : ((Object)$dataValidade).hashCode());
        String $finalidade = this.getFinalidade();
        result = result * 59 + ($finalidade == null ? 43 : $finalidade.hashCode());
        String $outraFinalidade = this.getOutraFinalidade();
        result = result * 59 + ($outraFinalidade == null ? 43 : $outraFinalidade.hashCode());
        CadastroGeral $cadastroGeral = this.getCadastroGeral();
        result = result * 59 + ($cadastroGeral == null ? 43 : $cadastroGeral.hashCode());
        String $requerente = this.getRequerente();
        result = result * 59 + ($requerente == null ? 43 : $requerente.hashCode());
        String $cpfRequerente = this.getCpfRequerente();
        result = result * 59 + ($cpfRequerente == null ? 43 : $cpfRequerente.hashCode());
        TipoPessoa $tipoPessoaRequerente = this.getTipoPessoaRequerente();
        result = result * 59 + ($tipoPessoaRequerente == null ? 43 : $tipoPessoaRequerente.hashCode());
        String $subTipo = this.getSubTipo();
        result = result * 59 + ($subTipo == null ? 43 : $subTipo.hashCode());
        Boolean $impressaoWeb = this.getImpressaoWeb();
        result = result * 59 + ($impressaoWeb == null ? 43 : ((Object)$impressaoWeb).hashCode());
        String $codigoBarras = this.getCodigoBarras();
        result = result * 59 + ($codigoBarras == null ? 43 : $codigoBarras.hashCode());
        BigDecimal $valorBloqueto = this.getValorBloqueto();
        result = result * 59 + ($valorBloqueto == null ? 43 : ((Object)$valorBloqueto).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "DocumentoAutenticadoDTO(exercicio=" + this.getExercicio() + ", descricao=" + this.getDescricao() + ", documento=" + this.getDocumento() + ", tipoDocumento=" + this.getTipoDocumento() + ", cnpjCpf=" + this.getCnpjCpf() + ", dataEmissao=" + this.getDataEmissao() + ", dataValidade=" + this.getDataValidade() + ", finalidade=" + this.getFinalidade() + ", outraFinalidade=" + this.getOutraFinalidade() + ", cadastroGeral=" + this.getCadastroGeral() + ", requerente=" + this.getRequerente() + ", cpfRequerente=" + this.getCpfRequerente() + ", tipoPessoaRequerente=" + this.getTipoPessoaRequerente() + ", subTipo=" + this.getSubTipo() + ", impressaoWeb=" + this.getImpressaoWeb() + ", codigoBarras=" + this.getCodigoBarras() + ", valorBloqueto=" + this.getValorBloqueto() + ")";
    }
}

