/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain;

import br.com.elotech.core.enumerable.EnumConverter;
import br.com.elotech.core.enumerable.EnumValues;
import br.com.elotech.core.utils.EnumUtils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import javax.xml.bind.annotation.XmlEnum;

@XmlEnum(value=Long.class)
public enum TipoCadastro implements EnumConverter<TipoCadastro, Long>
{
    IMOBILIARIO(Long.valueOf(1L), "Cadastro Imobili\u00e1rio"),
    MOBILIARIO(Long.valueOf(2L), "Cadastro Mobili\u00e1rio"),
    RURAL(Long.valueOf(3L), "Cadastro Rural"),
    CEMITERIO(Long.valueOf(4L), "Cadastro Cemit\u00e9rio"),
    AGUA_ESGOTO(Long.valueOf(5L), "Cadastro \u00c1gua / Esgoto"),
    AVULSO(Long.valueOf(9L), "Cadastro Avulso");

    private static final EnumValues<TipoCadastro, Long> VALUES;
    private final Long codigo;
    private final String descricao;

    private TipoCadastro(Long codigo, String descricao) {
        this.codigo = codigo;
        this.descricao = descricao;
    }

    public String getDescricao() {
        return this.descricao;
    }

    @JsonValue
    public Long getValue() {
        return this.codigo;
    }

    @JsonCreator
    public static TipoCadastro fromValue(Long value) {
        return (TipoCadastro)VALUES.getEnum((Object)value);
    }

    public Boolean isMobiliario() {
        return TipoCadastro.MOBILIARIO.codigo == this.codigo;
    }

    public Boolean isImobiliario() {
        return TipoCadastro.IMOBILIARIO.codigo == this.codigo;
    }

    public Boolean isAvulso() {
        return TipoCadastro.AVULSO.codigo == this.codigo;
    }

    public Boolean isCemiterio() {
        return TipoCadastro.CEMITERIO.codigo == this.codigo;
    }

    public Boolean isRural() {
        return TipoCadastro.RURAL.codigo == this.codigo;
    }

    public Boolean isAguaEsgoto() {
        return TipoCadastro.AGUA_ESGOTO.codigo == this.codigo;
    }

    static {
        VALUES = EnumUtils.getEnumValuesMap(TipoCadastro.class);
    }
}

