/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.converter.BooleanToStringConverter;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.enumerable.common.TipoPessoa;
import br.com.elotech.core.metamodel.annotation.Caption;
import br.com.elotech.tributos.domain.BancoPessoa;
import br.com.elotech.tributos.domain.ContatoPessoa;
import br.com.elotech.tributos.domain.EnderecoPessoa;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import lombok.Generated;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="PESSOA")
@DynamicInsert
@DynamicUpdate
public class Pessoa
implements EloEntity<Long> {
    @Id
    @Column(name="PESSOA")
    @EloSequence(sequenceName="s90Pessoa")
    private Long id;
    private TipoPessoa tipoPessoa;
    @Length(max=150)
    private String nome;
    @Length(max=150)
    private String nomeFantasia;
    @JsonIgnore
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.LAZY)
    @JoinColumn(name="pessoa", updatable=false, nullable=false)
    @Caption(value="Endere\u00e7os")
    private final List<EnderecoPessoa> enderecos = new ArrayList();
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.LAZY)
    @JoinColumn(name="pessoa", updatable=false, nullable=false)
    @Caption(value="Bancos")
    private final List<BancoPessoa> bancos = new ArrayList();
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.LAZY)
    @JoinColumn(name="pessoa", updatable=false, nullable=false)
    @Caption(value="Contatos")
    private final List<ContatoPessoa> contatos = new ArrayList();
    @Column(name="CNPJ_CPF")
    @Length(max=20)
    private String cnpjCpf;
    @Length(max=20)
    private String rg;
    @Length(max=20)
    private String orgaoEmissor;
    private LocalDate dataEmissao;
    @Length(max=20)
    private String inscricaoEstadual;
    private Long sequenciaEndereco;
    private Long sequenciaContato;
    private Long sequenciaBanco;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean contribuinte;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean fornecedor;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean pessoal;
    private LocalDate dataInclusao;
    @Length(max=1000)
    private String observacao;
    @Length(max=15)
    private String usuarioInclusao;
    @Column(length=2)
    @Caption(value="Estado Emissor")
    private String estadoEmissor;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean microEmpresa;
    private LocalDate dataAlteracao;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean estrangeiro;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean autonomo;
    @Length(max=1000)
    private String atividadePrincipal;
    @Column(name="inscricaoissqn")
    @Length(max=20)
    private String inscricaoMunicipal;
    private LocalDate dataIssqn;
    private Long fornecedorSiscop;
    @Length(max=18)
    private String codigoSistemaAnterior;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean inativo;
    private Long sequenciaImagem;
    @Length(max=60)
    private String activeFormOrigem;
    private LocalDate dataNascimento;
    @Length(max=12)
    private String nit;
    @Length(max=11)
    private String nire;
    @Column(name="pispasep")
    @Length(max=20)
    private String pis;
    private LocalDate dataAberturaCnpj;
    @Column(name="codigotce")
    @Length(max=20)
    private String idTcePR;
    private Long idUnico;

    public TipoPessoa getTipoPessoa() {
        return this.tipoPessoa;
    }

    public void setTipoPessoa(TipoPessoa tipoPessoa) {
        this.tipoPessoa = tipoPessoa;
    }

    public String getNome() {
        return this.nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public String getNomeFantasia() {
        return this.nomeFantasia;
    }

    public void setNomeFantasia(String nomeFantasia) {
        this.nomeFantasia = nomeFantasia;
    }

    public String getCnpjCpf() {
        return this.cnpjCpf;
    }

    public void setCnpjCpf(String cnpjCpf) {
        this.cnpjCpf = cnpjCpf;
    }

    public String getRg() {
        return this.rg;
    }

    public void setRg(String rg) {
        this.rg = rg;
    }

    public String getOrgaoEmissor() {
        return this.orgaoEmissor;
    }

    public void setOrgaoEmissor(String orgaoEmissor) {
        this.orgaoEmissor = orgaoEmissor;
    }

    public LocalDate getDataEmissao() {
        return this.dataEmissao;
    }

    public void setDataEmissao(LocalDate dataEmissao) {
        this.dataEmissao = dataEmissao;
    }

    public String getInscricaoEstadual() {
        return this.inscricaoEstadual;
    }

    public void setInscricaoEstadual(String inscricaoEstadual) {
        this.inscricaoEstadual = inscricaoEstadual;
    }

    public Long getSequenciaContato() {
        return this.sequenciaContato;
    }

    public void setSequenciaContato(Long sequenciaContato) {
        this.sequenciaContato = sequenciaContato;
    }

    public Long getSequenciaBanco() {
        return this.sequenciaBanco;
    }

    public void setSequenciaBanco(Long sequenciaBanco) {
        this.sequenciaBanco = sequenciaBanco;
    }

    public Boolean getContribuinte() {
        return this.contribuinte;
    }

    public void setContribuinte(Boolean contribuinte) {
        this.contribuinte = contribuinte;
    }

    public Boolean getFornecedor() {
        return this.fornecedor;
    }

    public void setFornecedor(Boolean fornecedor) {
        this.fornecedor = fornecedor;
    }

    public Boolean getPessoal() {
        return this.pessoal;
    }

    public void setPessoal(Boolean pessoal) {
        this.pessoal = pessoal;
    }

    public LocalDate getDataInclusao() {
        return this.dataInclusao;
    }

    public void setDataInclusao(LocalDate dataInclusao) {
        this.dataInclusao = dataInclusao;
    }

    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    public String getUsuarioInclusao() {
        return this.usuarioInclusao;
    }

    public void setUsuarioInclusao(String usuarioInclusao) {
        this.usuarioInclusao = usuarioInclusao;
    }

    public String getEstadoEmissor() {
        return this.estadoEmissor;
    }

    public void setEstadoEmissor(String estadoEmissor) {
        this.estadoEmissor = estadoEmissor;
    }

    public Boolean getMicroEmpresa() {
        return this.microEmpresa;
    }

    public void setMicroEmpresa(Boolean microEmpresa) {
        this.microEmpresa = microEmpresa;
    }

    public LocalDate getDataAlteracao() {
        return this.dataAlteracao;
    }

    public void setDataAlteracao(LocalDate dataAlteracao) {
        this.dataAlteracao = dataAlteracao;
    }

    public Boolean getEstrangeiro() {
        return this.estrangeiro;
    }

    public void setEstrangeiro(Boolean estrangeiro) {
        this.estrangeiro = estrangeiro;
    }

    public Boolean getAutonomo() {
        return this.autonomo;
    }

    public void setAutonomo(Boolean autonomo) {
        this.autonomo = autonomo;
    }

    public String getAtividadePrincipal() {
        return this.atividadePrincipal;
    }

    public void setAtividadePrincipal(String atividadePrincipal) {
        this.atividadePrincipal = atividadePrincipal;
    }

    public String getInscricaoMunicipal() {
        return this.inscricaoMunicipal;
    }

    public void setInscricaoMunicipal(String inscricaoMunicipal) {
        this.inscricaoMunicipal = inscricaoMunicipal;
    }

    public LocalDate getDataIssqn() {
        return this.dataIssqn;
    }

    public void setDataIssqn(LocalDate dataissqn) {
        this.dataIssqn = dataissqn;
    }

    public Long getFornecedorSiscop() {
        return this.fornecedorSiscop;
    }

    public void setFornecedorSiscop(Long fornecedorSiscop) {
        this.fornecedorSiscop = fornecedorSiscop;
    }

    public String getCodigoSistemaAnterior() {
        return this.codigoSistemaAnterior;
    }

    public void setCodigoSistemaAnterior(String codigoSistemaAnterior) {
        this.codigoSistemaAnterior = codigoSistemaAnterior;
    }

    public Boolean getInativo() {
        return this.inativo;
    }

    public void setInativo(Boolean inativo) {
        this.inativo = inativo;
    }

    public Long getSequenciaImagem() {
        return this.sequenciaImagem;
    }

    public void setSequenciaImagem(Long sequenciaImagem) {
        this.sequenciaImagem = sequenciaImagem;
    }

    public String getActiveFormOrigem() {
        return this.activeFormOrigem;
    }

    public void setActiveFormOrigem(String activeFormOrigem) {
        this.activeFormOrigem = activeFormOrigem;
    }

    public LocalDate getDataNascimento() {
        return this.dataNascimento;
    }

    public void setDataNascimento(LocalDate dataNascimento) {
        this.dataNascimento = dataNascimento;
    }

    public String getNit() {
        return this.nit;
    }

    public void setNit(String nit) {
        this.nit = nit;
    }

    public String getNire() {
        return this.nire;
    }

    public void setNire(String nire) {
        this.nire = nire;
    }

    public String getPis() {
        return this.pis;
    }

    public void setPis(String pis) {
        this.pis = pis;
    }

    public LocalDate getDataAberturaCnpj() {
        return this.dataAberturaCnpj;
    }

    public void setDataAberturaCnpj(LocalDate dataAberturaCnpj) {
        this.dataAberturaCnpj = dataAberturaCnpj;
    }

    public String getIdTcePR() {
        return this.idTcePR;
    }

    public void setIdTcePR(String idTcePR) {
        this.idTcePR = idTcePR;
    }

    public Long getIdUnico() {
        return this.idUnico;
    }

    public void setIdUnico(Long idUnico) {
        this.idUnico = idUnico;
    }

    public List<EnderecoPessoa> getEnderecos() {
        return this.enderecos;
    }

    public List<BancoPessoa> getBancos() {
        return this.bancos;
    }

    public List<ContatoPessoa> getContatos() {
        return this.contatos;
    }

    @JsonIgnore
    public EnderecoPessoa getEnderecoPrincipal() {
        for (EnderecoPessoa enderecoPessoa : this.enderecos) {
            if (enderecoPessoa.getCodigo() == null || !enderecoPessoa.getCodigo().equals(this.sequenciaEndereco)) continue;
            return enderecoPessoa;
        }
        return null;
    }

    public void setEnderecoPrincipal(EnderecoPessoa enderecoPrincipal) {
        this.sequenciaEndereco = null;
        if (enderecoPrincipal != null) {
            this.sequenciaEndereco = enderecoPrincipal.getCodigo();
        }
    }

    public ContatoPessoa getContatoPrincipal() {
        for (ContatoPessoa contatoPessoa : this.contatos) {
            if (contatoPessoa.getCodigo() == null || !contatoPessoa.getCodigo().equals(this.sequenciaContato)) continue;
            return contatoPessoa;
        }
        return null;
    }

    public void setContaBancariaPrincipal(BancoPessoa contaBancariaPrincipal) {
        this.sequenciaBanco = null;
        if (contaBancariaPrincipal != null) {
            this.sequenciaBanco = contaBancariaPrincipal.getCodigo();
        }
    }

    public BancoPessoa getContaBancariaPrincipal() {
        for (BancoPessoa contBancariaPessoa : this.bancos) {
            if (contBancariaPessoa.getCodigo() == null || !contBancariaPessoa.getCodigo().equals(this.sequenciaBanco)) continue;
            return contBancariaPessoa;
        }
        return null;
    }

    public void setContatoPrincipal(ContatoPessoa contatoPrincipal) {
        this.sequenciaContato = null;
        if (contatoPrincipal != null) {
            this.sequenciaContato = contatoPrincipal.getCodigo();
        }
    }

    public static Pessoa of(Long id) {
        return new Pessoa().withId(id);
    }

    public Pessoa withId(Long id) {
        this.setId(id);
        return this;
    }

    public Pessoa withContatoPrincipal(ContatoPessoa contatoPessoa) {
        this.getContatos().add(contatoPessoa);
        this.setSequenciaContato(contatoPessoa.getCodigo());
        return this;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getSequenciaEndereco() {
        return this.sequenciaEndereco;
    }

    public void setSequenciaEndereco(Long sequenciaEndereco) {
        this.sequenciaEndereco = sequenciaEndereco;
    }

    @Generated
    public String toString() {
        return "Pessoa(id=" + this.getId() + ", tipoPessoa=" + this.getTipoPessoa() + ", nome=" + this.getNome() + ", cnpjCpf=" + this.getCnpjCpf() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Pessoa)) {
            return false;
        }
        Pessoa other = (Pessoa)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Pessoa;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }
}

