/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.converter.BooleanToStringConverter;
import br.com.elotech.tributos.converter.TipoCadastroConverter;
import br.com.elotech.tributos.domain.ImobiliarioItbiObs;
import br.com.elotech.tributos.domain.ImobiliarioItbiObsId;
import br.com.elotech.tributos.domain.ImobiliarioItbiSegmento;
import br.com.elotech.tributos.domain.ImobiliarioItbiSegmentoId;
import br.com.elotech.tributos.domain.ParametroItbi;
import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.domain.ProprietarioItbi;
import br.com.elotech.tributos.domain.ProprietarioItbiId;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.domain.TipoItbi;
import br.com.elotech.tributos.domain.TipoProprietarioItbi;
import br.com.elotech.tributos.dto.ImobiliarioItbiDTO;
import br.com.elotech.tributos.dto.ImobiliarioItbiSegmentoDTO;
import br.com.elotech.tributos.exception.ProprietarioPrincipalItbiException;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.hibernate.validator.constraints.Length;
import org.springframework.http.HttpStatus;

@Entity
@Table(name="TRIBIMOBILIARIOITBI")
public class ImobiliarioItbi {
    @Id
    @EloSequence(sequenceName="s05imobiliarioitbi")
    @Column(name="idsequencia")
    @JsonProperty(value="idItbi")
    private Long id;
    private Long entidade;
    private Long exercicio;
    @NotNull
    private TipoCadastro tipoCadastro;
    @NotNull
    private Long cadastroGeral;
    private Long guiaRecolhimento;
    private Long subDivida;
    private LocalDate dataLancamento;
    private LocalDate dataSituacao;
    @Length(max=15)
    private String usuario;
    private LocalDate dataInclusao;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean transferido = Boolean.FALSE;
    private LocalDate dataVencimento;
    private BigDecimal valor = BigDecimal.ZERO;
    private BigDecimal valorFinanciado = BigDecimal.ZERO;
    private BigDecimal aliquota = BigDecimal.ZERO;
    private BigDecimal aliquotaFinanciado = BigDecimal.ZERO;
    private BigDecimal baseCalculo = BigDecimal.ZERO;
    private BigDecimal baseCalculoFinanciado = BigDecimal.ZERO;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean todasUnidades = Boolean.FALSE;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean debitoGerado = Boolean.FALSE;
    @ManyToOne
    @JoinColumn(name="tipoitbi")
    private TipoItbi tipoItbi;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean somenteTerreno = Boolean.FALSE;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean parcelado = Boolean.FALSE;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean transfereAutomatico = Boolean.FALSE;
    @NotNull
    private Long codigoItbi;
    @ManyToOne
    @JoinColumn(name="parametroitbi")
    private ParametroItbi parametroItbi;
    @JsonIgnore
    @OneToMany(mappedBy="id.itbi", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<ImobiliarioItbiObs> observacoes = new ArrayList();
    @JsonIgnore
    @OneToMany(mappedBy="id.itbi", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<ProprietarioItbi> proprietarios = new ArrayList();
    @JsonIgnore
    @OneToMany(mappedBy="id.itbi", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<ImobiliarioItbiSegmento> segmentos = new ArrayList();

    public void addObservacao(ImobiliarioItbiObs obs) {
        ImobiliarioItbiObsId idObs = new ImobiliarioItbiObsId();
        idObs.setItbi(this);
        idObs.setSequencia(Long.valueOf(this.observacoes.size() + 1));
        obs.setId(idObs);
        this.observacoes.add(obs);
    }

    public void addProprietario(ProprietarioItbi proprietario, Pessoa pessoa, TipoProprietarioItbi tipoProprietarioItbi) {
        ProprietarioItbiId idProprietario = new ProprietarioItbiId();
        idProprietario.setItbi(this);
        idProprietario.setPessoa(pessoa);
        idProprietario.setTipoProprietarioItbi(tipoProprietarioItbi);
        proprietario.setId(idProprietario);
        this.proprietarios.add(proprietario);
    }

    public void addSegmento(ImobiliarioItbiSegmento segmento) {
        ImobiliarioItbiSegmentoId idSegmento = new ImobiliarioItbiSegmentoId();
        idSegmento.setItbi(this);
        idSegmento.setSequencia(Integer.valueOf(this.segmentos.size() + 1));
        segmento.setId(idSegmento);
        this.segmentos.add(segmento);
    }

    public void addSegmento(ImobiliarioItbiSegmentoDTO segmentoDTO) {
        ImobiliarioItbiSegmentoId idSegmento = new ImobiliarioItbiSegmentoId();
        idSegmento.setItbi(this);
        idSegmento.setSequencia(segmentoDTO.getSequencia());
        ImobiliarioItbiSegmento segmento = new ImobiliarioItbiSegmento();
        segmento.setAreaConstruida(segmentoDTO.getAreaConstruida());
        segmento.setAreaItbi(segmentoDTO.getAreaItbi());
        segmento.setTipoSegmento(segmentoDTO.getTipoSegmento());
        segmento.setValorConstrucao(segmentoDTO.getValorConstrucao());
        segmento.setId(idSegmento);
        this.segmentos.add(segmento);
    }

    public static ImobiliarioItbi from(ImobiliarioItbiDTO dto) {
        TipoCadastroConverter converter = new TipoCadastroConverter();
        ImobiliarioItbi itbi = new ImobiliarioItbi();
        itbi.setTipoCadastro(converter.convertToEntityAttribute(dto.getTipoCadastro()));
        itbi.setCadastroGeral(dto.getCadastroGeral());
        itbi.setTransfereAutomatico(dto.getTransfereAutomatico());
        itbi.setValor(dto.getValor());
        itbi.setValorFinanciado(dto.getValorFinanciado());
        itbi.setAliquota(dto.getAliquota());
        itbi.setAliquotaFinanciado(dto.getAliquotaFinanciado());
        itbi.setBaseCalculo(dto.getBaseCalculo());
        itbi.setBaseCalculoFinanciado(dto.getBaseCalculoFinanciado());
        itbi.setUsuario(dto.getUsuario());
        dto.getObservacoes().stream().map(ImobiliarioItbiObs::new).forEach(arg_0 -> itbi.addObservacao(arg_0));
        return itbi;
    }

    public void validar() {
        if (this.proprietarios.stream().filter(ProprietarioItbi::isAtual).noneMatch(ProprietarioItbi::getPrincipal)) {
            throw new ProprietarioPrincipalItbiException(HttpStatus.BAD_REQUEST, "Necess\u00e1rio informar um novo propriet\u00e1rio principal.");
        }
    }

    @Generated
    public ImobiliarioItbi() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Long getEntidade() {
        return this.entidade;
    }

    @Generated
    public Long getExercicio() {
        return this.exercicio;
    }

    @Generated
    public TipoCadastro getTipoCadastro() {
        return this.tipoCadastro;
    }

    @Generated
    public Long getCadastroGeral() {
        return this.cadastroGeral;
    }

    @Generated
    public Long getGuiaRecolhimento() {
        return this.guiaRecolhimento;
    }

    @Generated
    public Long getSubDivida() {
        return this.subDivida;
    }

    @Generated
    public LocalDate getDataLancamento() {
        return this.dataLancamento;
    }

    @Generated
    public LocalDate getDataSituacao() {
        return this.dataSituacao;
    }

    @Generated
    public String getUsuario() {
        return this.usuario;
    }

    @Generated
    public LocalDate getDataInclusao() {
        return this.dataInclusao;
    }

    @Generated
    public Boolean getTransferido() {
        return this.transferido;
    }

    @Generated
    public LocalDate getDataVencimento() {
        return this.dataVencimento;
    }

    @Generated
    public BigDecimal getValor() {
        return this.valor;
    }

    @Generated
    public BigDecimal getValorFinanciado() {
        return this.valorFinanciado;
    }

    @Generated
    public BigDecimal getAliquota() {
        return this.aliquota;
    }

    @Generated
    public BigDecimal getAliquotaFinanciado() {
        return this.aliquotaFinanciado;
    }

    @Generated
    public BigDecimal getBaseCalculo() {
        return this.baseCalculo;
    }

    @Generated
    public BigDecimal getBaseCalculoFinanciado() {
        return this.baseCalculoFinanciado;
    }

    @Generated
    public Boolean getTodasUnidades() {
        return this.todasUnidades;
    }

    @Generated
    public Boolean getDebitoGerado() {
        return this.debitoGerado;
    }

    @Generated
    public TipoItbi getTipoItbi() {
        return this.tipoItbi;
    }

    @Generated
    public Boolean getSomenteTerreno() {
        return this.somenteTerreno;
    }

    @Generated
    public Boolean getParcelado() {
        return this.parcelado;
    }

    @Generated
    public Boolean getTransfereAutomatico() {
        return this.transfereAutomatico;
    }

    @Generated
    public Long getCodigoItbi() {
        return this.codigoItbi;
    }

    @Generated
    public ParametroItbi getParametroItbi() {
        return this.parametroItbi;
    }

    @Generated
    public List<ImobiliarioItbiObs> getObservacoes() {
        return this.observacoes;
    }

    @Generated
    public List<ProprietarioItbi> getProprietarios() {
        return this.proprietarios;
    }

    @Generated
    public List<ImobiliarioItbiSegmento> getSegmentos() {
        return this.segmentos;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    @Generated
    public void setExercicio(Long exercicio) {
        this.exercicio = exercicio;
    }

    @Generated
    public void setTipoCadastro(TipoCadastro tipoCadastro) {
        this.tipoCadastro = tipoCadastro;
    }

    @Generated
    public void setCadastroGeral(Long cadastroGeral) {
        this.cadastroGeral = cadastroGeral;
    }

    @Generated
    public void setGuiaRecolhimento(Long guiaRecolhimento) {
        this.guiaRecolhimento = guiaRecolhimento;
    }

    @Generated
    public void setSubDivida(Long subDivida) {
        this.subDivida = subDivida;
    }

    @Generated
    public void setDataLancamento(LocalDate dataLancamento) {
        this.dataLancamento = dataLancamento;
    }

    @Generated
    public void setDataSituacao(LocalDate dataSituacao) {
        this.dataSituacao = dataSituacao;
    }

    @Generated
    public void setUsuario(String usuario) {
        this.usuario = usuario;
    }

    @Generated
    public void setDataInclusao(LocalDate dataInclusao) {
        this.dataInclusao = dataInclusao;
    }

    @Generated
    public void setTransferido(Boolean transferido) {
        this.transferido = transferido;
    }

    @Generated
    public void setDataVencimento(LocalDate dataVencimento) {
        this.dataVencimento = dataVencimento;
    }

    @Generated
    public void setValor(BigDecimal valor) {
        this.valor = valor;
    }

    @Generated
    public void setValorFinanciado(BigDecimal valorFinanciado) {
        this.valorFinanciado = valorFinanciado;
    }

    @Generated
    public void setAliquota(BigDecimal aliquota) {
        this.aliquota = aliquota;
    }

    @Generated
    public void setAliquotaFinanciado(BigDecimal aliquotaFinanciado) {
        this.aliquotaFinanciado = aliquotaFinanciado;
    }

    @Generated
    public void setBaseCalculo(BigDecimal baseCalculo) {
        this.baseCalculo = baseCalculo;
    }

    @Generated
    public void setBaseCalculoFinanciado(BigDecimal baseCalculoFinanciado) {
        this.baseCalculoFinanciado = baseCalculoFinanciado;
    }

    @Generated
    public void setTodasUnidades(Boolean todasUnidades) {
        this.todasUnidades = todasUnidades;
    }

    @Generated
    public void setDebitoGerado(Boolean debitoGerado) {
        this.debitoGerado = debitoGerado;
    }

    @Generated
    public void setTipoItbi(TipoItbi tipoItbi) {
        this.tipoItbi = tipoItbi;
    }

    @Generated
    public void setSomenteTerreno(Boolean somenteTerreno) {
        this.somenteTerreno = somenteTerreno;
    }

    @Generated
    public void setParcelado(Boolean parcelado) {
        this.parcelado = parcelado;
    }

    @Generated
    public void setTransfereAutomatico(Boolean transfereAutomatico) {
        this.transfereAutomatico = transfereAutomatico;
    }

    @Generated
    public void setCodigoItbi(Long codigoItbi) {
        this.codigoItbi = codigoItbi;
    }

    @Generated
    public void setParametroItbi(ParametroItbi parametroItbi) {
        this.parametroItbi = parametroItbi;
    }

    @Generated
    public void setObservacoes(List<ImobiliarioItbiObs> observacoes) {
        this.observacoes = observacoes;
    }

    @Generated
    public void setProprietarios(List<ProprietarioItbi> proprietarios) {
        this.proprietarios = proprietarios;
    }

    @Generated
    public void setSegmentos(List<ImobiliarioItbiSegmento> segmentos) {
        this.segmentos = segmentos;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ImobiliarioItbi)) {
            return false;
        }
        ImobiliarioItbi other = (ImobiliarioItbi)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$entidade = this.getEntidade();
        Long other$entidade = other.getEntidade();
        if (this$entidade == null ? other$entidade != null : !((Object)this$entidade).equals(other$entidade)) {
            return false;
        }
        Long this$exercicio = this.getExercicio();
        Long other$exercicio = other.getExercicio();
        if (this$exercicio == null ? other$exercicio != null : !((Object)this$exercicio).equals(other$exercicio)) {
            return false;
        }
        TipoCadastro this$tipoCadastro = this.getTipoCadastro();
        TipoCadastro other$tipoCadastro = other.getTipoCadastro();
        if (this$tipoCadastro == null ? other$tipoCadastro != null : !this$tipoCadastro.equals(other$tipoCadastro)) {
            return false;
        }
        Long this$cadastroGeral = this.getCadastroGeral();
        Long other$cadastroGeral = other.getCadastroGeral();
        if (this$cadastroGeral == null ? other$cadastroGeral != null : !((Object)this$cadastroGeral).equals(other$cadastroGeral)) {
            return false;
        }
        Long this$guiaRecolhimento = this.getGuiaRecolhimento();
        Long other$guiaRecolhimento = other.getGuiaRecolhimento();
        if (this$guiaRecolhimento == null ? other$guiaRecolhimento != null : !((Object)this$guiaRecolhimento).equals(other$guiaRecolhimento)) {
            return false;
        }
        Long this$subDivida = this.getSubDivida();
        Long other$subDivida = other.getSubDivida();
        if (this$subDivida == null ? other$subDivida != null : !((Object)this$subDivida).equals(other$subDivida)) {
            return false;
        }
        LocalDate this$dataLancamento = this.getDataLancamento();
        LocalDate other$dataLancamento = other.getDataLancamento();
        if (this$dataLancamento == null ? other$dataLancamento != null : !((Object)this$dataLancamento).equals(other$dataLancamento)) {
            return false;
        }
        LocalDate this$dataSituacao = this.getDataSituacao();
        LocalDate other$dataSituacao = other.getDataSituacao();
        if (this$dataSituacao == null ? other$dataSituacao != null : !((Object)this$dataSituacao).equals(other$dataSituacao)) {
            return false;
        }
        String this$usuario = this.getUsuario();
        String other$usuario = other.getUsuario();
        if (this$usuario == null ? other$usuario != null : !this$usuario.equals(other$usuario)) {
            return false;
        }
        LocalDate this$dataInclusao = this.getDataInclusao();
        LocalDate other$dataInclusao = other.getDataInclusao();
        if (this$dataInclusao == null ? other$dataInclusao != null : !((Object)this$dataInclusao).equals(other$dataInclusao)) {
            return false;
        }
        Boolean this$transferido = this.getTransferido();
        Boolean other$transferido = other.getTransferido();
        if (this$transferido == null ? other$transferido != null : !((Object)this$transferido).equals(other$transferido)) {
            return false;
        }
        LocalDate this$dataVencimento = this.getDataVencimento();
        LocalDate other$dataVencimento = other.getDataVencimento();
        if (this$dataVencimento == null ? other$dataVencimento != null : !((Object)this$dataVencimento).equals(other$dataVencimento)) {
            return false;
        }
        BigDecimal this$valor = this.getValor();
        BigDecimal other$valor = other.getValor();
        if (this$valor == null ? other$valor != null : !((Object)this$valor).equals(other$valor)) {
            return false;
        }
        BigDecimal this$valorFinanciado = this.getValorFinanciado();
        BigDecimal other$valorFinanciado = other.getValorFinanciado();
        if (this$valorFinanciado == null ? other$valorFinanciado != null : !((Object)this$valorFinanciado).equals(other$valorFinanciado)) {
            return false;
        }
        BigDecimal this$aliquota = this.getAliquota();
        BigDecimal other$aliquota = other.getAliquota();
        if (this$aliquota == null ? other$aliquota != null : !((Object)this$aliquota).equals(other$aliquota)) {
            return false;
        }
        BigDecimal this$aliquotaFinanciado = this.getAliquotaFinanciado();
        BigDecimal other$aliquotaFinanciado = other.getAliquotaFinanciado();
        if (this$aliquotaFinanciado == null ? other$aliquotaFinanciado != null : !((Object)this$aliquotaFinanciado).equals(other$aliquotaFinanciado)) {
            return false;
        }
        BigDecimal this$baseCalculo = this.getBaseCalculo();
        BigDecimal other$baseCalculo = other.getBaseCalculo();
        if (this$baseCalculo == null ? other$baseCalculo != null : !((Object)this$baseCalculo).equals(other$baseCalculo)) {
            return false;
        }
        BigDecimal this$baseCalculoFinanciado = this.getBaseCalculoFinanciado();
        BigDecimal other$baseCalculoFinanciado = other.getBaseCalculoFinanciado();
        if (this$baseCalculoFinanciado == null ? other$baseCalculoFinanciado != null : !((Object)this$baseCalculoFinanciado).equals(other$baseCalculoFinanciado)) {
            return false;
        }
        Boolean this$todasUnidades = this.getTodasUnidades();
        Boolean other$todasUnidades = other.getTodasUnidades();
        if (this$todasUnidades == null ? other$todasUnidades != null : !((Object)this$todasUnidades).equals(other$todasUnidades)) {
            return false;
        }
        Boolean this$debitoGerado = this.getDebitoGerado();
        Boolean other$debitoGerado = other.getDebitoGerado();
        if (this$debitoGerado == null ? other$debitoGerado != null : !((Object)this$debitoGerado).equals(other$debitoGerado)) {
            return false;
        }
        TipoItbi this$tipoItbi = this.getTipoItbi();
        TipoItbi other$tipoItbi = other.getTipoItbi();
        if (this$tipoItbi == null ? other$tipoItbi != null : !this$tipoItbi.equals(other$tipoItbi)) {
            return false;
        }
        Boolean this$somenteTerreno = this.getSomenteTerreno();
        Boolean other$somenteTerreno = other.getSomenteTerreno();
        if (this$somenteTerreno == null ? other$somenteTerreno != null : !((Object)this$somenteTerreno).equals(other$somenteTerreno)) {
            return false;
        }
        Boolean this$parcelado = this.getParcelado();
        Boolean other$parcelado = other.getParcelado();
        if (this$parcelado == null ? other$parcelado != null : !((Object)this$parcelado).equals(other$parcelado)) {
            return false;
        }
        Boolean this$transfereAutomatico = this.getTransfereAutomatico();
        Boolean other$transfereAutomatico = other.getTransfereAutomatico();
        if (this$transfereAutomatico == null ? other$transfereAutomatico != null : !((Object)this$transfereAutomatico).equals(other$transfereAutomatico)) {
            return false;
        }
        Long this$codigoItbi = this.getCodigoItbi();
        Long other$codigoItbi = other.getCodigoItbi();
        if (this$codigoItbi == null ? other$codigoItbi != null : !((Object)this$codigoItbi).equals(other$codigoItbi)) {
            return false;
        }
        ParametroItbi this$parametroItbi = this.getParametroItbi();
        ParametroItbi other$parametroItbi = other.getParametroItbi();
        if (this$parametroItbi == null ? other$parametroItbi != null : !this$parametroItbi.equals(other$parametroItbi)) {
            return false;
        }
        List this$observacoes = this.getObservacoes();
        List other$observacoes = other.getObservacoes();
        if (this$observacoes == null ? other$observacoes != null : !((Object)this$observacoes).equals(other$observacoes)) {
            return false;
        }
        List this$proprietarios = this.getProprietarios();
        List other$proprietarios = other.getProprietarios();
        if (this$proprietarios == null ? other$proprietarios != null : !((Object)this$proprietarios).equals(other$proprietarios)) {
            return false;
        }
        List this$segmentos = this.getSegmentos();
        List other$segmentos = other.getSegmentos();
        return !(this$segmentos == null ? other$segmentos != null : !((Object)this$segmentos).equals(other$segmentos));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ImobiliarioItbi;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $entidade = this.getEntidade();
        result = result * 59 + ($entidade == null ? 43 : ((Object)$entidade).hashCode());
        Long $exercicio = this.getExercicio();
        result = result * 59 + ($exercicio == null ? 43 : ((Object)$exercicio).hashCode());
        TipoCadastro $tipoCadastro = this.getTipoCadastro();
        result = result * 59 + ($tipoCadastro == null ? 43 : $tipoCadastro.hashCode());
        Long $cadastroGeral = this.getCadastroGeral();
        result = result * 59 + ($cadastroGeral == null ? 43 : ((Object)$cadastroGeral).hashCode());
        Long $guiaRecolhimento = this.getGuiaRecolhimento();
        result = result * 59 + ($guiaRecolhimento == null ? 43 : ((Object)$guiaRecolhimento).hashCode());
        Long $subDivida = this.getSubDivida();
        result = result * 59 + ($subDivida == null ? 43 : ((Object)$subDivida).hashCode());
        LocalDate $dataLancamento = this.getDataLancamento();
        result = result * 59 + ($dataLancamento == null ? 43 : ((Object)$dataLancamento).hashCode());
        LocalDate $dataSituacao = this.getDataSituacao();
        result = result * 59 + ($dataSituacao == null ? 43 : ((Object)$dataSituacao).hashCode());
        String $usuario = this.getUsuario();
        result = result * 59 + ($usuario == null ? 43 : $usuario.hashCode());
        LocalDate $dataInclusao = this.getDataInclusao();
        result = result * 59 + ($dataInclusao == null ? 43 : ((Object)$dataInclusao).hashCode());
        Boolean $transferido = this.getTransferido();
        result = result * 59 + ($transferido == null ? 43 : ((Object)$transferido).hashCode());
        LocalDate $dataVencimento = this.getDataVencimento();
        result = result * 59 + ($dataVencimento == null ? 43 : ((Object)$dataVencimento).hashCode());
        BigDecimal $valor = this.getValor();
        result = result * 59 + ($valor == null ? 43 : ((Object)$valor).hashCode());
        BigDecimal $valorFinanciado = this.getValorFinanciado();
        result = result * 59 + ($valorFinanciado == null ? 43 : ((Object)$valorFinanciado).hashCode());
        BigDecimal $aliquota = this.getAliquota();
        result = result * 59 + ($aliquota == null ? 43 : ((Object)$aliquota).hashCode());
        BigDecimal $aliquotaFinanciado = this.getAliquotaFinanciado();
        result = result * 59 + ($aliquotaFinanciado == null ? 43 : ((Object)$aliquotaFinanciado).hashCode());
        BigDecimal $baseCalculo = this.getBaseCalculo();
        result = result * 59 + ($baseCalculo == null ? 43 : ((Object)$baseCalculo).hashCode());
        BigDecimal $baseCalculoFinanciado = this.getBaseCalculoFinanciado();
        result = result * 59 + ($baseCalculoFinanciado == null ? 43 : ((Object)$baseCalculoFinanciado).hashCode());
        Boolean $todasUnidades = this.getTodasUnidades();
        result = result * 59 + ($todasUnidades == null ? 43 : ((Object)$todasUnidades).hashCode());
        Boolean $debitoGerado = this.getDebitoGerado();
        result = result * 59 + ($debitoGerado == null ? 43 : ((Object)$debitoGerado).hashCode());
        TipoItbi $tipoItbi = this.getTipoItbi();
        result = result * 59 + ($tipoItbi == null ? 43 : $tipoItbi.hashCode());
        Boolean $somenteTerreno = this.getSomenteTerreno();
        result = result * 59 + ($somenteTerreno == null ? 43 : ((Object)$somenteTerreno).hashCode());
        Boolean $parcelado = this.getParcelado();
        result = result * 59 + ($parcelado == null ? 43 : ((Object)$parcelado).hashCode());
        Boolean $transfereAutomatico = this.getTransfereAutomatico();
        result = result * 59 + ($transfereAutomatico == null ? 43 : ((Object)$transfereAutomatico).hashCode());
        Long $codigoItbi = this.getCodigoItbi();
        result = result * 59 + ($codigoItbi == null ? 43 : ((Object)$codigoItbi).hashCode());
        ParametroItbi $parametroItbi = this.getParametroItbi();
        result = result * 59 + ($parametroItbi == null ? 43 : $parametroItbi.hashCode());
        List $observacoes = this.getObservacoes();
        result = result * 59 + ($observacoes == null ? 43 : ((Object)$observacoes).hashCode());
        List $proprietarios = this.getProprietarios();
        result = result * 59 + ($proprietarios == null ? 43 : ((Object)$proprietarios).hashCode());
        List $segmentos = this.getSegmentos();
        result = result * 59 + ($segmentos == null ? 43 : ((Object)$segmentos).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ImobiliarioItbi(id=" + this.getId() + ", entidade=" + this.getEntidade() + ", exercicio=" + this.getExercicio() + ", tipoCadastro=" + this.getTipoCadastro() + ", cadastroGeral=" + this.getCadastroGeral() + ", guiaRecolhimento=" + this.getGuiaRecolhimento() + ", subDivida=" + this.getSubDivida() + ", dataLancamento=" + this.getDataLancamento() + ", dataSituacao=" + this.getDataSituacao() + ", usuario=" + this.getUsuario() + ", dataInclusao=" + this.getDataInclusao() + ", transferido=" + this.getTransferido() + ", dataVencimento=" + this.getDataVencimento() + ", valor=" + this.getValor() + ", valorFinanciado=" + this.getValorFinanciado() + ", aliquota=" + this.getAliquota() + ", aliquotaFinanciado=" + this.getAliquotaFinanciado() + ", baseCalculo=" + this.getBaseCalculo() + ", baseCalculoFinanciado=" + this.getBaseCalculoFinanciado() + ", todasUnidades=" + this.getTodasUnidades() + ", debitoGerado=" + this.getDebitoGerado() + ", tipoItbi=" + this.getTipoItbi() + ", somenteTerreno=" + this.getSomenteTerreno() + ", parcelado=" + this.getParcelado() + ", transfereAutomatico=" + this.getTransfereAutomatico() + ", codigoItbi=" + this.getCodigoItbi() + ", parametroItbi=" + this.getParametroItbi() + ", observacoes=" + this.getObservacoes() + ", proprietarios=" + this.getProprietarios() + ", segmentos=" + this.getSegmentos() + ")";
    }
}

