/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.converter.BooleanToStringConverter;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import lombok.Generated;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="CONTATOPESSOA")
@DynamicInsert
@DynamicUpdate
public class ContatoPessoa {
    @Id
    @Column(name="idkey")
    @EloSequence(applyOnMerge=true, sequenceName="S_CONTATOPESSOA_ID")
    private Long id;
    @Column(name="sequencia")
    @EloSequence
    private Long codigo;
    @Length(max=60)
    private String nome;
    @Length(max=20)
    private String telefoneResidencial;
    @Length(max=20)
    private String telefoneComercial;
    @Length(max=20)
    private String telefoneFax;
    @Length(max=20)
    private String telefoneCelular;
    @Length(max=100)
    private String email;
    @Length(max=100)
    private String homepage;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean representanteLegal = Boolean.FALSE;

    public ContatoPessoa withPk(Long id) {
        this.id = id;
        return this;
    }

    public String getNome() {
        return this.nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public String getTelefoneResidencial() {
        return this.telefoneResidencial;
    }

    public String getTelefoneComercial() {
        return this.telefoneComercial;
    }

    public String getTelefoneFax() {
        return this.telefoneFax;
    }

    public String getTelefoneCelular() {
        return this.telefoneCelular;
    }

    public void setTelefoneResidencial(String telefoneResidencial) {
        this.telefoneResidencial = telefoneResidencial;
    }

    public void setTelefoneComercial(String telefoneComercial) {
        this.telefoneComercial = telefoneComercial;
    }

    public void setTelefoneFax(String telefoneFax) {
        this.telefoneFax = telefoneFax;
    }

    public void setTelefoneCelular(String telefoneCelular) {
        this.telefoneCelular = telefoneCelular;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getHomepage() {
        return this.homepage;
    }

    public void setHomepage(String homepage) {
        this.homepage = homepage;
    }

    public void setRepresentanteLegal(Boolean representanteLegal) {
        this.representanteLegal = representanteLegal;
    }

    public Boolean getRepresentanteLegal() {
        return this.representanteLegal;
    }

    public static ContatoPessoa of(Long id) {
        return new ContatoPessoa().withId(id);
    }

    private ContatoPessoa withId(Long id) {
        this.setCodigo(id);
        return this;
    }

    public ContatoPessoa withEmail(String email) {
        this.setEmail(email);
        return this;
    }

    public Long getCodigo() {
        return this.codigo;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setCodigo(Long codigo) {
        this.codigo = codigo;
    }

    public Long getId() {
        return this.id;
    }

    @Generated
    public String toString() {
        return "ContatoPessoa(id=" + this.getId() + ", codigo=" + this.getCodigo() + ", nome=" + this.getNome() + ", telefoneResidencial=" + this.getTelefoneResidencial() + ", telefoneComercial=" + this.getTelefoneComercial() + ", telefoneFax=" + this.getTelefoneFax() + ", telefoneCelular=" + this.getTelefoneCelular() + ", email=" + this.getEmail() + ", homepage=" + this.getHomepage() + ", representanteLegal=" + this.getRepresentanteLegal() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ContatoPessoa)) {
            return false;
        }
        ContatoPessoa other = (ContatoPessoa)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ContatoPessoa;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }
}

