/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.converter.BooleanToStringConverter;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.metamodel.annotation.Caption;
import br.com.elotech.tributos.domain.Bairro;
import br.com.elotech.tributos.domain.CadastroGeralIsencao;
import br.com.elotech.tributos.domain.Cidade;
import br.com.elotech.tributos.domain.Logradouro;
import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.domain.Proprietario;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.domain.mobiliario.RegimeFiscalPeriodo;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.envers.AuditJoinTable;
import org.hibernate.envers.Audited;
import org.hibernate.envers.NotAudited;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="TRIBCADASTROGERAL")
@Inheritance(strategy=InheritanceType.JOINED)
@DynamicInsert
@DynamicUpdate
@Audited
public class CadastroGeral
implements EloEntity<Long>,
Serializable {
    @Id
    @Column(name="idkey")
    @EloSequence(sequenceName="S_TRIBCADASTROGERAL_ID")
    private Long id;
    @NotNull
    private TipoCadastro tipoCadastro;
    @EloSequence(sequenceNameFactory="#{sequenceCadastroGeralService.getExpression(tipoCadastro)}")
    @Min(value=1L)
    private @Min(value=1L) Long cadastroGeral;
    @ManyToOne
    @NotAudited
    private Pessoa pessoa;
    @Length(max=10)
    private String numero;
    @Length(max=100)
    private String complemento;
    @NotAudited
    @ManyToOne
    @JoinColumn
    private Cidade cidade;
    @NotAudited
    @ManyToOne
    @JoinColumn(name="LOGRADOURO_IDKEY")
    private Logradouro logradouro;
    @NotAudited
    @ManyToOne
    @JoinColumn(name="BAIRRO_IDKEY")
    private Bairro bairro;
    private Long cep;
    @NotNull
    @Column(name="IDCADASTROGERALISS")
    private Long cadastroGeralISS;
    @Convert(converter=BooleanToStringConverter.class)
    @Caption(value="Exclus\u00e3o L\u00f3gica")
    private Boolean exclusaoLogica = Boolean.FALSE;
    @Convert(converter=BooleanToStringConverter.class)
    @Caption(value="Englobado")
    private Boolean englobado = Boolean.FALSE;
    @Convert(converter=BooleanToStringConverter.class)
    @Caption(value="Suspenso Emiss\u00e3o")
    private Boolean suspensoEmissao = Boolean.FALSE;
    @Convert(converter=BooleanToStringConverter.class)
    @Caption(value="Correspond\u00eancia Local")
    private Boolean correspondenciaLocal = Boolean.FALSE;
    private LocalDate dataInclusao = LocalDate.now();
    private LocalDate dataAlteracao = LocalDate.now();
    @Convert(converter=BooleanToStringConverter.class)
    @Caption(value="D\u00e9bito Autom\u00e1tico")
    private Boolean debitoAutomatico;
    @Length(max=25)
    private String identificacao;
    @Convert(converter=BooleanToStringConverter.class)
    @Caption(value="Endere\u00e7o Entrega Carne Anual")
    private Boolean enderecoEntregaCarneAnual;
    @Length(max=100)
    @Caption(value="Endere\u00e7o Correspond\u00eancia")
    private String enderecoCorrespondencia;
    @Length(max=20)
    @Caption(value="N\u00famero Correspond\u00eancia")
    private String numeroCorrespondencia;
    @Length(max=100)
    @Caption(value="Complemento Correspond\u00eancia")
    private String complementoCorrespondencia;
    @Length(max=100)
    @Caption(value="Cidade/UF Correspond\u00eancia")
    private String cidadeUfCorrespondencia;
    @Length(max=20)
    @Caption(value="CEP Correspond\u00eancia")
    private String cepCorrespondencia;
    @Length(max=100)
    @Caption(value="Bairro Correspondencia")
    private String bairroCorrespondencia;
    @Length(max=15)
    private String usuario;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.LAZY)
    @JoinColumn(name="TRIBCADASTROGERAL_IDKEY", updatable=false, nullable=false)
    @AuditJoinTable(name="TRIBCADGERALISENCAO_CAD_AUD")
    @Caption(value="Isen\u00e7\u00f5es")
    private final List<CadastroGeralIsencao> cadastroGeralIsencoes = new ArrayList();
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.LAZY)
    @JoinColumn(name="TRIBCADASTROGERAL_IDKEY", updatable=false, nullable=false)
    @AuditJoinTable(name="TRIBPROPRIETARIO_CAD_AUD")
    @Caption(value="Propriet\u00e1rios")
    private final List<Proprietario> proprietarios = new ArrayList();
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.LAZY)
    @JoinColumn(name="idcadastro", referencedColumnName="idcadastrogeraliss", insertable=false, updatable=false)
    @Caption(value="Regimes Fiscais por Per\u00edodo")
    @AuditJoinTable(name="REGIMEFISCALPER_CADASTRO_AUD")
    private List<RegimeFiscalPeriodo> regimeFiscalPeriodo = new ArrayList();

    public Long getCadastroGeralISS() {
        return this.cadastroGeralISS;
    }

    public void setCadastroGeralISS(Long cadastroGeralISS) {
        this.cadastroGeralISS = cadastroGeralISS;
    }

    public Pessoa getPessoa() {
        return this.pessoa;
    }

    public void setPessoa(Pessoa pessoa) {
        this.pessoa = pessoa;
    }

    public String getNumero() {
        return this.numero;
    }

    public void setNumero(String numero) {
        this.numero = numero;
    }

    public String getComplemento() {
        return this.complemento;
    }

    public void setComplemento(String complemento) {
        this.complemento = complemento;
    }

    public Cidade getCidade() {
        return this.cidade;
    }

    public void setCidade(Cidade cidade) {
        this.cidade = cidade;
    }

    public Logradouro getLogradouro() {
        return this.logradouro;
    }

    public void setLogradouro(Logradouro logradouro) {
        this.logradouro = logradouro;
    }

    public Bairro getBairro() {
        return this.bairro;
    }

    public void setBairro(Bairro bairro) {
        this.bairro = bairro;
    }

    public Long getCep() {
        return this.cep;
    }

    public void setCep(Long cep) {
        this.cep = cep;
    }

    public Boolean getExclusaoLogica() {
        return this.exclusaoLogica;
    }

    public Boolean getEnglobado() {
        return this.englobado;
    }

    public Boolean getSuspensoEmissao() {
        return this.suspensoEmissao;
    }

    public Boolean getCorrespondenciaLocal() {
        return this.correspondenciaLocal;
    }

    public LocalDate getDataInclusao() {
        return this.dataInclusao;
    }

    public LocalDate getDataAlteracao() {
        return this.dataAlteracao;
    }

    public Boolean getDebitoAutomatico() {
        return this.debitoAutomatico;
    }

    public String getIdentificacao() {
        return this.identificacao;
    }

    public Boolean getEnderecoEntregaCarneAnual() {
        return this.enderecoEntregaCarneAnual;
    }

    public String getEnderecoCorrespondencia() {
        return this.enderecoCorrespondencia;
    }

    public String getNumeroCorrespondencia() {
        return this.numeroCorrespondencia;
    }

    public String getComplementoCorrespondencia() {
        return this.complementoCorrespondencia;
    }

    public String getCidadeUfCorrespondencia() {
        return this.cidadeUfCorrespondencia;
    }

    public String getCepCorrespondencia() {
        return this.cepCorrespondencia;
    }

    public String getBairroCorrespondencia() {
        return this.bairroCorrespondencia;
    }

    public String getUsuario() {
        return this.usuario;
    }

    public void setExclusaoLogica(Boolean exclusaoLogica) {
        this.exclusaoLogica = exclusaoLogica;
    }

    public void setEnglobado(Boolean englobado) {
        this.englobado = englobado;
    }

    public void setSuspensoEmissao(Boolean suspensoEmissao) {
        this.suspensoEmissao = suspensoEmissao;
    }

    public void setCorrespondenciaLocal(Boolean correspondenciaLocal) {
        this.correspondenciaLocal = correspondenciaLocal;
    }

    public void setDataInclusao(LocalDate dataInclusao) {
        this.dataInclusao = dataInclusao;
    }

    public void setDataAlteracao(LocalDate dataAlteracao) {
        this.dataAlteracao = dataAlteracao;
    }

    public void setDebitoAutomatico(Boolean debitoAutomatico) {
        this.debitoAutomatico = debitoAutomatico;
    }

    public void setIdentificacao(String identificacao) {
        this.identificacao = identificacao;
    }

    public void setEnderecoEntregaCarneAnual(Boolean enderecoEntregaCarneAnual) {
        this.enderecoEntregaCarneAnual = enderecoEntregaCarneAnual;
    }

    public void setEnderecoCorrespondencia(String enderecoCorrespondencia) {
        this.enderecoCorrespondencia = enderecoCorrespondencia;
    }

    public void setNumeroCorrespondencia(String numeroCorrespondencia) {
        this.numeroCorrespondencia = numeroCorrespondencia;
    }

    public void setComplementoCorrespondencia(String complementoCorrespondencia) {
        this.complementoCorrespondencia = complementoCorrespondencia;
    }

    public void setCidadeUfCorrespondencia(String cidadeUfCorrespondencia) {
        this.cidadeUfCorrespondencia = cidadeUfCorrespondencia;
    }

    public void setCepCorrespondencia(String cepCorrespondencia) {
        this.cepCorrespondencia = cepCorrespondencia;
    }

    public void setBairroCorrespondencia(String bairroCorrespondencia) {
        this.bairroCorrespondencia = bairroCorrespondencia;
    }

    public void setUsuario(String usuario) {
        this.usuario = usuario;
    }

    public String getEnderecoFormatado() {
        StringBuilder result = new StringBuilder();
        if (this.logradouro != null) {
            result.append(this.logradouro.getTipoLogradouroDescricao()).append(" ").append(this.logradouro.getDescricao()).append(", ").append(StringUtils.defaultString((String)this.numero));
        }
        if (this.bairro != null) {
            result.append(" - ").append(this.bairro.getDescricao());
        }
        return result.toString();
    }

    public String getCidadeFormatada() {
        StringBuilder result = new StringBuilder();
        if (this.cidade != null) {
            result.append(this.cidade.getDescricao()).append('/').append(this.cidade.getUnidadeFederacao());
        }
        return result.toString();
    }

    public List<CadastroGeralIsencao> getCadastroGeralIsencoes() {
        return this.cadastroGeralIsencoes;
    }

    public List<Proprietario> getProprietarios() {
        return this.proprietarios;
    }

    public Long getId() {
        return this.id;
    }

    public TipoCadastro getTipoCadastro() {
        return this.tipoCadastro;
    }

    public Long getCadastroGeral() {
        return this.cadastroGeral;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setTipoCadastro(TipoCadastro tipoCadastro) {
        this.tipoCadastro = tipoCadastro;
    }

    public void setCadastroGeral(Long cadastroGeral) {
        this.cadastroGeral = cadastroGeral;
    }

    public List<RegimeFiscalPeriodo> getRegimeFiscalPeriodo() {
        return this.regimeFiscalPeriodo;
    }

    public void setRegimeFiscalPeriodo(List<RegimeFiscalPeriodo> regimeFiscalPeriodo) {
        this.regimeFiscalPeriodo = regimeFiscalPeriodo;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CadastroGeral)) {
            return false;
        }
        CadastroGeral other = (CadastroGeral)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CadastroGeral;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "CadastroGeral(id=" + this.getId() + ")";
    }
}

