/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.controller;

import br.com.elotech.core.exception.RestException;
import br.com.elotech.core.utils.web.ResponseUtils;
import br.com.elotech.tributos.dto.DebitoAutomaticoDTO;
import br.com.elotech.tributos.params.DebitoAutomaticoParams;
import br.com.elotech.tributos.report.RelatorioTributos;
import br.com.elotech.tributos.service.DebitoAutomaticoRelatorioService;
import br.com.elotech.tributos.service.DebitoAutomaticoService;
import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/api/relatorios"})
public class DebitoAutomaticoRelatorioController {
    private final DebitoAutomaticoService debitoDebitoAutomaticoService;
    private final DebitoAutomaticoRelatorioService debitoAutomaticoRelatorioService;

    public DebitoAutomaticoRelatorioController(DebitoAutomaticoService debitoDebitoAutomaticoService, DebitoAutomaticoRelatorioService debitoAutomaticoRelatorioService) {
        this.debitoDebitoAutomaticoService = debitoDebitoAutomaticoService;
        this.debitoAutomaticoRelatorioService = debitoAutomaticoRelatorioService;
    }

    @RequestMapping(value={"/debito-automatico"}, method={RequestMethod.GET}, params={"exercicio", "tipoCadastro", "cadastroGeral", "guiaRecolhimento", "subDivida", "opcaoDebitoAutomatico"})
    public void imprimirIdentificacaoDebitoAutomatico(DebitoAutomaticoParams params, HttpServletResponse response) throws IOException {
        DebitoAutomaticoDTO debitoAutomatico = this.loadDebitosDebitoAutomatico(params);
        if (debitoAutomatico.getPk() == null) {
            throw RestException.notFound((String)"Problemas para imprimir o relat\u00f3rio");
        }
        byte[] identificacaoDebitoAutomatico = this.debitoAutomaticoRelatorioService.createDebitoAutomaticoPdfReport(debitoAutomatico);
        ResponseUtils.writePdfToResponse((HttpServletResponse)response, (byte[])identificacaoDebitoAutomatico, (String)RelatorioTributos.DEBITO_AUTOMATICO.getNomePdf());
    }

    private DebitoAutomaticoDTO loadDebitosDebitoAutomatico(DebitoAutomaticoParams params) {
        DebitoAutomaticoDTO debitoAutomaticoDTO = this.debitoDebitoAutomaticoService.getDebitoAutomatico(params.getExercicio(), params.getTipoCadastro(), params.getCadastroGeral(), params.getGuiaRecolhimento(), params.getSubDivida());
        debitoAutomaticoDTO.setOpcaoDebitoAutomatico(params.getOpcaoDebitoAutomatico());
        return debitoAutomaticoDTO;
    }
}

