/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.config;

import br.com.elotech.tributos.config.CustomJaxbNamingPrefix;
import br.com.elotech.tributos.config.CustomResponseErrorHandler;
import br.com.elotech.tributos.config.TributosProperties;
import br.com.elotech.tributos.ws.interceptor.ChangeXsiAttribute;
import java.util.HashMap;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.HttpClientBuilder;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.oxm.Marshaller;
import org.springframework.oxm.jaxb.Jaxb2Marshaller;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestTemplate;
import org.springframework.ws.client.core.WebServiceTemplate;
import org.springframework.ws.client.support.interceptor.ClientInterceptor;
import org.springframework.ws.transport.WebServiceMessageSender;
import org.springframework.ws.transport.http.HttpComponentsMessageSender;

@Configuration
public class WebServiceTemplateConfiguration {
    private static final String[] WS_CLASSES_PACKAGES = new String[]{"br.com.elotech.tributos.ws.domain"};

    @Bean
    public HttpClient aiseWebServiceHttpClient(TributosProperties tributosProperties) {
        RequestConfig requestConfiguration = RequestConfig.custom().setConnectTimeout(tributosProperties.getAise().getConnectTimeout().intValue()).setSocketTimeout(tributosProperties.getAise().getSocketTimeout().intValue()).build();
        return HttpClientBuilder.create().addInterceptorFirst((HttpRequestInterceptor)new HttpComponentsMessageSender.RemoveSoapHeadersInterceptor()).setDefaultRequestConfig(requestConfiguration).build();
    }

    @Bean
    public HttpComponentsMessageSender aiseWebServiceHttpSender(HttpClient httpClient) {
        return new HttpComponentsMessageSender(httpClient);
    }

    @Bean
    public Jaxb2Marshaller aiseWebServiceMarshaller() {
        Jaxb2Marshaller jaxb2Marshaller = new Jaxb2Marshaller();
        jaxb2Marshaller.setPackagesToScan(WS_CLASSES_PACKAGES);
        HashMap<String, CustomJaxbNamingPrefix> marshallerProperties = new HashMap<String, CustomJaxbNamingPrefix>();
        marshallerProperties.put("com.sun.xml.bind.namespacePrefixMapper", new CustomJaxbNamingPrefix());
        jaxb2Marshaller.setMarshallerProperties(marshallerProperties);
        return jaxb2Marshaller;
    }

    @Bean
    public ChangeXsiAttribute aiseWSChangeXsiAttrInterceptor() {
        return new ChangeXsiAttribute();
    }

    @Bean
    public WebServiceTemplate aiseWebServiceTemplate(Jaxb2Marshaller marshaller, HttpComponentsMessageSender sender, ChangeXsiAttribute interceptor, TributosProperties tributosProperties) {
        String defaultUri = String.format("%s/soap/IIAiseServiceTributos", tributosProperties.getAise().getBaseUrl());
        WebServiceTemplate webServiceTemplate = new WebServiceTemplate((Marshaller)marshaller);
        webServiceTemplate.setMessageSender((WebServiceMessageSender)sender);
        webServiceTemplate.setInterceptors(new ClientInterceptor[]{interceptor});
        webServiceTemplate.setDefaultUri(defaultUri);
        return webServiceTemplate;
    }

    @Bean
    public RestTemplate restTemplate(RestTemplateBuilder restTemplateBuilder) {
        return restTemplateBuilder.errorHandler((ResponseErrorHandler)new CustomResponseErrorHandler()).build();
    }
}

