/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.config;

import br.com.elotech.tributos.exception.AiseWebServiceExceptionUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.web.client.DefaultResponseErrorHandler;

public class CustomResponseErrorHandler
extends DefaultResponseErrorHandler {
    private static final Logger LOG = LoggerFactory.getLogger(CustomResponseErrorHandler.class);

    public void handleError(ClientHttpResponse response, HttpStatus httpStatus) throws IOException {
        String responseString = new String(this.getResponseBody(response));
        try {
            Map erros = (Map)new ObjectMapper().readValue(responseString, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            if (erros.containsKey("erro")) {
                responseString = (String)erros.get("erro");
            } else if (erros.containsKey("error")) {
                responseString = (String)erros.get("error");
            }
        }
        catch (IOException e) {
            LOG.warn("Falha ao obter mensagem de erro!", (Throwable)e);
        }
        if (HttpStatus.UNAUTHORIZED.equals((Object)httpStatus)) {
            LOG.error("Falha na autentica\u00e7\u00e3o do webservice: {}", (Object)responseString);
            throw AiseWebServiceExceptionUtils.status((HttpStatus)HttpStatus.UNAUTHORIZED, (String)"O servi\u00e7o est\u00e1 indispon\u00edvel no momento.");
        }
        throw AiseWebServiceExceptionUtils.status((HttpStatus)httpStatus, (String)responseString);
    }
}

