/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.aop;

import com.google.common.base.Predicates;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;

@Aspect
public class LoggingAspect {
    private static final Logger LOG = LoggerFactory.getLogger(LoggingAspect.class);
    private final Environment env;

    public LoggingAspect(Environment env) {
        this.env = env;
    }

    @Pointcut(value="within(br.com.elotech.tributos.repository..*) || within(br.com.elotech.tributos.service..*) || within(br.com.elotech.tributos.ws..*) || within(br.com.elotech.tributos.controller..*) || within(br.com.elotech.tributos.resource..*)")
    public void applicationPackagePointcut() {
    }

    @AfterThrowing(pointcut="applicationPackagePointcut()", throwing="e")
    public void logAfterThrowing(JoinPoint joinPoint, Throwable e) {
        if (this.env.acceptsProfiles(new String[]{"dev"})) {
            LOG.error("Exception in {}.{}() with cause = '{}' and exception = '{}'", new Object[]{joinPoint.getSignature().getDeclaringTypeName(), joinPoint.getSignature().getName(), ObjectUtils.defaultIfNull((Object)e.getCause(), (Object)"NULL"), e.getMessage(), e});
        } else {
            LOG.error("Exception in {}.{}() with cause = {}", new Object[]{joinPoint.getSignature().getDeclaringTypeName(), joinPoint.getSignature().getName(), ObjectUtils.defaultIfNull((Object)e.getCause(), (Object)"NULL")});
        }
    }

    @Around(value="applicationPackagePointcut()")
    public Object logAround(ProceedingJoinPoint joinPoint) throws Throwable {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Enter: {}.{}() with argument[s] = {}", new Object[]{joinPoint.getSignature().getDeclaringTypeName(), joinPoint.getSignature().getName(), this.toStringArgs(joinPoint.getArgs())});
        }
        try {
            Object result = joinPoint.proceed();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Exit: {}.{}() with result = {}", new Object[]{joinPoint.getSignature().getDeclaringTypeName(), joinPoint.getSignature().getName(), result});
            }
            return result;
        }
        catch (IllegalArgumentException e) {
            LOG.error("Illegal argument: {} in {}.{}()", new Object[]{this.toStringArgs(joinPoint.getArgs()), joinPoint.getSignature().getDeclaringTypeName(), joinPoint.getSignature().getName()});
            throw e;
        }
    }

    private String toStringArgs(Object[] args) {
        String argsAsString = Arrays.stream(args).filter((Predicate<Object>)Predicates.not(arg_0 -> this.isByteArray(arg_0))).map(String::valueOf).collect(Collectors.joining(", "));
        return '[' + argsAsString + ']';
    }

    private <T> boolean isByteArray(T arg) {
        if (Objects.isNull(arg)) {
            return false;
        }
        return byte[].class.isAssignableFrom(arg.getClass()) || Byte[].class.isAssignableFrom(arg.getClass());
    }
}

