/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.api.register.proxy.ribbon;

import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.shared.Application;
import com.netflix.discovery.shared.Applications;
import com.netflix.eureka.registry.PeerAwareInstanceRegistry;
import com.netflix.loadbalancer.ILoadBalancer;
import com.netflix.loadbalancer.Server;
import com.netflix.niws.loadbalancer.DiscoveryEnabledServer;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.netflix.ribbon.SpringClientFactory;
import org.springframework.cloud.netflix.ribbon.apache.RibbonLoadBalancingHttpClient;
import org.springframework.cloud.netflix.ribbon.support.RibbonCommandContext;
import org.springframework.cloud.netflix.zuul.filters.ZuulProperties;
import org.springframework.cloud.netflix.zuul.filters.route.FallbackProvider;
import org.springframework.cloud.netflix.zuul.filters.route.apache.HttpClientRibbonCommand;
import org.springframework.cloud.netflix.zuul.filters.route.apache.HttpClientRibbonCommandFactory;

public class LoadBalanceHttpClientRibbonCommandFactory
extends HttpClientRibbonCommandFactory {
    @Generated
    private static final Log log = LogFactory.getLog(LoadBalanceHttpClientRibbonCommandFactory.class);
    private final SpringClientFactory clientFactory;
    private final ZuulProperties zuulProperties;
    private final PeerAwareInstanceRegistry registry;

    public LoadBalanceHttpClientRibbonCommandFactory(SpringClientFactory clientFactory, ZuulProperties zuulProperties, Set<FallbackProvider> fallbackProviders, PeerAwareInstanceRegistry registry) {
        super(clientFactory, zuulProperties, fallbackProviders);
        this.clientFactory = clientFactory;
        this.zuulProperties = zuulProperties;
        this.registry = registry;
    }

    public HttpClientRibbonCommand create(RibbonCommandContext context) {
        FallbackProvider zuulFallbackProvider = this.getFallbackProvider(context.getServiceId());
        String serviceId = context.getServiceId();
        RibbonLoadBalancingHttpClient client = (RibbonLoadBalancingHttpClient)this.clientFactory.getClient(serviceId, RibbonLoadBalancingHttpClient.class);
        ILoadBalancer loadBalancer = this.clientFactory.getLoadBalancer(serviceId);
        loadBalancer.addServers(this.getServers(serviceId));
        client.setLoadBalancer(loadBalancer);
        return new HttpClientRibbonCommand(serviceId, client, context, this.zuulProperties, zuulFallbackProvider);
    }

    public List<Server> getServers(String serviceId) {
        log.info((Object)("Load servers for " + serviceId));
        ArrayList<Server> servers = new ArrayList<Server>();
        Applications applications = this.registry.getApplications();
        List registered = applications.getRegisteredApplications();
        for (Application app : registered) {
            if (!app.getName().equalsIgnoreCase(serviceId)) continue;
            List instances = app.getInstances();
            for (InstanceInfo instanceInfo : instances) {
                servers.add((Server)new DiscoveryEnabledServer(instanceInfo, false));
            }
        }
        return servers;
    }
}

