package groovy

def verifyGeracaoLaudo(def verificacaoGeracaoLaudoDTO) {

    def cnaesRiscoAlto = ['0892403','1032501','1041400','1042200','1053800','1061902','1062700','1065102','1065103',
                          '1072401','1072402','1081302','1082100','1091101','1099602','1099603','1099606','1099607',
                          '1099699','1121600','1122404','1122499','1742701','1742702','2052500','2061400','2062200',
                          '2063100','2110600','2121101','2121102','2121103','2123800','2660400','3250701','3250702',
                          '3250703','3250704','3250705','3250709','4639702','4644301','4645101','4645102','4645103',
                          '4646001','4646002','4649408','4649409','4771701','4771702','4771703','5620101','8122200',
                          '8511200','8610101','8610102','8621601','8621602','8630501','8630502','8630504','8630506',
                          '8630507','8640201','8640202','8640203','8640204','8640205','8640206','8640207','8640208',
                          '8640209','8640210','8640211','8640212','8640213','8640214','8640299','8650007','8690902',
                          '8711501','8711502','8711503','8712300','8720499','8730101','8730199','9603305','9609206'];

    def cnaesRiscoBaixo = ['1091102','3250706','3702900','3812200','3822000','4621400','4622200','4623105','4632001',
                           '4632002','4633801','4637101','4637102','4637103','4637104','4637105','4637106','4637107',
                           '4637199','4639701','4691500','4711301','4711302','4712100','4721102','4721103','4721104',
                           '4722901','4722902','4724500','4729602','4729699','4773300','5510801','5510802','5510803',
                           '5590601','5590603','5590699','5611201','5611203','5611204','5611205','5612100','5620102',
                           '5620103','5620104','7729203','8512100','8513900','8520100','8531700','8532500','8533300',
                           '8541400','8622400','8650004','8650006','8690901','8690903','8690904','8711504','8711505',
                           '8720401','8800600','9312300','9313100','9321200','9603302','9603303','9603304','9603399',
                           '9609205'];

    def cnaesDependemPerguntasRespostasRedeSim = ['1031700','1032599','1043100','1061901','1063500','1064300','1065101',
                                                  '1069400','1071600','1081301','1092900','1093701','1093702','1094500',
                                                  '1095300','1096100','1099604','1099605','1122403','1731100','1732000',
                                                  '1733800','2014200','2019399','2029100','2071100','2091600','2093200',
                                                  '2219600','2222600','2312500','2341900','2349499','2591800','2829199',
                                                  '3092000','3250707','3291400','3292202','3299006','3600602','4632003',
                                                  '4635403','4664800','4774100','4930201','4930202','5211701','5211799',
                                                  '7120100','7500100','8129000','8292000','8630503','8630599','8650001',
                                                  '8650099','8690999','9601701','9602501','9602502','9609299'];

    def retorno = GrauDeRiscoVISA.RISCO_LIBERDADE_ECONOMICA.getSigla();

    for (atividade in verificacaoGeracaoLaudoDTO.atividades) {
        if (cnaesRiscoAlto.contains(atividade)) {
            return GrauDeRiscoVISA.RISCO_ALTO.getSigla();
        }

        if (cnaesDependemPerguntasRespostasRedeSim.contains(atividade)) {
            def grauPerguntas = verifyGrauRiscoQuestionario(verificacaoGeracaoLaudoDTO.perguntas, atividade);

            if (grauPerguntas != GrauDeRiscoVISA.RISCO_LIBERDADE_ECONOMICA.getSigla()){
                retorno = grauPerguntas;
            }

            if (retorno == GrauDeRiscoVISA.RISCO_ALTO.getSigla()) {
                return retorno;
            }
        }

        if (cnaesRiscoBaixo.contains(atividade)) {
            retorno = GrauDeRiscoVISA.RISCO_BAIXO.getSigla();
        }
    };

    return retorno;
}

def verifyGrauRiscoQuestionario(def perguntas, String atividade) {
    def retorno = GrauDeRiscoVISA.RISCO_LIBERDADE_ECONOMICA.getSigla();

    for (pergunta in perguntas) {
        GrauDeRiscoRespostaVISA grauDeRiscoRespostaVISA = GrauDeRiscoRespostaVISA.findByCnaeAndCodigoPergunta(
                atividade, pergunta.getCo_pergunta());

        if (grauDeRiscoRespostaVISA != null) {
            if (grauDeRiscoRespostaVISA.getGrauDeRisco(pergunta.getDs_resposta()) == GrauDeRiscoVISA.RISCO_ALTO) {
                return GrauDeRiscoVISA.RISCO_ALTO.getSigla();
            }

            if (grauDeRiscoRespostaVISA.getGrauDeRisco(pergunta.getDs_resposta()) != GrauDeRiscoVISA.RISCO_LIBERDADE_ECONOMICA) {
                retorno = grauDeRiscoRespostaVISA.getGrauDeRisco(pergunta.getDs_resposta()).getSigla();
            }
        }
    }

    return retorno;
}

enum GrauDeRiscoVISA {

    RISCO_ALTO("C"),
    RISCO_BAIXO("B"),
    RISCO_LIBERDADE_ECONOMICA("A");

    private final String sigla;

    GrauDeRiscoVISA(String sigla) {
        this.sigla = sigla;
    }

    String getSigla() {
        return sigla;
    }

    static GrauDeRiscoVISA findBySigla(String sigla){
        for (GrauDeRiscoVISA valEnum : GrauDeRiscoVISA.values()){
            if (valEnum.sigla.equals(sigla)){
                return valEnum;
            }
        }
    }
}

enum GrauDeRiscoRespostaVISA {
    p10431002("1043100",2,"C","A"),
    p10929001("1092900",1,"C","B"),
    p17311007("1731100",7,"C","A"),
    p17320008("1732000",8,"C","A"),
    p17338008("1733800",8,"C","A"),
    p20142009("2014200",9,"C","A"),
    p201939910("2019399",10,"C","A"),
    p202910010("2029100",10,"C","A"),
    p207110011("2071100",11,"C","A"),
    p207110012("2071100",12,"C","A"),
    p209160011("2091600",11,"C","A"),
    p209160014("2091600",14,"C","A"),
    p209320015("2093200",15,"C","A"),
    p221960016("2219600",16,"C","A"),
    p221960017("2219600",17,"C","A"),
    p222260018("2222600",18,"C","A"),
    p231250019("2312500",19,"C","A"),
    p234190020("2341900",20,"C","A"),
    p234949921("2349499",21,"C","A"),
    p259180022("2591800",22,"C","A"),
    p282919923("2829199",23,"C","A"),
    p282919924("2829199",24,"C","A"),
    p282919925("2829199",25,"C","A"),
    p309200026("3092000",26,"C","A"),
    p325070727("3250707",27,"C","A"),
    p329140028("3291400",28,"C","A"),
    p329220229("3292202",29,"C","A"),
    p329900630("3299006",30,"C","A"),
    p360060249("3600602",49,"C","B"),
    p463540332("4635403",32,"C","A"),
    p466480033("4664800",33,"C","A"),
    p493020134("4930201",34,"C","A"),
    p493020234("4930202",34,"C","A"),
    p521170135("5211701",35,"C","A"),
    p521179935("5211799",35,"C","A"),
    p712010037("7120100",37,"C","A"),
    p750010038("7500100",38,"C","A"),
    p812900039("8129000",39,"C","A"),
    p812900040("8129000",40,"C","A"),
    p812900041("8129000",41,"C","A"),
    p812900042("8129000",42,"C","A"),
    p812900043("8129000",43,"C","A"),
    p812900044("8129000",44,"C","A"),
    p829200045("8292000",45,"C","A"),
    p960170147("9601701",47,"C","B"),
    p960929946("9609299",46,"C","A"),
    p10317001("1031700",1,"C","B"),
    p10325991("1032599",1,"C","B"),
    p10619013("1061901",3,"C","B"),
    p10635001("1063500",1,"C","B"),
    p10643001("1064300",1,"C","B"),
    p10651014("1065101",4,"C","B"),
    p10694001("1069400",1,"C","B"),
    p10716001("1071600",1,"C","B"),
    p10813011("1081301",1,"C","B"),
    p10937011("1093701",1,"C","B"),
    p10937021("1093702",1,"C","B"),
    p10945001("1094500",1,"C","B"),
    p10953005("1095300",5,"C","B"),
    p10961001("1096100",1,"C","B"),
    p10996046("1099604",6,"C","B"),
    p10996051("1099605",1,"C","B"),
    p11224031("1122403",1,"C","B"),
    p463200331("4632003",31,"C","B"),
    p863050346("8630503",46,"C","B"),
    p863059946("8630599",46,"C","B"),
    p865000146("8650001",46,"C","B"),
    p865009946("8650099",46,"C","B"),
    p869099946("8690999",46,"C","B"),
    p960250246("9602502",46,"C","B"),
    p477410048("4774100",48,"B","A"),
    p960250113("9602501",13,"C","B");

    private final String cnae;
    private final int codigoPergunta;
    private final String grauRespostaSim;
    private final String grauRespostaNao;

    GrauDeRiscoRespostaVISA(String cnae, int codigoPergunta, String grauRespostaSim, String grauRespostaNao){
        this.cnae = cnae;
        this.codigoPergunta = codigoPergunta;
        this.grauRespostaSim = grauRespostaSim;
        this.grauRespostaNao = grauRespostaNao;
    }

    GrauDeRiscoVISA getGrauDeRisco(String resposta){
        if (resposta.equalsIgnoreCase("S") || resposta.equalsIgnoreCase("SIM")){
            return GrauDeRiscoVISA.findBySigla(this.grauRespostaSim);
        }
        return GrauDeRiscoVISA.findBySigla(this.grauRespostaNao);
    }

    static GrauDeRiscoRespostaVISA findByCnaeAndCodigoPergunta(String cnae, int codigoPergunta){
        for (GrauDeRiscoRespostaVISA valEnum : GrauDeRiscoRespostaVISA.values()){
            if (valEnum.cnae.equals(cnae) && valEnum.codigoPergunta == codigoPergunta){
                return valEnum;
            }
        }
    }

}