package groovy

def verifyGeracaoLaudo(def verificacaoGeracaoLaudoDTO) {

    def cnaesRiscoAlto = ['8511200', '8512100', '8513900'];

    def retorno = GrauDeRiscoSME.RISCO_LIBERDADE_ECONOMICA.getSigla();

    for (codigoAtividade in verificacaoGeracaoLaudoDTO.atividades) {

        if (cnaesRiscoAlto.contains(codigoAtividade)) {
            return GrauDeRiscoSME.RISCO_ALTO.getSigla();
        }
    };

    return retorno;
}

enum GrauDeRiscoSME {

    RISCO_ALTO("C"),
    RISCO_LIBERDADE_ECONOMICA("A");

    private final String sigla;

    GrauDeRiscoSME(String sigla) {
        this.sigla = sigla;
    }

    String getSigla() {
        return sigla;
    }
}