package groovy

def verifyGeracaoLaudo(def verificacaoGeracaoLaudoDTO) {

    def cnaesRiscoAlto = ['4923001', '4924800', '5320202'];

    def retorno = GrauDeRiscoAMTT.RISCO_LIBERDADE_ECONOMICA.getSigla();

    for (codigoAtividade in verificacaoGeracaoLaudoDTO.atividades) {

        if (cnaesRiscoAlto.contains(codigoAtividade)) {
            return GrauDeRiscoAMTT.RISCO_ALTO.getSigla();
        }
    };

    return retorno;
}

enum GrauDeRiscoAMTT {

    RISCO_ALTO("C"),
    RISCO_LIBERDADE_ECONOMICA("A");

    private final String sigla;

    GrauDeRiscoAMTT(String sigla) {
        this.sigla = sigla;
    }

    String getSigla() {
        return sigla;
    }
}