/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.ws.oxm.geo;

import br.com.elotech.portalarrecadacao.enumerator.RestricaoPermissivelEnum;
import br.com.elotech.tributacao.enumerator.SimNaoEnum;
import java.io.Serializable;
import java.math.BigDecimal;

public class RestricaoPermissivel
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Integer codigo;
    private String descricao;
    private String valor;

    public Integer getCodigo() {
        return this.codigo;
    }

    public void setCodigo(Integer codigo) {
        this.codigo = codigo;
    }

    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    public String getValor() {
        return this.valor;
    }

    public void setValor(String valor) {
        this.valor = valor;
    }

    public String isSomenteEscritorio() {
        if (this.codigo.compareTo(RestricaoPermissivelEnum.SOMENTE_ESCRITORIO.getCodigo()) == 0) {
            return SimNaoEnum.SIM.getShortText();
        }
        return SimNaoEnum.NAO.getShortText();
    }

    public String isEscritorioConcomitante() {
        if (this.codigo.compareTo(RestricaoPermissivelEnum.ESCRITORIO_CONCOMITANTE.getCodigo()) == 0) {
            return SimNaoEnum.SIM.getShortText();
        }
        return SimNaoEnum.NAO.getShortText();
    }

    public String isAtividadeConcomitante() {
        if (this.codigo.compareTo(RestricaoPermissivelEnum.ATIVIDADE_CONCOMITANTE_RESIDENCIA.getCodigo()) == 0) {
            return SimNaoEnum.SIM.getShortText();
        }
        return SimNaoEnum.NAO.getShortText();
    }

    public BigDecimal getAreaMaximaProcessamento() {
        if (this.codigo.compareTo(RestricaoPermissivelEnum.AREA_PROCESS_MAXIMA.getCodigo()) == 0) {
            return new BigDecimal(this.valor);
        }
        return BigDecimal.ZERO;
    }
}

