/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.utils.params;

import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraAtividadeEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.exception.ConsultaPreviaRedeSimException;
import br.com.elotech.portalarrecadacao.exception.SolicitacaoAlvaraRedeSimException;
import br.com.elotech.portalarrecadacao.integration.dto.consulta.Controle;
import br.com.elotech.portalarrecadacao.integration.dto.consulta.DadosSolicitacao;
import br.com.elotech.portalarrecadacao.rest.dto.SolicitacaoAlvaraRedeSimDTO;
import br.com.elotech.util.json.EloJsonUtils;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Objects;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.codec.binary.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortalUtils {
    private static final Logger logger = LoggerFactory.getLogger(PortalUtils.class);
    private static final long ENTIDADE = 1L;
    private static final String USUARIOALVARAONLINE = "ALVARAONLINE";
    private static final String MODULO_ALVARAONLINE = "40";
    private static final String MODULO_CONFIGURACAO = "90";
    private static final Integer TIPO_OPERACAOLOG_INSERT = new Integer(1);
    private static final Integer TIPO_OPERACAOLOG_EDIT = new Integer(2);
    private static final Integer TIPO_OPERACAOLOG_DELETE = new Integer(3);
    private static final Long COD_RESTRICAOACESSIBILIDADE = 1L;
    private static final Long COD_RESTRICAODEBITOMOBILIARIO = 2L;
    private static final Long COD_RESTRICAODEBITOIMOBILIARIO = 3L;
    private static final Long COD_RESTRICAODEBITOIMOB_SENDO_MOBIL_DONO = 4L;
    private static final Long COD_RESTRICAOHABITESE = 5L;
    private static final Long COD_RESTRICAOCAD_PESSOA_JA_EXISTENTE = 6L;
    private static final Long COD_RESTRICAORESPTEC_MEIOAMBIENTE = 7L;
    private static final Long COD_RESTRICAORESPTEC_VIGSANITARIA = 8L;
    private static final Long COD_RESTRICAORESPTEC_VIGAMBIENTAL = 9L;

    public static Long getCodRestricaoresptecMeioambiente() {
        return COD_RESTRICAORESPTEC_MEIOAMBIENTE;
    }

    public static Long getCodRestricaoresptecVigsanitaria() {
        return COD_RESTRICAORESPTEC_VIGSANITARIA;
    }

    public static Long getCodRestricaoresptecVigambiental() {
        return COD_RESTRICAORESPTEC_VIGAMBIENTAL;
    }

    public static Long getCodRestricaoacessibilidade() {
        return COD_RESTRICAOACESSIBILIDADE;
    }

    public static Long getCodRestricaodebitomobiliario() {
        return COD_RESTRICAODEBITOMOBILIARIO;
    }

    public static Long getCodRestricaodebitoimobiliario() {
        return COD_RESTRICAODEBITOIMOBILIARIO;
    }

    public static Long getCodRestricaodebitoimobSendoMobilDono() {
        return COD_RESTRICAODEBITOIMOB_SENDO_MOBIL_DONO;
    }

    public static Long getCodRestricaohabitese() {
        return COD_RESTRICAOHABITESE;
    }

    public static Long getCodRestricaocadPessoaJaExistente() {
        return COD_RESTRICAOCAD_PESSOA_JA_EXISTENTE;
    }

    public static Integer getTipoOperacaologInsert() {
        return TIPO_OPERACAOLOG_INSERT;
    }

    public static Integer getTipoOperacaologEdit() {
        return TIPO_OPERACAOLOG_EDIT;
    }

    public static Integer getTipoOperacaologDelete() {
        return TIPO_OPERACAOLOG_DELETE;
    }

    public static String getModuloConfiguracao() {
        return MODULO_CONFIGURACAO;
    }

    public static Long getEntidade() {
        return 1L;
    }

    public static String getUsuarioalvaraonline() {
        return USUARIOALVARAONLINE;
    }

    public static String getModuloAlvaraonline() {
        return MODULO_ALVARAONLINE;
    }

    public static String loadCertificate(String certPath) throws ConsultaPreviaRedeSimException {
        String certContent = null;
        try {
            FileInputStream fis = new FileInputStream(certPath);
            InputStreamReader isr = new InputStreamReader(fis);
            BufferedReader br = new BufferedReader(isr);
            String s = null;
            StringBuilder sb = new StringBuilder();
            while ((s = br.readLine()) != null) {
                sb.append(s);
                sb.append("\n");
            }
            certContent = sb.toString();
            br.close();
            return certContent;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new ConsultaPreviaRedeSimException("Falha ao carregar certificado da Rede Sim");
        }
    }

    public static String md5(String tag) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.reset();
            messageDigest.update(tag.getBytes(Charset.forName("UTF8")));
            byte[] resultByte = messageDigest.digest();
            String result = new String(Hex.encodeHex((byte[])resultByte));
            return result;
        }
        catch (NoSuchAlgorithmException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static String getTipoPessoa(String cnpj_cpf) {
        switch (cnpj_cpf.length()) {
            case 11: {
                return "F";
            }
            case 14: {
                return "J";
            }
        }
        return null;
    }

    public static String getDescricaoAtividadesMei(SolicitacaoAlvaraEntity solicitacao) {
        StringBuilder sb = new StringBuilder();
        for (SolicitacaoAlvaraAtividadeEntity atividade : solicitacao.getSolicitacaoAlvaraAtividades()) {
            String descricao = atividade.getAtividadeMei().getCnae().getDescricao();
            int lastIndexOf = sb.lastIndexOf(descricao);
            if (lastIndexOf >= 0) continue;
            sb.append(descricao).append("; ");
        }
        return sb.toString().trim();
    }

    public static String getUrlApplicacao() {
        HttpServletRequest request = (HttpServletRequest)FacesContext.getCurrentInstance().getExternalContext().getRequest();
        return request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + request.getContextPath();
    }

    public static SolicitacaoAlvaraRedeSimDTO normalizeJson(String solicitacaoAlvaraRedeSimDTO) throws SolicitacaoAlvaraRedeSimException {
        JsonNode jsonNode = null;
        SolicitacaoAlvaraRedeSimDTO dadosSolicitacao = new SolicitacaoAlvaraRedeSimDTO();
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            jsonNode = objectMapper.readTree(solicitacaoAlvaraRedeSimDTO);
            if (Objects.nonNull(jsonNode)) {
                dadosSolicitacao.setControle((Controle)EloJsonUtils.fromJson((String)jsonNode.get("controle").toString(), Controle.class));
                dadosSolicitacao.setDados_solicitacao(DadosSolicitacao.of((JsonNode)jsonNode));
                return dadosSolicitacao;
            }
        }
        catch (Exception e) {
            throw new SolicitacaoAlvaraRedeSimException("Ocorreu uma falha ao carregar os arquivos entidade registro", (Throwable)e);
        }
        return null;
    }
}

