/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.utils.params;

import br.com.elotech.exception.common.ErroInesperado;
import br.com.elotech.logLayer.EloLogger;
import br.com.elotech.portalarrecadacao.enumerator.ParametroGeralEnum;
import br.com.elotech.tributacao.domain.ParametroGeralEntity;
import br.com.elotech.tributacao.domain.ParametroGeralPK;
import br.com.elotech.tributacao.repository.RepositoryParametroGeral;
import br.com.elotech.util.crypto.EloCryptoUtils;
import br.com.elotech.util.exceptions.CryptoException;
import br.com.elotech.util.params.EloParamLoader;
import br.com.elotech.util.sql.Modulo;
import javax.annotation.Resource;

public class EloParamUtils
extends EloLogger
implements EloParamLoader {
    private static final String MODULO = Modulo.ALVARAONLINE.toString();
    private static final long serialVersionUID = 1L;
    public static final String PARAM_USUARIO_ISS_UNICO = "USUARIOISSUNICO";
    public static final String PARAM_SENHA_ISS_UNICO = "SENHAISSUNICO";
    public static final String PARAM_USUARIO_ALVARA_UNICO = "USUARIOALVARAUNICO";
    public static final String PARAM_SENHA_ALVARA_UNICO = "SENHAALVARAUNICO";
    @Resource
    private RepositoryParametroGeral repositoryParametroGeral;

    public boolean isDev() {
        return false;
    }

    @Deprecated
    public String getParamValue(String param) {
        return this.getParamValue(MODULO, param);
    }

    public String getParamValueCriptografado(String paramName) {
        try {
            return this.getParamValueCriptografado(paramName, "softElo");
        }
        catch (CryptoException e) {
            this.logger.error((Object)e.getLocalizedMessage(), (Throwable)e);
            throw new ErroInesperado(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public String getParamValueCriptografado(String paramName, String key) throws CryptoException {
        return this.getParamValueCriptografado(MODULO, paramName, key);
    }

    public String getParamValueCriptografado(String modulo, String paramName, String key) throws CryptoException {
        return EloCryptoUtils.decifra((String)this.getParamValue(modulo, paramName), (String)key);
    }

    public String getParamValue(String modulo, String paramName) {
        ParametroGeralEntity parametroGeral = this.getParametroGeral(modulo, paramName);
        if (parametroGeral == null) {
            return null;
        }
        return parametroGeral.getValor();
    }

    public ParametroGeralEntity getParametroGeral(String modulo, String paramName) {
        return this.getParametroGeral(new ParametroGeralPK(modulo, paramName));
    }

    public ParametroGeralEntity getParametroGeral(ParametroGeralPK parametroGeralPK) {
        return this.repositoryParametroGeral.load(parametroGeralPK);
    }

    public Long getParamValueAsLong(String param) {
        try {
            return Long.parseLong(this.getParamValue(MODULO, param));
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getParamValue(ParametroGeralEnum param) {
        return this.getParamValue(param.getModulo(), param.name());
    }
}

