/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.utils;

import br.com.elotech.util.string.EloStringUtils;
import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.layout.PatternLayout;

public class CustomAppender
extends AbstractAppender {
    private final List<String> logs = new ArrayList();
    private String threadName = "";

    public CustomAppender(String name, String threadName) {
        super(name, null, (Layout)PatternLayout.newBuilder().withPattern("[%-5level] %d{yyyy-MM-dd HH:mm:ss} [%t] %c{1} - %msg%n").build());
        this.threadName = threadName;
    }

    public void append(LogEvent event) {
        String data = new String(this.getLayout().toByteArray(event)).trim();
        if (!EloStringUtils.isEmpty((String)this.threadName) && data.contains(this.threadName)) {
            this.logs.add(data);
        }
    }

    public String getLogs() {
        return Joiner.on((String)"\n").join((Iterable)this.logs);
    }

    public void clearLogs() {
        this.logs.clear();
    }
}

