/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.service.impl;

import br.com.elotech.annotations.spring.EloService;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.portalarrecadacao.domain.ZoneamentoPermitidoEntity;
import br.com.elotech.portalarrecadacao.exception.ShowMessage;
import br.com.elotech.portalarrecadacao.repository.RepositoryZoneamento;
import br.com.elotech.portalarrecadacao.service.SrvZoneamento;
import br.com.elotech.tributacao.domain.aise.ConfiguracaoAtividadeEntity;
import br.com.elotech.tributacao.domain.aise.ZoneamentoEntity;
import br.com.elotech.util.math.EloNumberUtils;
import java.util.List;
import javax.annotation.Resource;

@EloService(value="srvZoneamento")
public class SrvZoneamentoImpl
implements SrvZoneamento {
    @Resource
    private RepositoryZoneamento repositoryZoneamento;

    public List<ZoneamentoPermitidoEntity> carregarZoneamentosPermitidos(ConfiguracaoAtividadeEntity configuracaoAtividade) {
        if (configuracaoAtividade == null) {
            throw new IllegalArgumentException("Atividade n\u00e3o selecionada para consultar as Proibi\u00e7\u00f5es.");
        }
        return this.repositoryZoneamento.carregarZoneamentosPermitidos(configuracaoAtividade);
    }

    public void salvarZoneamentoPermitido(ZoneamentoPermitidoEntity ZoneamentoPermitido) throws BaseException {
        if (this.ZoneamentoNaoCadastrado(ZoneamentoPermitido)) {
            if (!EloNumberUtils.isBiggerThanZero((Number)ZoneamentoPermitido.getIdZoneamentoPermitido()).booleanValue()) {
                ZoneamentoPermitido.setIdZoneamentoPermitido(this.repositoryZoneamento.getSequence());
            }
            this.repositoryZoneamento.saveOrUpdate(ZoneamentoPermitido);
            ShowMessage.addInfoMessage((String)"msgZoneamentoPermitido", (String)("Zoneamento " + ZoneamentoPermitido.getZoneamento().getSigla() + " adicionado com sucesso"));
        } else {
            ShowMessage.addWarnMessage((String)"msgZoneamentoPermitido", (String)("Zoneamento " + ZoneamentoPermitido.getZoneamento().getSigla() + " j\u00e1 est\u00e1 vinculado a esta Atividade."));
        }
    }

    private boolean ZoneamentoNaoCadastrado(ZoneamentoPermitidoEntity ZoneamentoPermitido) {
        return this.repositoryZoneamento.zoneamentoNaoCadastrado(ZoneamentoPermitido);
    }

    public void excluirZoneamentoPermitido(ZoneamentoPermitidoEntity ZoneamentoPermitido) {
        this.repositoryZoneamento.remove(ZoneamentoPermitido);
    }

    public List<ZoneamentoEntity> carregarTodosZoneamentos() {
        return this.repositoryZoneamento.carregarTodosZoneamentos();
    }
}

