/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.service.impl;

import br.com.elotech.annotations.spring.EloService;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.exception.SolicitacaoAlvaraException;
import br.com.elotech.portalarrecadacao.service.SrvRestricaoLote;
import br.com.elotech.portalarrecadacao.service.SrvWebServiceGeo;
import br.com.elotech.portalarrecadacao.service.impl.SrvConsultaGeoRest;
import br.com.elotech.portalarrecadacao.service.impl.SrvSolicitacaoAlvaraHelperImpl;
import br.com.elotech.portalarrecadacao.ws.oxm.geo.Atividade;
import br.com.elotech.portalarrecadacao.ws.oxm.geo.ConsultaAtividadeEnvio;
import br.com.elotech.portalarrecadacao.ws.oxm.geo.ConsultaAtividadeEnvioNovoGeo;
import br.com.elotech.portalarrecadacao.ws.oxm.geo.FiltrarAtividadesResposta;
import br.com.elotech.portalarrecadacao.ws.oxm.geo.RetornaAtividadeResponse;
import br.com.elotech.portalarrecadacao.ws.oxm.geo.VisualizarLoteEnvio;
import br.com.elotech.portalarrecadacao.ws.oxm.geo.VisualizarLoteResposta;
import br.com.elotech.tributacao.domain.aise.CadastroImobiliarioEntity;
import br.com.elotech.tributacao.domain.aise.CadastroMobiliarioCboEntity;
import br.com.elotech.tributacao.domain.aise.MobiliarioCnaeEntity;
import br.com.elotech.tributacao.enumerator.TipoAtividadeEnum;
import br.com.elotech.tributacao.repository.aise.RepositoryImobiliarioTestada;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Resource;
import org.springframework.ws.client.core.WebServiceTemplate;

@EloService(value="srvWebServiceGeo")
public class SrvWebServiceGeoImpl
extends SrvSolicitacaoAlvaraHelperImpl
implements SrvWebServiceGeo {
    private CadastroMobiliarioCboEntity mobiliarioCbo;
    private MobiliarioCnaeEntity mobiliarioCnae;
    @Resource
    private WebServiceTemplate webServiceTemplateVisualizarLote;
    @Resource
    private WebServiceTemplate webServiceTemplateAtualizarNumPredial;
    @Resource
    private RepositoryImobiliarioTestada repositoryImobiliarioTestada;
    @Resource
    private SrvRestricaoLote srvRestricaoLote;
    @Resource
    private SrvConsultaGeoRest srvConsultaGeoRest;

    public void setWebServiceTemplateVisualizarLote(WebServiceTemplate webServiceTemplateVisualizarLote) {
        this.webServiceTemplateVisualizarLote = webServiceTemplateVisualizarLote;
    }

    public void setWebServiceTemplateAtualizarNumPredial(WebServiceTemplate webServiceTemplateAtualizarNumPredial) {
        this.webServiceTemplateAtualizarNumPredial = webServiceTemplateAtualizarNumPredial;
    }

    public VisualizarLoteResposta visualizarLote(VisualizarLoteEnvio envio) {
        return (VisualizarLoteResposta)this.webServiceTemplateVisualizarLote.marshalSendAndReceive((Object)envio);
    }

    public RetornaAtividadeResponse consultaTabelaConfiguracaoCnae(ConsultaAtividadeEnvio envio) throws BaseException {
        try {
            Atividade atividade = (Atividade)Optional.ofNullable(this.srvConsultaGeoRest.getAtividadeGeo(envio.getCnae())).map(FiltrarAtividadesResposta::getAtividades).orElseThrow(() -> new SolicitacaoAlvaraException("Ocorreu uma falha na consulta do Geo Processamento: Erro ao obter atividades do CNAE")).stream().findFirst().orElseThrow(() -> new SolicitacaoAlvaraException("Ocorreu uma falha na consulta do Geo Processamento: Erro ao obter atividade principal"));
            return this.srvConsultaGeoRest.getConsultarAtividade(new ConsultaAtividadeEnvioNovoGeo(atividade.getAtividadeId().toString(), envio.getCadastroImobiliario(), envio.getCodLogradouro().toString()));
        }
        catch (Exception e) {
            throw new SolicitacaoAlvaraException(String.format("Ocorreu uma falha na consulta do Geo Processamento, entre em contato com a prefeitura no email:%s", this.getEmailSetorCadastroAlvara()), e.getCause());
        }
    }

    public String getCodTaxa(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        Integer codTaxa = null;
        if (solicitacao.isSolicitacaoCBO()) {
            Iterator iterator = solicitacao.getCadastroMobiliario().getMobiliarioCbos().iterator();
            while (iterator.hasNext()) {
                CadastroMobiliarioCboEntity mobCbo;
                this.mobiliarioCbo = mobCbo = (CadastroMobiliarioCboEntity)iterator.next();
                codTaxa = this.recuperaCodigoTaxa(solicitacao, codTaxa);
            }
        } else if (solicitacao.isSolicitacaoJuridicaNormal() || solicitacao.isSolicitacaoPrestadorServico()) {
            Iterator iterator = solicitacao.getCadastroMobiliario().getMobiliarioCnaes().iterator();
            while (iterator.hasNext()) {
                MobiliarioCnaeEntity mobCnae;
                this.mobiliarioCnae = mobCnae = (MobiliarioCnaeEntity)iterator.next();
                codTaxa = this.recuperaCodigoTaxa(solicitacao, codTaxa);
            }
        }
        if (Objects.nonNull(codTaxa)) {
            return codTaxa.toString();
        }
        return null;
    }

    private Integer recuperaCodigoTaxa(SolicitacaoAlvaraEntity solicitacao, Integer codTaxa) throws BaseException {
        ConsultaAtividadeEnvio envio = new ConsultaAtividadeEnvio();
        envio.setCadastroImobiliario(solicitacao.getCadastroMobiliario().getCadastroImobiliario().getId().getCodigo().toString());
        if (this.mobiliarioCnae != null) {
            envio.setTipoAtividade(TipoAtividadeEnum.CNAE);
            envio.setCnae(this.mobiliarioCnae.getId().getCnae().getCodigo());
        } else if (this.mobiliarioCbo != null) {
            envio.setTipoAtividade(TipoAtividadeEnum.CBO);
            envio.setCnae(this.mobiliarioCbo.getRhCbo().getCodigo());
        }
        envio.setCodLogradouro(Integer.valueOf(this.getLogradouro(solicitacao.getCadastroMobiliario().getCadastroImobiliario()).intValue()));
        envio.setRestricoesLote(this.srvRestricaoLote.getRestricaoLote(solicitacao.getCadastroMobiliario().getCadastroGeral()));
        RetornaAtividadeResponse resposta = this.consultaTabelaConfiguracaoCnae(envio);
        if (resposta != null) {
            Integer codTaxaResposta = resposta.getRetornoConsultaAtividade().getAtividade().getCodigoDeTaxa();
            if (Objects.isNull(codTaxa)) {
                codTaxa = codTaxaResposta;
            } else if (codTaxa < codTaxaResposta) {
                codTaxa = codTaxaResposta;
            }
        }
        return codTaxa;
    }

    private Long getLogradouro(CadastroImobiliarioEntity cadastroImobiliario) {
        return this.repositoryImobiliarioTestada.buscarTestadaPrincipal(cadastroImobiliario.getId().getCodigo()).getId().getLogradouroTestada().getLogradouro().getId().getLogradouro();
    }
}

