/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.service.impl;

import br.com.elotech.annotations.spring.EloService;
import br.com.elotech.domain.Page;
import br.com.elotech.exception.common.EEntityNotFound;
import br.com.elotech.exception.common.ErroInesperado;
import br.com.elotech.exception.common.ValidacaoException;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.logLayer.EloLogger;
import br.com.elotech.portalarrecadacao.controller.dataModel.UsuarioDataModel;
import br.com.elotech.portalarrecadacao.exception.DadosUsuarioByTokenException;
import br.com.elotech.portalarrecadacao.http.utils.HttpUtils;
import br.com.elotech.portalarrecadacao.repository.RepositoryTipoDocumentoUsuarioAlvara;
import br.com.elotech.portalarrecadacao.rest.response.UsuarioResponseToken;
import br.com.elotech.portalarrecadacao.service.SrvUsuario;
import br.com.elotech.portalarrecadacao.utils.params.PortalUtils;
import br.com.elotech.tributacao.domain.EntidadeEntity;
import br.com.elotech.tributacao.domain.EntidadeInterface;
import br.com.elotech.tributacao.domain.aise.ContatoPessoaEntity;
import br.com.elotech.tributacao.domain.aise.ContatoPessoaPK;
import br.com.elotech.tributacao.domain.aise.EntidadeAiseEntity;
import br.com.elotech.tributacao.domain.aise.EntidadeTributacaoEntity;
import br.com.elotech.tributacao.domain.aise.ModuloEntity;
import br.com.elotech.tributacao.domain.aise.PessoaEntity;
import br.com.elotech.tributacao.domain.aise.SeletorEntity;
import br.com.elotech.tributacao.domain.aise.TipoDocumentoUsuarioAlvaraEntity;
import br.com.elotech.tributacao.domain.aise.UsuarioEntidadeEntity;
import br.com.elotech.tributacao.domain.aise.UsuarioEntidadePK;
import br.com.elotech.tributacao.domain.aise.UsuarioEntity;
import br.com.elotech.tributacao.domain.aise.UsuarioModuloEntity;
import br.com.elotech.tributacao.domain.aise.UsuarioModuloPK;
import br.com.elotech.tributacao.domain.aise.UsuarioSeletorEntity;
import br.com.elotech.tributacao.domain.aise.UsuarioSeletorPK;
import br.com.elotech.tributacao.domain.vo.UsuarioVo;
import br.com.elotech.tributacao.enumerator.SimNaoEnum;
import br.com.elotech.tributacao.repository.RepositoryParametroGeral;
import br.com.elotech.tributacao.repository.aise.RepositoryEntidadeAise;
import br.com.elotech.tributacao.repository.aise.RepositoryEntidadeTributacao;
import br.com.elotech.tributacao.repository.aise.RepositoryModulo;
import br.com.elotech.tributacao.repository.aise.RepositoryPessoa;
import br.com.elotech.tributacao.repository.aise.RepositorySeletor;
import br.com.elotech.tributacao.repository.aise.RepositoryUsuario;
import br.com.elotech.tributacao.repository.aise.RepositoryUsuarioSeletor;
import br.com.elotech.tributacao.service.SrvContatoPessoa;
import br.com.elotech.tributacao.service.SrvPessoa;
import br.com.elotech.unico.domain.ConfiguracaoUnico;
import br.com.elotech.unico.rest.client.rest.UsuarioUnicoClientRest;
import br.com.elotech.unico.rest.domain.UsuarioUnico;
import br.com.elotech.unico.rest.exception.UnicoClientException;
import br.com.elotech.unico.rest.function.ListUsuarioEntidadeEntityToListPatchFunction;
import br.com.elotech.unico.rest.function.ListUsuarioModuloEntityToListPatchFunction;
import br.com.elotech.unico.rest.function.UsuarioEntityToUsuarioUnico;
import br.com.elotech.util.date.EloDateUtils;
import br.com.elotech.util.exceptions.HashException;
import br.com.elotech.util.filter.EloFilter;
import br.com.elotech.util.filter.HashMapEloFilter;
import br.com.elotech.util.list.EloListUtils;
import br.com.elotech.util.sql.Modulo;
import br.com.elotech.util.string.EloHashUtils;
import br.com.elotech.util.string.EloStringUtils;
import com.google.common.collect.Lists;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Resource;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;

@EloService(value="srvUsuario")
public class SrvUsuarioImpl
extends EloLogger
implements SrvUsuario {
    private static final String SELETORTELASOLICITACAOALVARA = "ROLE_TELASOLICITACAOALVARA";
    private static final String SELETORTELAACOMPANHAMENTO = "ROLE_TELAACOMPANHAMENTO";
    @Resource
    private RepositoryParametroGeral repositoryParametroGeral;
    @Resource
    private RepositoryPessoa repositoryPessoa;
    @Resource
    private SrvPessoa srvPessoa;
    @Resource
    private RepositoryUsuario repositoryUsuario;
    @Resource
    private RepositorySeletor repositorySeletor;
    @Resource
    private RepositoryEntidadeTributacao repositoryEntidadeTributacao;
    @Resource
    private RepositoryUsuarioSeletor repositoryUsuarioSeletor;
    @Resource
    private ConfiguracaoUnico configuracaoUnico;
    @Resource
    private UsuarioUnicoClientRest usuarioUnicoClientRest;
    @Resource
    private RepositoryModulo repositoryModulo;
    @Resource
    private RepositoryEntidadeAise repositoryEntidadeAise;
    @Resource
    private SrvContatoPessoa srvContatoPessoa;
    @Resource
    private RepositoryTipoDocumentoUsuarioAlvara repositoryTipoDocumentoUsuarioAlvara;
    private static final long NIVELUSUARIO = 1L;

    public void setRepositoryPessoa(RepositoryPessoa repositoryPessoa) {
        this.repositoryPessoa = repositoryPessoa;
    }

    public void setRepositoryUsuario(RepositoryUsuario repositoryUsuario) {
        this.repositoryUsuario = repositoryUsuario;
    }

    public void setRepositoryUsuarioSeletor(RepositoryUsuarioSeletor repositoryUsuarioSeletor) {
        this.repositoryUsuarioSeletor = repositoryUsuarioSeletor;
    }

    public void setRepositorySeletor(RepositorySeletor repositorySeletor) {
        this.repositorySeletor = repositorySeletor;
    }

    public void setRepositoryModulo(RepositoryModulo repositoryModulo) {
        this.repositoryModulo = repositoryModulo;
    }

    public void setRepositoryEntidadeAise(RepositoryEntidadeAise repositoryEntidadeAise) {
        this.repositoryEntidadeAise = repositoryEntidadeAise;
    }

    public UsuarioEntity criarUsuarioPorToken(String accessToken, Optional<PessoaEntity> pessoa) throws HashException, BaseException {
        JSONObject objetoJson = null;
        UsuarioResponseToken usuarioResponseToken = new UsuarioResponseToken();
        String cpfUsuario = null;
        try {
            if (this.usaOauthLogin()) {
                objetoJson = this.getUsuarioOauth(accessToken);
                cpfUsuario = (String)objetoJson.get("cpfcgc");
                usuarioResponseToken.setCpfUsuario(cpfUsuario);
                usuarioResponseToken.setNome((String)objetoJson.get("nome"));
            } else {
                objetoJson = this.getUsuarioSemOauth(accessToken);
                cpfUsuario = (String)objetoJson.get("cpf");
                cpfUsuario = StringUtils.leftPad((String)cpfUsuario, (int)11, (char)'0');
                usuarioResponseToken.setCpfUsuario(cpfUsuario);
                usuarioResponseToken.setNome((String)objetoJson.get("nome"));
                if (objetoJson.has("rg")) {
                    usuarioResponseToken.setRg(objetoJson.getString("rg"));
                }
                if (objetoJson.has("uf_rg")) {
                    usuarioResponseToken.setOrgaoEmissor(objetoJson.getString("uf_rg"));
                }
                if (objetoJson.has("dtnasc")) {
                    usuarioResponseToken.setNascimento(EloDateUtils.fromAnsiDateString((String)objetoJson.getString("dtnasc"), (String)"yyyy-MM-dd"));
                }
                if (objetoJson.has("email")) {
                    usuarioResponseToken.setEmail(objetoJson.getString("email"));
                }
                if (objetoJson.has("fone")) {
                    usuarioResponseToken.setFone(objetoJson.getString("fone"));
                }
            }
        }
        catch (RuntimeException e) {
            this.logger.error((Object)"Erro ao obter os dados do usu\u00e1rio pelo token", (Throwable)e);
            throw new ErroInesperado("Erro ao obter os dados do usu\u00e1rio pelo token");
        }
        UsuarioEntity usuario = null;
        if (this.configuracaoUnico.isIntegrado()) {
            UsuarioUnico usuarioUnico = this.usuarioUnicoClientRest.searchBycpf(cpfUsuario);
            if (Objects.nonNull(usuarioUnico)) {
                usuario = this.repositoryUsuario.findByIdUnico(usuarioUnico.getId());
                if (!pessoa.isPresent()) {
                    usuario.setEmail(usuarioUnico.getEmail());
                }
            }
            if (Objects.nonNull(usuario)) {
                pessoa = this.criarPessoa(usuarioResponseToken);
                this.verificaContato(pessoa, usuarioResponseToken);
                usuario.setPessoa(this.repositoryPessoa.refresh((PessoaEntity)pessoa.get()));
                usuario = this.vincularModuloAlvaraAoUsuario(this.getModuloAlvara(), usuario);
                usuario = this.vincularEntidadeAoUsuario(this.getEntidadePrincipal(), usuario);
                if (Objects.isNull(usuario.getEmail())) {
                    usuario.setEmail(usuarioResponseToken.getEmail());
                }
                this.salvarUsuario(usuario);
            }
        } else {
            usuario = this.repositoryUsuario.verificaLoginByCnpjCpf(cpfUsuario);
        }
        if (usuario == null) {
            if (!pessoa.isPresent()) {
                pessoa = this.criarPessoa(usuarioResponseToken);
            }
            this.verificaContato(pessoa, usuarioResponseToken);
            usuario = this.criarUsuario((PessoaEntity)pessoa.get(), usuarioResponseToken);
        }
        this.vincularSeletorTelaCompanhamentoETelaSolicitacaoAlvara(usuario);
        return usuario;
    }

    private void verificaContato(Optional<PessoaEntity> pessoa, UsuarioResponseToken usuarioResponseToken) throws UnicoClientException {
        ContatoPessoaEntity contatoPrincipal = pessoa.get().getContatoPessoaPrincipal();
        if (Objects.nonNull(contatoPrincipal)) {
            contatoPrincipal.setEmail(usuarioResponseToken.getEmail());
            this.srvContatoPessoa.salvar(contatoPrincipal);
        } else if (pessoa.get().isPossuiSomenteUmContato()) {
            ContatoPessoaEntity contato = (ContatoPessoaEntity)pessoa.get().getContatos().stream().findFirst().get();
            contato.setEmail(usuarioResponseToken.getEmail());
            this.srvPessoa.salvar(pessoa.get());
        } else {
            this.srvContatoPessoa.salvar(this.criaContatoPrincipal(usuarioResponseToken, pessoa.get()));
        }
    }

    private boolean existEntidadeAoUsuario(UsuarioEntity usuario, EntidadeInterface entidadeInterface) {
        EntidadeAiseEntity entidadeAiseEntity = (EntidadeAiseEntity)entidadeInterface;
        if (Objects.isNull(usuario.getUsuarioEntidades()) || usuario.getUsuarioEntidades().isEmpty()) {
            return false;
        }
        Optional<UsuarioEntidadeEntity> optional = usuario.getUsuarioEntidades().stream().filter(item -> item.getId().getEntidade().equals((Object)entidadeAiseEntity)).findFirst();
        return optional.isPresent();
    }

    private UsuarioEntity salvarEntidadeNaoVinculadoAoUsuario(UsuarioEntity usuario) throws BaseException {
        EntidadeInterface entidadeInterface = this.getEntidadePrincipal();
        if (!this.existEntidadeAoUsuario(usuario, entidadeInterface)) {
            usuario = this.vincularEntidadeAoUsuario(entidadeInterface, usuario);
            if (this.configuracaoUnico.isIntegrado()) {
                UsuarioUnico usuarioUnico = this.usuarioUnicoClientRest.get(usuario.getIdUnico());
                List patches = new ListUsuarioEntidadeEntityToListPatchFunction().apply(usuario.getUsuarioEntidades());
                usuarioUnico = this.usuarioUnicoClientRest.atualizarUsuario(usuarioUnico, patches);
                return this.repositoryUsuario.findByIdUnico(usuarioUnico.getId());
            }
        }
        return usuario;
    }

    private Boolean existModuloAlvaraAoUsuario(UsuarioEntity usuario, ModuloEntity moduloAlvara) throws BaseException {
        if (Objects.isNull(usuario.getUsuarioModulos()) || usuario.getUsuarioModulos().isEmpty()) {
            return false;
        }
        Optional<UsuarioModuloEntity> optional = usuario.getUsuarioModulos().stream().filter(item -> item.getId().getModulo().equals((Object)moduloAlvara)).findFirst();
        return optional.isPresent();
    }

    private UsuarioEntity salvarModuloAlvaraNaoVinculadoAoUsuario(UsuarioEntity usuario) throws BaseException {
        ModuloEntity moduloAlvara = this.getModuloAlvara();
        if (!this.existModuloAlvaraAoUsuario(usuario, moduloAlvara).booleanValue()) {
            usuario = this.vincularModuloAlvaraAoUsuario(moduloAlvara, usuario);
            if (this.configuracaoUnico.isIntegrado()) {
                UsuarioUnico usuarioUnico = this.usuarioUnicoClientRest.get(usuario.getIdUnico());
                List patches = new ListUsuarioModuloEntityToListPatchFunction().apply(usuario.getUsuarioModulos());
                usuarioUnico = this.usuarioUnicoClientRest.atualizarUsuario(usuarioUnico, patches);
                return this.repositoryUsuario.findByIdUnico(usuarioUnico.getId());
            }
        }
        return usuario;
    }

    private UsuarioEntity vincularSeletorTelaCompanhamentoETelaSolicitacaoAlvara(UsuarioEntity usuario) throws BaseException {
        ArrayList<UsuarioSeletorEntity> listaUsuarioSeletor = this.getUsuarioSeletor(usuario);
        if (Objects.isNull(listaUsuarioSeletor) || listaUsuarioSeletor.isEmpty()) {
            listaUsuarioSeletor = new ArrayList<UsuarioSeletorEntity>();
        } else {
            usuario.setUsuarioSeletores(listaUsuarioSeletor);
        }
        boolean seletorTelaCompanhamento = false;
        boolean seletorTelaSolicitacaoAlvara = false;
        for (UsuarioSeletorEntity usuario_seletor : listaUsuarioSeletor) {
            if (usuario_seletor.getId().getSeletor().getId().getSeletor().equals(SELETORTELAACOMPANHAMENTO)) {
                seletorTelaCompanhamento = true;
            }
            if (usuario_seletor.getId().getSeletor().getId().getSeletor().equals(SELETORTELASOLICITACAOALVARA)) {
                seletorTelaSolicitacaoAlvara = true;
            }
            if (!seletorTelaCompanhamento || !seletorTelaSolicitacaoAlvara) continue;
            break;
        }
        if (!seletorTelaCompanhamento || !seletorTelaSolicitacaoAlvara) {
            usuario = this.salvarModuloAlvaraNaoVinculadoAoUsuario(usuario);
            usuario = this.salvarEntidadeNaoVinculadoAoUsuario(usuario);
            if (!seletorTelaCompanhamento) {
                listaUsuarioSeletor.add(this.getUsuarioSeletor(usuario, this.getSeletor(SELETORTELAACOMPANHAMENTO)));
            }
            if (!seletorTelaSolicitacaoAlvara) {
                listaUsuarioSeletor.add(this.getUsuarioSeletor(usuario, this.getSeletor(SELETORTELASOLICITACAOALVARA)));
            }
            usuario.setUsuarioSeletores(listaUsuarioSeletor);
            this.repositoryUsuarioSeletor.saveOrUpdate(listaUsuarioSeletor);
        }
        usuario = (UsuarioEntity)this.carregarAuthorities((UserDetails)usuario);
        return usuario;
    }

    protected List<UsuarioSeletorEntity> getUsuarioSeletor(UsuarioEntity usuario) {
        return this.repositoryUsuarioSeletor.getUsuarioSeletor(Modulo.ALVARAONLINE.getCodigo(), usuario.getUsuario());
    }

    private UserDetails carregarAuthorities(UserDetails user) {
        UsuarioEntity usuario = (UsuarioEntity)user;
        usuario.setAuthorities((List)Lists.newArrayList());
        if (!EloListUtils.safeIsEmpty((List)usuario.getUsuarioSeletores()).booleanValue()) {
            usuario.getUsuarioSeletores().stream().forEach(s -> usuario.getAuthorities().add(new SimpleGrantedAuthority(s.getId().getSeletor().getSeletor())));
        }
        return usuario;
    }

    private UsuarioEntity vincularModuloAlvaraAoUsuario(ModuloEntity moduloAlvara, UsuarioEntity usuario) throws BaseException {
        UsuarioModuloEntity usuarioModuloEntity = new UsuarioModuloEntity();
        usuarioModuloEntity.setId(new UsuarioModuloPK());
        usuarioModuloEntity.getId().setModulo(moduloAlvara);
        usuarioModuloEntity.getId().setUsuario(usuario);
        if (Objects.isNull(usuario.getUsuarioModulos()) || usuario.getUsuarioModulos().isEmpty()) {
            usuario.setUsuarioModulos(new ArrayList());
        }
        usuario.getUsuarioModulos().add(usuarioModuloEntity);
        return usuario;
    }

    private UsuarioEntity vincularEntidadeAoUsuario(EntidadeInterface entidadeInterface, UsuarioEntity usuario) throws BaseException {
        EntidadeAiseEntity entidadeAiseEntity = (EntidadeAiseEntity)entidadeInterface;
        UsuarioEntidadeEntity usuarioEntidadeEntity = new UsuarioEntidadeEntity();
        usuarioEntidadeEntity.setId(new UsuarioEntidadePK());
        usuarioEntidadeEntity.getId().setEntidade((EntidadeEntity)entidadeAiseEntity);
        usuarioEntidadeEntity.getId().setUsuario(usuario);
        if (Objects.isNull(usuario.getUsuarioEntidades()) || usuario.getUsuarioEntidades().isEmpty()) {
            usuario.setUsuarioEntidades(new ArrayList());
        }
        usuario.getUsuarioEntidades().add(usuarioEntidadeEntity);
        return usuario;
    }

    protected SeletorEntity getSeletor(String seletor) {
        return this.repositorySeletor.getSeletor(Modulo.ALVARAONLINE.getCodigo(), seletor);
    }

    private EntidadeInterface getEntidadePrincipal() throws BaseException, EEntityNotFound {
        EntidadeInterface entidadeInterface = this.repositoryEntidadeAise.findEntidadePrincipal();
        if (Objects.isNull(entidadeInterface)) {
            throw new EEntityNotFound("Entidade principal n\u00e3o encontrado.");
        }
        return entidadeInterface;
    }

    private ModuloEntity getModuloAlvara() throws EEntityNotFound {
        ModuloEntity moduloEntity = this.repositoryModulo.load(Modulo.ALVARAONLINE.getCodigo());
        if (Objects.isNull(moduloEntity)) {
            throw new EEntityNotFound("M\u00f3dulo de alvar\u00e1 n\u00e3o encontrado.");
        }
        return moduloEntity;
    }

    public UsuarioEntity criarUsuario(PessoaEntity pessoa, UsuarioResponseToken usuarioResponseToken) throws HashException, BaseException {
        String idUsuario = pessoa.getCnpjCpf();
        String senha = String.format("%s%s", pessoa.getCnpjCpf(), pessoa.getNome().replace(" ", "").trim().toLowerCase());
        UsuarioEntity usuario = new UsuarioEntity();
        usuario.setUsuario(idUsuario);
        usuario.setNome(pessoa.getNome());
        usuario.setCpf(pessoa.getCnpjCpf());
        usuario.setEmail(usuarioResponseToken.getEmail());
        usuario.setAtivo("S");
        usuario.setSenha(EloHashUtils.hashMD5((String)senha));
        usuario.setPessoa(pessoa);
        usuario.setNivelUsuario(Long.valueOf(1L));
        usuario.setTiposDocumento(new ArrayList());
        usuario = this.vincularModuloAlvaraAoUsuario(this.getModuloAlvara(), usuario);
        usuario = this.vincularEntidadeAoUsuario(this.getEntidadePrincipal(), usuario);
        return this.salvarUsuario(usuario);
    }

    private UsuarioEntity salvarUsuario(UsuarioEntity usuario) throws UnicoClientException, HashException {
        if (this.configuracaoUnico.isIntegrado()) {
            UsuarioUnico usuarioUnico = new UsuarioEntityToUsuarioUnico().apply(usuario);
            usuarioUnico = this.usuarioUnicoClientRest.salvarOuAtualizar(usuarioUnico);
            UsuarioEntity usuarioSalvo = this.repositoryUsuario.findByIdUnico(usuarioUnico.getId());
            this.repositoryUsuario.refresh(usuarioSalvo);
            return usuarioSalvo;
        }
        return this.repositoryUsuario.saveOrUpdate(usuario);
    }

    private Optional<PessoaEntity> criarPessoa(UsuarioResponseToken usuarioResponseToken) throws UnicoClientException {
        Optional<Object> pessoa = null;
        List pessoas = this.repositoryPessoa.carregaPessoasPorCpfCnpj(usuarioResponseToken.getCpfUsuario());
        if (!EloListUtils.safeIsEmpty((List)pessoas).booleanValue()) {
            Comparator comp = (p1, p2) -> Long.compare(p1.getId(), p2.getId());
            pessoa = Optional.of(pessoas.stream().max(comp).get());
        } else {
            pessoa = Optional.of(new PessoaEntity());
            pessoa.get().setCnpjCpf(usuarioResponseToken.getCpfUsuario());
            ((PessoaEntity)pessoa.get()).setNome(usuarioResponseToken.getNome());
            ((PessoaEntity)pessoa.get()).setDataInclusao(new Date());
            ((PessoaEntity)pessoa.get()).setInativo(SimNaoEnum.getNaoShortText());
            ((PessoaEntity)pessoa.get()).setTipoPessoa(this.getTipoPessoa(usuarioResponseToken.getCpfUsuario()));
            ((PessoaEntity)pessoa.get()).setUsuarioInclusao(PortalUtils.getUsuarioalvaraonline());
            ((PessoaEntity)pessoa.get()).setRg(usuarioResponseToken.getRg());
            ((PessoaEntity)pessoa.get()).setOrgaoEmissor(usuarioResponseToken.getOrgaoEmissor());
            ((PessoaEntity)pessoa.get()).setDataNascimento(usuarioResponseToken.getNascimento());
            if (StringUtils.isNotBlank((CharSequence)usuarioResponseToken.getEmail()) || StringUtils.isNotBlank((CharSequence)usuarioResponseToken.getFone())) {
                this.criaContatoPrincipal(usuarioResponseToken, (PessoaEntity)pessoa.get());
            }
            pessoa = Optional.of(this.srvPessoa.salvar((PessoaEntity)pessoa.get()));
        }
        return pessoa;
    }

    private ContatoPessoaEntity criaContatoPrincipal(UsuarioResponseToken usuarioResponseToken, PessoaEntity pessoa) {
        ContatoPessoaPK id = new ContatoPessoaPK();
        id.setPessoa(pessoa);
        ContatoPessoaEntity contato = new ContatoPessoaEntity();
        contato.setId(id);
        contato.setEmail(usuarioResponseToken.getEmail());
        contato.setTelefoneResidencial(usuarioResponseToken.getFone());
        contato.setNome(usuarioResponseToken.getNome());
        contato.setPrincipal(Boolean.TRUE.booleanValue());
        return contato;
    }

    private JSONObject getUsuarioSemOauth(String token) throws DadosUsuarioByTokenException {
        HttpResponse response = null;
        try {
            response = HttpUtils.requestHttpGet((String)(this.repositoryParametroGeral.getParametro(Modulo.ALVARAONLINE.getCodigo(), "LINKDADOSAUSUARIOTOKEN") + "?token=" + token));
            BufferedReader rd = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
            JSONObject object = JSONObject.fromObject((Object)rd.readLine());
            return object;
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new DadosUsuarioByTokenException("Usu\u00e1rio n\u00e3o foi Autenticado! (N\u00e3o foi poss\u00edvel recuperar os dados do usu\u00e1rio)", (Throwable)e);
        }
    }

    private JSONObject getUsuarioOauth(String token) {
        JSONObject jsonObject = null;
        try {
            HttpResponse response = HttpUtils.requestHttpGet((String)(this.repositoryParametroGeral.getParametro(Modulo.ALVARAONLINE.getCodigo(), "LINKADADOSUSUARIOOAUTH") + "?access_token=" + token));
            BufferedReader rd = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
            if (rd != null) {
                jsonObject = JSONObject.fromObject((Object)rd.readLine());
                rd.close();
            }
        }
        catch (IOException | URISyntaxException | HttpException e) {
            this.logger.error((Object)e.getMessage(), e);
        }
        return jsonObject;
    }

    private String getTipoPessoa(String cpfCnpj) {
        return EloStringUtils.getTipoPessoaFromCnpjCpf((String)cpfCnpj);
    }

    private EntidadeAiseEntity getEntidade() {
        EntidadeTributacaoEntity entidadeTributacao = this.repositoryEntidadeTributacao.getExercicioAtual(Long.valueOf(EloDateUtils.getYear((Date)new Date())));
        return entidadeTributacao.getId().getEntidade();
    }

    private UsuarioSeletorEntity getUsuarioSeletor(UsuarioEntity usuario, SeletorEntity seletor) {
        UsuarioSeletorEntity usuarioSeletor = new UsuarioSeletorEntity();
        usuarioSeletor.setInserir("N");
        usuarioSeletor.setAlterar("N");
        usuarioSeletor.setExcluir("N");
        usuarioSeletor.setFavorito("N");
        usuarioSeletor.setFuncaoEspecial("N");
        UsuarioSeletorPK usuarioSeletorPK = new UsuarioSeletorPK();
        usuarioSeletorPK.setEntidade((EntidadeEntity)this.getEntidade());
        usuarioSeletorPK.setSeletor(seletor);
        usuarioSeletorPK.setUsuario(usuario);
        usuarioSeletor.setId(usuarioSeletorPK);
        return usuarioSeletor;
    }

    private boolean usaOauthLogin() {
        String clientOauth = this.repositoryParametroGeral.getParametro(Modulo.ALVARAONLINE.getCodigo(), "CLIENTOAUTH");
        return StringUtils.isNotBlank((CharSequence)clientOauth);
    }

    public List<UsuarioEntity> carregarUsuariosPorModulo(Modulo modulo) {
        return this.repositoryUsuario.carregarUsuariosPorModulo(modulo);
    }

    public UsuarioEntity salvar(UsuarioEntity usuario) throws UnicoClientException, HashException {
        return this.salvarUsuario(usuario);
    }

    public List<TipoDocumentoUsuarioAlvaraEntity> salvarTipoDocumentoUsuarioAlvara(UsuarioEntity usuarioAlvara) throws ValidacaoException {
        if (!EloListUtils.safeIsEmpty((List)usuarioAlvara.getTiposDocumento()).booleanValue()) {
            this.removerTipoDocUsuarioAlvara(((TipoDocumentoUsuarioAlvaraEntity)usuarioAlvara.getTiposDocumento().stream().findFirst().get()).getUsuario());
            this.repositoryTipoDocumentoUsuarioAlvara.saveList(usuarioAlvara.getTiposDocumento());
        } else {
            this.removerTipoDocUsuarioAlvara(usuarioAlvara);
        }
        return usuarioAlvara.getTiposDocumento();
    }

    private void removerTipoDocUsuarioAlvara(UsuarioEntity usuario) {
        List documentos = this.repositoryTipoDocumentoUsuarioAlvara.carregaTiposDocumentosPorUsuario(usuario);
        for (TipoDocumentoUsuarioAlvaraEntity doc : documentos) {
            this.repositoryTipoDocumentoUsuarioAlvara.removeByPk(doc.getId());
        }
    }

    public Page<UsuarioVo> carregarUsuariosPorModulo(UsuarioDataModel usuarioDataModel, int pagina, int tamanhoPagina) throws UnicoClientException {
        ArrayList<EloFilter> filtros = new ArrayList<EloFilter>();
        filtros.add(EloFilter.newFrom((String)"modulo", (Object)usuarioDataModel.getModulo().toString()));
        filtros.add(EloFilter.newFrom((String)"cpf", (Object)usuarioDataModel.getCpf()));
        filtros.add(EloFilter.newFrom((String)"nome", (Object)usuarioDataModel.getNome()));
        HashMapEloFilter hashMapEloFilter = new HashMapEloFilter(filtros);
        return this.repositoryUsuario.carregarUsuariosPorModulo(hashMapEloFilter, pagina, tamanhoPagina);
    }

    public UsuarioEntity getUsuarioAutenticado() {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        if (auth != null && auth.getPrincipal() instanceof UsuarioEntity) {
            return (UsuarioEntity)auth.getPrincipal();
        }
        return null;
    }

    public void setSrvContatoPessoa(SrvContatoPessoa srvContatoPessoa) {
        this.srvContatoPessoa = srvContatoPessoa;
    }

    public void setSrvPessoa(SrvPessoa srvPessoa) {
        this.srvPessoa = srvPessoa;
    }

    public void setConfiguracaoUnico(ConfiguracaoUnico configuracaoUnico) {
        this.configuracaoUnico = configuracaoUnico;
    }

    public void salvarCadastroRestricaoUsuarioAlvara(UsuarioEntity usuarioSelecionado) {
        if (EloListUtils.safeIsEmpty((List)usuarioSelecionado.getCadastroRestricoesAlvaras()).booleanValue()) {
            usuarioSelecionado.setCadastroRestricoesAlvaras(new ArrayList());
        }
        this.repositoryUsuario.saveOrUpdate(usuarioSelecionado);
    }
}

