/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.service.impl;

import br.com.elotech.annotations.spring.EloService;
import br.com.elotech.portalarrecadacao.domain.ParametroAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.StatusLaudoAlvara;
import br.com.elotech.portalarrecadacao.enumerator.ParametroAlvaraEnum;
import br.com.elotech.portalarrecadacao.repository.RepositoryParametroAlvara;
import br.com.elotech.portalarrecadacao.service.SrvStatusLaudoAlvara;
import br.com.elotech.tributacao.domain.aise.EntidadeAiseEntity;
import br.com.elotech.util.string.EloStringUtils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;

@EloService(value="srvStatusLaudoAlvara")
public class SrvStatusLaudoAlvaraImpl
implements SrvStatusLaudoAlvara {
    @Resource
    private RepositoryParametroAlvara repositoryParametroAlvara;

    public List<StatusLaudoAlvara> getStatusLaudoAlvaraPermitidos(EntidadeAiseEntity entidade) {
        ArrayList<StatusLaudoAlvara> listStatus = new ArrayList<StatusLaudoAlvara>();
        ParametroAlvaraEntity parametroStatus = this.repositoryParametroAlvara.getParametroAlvara(entidade, ParametroAlvaraEnum.STATUS_LAUDO_PERMITIDOS);
        if (parametroStatus != null && !EloStringUtils.isEmpty((String)parametroStatus.getValor())) {
            String[] statusParam;
            for (String statusCodigo : statusParam = parametroStatus.getValor().split(",")) {
                for (StatusLaudoAlvara status : StatusLaudoAlvara.values()) {
                    if (!statusCodigo.equals(status.getCodigo())) continue;
                    listStatus.add(status);
                }
            }
        }
        return listStatus;
    }
}

