/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.service.impl;

import br.com.elotech.annotations.spring.EloService;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.portalarrecadacao.common.CommonGeraDocumento;
import br.com.elotech.portalarrecadacao.common.GeraDocumentoInscricaoMunicipal;
import br.com.elotech.portalarrecadacao.common.GeraDocumentoObservacaoConsulta;
import br.com.elotech.portalarrecadacao.common.GeraDocumentoTermoDispensa;
import br.com.elotech.portalarrecadacao.controller.UtilsController;
import br.com.elotech.portalarrecadacao.domain.ClassificacaoTipoInscricaoEntity;
import br.com.elotech.portalarrecadacao.domain.EventoRedeSimEntity;
import br.com.elotech.portalarrecadacao.domain.HistoricoExigenciaRedeSimEntity;
import br.com.elotech.portalarrecadacao.domain.HistoricoExigenciaUrlDocEntity;
import br.com.elotech.portalarrecadacao.domain.NaturezaSolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.ParametroAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.RegimeFiscalEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraAtividadeEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraDebitoEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraValidadeEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoBaixaRedeSimEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoEncaminhadaEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoRedeSimEntity;
import br.com.elotech.portalarrecadacao.domain.helper.ImprimirTaxasAlvara;
import br.com.elotech.portalarrecadacao.domain.vo.ConsultaAtividadeVo;
import br.com.elotech.portalarrecadacao.domain.vo.DebitoWebVo;
import br.com.elotech.portalarrecadacao.domain.vo.EmailVo;
import br.com.elotech.portalarrecadacao.domain.vo.ReceitaVo;
import br.com.elotech.portalarrecadacao.enumerator.EnquadramentoEmpresaEnum;
import br.com.elotech.portalarrecadacao.enumerator.GrauDeRiscoEnum;
import br.com.elotech.portalarrecadacao.enumerator.NaturezaSolicitacaoAlvaraEnum;
import br.com.elotech.portalarrecadacao.enumerator.ParametroAlvaraEnum;
import br.com.elotech.portalarrecadacao.enumerator.SituacaoConsultaPreviaRedeSimEnum;
import br.com.elotech.portalarrecadacao.enumerator.SituacaoRespostaRedeSimEnum;
import br.com.elotech.portalarrecadacao.enumerator.TipoAlvaraEnum;
import br.com.elotech.portalarrecadacao.enumerator.TipoArquivoJuntaComercialEnum;
import br.com.elotech.portalarrecadacao.enumerator.TipoSolicitacaoRedeSimEnum;
import br.com.elotech.portalarrecadacao.exception.AtividadeNaoConfiguradaException;
import br.com.elotech.portalarrecadacao.exception.AtividadeNaoPermitidaException;
import br.com.elotech.portalarrecadacao.exception.CadastroImobiliarioNaoEncontradoException;
import br.com.elotech.portalarrecadacao.exception.DocumentoNaoEncontradoException;
import br.com.elotech.portalarrecadacao.exception.GeraBloquetoException;
import br.com.elotech.portalarrecadacao.exception.LogradouroNaoEncontradoException;
import br.com.elotech.portalarrecadacao.exception.SolicitacaoAlvaraException;
import br.com.elotech.portalarrecadacao.exception.SolicitacaoRedeSimException;
import br.com.elotech.portalarrecadacao.exception.TestadaNaoEncontradaException;
import br.com.elotech.portalarrecadacao.facade.FacadeAlteracaoAtividades;
import br.com.elotech.portalarrecadacao.facade.FacadeEntidade;
import br.com.elotech.portalarrecadacao.facade.FacadeRedeSim;
import br.com.elotech.portalarrecadacao.facade.FacadeSituacaoMobiliarioAlvara;
import br.com.elotech.portalarrecadacao.facade.FacadeSolicitacaoAlvara;
import br.com.elotech.portalarrecadacao.integration.dto.consulta.Arquivo;
import br.com.elotech.portalarrecadacao.integration.dto.consulta.ArquivosEntidadeRegistro;
import br.com.elotech.portalarrecadacao.integration.dto.consulta.Atividades;
import br.com.elotech.portalarrecadacao.integration.dto.consulta.DadosSolicitacao;
import br.com.elotech.portalarrecadacao.integration.dto.consulta.Evento;
import br.com.elotech.portalarrecadacao.integration.dto.consulta.GrauRiscoPergunta;
import br.com.elotech.portalarrecadacao.integration.dto.consulta.Solicitante;
import br.com.elotech.portalarrecadacao.integration.dto.dadosEmpresa.DadosRetornoExigencia;
import br.com.elotech.portalarrecadacao.integration.dto.dadosEmpresa.Empresa;
import br.com.elotech.portalarrecadacao.integration.dto.dadosEmpresa.ExigenciaRetorno;
import br.com.elotech.portalarrecadacao.integration.transformer.ProcessaConsulta;
import br.com.elotech.portalarrecadacao.repository.RepositoryClassificacaoTipoInscricao;
import br.com.elotech.portalarrecadacao.repository.RepositoryCnaePrestadorServico;
import br.com.elotech.portalarrecadacao.repository.RepositoryConsultaRedeSim;
import br.com.elotech.portalarrecadacao.repository.RepositoryEventoRedeSim;
import br.com.elotech.portalarrecadacao.repository.RepositoryExigenciaRedeSim;
import br.com.elotech.portalarrecadacao.repository.RepositoryHistoricoExigenciaRedeSim;
import br.com.elotech.portalarrecadacao.repository.RepositoryHistoricoExigenciaUrlDoc;
import br.com.elotech.portalarrecadacao.repository.RepositoryModeloPerguntaAlvara;
import br.com.elotech.portalarrecadacao.repository.RepositoryParametroAlvara;
import br.com.elotech.portalarrecadacao.repository.RepositoryRegimeFiscal;
import br.com.elotech.portalarrecadacao.repository.RepositoryRestricaoConsultaPrevia;
import br.com.elotech.portalarrecadacao.repository.RepositorySolicitacaoAlvara;
import br.com.elotech.portalarrecadacao.repository.RepositorySolicitacaoAlvaraDebito;
import br.com.elotech.portalarrecadacao.repository.RepositorySolicitacaoAlvaraValidade;
import br.com.elotech.portalarrecadacao.repository.RepositorySolicitacaoBaixaRedeSim;
import br.com.elotech.portalarrecadacao.repository.RepositorySolicitacaoContratoSocial;
import br.com.elotech.portalarrecadacao.repository.RepositorySolicitacaoContratoSocialPessoa;
import br.com.elotech.portalarrecadacao.repository.RepositorySolicitacaoDocRedeSim;
import br.com.elotech.portalarrecadacao.repository.RepositorySolicitacaoEncaminhada;
import br.com.elotech.portalarrecadacao.repository.RepositoryTipoInscricaoAlvara;
import br.com.elotech.portalarrecadacao.repository.RepositoryUrlArquivoRedeSim;
import br.com.elotech.portalarrecadacao.rest.dto.SolicitacaoAlvaraRedeSimDTO;
import br.com.elotech.portalarrecadacao.rest.geradocumento.EnvioGeraDocumento;
import br.com.elotech.portalarrecadacao.rest.geradocumento.GeraDocumentoClientAlvara;
import br.com.elotech.portalarrecadacao.rest.imprimirdocumento.ImprimeDocumentoAlvara;
import br.com.elotech.portalarrecadacao.rest.issExterno.SrvClientIssExterno;
import br.com.elotech.portalarrecadacao.service.SrvContratoSocial;
import br.com.elotech.portalarrecadacao.service.SrvDebitosPortal;
import br.com.elotech.portalarrecadacao.service.SrvRespostaDocumentosRedeSim;
import br.com.elotech.portalarrecadacao.service.SrvSituacaoMobiliario;
import br.com.elotech.portalarrecadacao.service.SrvSolicitacaoAlvara;
import br.com.elotech.portalarrecadacao.service.SrvSolicitacaoAlvaraMEI;
import br.com.elotech.portalarrecadacao.service.SrvSolicitacaoAlvaraRedeSim;
import br.com.elotech.portalarrecadacao.service.impl.SrvConsultaPreviaImpl;
import br.com.elotech.portalarrecadacao.service.impl.SrvFindEnderecoBySimilarity;
import br.com.elotech.portalarrecadacao.service.impl.SrvFindTipoInscricaoAlvaraImpl;
import br.com.elotech.portalarrecadacao.service.impl.SrvSolicitacaoAlvaraImpl;
import br.com.elotech.portalarrecadacao.utils.params.PortalUtils;
import br.com.elotech.portalarrecadacao.ws.oxm.GeraDebitoWeb;
import br.com.elotech.portalarrecadacao.ws.oxm.GeraDebitoWebEnvio;
import br.com.elotech.spring.SpringContext;
import br.com.elotech.tributacao.domain.aise.CadastroGeralAiseEntity;
import br.com.elotech.tributacao.domain.aise.CadastroGeralAisePK;
import br.com.elotech.tributacao.domain.aise.CadastroImobiliarioEntity;
import br.com.elotech.tributacao.domain.aise.CadastroImobiliarioTestadaEntity;
import br.com.elotech.tributacao.domain.aise.CadastroMobiliarioEntity;
import br.com.elotech.tributacao.domain.aise.CategoriaMobiliarioEntity;
import br.com.elotech.tributacao.domain.aise.DebitoEntity;
import br.com.elotech.tributacao.domain.aise.DocumentoAiseEntity;
import br.com.elotech.tributacao.domain.aise.EnderecoCadastroGeralEntity;
import br.com.elotech.tributacao.domain.aise.EnderecoPessoaEntity;
import br.com.elotech.tributacao.domain.aise.EntidadeAiseEntity;
import br.com.elotech.tributacao.domain.aise.EntidadeTributacaoEntity;
import br.com.elotech.tributacao.domain.aise.GuiaRecolhimentoEntity;
import br.com.elotech.tributacao.domain.aise.GuiaRecolhimentoReceitaEntity;
import br.com.elotech.tributacao.domain.aise.LogradouroEntity;
import br.com.elotech.tributacao.domain.aise.MobiliarioSituacaoEntity;
import br.com.elotech.tributacao.domain.aise.MobiliarioSituacaoPK;
import br.com.elotech.tributacao.domain.aise.NaturezaJuridicaEntity;
import br.com.elotech.tributacao.domain.aise.PessoaEntity;
import br.com.elotech.tributacao.domain.aise.RegimeFiscalPeriodoRealAiseEntity;
import br.com.elotech.tributacao.domain.aise.SituacaoMobiliarioEntity;
import br.com.elotech.tributacao.domain.aise.TipoInscricaoAlvaraEntity;
import br.com.elotech.tributacao.domain.aise.UsuarioEntity;
import br.com.elotech.tributacao.dto.GeraDebitoGenericoDTO;
import br.com.elotech.tributacao.enumerator.DocumentoTipoEnum;
import br.com.elotech.tributacao.enumerator.SimNaoEnum;
import br.com.elotech.tributacao.enumerator.SituacaoMobiliarioAlvaraEnum;
import br.com.elotech.tributacao.filter.GuiaRecolhimentoReceitaFiltro;
import br.com.elotech.tributacao.interfaces.Atividade;
import br.com.elotech.tributacao.repository.aise.RepositoryCadastroGeral;
import br.com.elotech.tributacao.repository.aise.RepositoryCadastroImobiliario;
import br.com.elotech.tributacao.repository.aise.RepositoryCadastroMobiliario;
import br.com.elotech.tributacao.repository.aise.RepositoryCnae;
import br.com.elotech.tributacao.repository.aise.RepositoryContatoPessoa;
import br.com.elotech.tributacao.repository.aise.RepositoryContratoSocial;
import br.com.elotech.tributacao.repository.aise.RepositoryDebito;
import br.com.elotech.tributacao.repository.aise.RepositoryDocumentoAise;
import br.com.elotech.tributacao.repository.aise.RepositoryEnderecoCadastroGeral;
import br.com.elotech.tributacao.repository.aise.RepositoryEntidadeTributacao;
import br.com.elotech.tributacao.repository.aise.RepositoryGuiaRecolhimentoReceita;
import br.com.elotech.tributacao.repository.aise.RepositoryMobiliarioSituacao;
import br.com.elotech.tributacao.repository.aise.RepositoryNaturezaJuridica;
import br.com.elotech.tributacao.repository.aise.RepositoryPessoa;
import br.com.elotech.tributacao.repository.aise.RepositoryProprietario;
import br.com.elotech.tributacao.repository.aise.RepositoryRegimeFiscalPeriodoRealAise;
import br.com.elotech.tributacao.repository.aise.RepositoryUsuario;
import br.com.elotech.tributacao.repository.alvara.RepositoryDocumentoAiseAlvara;
import br.com.elotech.tributacao.service.SrvGeraDebitoGenerico;
import br.com.elotech.tributacao.service.SrvPessoa;
import br.com.elotech.tributacao.service.SrvUnico;
import br.com.elotech.util.date.EloDateUtils;
import br.com.elotech.util.list.EloListUtils;
import br.com.elotech.util.string.EloStringUtils;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import java.net.URISyntaxException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.hibernate.Hibernate;
import org.springframework.security.core.context.SecurityContextHolder;

@EloService(value="srvSolicitacaoAlvaraRedeSim")
public class SrvSolicitacaoAlvaraRedeSimImpl
extends SrvSolicitacaoAlvaraImpl
implements SrvSolicitacaoAlvaraRedeSim {
    public static final String CADASTRO_MOBILIARIO_SEM_ENDERE\u00c7O = "Cadastro Mobili\u00e1rio sem Endere\u00e7o";
    @Resource
    private SrvPessoa srvPessoa;
    @Resource
    private SrvClientIssExterno srvClientIssExterno;
    @Resource
    private SrvGeraDebitoGenerico srvGeraDebitoGenerico;
    @Resource
    private RepositoryConsultaRedeSim repositoryConsultaRedeSim;
    @Resource
    private SrvUnico srvUnico;
    @Resource
    private RepositoryEnderecoCadastroGeral repositoryEnderecoCadastroGeral;
    @Resource
    private SrvSolicitacaoAlvara srvSolicitacaoAlvara;
    @Resource
    private SrvSolicitacaoAlvaraMEI srvSolicitacaoAlvaraMEI;
    @Resource
    private RepositorySolicitacaoAlvara repositorySolicitacaoAlvara;
    @Resource
    private RepositoryDocumentoAiseAlvara repositoryDocumentoAiseAlvara;
    @Resource
    private RepositoryModeloPerguntaAlvara repositoryModeloPerguntaAlvara;
    @Resource
    private RepositoryContatoPessoa repositoryContatoPessoa;
    @Resource
    private RepositoryParametroAlvara repositoryParametroAlvara;
    @Resource
    private RepositorySolicitacaoAlvaraDebito repositorySolicitacaoAlvaraDebito;
    @Resource
    private RepositoryTipoInscricaoAlvara repositoryTipoInscricao;
    @Resource
    private RepositoryCadastroMobiliario repositoryCadastroMobiliario;
    @Resource
    private RepositoryEventoRedeSim repositoryEventoRedeSim;
    @Resource
    private RepositoryPessoa repositoryPessoa;
    @Resource
    private SrvRespostaDocumentosRedeSim srvRespostaDocumentosRedeSim;
    @Resource
    private RepositorySolicitacaoAlvaraValidade repositorySolicitacaoValidade;
    @Resource
    private RepositoryGuiaRecolhimentoReceita repositoryGuiaRecolhimentoReceita;
    @Resource
    private SrvDebitosPortal srvDebitosPortal;
    @Resource
    private RepositoryUsuario repositoryUsuario;
    @Resource
    private RepositoryDebito repositoryDebito;
    @Resource
    private RepositoryHistoricoExigenciaRedeSim repositoryHistoricoExigencia;
    @Resource
    private RepositoryExigenciaRedeSim repositoryExigenciaRedeSim;
    @Resource
    private RepositorySolicitacaoContratoSocial repositorySolicitacaoContratoSocial;
    @Resource
    private RepositorySolicitacaoContratoSocialPessoa repositorySolicitacaoContratoSocialPessoa;
    @Resource
    private RepositoryDocumentoAise repositoryDocumentoAise;
    @Resource
    private ImprimeDocumentoAlvara imprimeDocumentoAlvara;
    @Resource
    private RepositoryUrlArquivoRedeSim repositoryUrlArquivoRedeSim;
    @Resource
    private RepositorySolicitacaoDocRedeSim repositorySolicitacaoDocRedeSim;
    @Resource
    private RepositoryHistoricoExigenciaUrlDoc repositoryHistoricoExigenciaUrlDoc;
    @Resource
    private ProcessaConsulta processaConsulta;
    @Resource
    private RepositorySolicitacaoEncaminhada repositorySolicitacaoEncaminhada;
    @Resource
    private RepositoryCnaePrestadorServico repositoryCnaePrestadorServico;
    @Resource
    private SrvContratoSocial srvContratoSocial;
    @Resource
    private RepositoryCadastroGeral repositoryCadastroGeral;
    @Resource
    private RepositoryProprietario repositoryProprietario;
    @Resource
    private RepositoryContratoSocial repositoryContratoSocial;
    @Resource
    private RepositoryRestricaoConsultaPrevia repositoryRestricaoConsultaPrevia;
    @Resource
    private RepositoryEntidadeTributacao repositoryEntidadeTributacao;
    @Resource
    private SrvSituacaoMobiliario srvSituacaoMobiliario;
    @Resource
    private RepositoryMobiliarioSituacao repositoryMobiliarioSituacao;
    @Resource
    private RepositorySolicitacaoBaixaRedeSim repositorySolicitacaoBaixaRedeSim;
    private boolean integradoGeo = false;
    private static final String INTEGRASGO = "INTEGRASGO";
    @Resource
    private RepositoryClassificacaoTipoInscricao repositoryClassificacaoTipoInscricao;
    @Resource
    private RepositoryCadastroImobiliario repositoryCadastroImobiliario;
    @Resource
    private SrvConsultaPreviaImpl srvConsultaPreviaImpl;
    @Resource
    private RepositoryRegimeFiscal repositoryRegimeFiscal;
    @Resource
    private RepositoryRegimeFiscalPeriodoRealAise repositoryRegimeFiscalPeriodoRealAise;
    @Resource
    private RepositoryCnae repositoryCnae;
    @Resource
    private SrvFindTipoInscricaoAlvaraImpl srvFindTipoInscricaoAlvara;
    @Resource
    private SrvFindEnderecoBySimilarity srvFindEnderecoBySimilarity;

    public void setSrvSolicitacaoAlvara(SrvSolicitacaoAlvara srvSolicitacaoAlvara) {
        this.srvSolicitacaoAlvara = srvSolicitacaoAlvara;
    }

    public void setSrvSituacaoMobiliario(SrvSituacaoMobiliario srvSituacaoMobiliario) {
        this.srvSituacaoMobiliario = srvSituacaoMobiliario;
    }

    public void setSrvContratoSocial(SrvContratoSocial srvContratoSocial) {
        this.srvContratoSocial = srvContratoSocial;
        super.setSrvContratoSocial(srvContratoSocial);
    }

    public void setSrvFindTipoInscricaoAlvara(SrvFindTipoInscricaoAlvaraImpl srvFindTipoInscricaoAlvara) {
        this.srvFindTipoInscricaoAlvara = srvFindTipoInscricaoAlvara;
        super.setSrvFindTipoInscricaoAlvara(srvFindTipoInscricaoAlvara);
    }

    public void setRepositoryProprietario(RepositoryProprietario repositoryProprietario) {
        this.repositoryProprietario = repositoryProprietario;
        super.setRepositoryProprietario(repositoryProprietario);
    }

    public void setRepositoryPessoa(RepositoryPessoa repositoryPessoa) {
        this.repositoryPessoa = repositoryPessoa;
        super.setRepositoryPessoa(repositoryPessoa);
    }

    public void setRepositoryContratoSocial(RepositoryContratoSocial repositoryContratoSocial) {
        this.repositoryContratoSocial = repositoryContratoSocial;
        super.setRepositoryContratoSocial(repositoryContratoSocial);
    }

    public void setSrvPessoa(SrvPessoa srvPessoa) {
        this.srvPessoa = srvPessoa;
        super.setSrvPessoa(srvPessoa);
    }

    public void setSrvClientIssExterno(SrvClientIssExterno srvClientIssExterno) {
        this.srvClientIssExterno = srvClientIssExterno;
        super.setSrvClientIssExterno(srvClientIssExterno);
    }

    public void setRepositoryClassificacaoTipoInscricao(RepositoryClassificacaoTipoInscricao repositoryClassificacaoTipoInscricao) {
        this.repositoryClassificacaoTipoInscricao = repositoryClassificacaoTipoInscricao;
    }

    public void setSrvConsultaPreviaImpl(SrvConsultaPreviaImpl srvConsultaPreviaImpl) {
        this.srvConsultaPreviaImpl = srvConsultaPreviaImpl;
    }

    public void setRepositoryCadastroMobiliario(RepositoryCadastroMobiliario repositoryCadastroMobiliario) {
        this.repositoryCadastroMobiliario = repositoryCadastroMobiliario;
        super.setRepositoryCadastroMobiliario(repositoryCadastroMobiliario);
    }

    public void setRepositoryCadastroImobiliario(RepositoryCadastroImobiliario repositoryCadastroImobiliario) {
        this.repositoryCadastroImobiliario = repositoryCadastroImobiliario;
    }

    public void setRepositoryHistoricoExigencia(RepositoryHistoricoExigenciaRedeSim repositoryHistoricoExigencia) {
        this.repositoryHistoricoExigencia = repositoryHistoricoExigencia;
    }

    public void setRepositoryExigenciaRedeSim(RepositoryExigenciaRedeSim repositoryExigenciaRedeSim) {
        this.repositoryExigenciaRedeSim = repositoryExigenciaRedeSim;
    }

    public void setRepositoryHistoricoExigenciaUrlDoc(RepositoryHistoricoExigenciaUrlDoc repositoryHistoricoExigenciaUrlDoc) {
        this.repositoryHistoricoExigenciaUrlDoc = repositoryHistoricoExigenciaUrlDoc;
    }

    public void setRepositoryGuiaRecolhimentoReceita(RepositoryGuiaRecolhimentoReceita repositoryGuiaRecolhimentoReceita) {
        this.repositoryGuiaRecolhimentoReceita = repositoryGuiaRecolhimentoReceita;
    }

    public void setSrvDebitosPortal(SrvDebitosPortal srvDebitosPortal) {
        this.srvDebitosPortal = srvDebitosPortal;
    }

    public void setSrvGeraDebitoGenerico(SrvGeraDebitoGenerico srvGeraDebitoGenerico) {
        this.srvGeraDebitoGenerico = srvGeraDebitoGenerico;
    }

    public void setRepositorySolicitacaoBaixaRedeSim(RepositorySolicitacaoBaixaRedeSim repositorySolicitacaoBaixaRedeSim) {
        this.repositorySolicitacaoBaixaRedeSim = repositorySolicitacaoBaixaRedeSim;
    }

    public void setRepositoryCadastroGeral(RepositoryCadastroGeral repositoryCadastroGeral) {
        this.repositoryCadastroGeral = repositoryCadastroGeral;
        super.setRepositoryCadastroGeral(repositoryCadastroGeral);
    }

    public void setRepositoryMobiliarioSituacao(RepositoryMobiliarioSituacao repositoryMobiliarioSituacao) {
        this.repositoryMobiliarioSituacao = repositoryMobiliarioSituacao;
        super.setRepositoryMobiliarioSituacao(repositoryMobiliarioSituacao);
    }

    public void setRepositoryEnderecoCadastroGeral(RepositoryEnderecoCadastroGeral repositoryEnderecoCadastroGeral) {
        this.repositoryEnderecoCadastroGeral = repositoryEnderecoCadastroGeral;
        super.setRepositoryEnderecoCadastroGeral(repositoryEnderecoCadastroGeral);
    }

    public void setSrvUnico(SrvUnico srvUnico) {
        this.srvUnico = srvUnico;
        super.setSrvUnico(srvUnico);
    }

    public void setRepositoryParametroAlvara(RepositoryParametroAlvara repositoryParametroAlvara) {
        this.repositoryParametroAlvara = repositoryParametroAlvara;
        super.setRepositoryParametroAlvara(repositoryParametroAlvara);
    }

    public void setRepositoryNaturezaJuridica(RepositoryNaturezaJuridica repositoryNaturezaJuridica) {
        this.repositoryNaturezaJuridica = repositoryNaturezaJuridica;
    }

    public void setRepositorySolicitacaoAlvaraDebito(RepositorySolicitacaoAlvaraDebito repositorySolicitacaoAlvaraDebito) {
        this.repositorySolicitacaoAlvaraDebito = repositorySolicitacaoAlvaraDebito;
        super.setRepositorySolicitacaoAlvaraDebito(repositorySolicitacaoAlvaraDebito);
    }

    public void setRepositorySolicitacaoAlvara(RepositorySolicitacaoAlvara repositorySolicitacaoAlvara) {
        this.repositorySolicitacaoAlvara = repositorySolicitacaoAlvara;
        super.setRepositorySolicitacaoAlvara(repositorySolicitacaoAlvara);
    }

    public void setRepositoryRestricaoConsultaPrevia(RepositoryRestricaoConsultaPrevia repositoryRestricaoConsultaPrevia) {
        this.repositoryRestricaoConsultaPrevia = repositoryRestricaoConsultaPrevia;
        super.setRepositoryRestricaoConsultaPrevia(repositoryRestricaoConsultaPrevia);
    }

    public void setRepositoryConsultaRedeSim(RepositoryConsultaRedeSim repositoryConsultaRedeSim) {
        this.repositoryConsultaRedeSim = repositoryConsultaRedeSim;
        super.setRepositoryConsultaRedeSim(repositoryConsultaRedeSim);
    }

    public void setRepositoryUsuario(RepositoryUsuario repositoryUsuario) {
        this.repositoryUsuario = repositoryUsuario;
    }

    public void setRepositoryEventoRedeSim(RepositoryEventoRedeSim repositoryEventoRedeSim) {
        this.repositoryEventoRedeSim = repositoryEventoRedeSim;
    }

    public void setRepositoryCnae(RepositoryCnae repositoryCnae) {
        this.repositoryCnae = repositoryCnae;
        super.setRepositoryCnae(repositoryCnae);
    }

    private List<NaturezaSolicitacaoAlvaraEntity> getNaturezaEvento(List<Evento> eventos) throws SolicitacaoRedeSimException {
        try {
            ArrayList naturezas = Lists.newArrayList();
            List eventosRedeSim = this.getEventos(eventos);
            for (EventoRedeSimEntity evento : eventosRedeSim) {
                if (EloStringUtils.isEmpty((String)evento.getSigla()) || this.isEventoJaAdicionado((List)naturezas, evento)) continue;
                naturezas.add(this.repositoryNaturezaSolicitacaoAlvara.getNatureza(evento.getSigla()));
            }
            return naturezas;
        }
        catch (Exception e) {
            throw new SolicitacaoRedeSimException("Ocorreu uma falha ao carregar os Eventos, Verificar a liga\u00e7\u00e3o de eventos por natureza de solicita\u00e7\u00e3o", e.getCause());
        }
    }

    private boolean isEventoJaAdicionado(List<NaturezaSolicitacaoAlvaraEntity> naturezas, EventoRedeSimEntity evento) {
        if (!EloListUtils.safeIsEmpty(naturezas).booleanValue()) {
            for (NaturezaSolicitacaoAlvaraEntity natureza : naturezas) {
                boolean jaAdicionado = this.repositoryNaturezaSolicitacaoAlvara.getNatureza(evento.getSigla()).getCodigo().equals(natureza.getCodigo());
                if (!jaAdicionado) continue;
                return true;
            }
        }
        return false;
    }

    private TipoInscricaoAlvaraEntity getTipoInscricaoByEnquadramento(int enquadramento) {
        return this.repositoryTipoInscricao.getTipoInscricaoBySigla(EnquadramentoEmpresaEnum.fromCodigo((Integer)enquadramento).getSigla());
    }

    private boolean isSomenteMudancaRazaoOuSocioOuNaturezaJuridica(List<Evento> eventos) throws BaseException {
        List naturezas = this.getNaturezaEvento(eventos);
        boolean toReturn = Boolean.FALSE;
        for (NaturezaSolicitacaoAlvaraEntity natureza : naturezas) {
            if (NaturezaSolicitacaoAlvaraEnum.ALTERACAO_NATUREZA_JURIDICA.getValue().equalsIgnoreCase(natureza.getCodigo()) || NaturezaSolicitacaoAlvaraEnum.ALTERACAO_SOCIOS.getValue().equalsIgnoreCase(natureza.getCodigo()) || NaturezaSolicitacaoAlvaraEnum.MUDANCA_RAZAO_SOCIAL.getValue().equalsIgnoreCase(natureza.getCodigo())) {
                toReturn = Boolean.TRUE;
                continue;
            }
            return Boolean.FALSE;
        }
        return toReturn;
    }

    public DadosSolicitacao solicitacaoAlvara(SolicitacaoAlvaraRedeSimDTO solicitacaoRedeSimDTO, SolicitacaoRedeSimEntity solicitacaoNaoProcessada) throws BaseException {
        String observacao = "";
        SolicitacaoRedeSimEntity solicitacaoRedeSim = this.findConsultaPreviaByProtocolo(solicitacaoRedeSimDTO.getDados_solicitacao().getCo_protocolo_redesim());
        boolean existeConsultaPrevia = Objects.nonNull(solicitacaoRedeSim);
        if (existeConsultaPrevia && SituacaoConsultaPreviaRedeSimEnum.ANALISE.getSigla().equals(solicitacaoRedeSim.getSituacao())) {
            observacao = "A consulta pr\u00e9via ainda se encontra com a situa\u00e7\u00e3o em an\u00e1lise";
        }
        SolicitacaoAlvaraEntity solicitacaoAlvara = new SolicitacaoAlvaraEntity();
        this.fillDadosSolicitante(solicitacaoRedeSimDTO, solicitacaoAlvara);
        if (existeConsultaPrevia && Objects.nonNull(solicitacaoRedeSim.getSolicitacaoAlvara())) {
            solicitacaoAlvara = solicitacaoRedeSim.getSolicitacaoAlvara();
            solicitacaoAlvara.setDataSolicitacao(new Date());
            solicitacaoRedeSim = solicitacaoNaoProcessada;
            solicitacaoRedeSim.setSolicitacaoAlvara(solicitacaoAlvara);
        } else if (Objects.nonNull(solicitacaoNaoProcessada.getSolicitacaoAlvara())) {
            solicitacaoRedeSim = solicitacaoNaoProcessada;
            solicitacaoAlvara = solicitacaoRedeSim.getSolicitacaoAlvara();
        }
        if (EloStringUtils.isEmpty((String)solicitacaoAlvara.getProtocoloRedeSim())) {
            solicitacaoAlvara.setProtocoloRedeSim(solicitacaoRedeSimDTO.getDados_solicitacao().getCo_protocolo_redesim());
        }
        if (Objects.isNull(solicitacaoAlvara.getDataSolicitacao())) {
            solicitacaoAlvara.setDataSolicitacao(new Date());
        }
        if (Objects.isNull(solicitacaoAlvara.getExercicio())) {
            solicitacaoAlvara.setExercicio(EloDateUtils.getAnoAtual());
        }
        if (Objects.isNull(solicitacaoAlvara.getTipoDeInscricao())) {
            this.setTipoDeInscricao(solicitacaoRedeSimDTO, solicitacaoAlvara);
        }
        ArrayList atividades = new ArrayList();
        if (EloListUtils.safeIsEmpty((List)solicitacaoAlvara.getSolicitacaoAlvaraAtividades()).booleanValue()) {
            atividades.addAll(((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).preencherSolcitacaoAlvaraAtividades(solicitacaoAlvara, solicitacaoRedeSimDTO.getDados_solicitacao().getEmpresa().getAtividades()));
        }
        if (Objects.isNull(solicitacaoAlvara.getClassificacaoTipoInscricao())) {
            ClassificacaoTipoInscricaoEntity classificacaoTipoInscricao = new ClassificacaoTipoInscricaoEntity();
            classificacaoTipoInscricao.setIdSolicitacaoAlvara(solicitacaoAlvara);
            classificacaoTipoInscricao.setIdClassificacaoTipoInscricao(this.repositoryClassificacaoTipoInscricao.getSequence());
            classificacaoTipoInscricao.setPontoReferencia(this.getPontoReferencia(solicitacaoRedeSimDTO.getDados_solicitacao().getEmpresa().getAtividades()));
            solicitacaoAlvara.setClassificacaoTipoInscricao(classificacaoTipoInscricao);
        }
        solicitacaoAlvara.setCpfCnpj(solicitacaoRedeSimDTO.getDados_solicitacao().getEmpresa().getNu_cnpj());
        List cadastrosMobiliarios = this.srvConsultaPreviaImpl.carregarCadastrosMobiliarios(solicitacaoAlvara.getCpfCnpj());
        int quantidadeCadastrosMobiliarios = 0;
        if (!EloListUtils.safeIsEmpty((List)cadastrosMobiliarios).booleanValue()) {
            quantidadeCadastrosMobiliarios = cadastrosMobiliarios.size();
        }
        this.logger.info((Object)String.format("Foram encontrado(s) %d cadastro(s) mobili\u00e1rio(s) para o CPF/CNPJ: %s", quantidadeCadastrosMobiliarios, solicitacaoAlvara.getCpfCnpj()));
        if (quantidadeCadastrosMobiliarios == 1 || quantidadeCadastrosMobiliarios > 0 && EnquadramentoEmpresaEnum.MEI.getCodigo().equals(solicitacaoRedeSimDTO.getDados_solicitacao().getEmpresa().getCo_enquadramento())) {
            solicitacaoAlvara.setCadastroMobiliario((CadastroMobiliarioEntity)cadastrosMobiliarios.get(0));
            this.formatLogCadastroMobiliarioAlvara("Preenchimento inicial do cadastro mobili\u00e1rio", solicitacaoAlvara.getCadastroMobiliario());
        }
        if (!existeConsultaPrevia && this.isSomenteMudancaRazaoOuSocioOuNaturezaJuridica(solicitacaoRedeSimDTO.getDados_solicitacao().getEventos_redesim()) || !existeConsultaPrevia && EnquadramentoEmpresaEnum.MEI.getCodigo().equals(solicitacaoRedeSimDTO.getDados_solicitacao().getEmpresa().getCo_enquadramento())) {
            solicitacaoRedeSim = this.criarSolicitacaoAlvaraRedeSim(solicitacaoRedeSimDTO, solicitacaoAlvara, solicitacaoNaoProcessada);
            if (EnquadramentoEmpresaEnum.MEI.getCodigo().equals(solicitacaoRedeSimDTO.getDados_solicitacao().getEmpresa().getCo_enquadramento()) && solicitacaoAlvara.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.INICIAL, NaturezaSolicitacaoAlvaraEnum.ALTERACAO_ATIVIDADE}) && Objects.nonNull((solicitacaoAlvara = this.adicionarAtividadesSolicitacaoMei(solicitacaoRedeSimDTO, solicitacaoAlvara)).getCadastroImobiliario())) {
                this.formatLogCadastroMobiliarioAlvara("Preenchimento das atividades MEI", solicitacaoAlvara.getCadastroMobiliario());
            }
        }
        if (!existeConsultaPrevia || TipoSolicitacaoRedeSimEnum.CONSULTA.getSigla().equals(solicitacaoRedeSim.getTipo())) {
            solicitacaoRedeSim = solicitacaoNaoProcessada;
        }
        if (this.inscricaoImobiliariaPreenchida(solicitacaoRedeSimDTO)) {
            this.verificarCadastroImobiliario(solicitacaoRedeSimDTO, solicitacaoAlvara);
        }
        if (solicitacaoAlvara.getCadastroImobiliario() == null && solicitacaoAlvara.getCadastroMobiliario() != null && !solicitacaoAlvara.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.INICIAL, NaturezaSolicitacaoAlvaraEnum.MUDANCA_ENDERECO}) && solicitacaoAlvara.getCadastroMobiliario() != null) {
            solicitacaoAlvara.setCadastroImobiliario(solicitacaoAlvara.getCadastroMobiliario().getCadastroImobiliario());
        }
        solicitacaoRedeSim.setEventos(this.getEventos(solicitacaoRedeSimDTO.getDados_solicitacao().getEventos_redesim()));
        solicitacaoRedeSim.setDataSolicitacao(new Date());
        solicitacaoRedeSim.setResposta(SimNaoEnum.NAO.getShortText());
        solicitacaoRedeSim.setIndeferido(SimNaoEnum.NAO.getShortText());
        solicitacaoRedeSim.setInvalidado(SimNaoEnum.getNaoShortText());
        solicitacaoRedeSim.setCnpjEmpresa((String)Optional.ofNullable(solicitacaoRedeSimDTO.getDados_solicitacao()).map(DadosSolicitacao::getEmpresa).map(Empresa::getNu_cnpj).orElse(null));
        solicitacaoAlvara.setFinalizado(SimNaoEnum.getSimShortText());
        solicitacaoAlvara.setDescricaoAtividades(solicitacaoRedeSimDTO.getDados_solicitacao().getEmpresa().getDs_objeto_social());
        solicitacaoAlvara.setNomeRazaoSocial(solicitacaoRedeSimDTO.getDados_solicitacao().getEmpresa().getDs_nome_empresarial());
        solicitacaoAlvara.setFantasia(solicitacaoRedeSimDTO.getDados_solicitacao().getEmpresa().getDs_nome_fantasia());
        if (Objects.isNull(solicitacaoAlvara.getGrauRisco()) && !EloListUtils.safeIsEmpty(atividades).booleanValue() && atividades.stream().allMatch(Objects::nonNull)) {
            solicitacaoAlvara.atribuirGrauRisco(atividades);
        }
        solicitacaoAlvara = this.salvarSolicitacaoAlvara(solicitacaoAlvara);
        SolicitacaoRedeSimEntity finalSolicitacaoRedeSim = solicitacaoRedeSim;
        Optional.ofNullable(solicitacaoRedeSimDTO.getDados_solicitacao().getEmpresa().getEndereco()).ifPresent(enderecoEmpresa -> {
            finalSolicitacaoRedeSim.setTipoLogradouro(enderecoEmpresa.getDs_tipo_logradouro());
            finalSolicitacaoRedeSim.setEndereco(enderecoEmpresa.getDs_endereco());
            finalSolicitacaoRedeSim.setNumero(enderecoEmpresa.getNu_numero());
            finalSolicitacaoRedeSim.setComplemento(enderecoEmpresa.getDs_complemento());
            finalSolicitacaoRedeSim.setBairro(enderecoEmpresa.getDs_bairro());
            Optional.ofNullable(enderecoEmpresa.getCo_cep()).ifPresent(cep -> finalSolicitacaoRedeSim.setCep(Long.valueOf(cep)));
        });
        if (finalSolicitacaoRedeSim.getSolicitacoesAlvara().isEmpty()) {
            finalSolicitacaoRedeSim.getSolicitacoesAlvara().add(solicitacaoAlvara);
        }
        if ((solicitacaoRedeSim = this.repositoryConsultaRedeSim.saveOrUpdate(finalSolicitacaoRedeSim)).isSolicitacaoBaixa() && Objects.isNull(solicitacaoRedeSim.getSolicitacaoAlvara().getCadastroMobiliario())) {
            if (EloListUtils.safeIsEmpty((List)solicitacaoRedeSim.getSolicitacaoAlvara().getSolicitacaoAlvaraAtividades()).booleanValue()) {
                solicitacaoRedeSim.getSolicitacaoAlvara().setSolicitacaoAlvaraAtividades(new ArrayList());
            }
            solicitacaoRedeSim.getSolicitacaoAlvara().setCadastroMobiliario(this.criarCadastroMobiliario(solicitacaoRedeSim, Optional.empty()));
        }
        solicitacaoRedeSim = this.repositoryConsultaRedeSim.saveOrUpdate(solicitacaoRedeSim);
        String valorParametroInscricaoAtualizada = UtilsController.getValorParametroAlvara((ParametroAlvaraEnum)ParametroAlvaraEnum.ENVIA_INSCRICAO_MUNICIPAL_COM_DADOS_ATUALIZADOS);
        if (!solicitacaoNaoProcessada.isSolicitacaoBaixa() && SimNaoEnum.equalSim((String)valorParametroInscricaoAtualizada).booleanValue() && !EnquadramentoEmpresaEnum.MEI.getCodigo().equals(solicitacaoRedeSimDTO.getDados_solicitacao().getEmpresa().getCo_enquadramento()) || SimNaoEnum.equalNao((String)valorParametroInscricaoAtualizada).booleanValue()) {
            this.adicionarHistoricoComDocumentos(solicitacaoRedeSim, Optional.of(observacao), solicitacaoRedeSimDTO.getDados_solicitacao().getArquivos_entidade_registro());
        }
        this.repositoryConsultaRedeSim.flush();
        solicitacaoRedeSimDTO.getDados_solicitacao().setId(solicitacaoRedeSim.getId().intValue());
        return solicitacaoRedeSimDTO.getDados_solicitacao();
    }

    private void formatLogCadastroMobiliarioAlvara(String prefixo, CadastroMobiliarioEntity cadastroMobiliario) {
        this.logger.info((Object)String.format("%s. Solicita\u00e7\u00e3o do alvar\u00e1 com cadastro mobili\u00e1rio: %d", prefixo, Optional.ofNullable(cadastroMobiliario.getCadastroGeral()).map(CadastroGeralAiseEntity::getId).map(CadastroGeralAisePK::getCodigo).orElse(null)));
    }

    private boolean inscricaoImobiliariaPreenchida(SolicitacaoAlvaraRedeSimDTO solicitacaoRedeSimDTO) {
        return solicitacaoRedeSimDTO.getDados_solicitacao().getEmpresa().getEndereco().getNatureza_imovel() != null && solicitacaoRedeSimDTO.getDados_solicitacao().getEmpresa().getEndereco().getNatureza_imovel().getNu_inscricao() != null;
    }

    public SolicitacaoRedeSimEntity buscarConsultaPreviaDeferidaByProtocolo(String protocolo) {
        return this.repositoryConsultaRedeSim.getConsultaByProtocolo(protocolo, SituacaoConsultaPreviaRedeSimEnum.DEFERIDO.getSigla());
    }

    public SolicitacaoRedeSimEntity findConsultaPreviaByProtocolo(String protocolo) {
        return this.repositoryConsultaRedeSim.getConsultaByProtocoloWithoutSituacao(protocolo);
    }

    private void setTipoDeInscricao(SolicitacaoAlvaraRedeSimDTO solicitacaoRedeSimDTO, SolicitacaoAlvaraEntity solicitacaoAlvara) throws BaseException {
        int enquadramento = solicitacaoRedeSimDTO.getDados_solicitacao().getEmpresa().getCo_enquadramento();
        List atividades = solicitacaoRedeSimDTO.getDados_solicitacao().getEmpresa().getAtividades();
        List tiposUnidade = solicitacaoRedeSimDTO.getDados_solicitacao().getEmpresa().getTipo_unidade();
        List formasAtuacao = solicitacaoRedeSimDTO.getDados_solicitacao().getEmpresa().getFormas_atuacao();
        TipoInscricaoAlvaraEntity tipoInscricaoAlvara = this.srvFindTipoInscricaoAlvara.findTipoInscricaoAlvara(enquadramento, atividades, tiposUnidade, formasAtuacao);
        solicitacaoAlvara.setTipoDeInscricao(tipoInscricaoAlvara);
    }

    private SolicitacaoRedeSimEntity criarSolicitacaoAlvaraRedeSim(SolicitacaoAlvaraRedeSimDTO solicitacaoRedeSimDTO, SolicitacaoAlvaraEntity solicitacaoAlvara, SolicitacaoRedeSimEntity solicitacaoNaoProcessada) throws BaseException {
        NaturezaJuridicaEntity naturezaJuridica;
        solicitacaoAlvara.setNaturezas(this.getNaturezaEvento(solicitacaoRedeSimDTO.getDados_solicitacao().getEventos_redesim()));
        solicitacaoAlvara.setProtocoloRedeSim(solicitacaoRedeSimDTO.getDados_solicitacao().getCo_protocolo_redesim());
        solicitacaoAlvara.setEfetivado(SimNaoEnum.NAO.getShortText());
        solicitacaoAlvara.setDataConsultaPrevia(new Date());
        solicitacaoAlvara.setRenovacao(SimNaoEnum.NAO.getShortText());
        solicitacaoAlvara.setExercicio(this.getExercicio());
        solicitacaoAlvara.setNumeroSolicitacao(this.repositorySolicitacaoAlvara.getNumeroSolicitacao(Long.valueOf(1L), solicitacaoAlvara.getExercicio()));
        this.fillDadosSolicitante(solicitacaoRedeSimDTO, solicitacaoAlvara);
        solicitacaoAlvara.setCpfCnpj(solicitacaoRedeSimDTO.getDados_solicitacao().getEmpresa().getNu_cnpj());
        solicitacaoAlvara.setNomeRazaoSocial(solicitacaoRedeSimDTO.getDados_solicitacao().getEmpresa().getDs_nome_empresarial());
        solicitacaoAlvara.setFantasia(solicitacaoRedeSimDTO.getDados_solicitacao().getEmpresa().getDs_nome_fantasia());
        if (Objects.isNull(solicitacaoAlvara.getTipoDeInscricao())) {
            this.setTipoDeInscricao(solicitacaoRedeSimDTO, solicitacaoAlvara);
        }
        if (Objects.nonNull(naturezaJuridica = (NaturezaJuridicaEntity)Optional.ofNullable(solicitacaoRedeSimDTO.getDados_solicitacao().getEmpresa()).map(Empresa::getCo_natureza_juridica).map(arg_0 -> this.getNaturezaJuridica(arg_0)).orElse(null))) {
            if (solicitacaoAlvara.isSolicitacaoMEI()) {
                solicitacaoAlvara.setPessoaMobiliario(naturezaJuridica.getIdPessoaMobiliarioMEI());
            } else {
                solicitacaoAlvara.setPessoaMobiliario(naturezaJuridica.getIdPessoaMobiliario());
            }
            if (Objects.nonNull(solicitacaoAlvara.getCadastroMobiliario())) {
                solicitacaoAlvara.getCadastroMobiliario().setNaturezaJuridica(naturezaJuridica);
                solicitacaoAlvara.getCadastroMobiliario().setPessoaMobiliario(solicitacaoAlvara.getPessoaMobiliario());
            }
        }
        solicitacaoAlvara.setSolicitacaoAlvara(this.repositorySolicitacaoAlvara.getSequence());
        solicitacaoAlvara = this.repositorySolicitacaoAlvara.saveOrUpdate(solicitacaoAlvara);
        solicitacaoNaoProcessada.setSolicitacaoAlvara(solicitacaoAlvara);
        return solicitacaoNaoProcessada;
    }

    private void verificarCadastroMobiliarioPrestador(SolicitacaoAlvaraEntity solicitacaoAlvara) {
        if (solicitacaoAlvara.isSolicitacaoMEI()) {
            if (this.isMobiliarioPrestadorServicoMEI(solicitacaoAlvara.getCadastroMobiliario())) {
                solicitacaoAlvara.setTipoDeInscricao(this.repositoryTipoInscricao.getTipoInscricaoBySigla("MP"));
            }
        } else if (this.isMobiliarioPrestadorServico(solicitacaoAlvara.getCadastroMobiliario())) {
            solicitacaoAlvara.setTipoDeInscricao(this.repositoryTipoInscricao.getTipoInscricaoBySigla("P"));
        }
    }

    private List<EventoRedeSimEntity> getEventos(List<Evento> eventos_redesim) throws SolicitacaoRedeSimException {
        try {
            ArrayList eventosRedeSim = Lists.newArrayList();
            for (Evento evento : eventos_redesim) {
                EventoRedeSimEntity eventoEntity = this.repositoryEventoRedeSim.load(new Long(evento.getCo_evento()));
                if (!Objects.nonNull(eventoEntity)) continue;
                eventosRedeSim.add(eventoEntity);
            }
            return eventosRedeSim;
        }
        catch (Exception e) {
            throw new SolicitacaoRedeSimException("Ocorreu uma falha ao carregar os Eventos. Verifique a liga\u00e7\u00e3o de eventos por natureza de solicita\u00e7\u00e3o.", e.getCause());
        }
    }

    public CadastroMobiliarioEntity createCadastroMobiliarioSemLaudo(SolicitacaoRedeSimEntity solicitacaoRedesim, Optional<CategoriaMobiliarioEntity> categoria) throws BaseException {
        return this.createCadastroMobiliario(solicitacaoRedesim, Optional.empty(), false);
    }

    public CadastroMobiliarioEntity criarCadastroMobiliario(SolicitacaoRedeSimEntity solicitacaoRedesim, Optional<CategoriaMobiliarioEntity> categoria) throws BaseException {
        return this.createCadastroMobiliario(solicitacaoRedesim, categoria, this.isAptoGerarLaudos(solicitacaoRedesim));
    }

    private boolean isAptoGerarLaudos(SolicitacaoRedeSimEntity solicitacaoRedesim) throws BaseException {
        return !solicitacaoRedesim.isSolicitacaoBaixa() && (SimNaoEnum.equalSim((String)UtilsController.getValorParametroAlvara((ParametroAlvaraEnum)ParametroAlvaraEnum.HABILITA_GERACAO_LAUDO_LIBERDADE_ECONOMICA)) != false || SimNaoEnum.equalNao((String)UtilsController.getValorParametroAlvara((ParametroAlvaraEnum)ParametroAlvaraEnum.HABILITA_GERACAO_LAUDO_LIBERDADE_ECONOMICA)) != false && !solicitacaoRedesim.getSolicitacaoAlvara().isGrauRiscoLiberdadeEconomica());
    }

    private CadastroMobiliarioEntity createCadastroMobiliario(SolicitacaoRedeSimEntity solicitacaoRedesim, Optional<CategoriaMobiliarioEntity> categoria, boolean geraLaudos) throws BaseException {
        boolean cadastroEmExclusaoLogica;
        SolicitacaoAlvaraEntity solicitacaoAlvara = solicitacaoRedesim.getSolicitacaoAlvara();
        if (!(this.integradoGeo() || UtilsController.isIntegracaoSimplificadaRedeSim() || solicitacaoAlvara.isMeiInicial())) {
            this.validarAtividadesSolicitacaoAlvara(solicitacaoAlvara);
        }
        SolicitacaoAlvaraRedeSimDTO solicitacaoDTO = PortalUtils.normalizeJson((String)solicitacaoRedesim.getArquivoDadosEmpresa());
        solicitacaoAlvara.setNomeRazaoSocial(solicitacaoDTO.getDados_solicitacao().getEmpresa().getDs_nome_empresarial());
        solicitacaoAlvara.setFantasia(solicitacaoDTO.getDados_solicitacao().getEmpresa().getDs_nome_fantasia());
        this.fillDadosSolicitante(solicitacaoDTO, solicitacaoAlvara);
        if (solicitacaoAlvara.isSolicitacaoMEINormal()) {
            solicitacaoAlvara.setDescricaoAtividades(PortalUtils.getDescricaoAtividadesMei((SolicitacaoAlvaraEntity)solicitacaoAlvara));
        } else {
            solicitacaoAlvara.setDescricaoAtividades(solicitacaoDTO.getDados_solicitacao().getEmpresa().getDs_objeto_social());
        }
        solicitacaoAlvara.setRenovacao(SimNaoEnum.NAO.getShortText());
        solicitacaoAlvara.setEfetivado(SimNaoEnum.SIM.getShortText());
        if (SimNaoEnum.equalSim((String)this.getParametroAlvara(ParametroAlvaraEnum.HABILITA_PROCESSO_AUTOMATICO_SOLICITACAO_REDESIM).getValor()).booleanValue() || solicitacaoAlvara.isMeiInicial()) {
            solicitacaoAlvara.setUsuario(this.repositoryUsuario.getUsuarioIntegraSGO());
        } else {
            solicitacaoAlvara.setUsuario((UsuarioEntity)this.getUsuarioLogado() == null ? this.repositoryUsuario.getUsuarioIntegraSGO() : (UsuarioEntity)this.getUsuarioLogado());
        }
        solicitacaoAlvara.setCpfCnpj(solicitacaoDTO.getDados_solicitacao().getEmpresa().getNu_cnpj());
        if (!solicitacaoRedesim.isRuralArquivoEmpresa() && !solicitacaoRedesim.isSolicitacaoBaixa()) {
            solicitacaoAlvara.setEnderecoImobiliarioPrincipal(this.buscaEnderecoPrincipal(solicitacaoAlvara));
        }
        SolicitacaoAlvaraEntity solicitacaoExistente = this.repositorySolicitacaoAlvara.load(solicitacaoAlvara.getSolicitacaoAlvara());
        Optional.ofNullable(solicitacaoExistente).map(SolicitacaoAlvaraEntity::getCadastroMobiliario).ifPresent(cadastroMobiliario -> solicitacaoRedesim.getSolicitacaoAlvara().setCadastroMobiliario(cadastroMobiliario));
        CadastroMobiliarioEntity cadastro = solicitacaoRedesim.getSolicitacaoAlvara().getCadastroMobiliario();
        boolean bl = cadastroEmExclusaoLogica = Objects.nonNull(cadastro) && SimNaoEnum.getSimShortText().equalsIgnoreCase(Optional.ofNullable(cadastro.getCadastroGeral()).map(CadastroGeralAiseEntity::getExclusaoLogica).orElse(""));
        if (Objects.isNull(cadastro) || cadastroEmExclusaoLogica) {
            if (cadastroEmExclusaoLogica) {
                this.logger.info((Object)String.format("Cadastro %d - em exclus\u00e3o l\u00f3gica", cadastro.getCadastroGeral().getId().getCodigo()));
            }
            this.logger.info((Object)String.format("Sol %d/%s - criando cadastro mobili\u00e1rio", solicitacaoRedesim.getId(), solicitacaoRedesim.getProtocolo()));
            cadastro = new CadastroMobiliarioEntity();
            CadastroGeralAiseEntity cadastroGeral = new CadastroGeralAiseEntity();
            cadastroGeral.setUsuario(PortalUtils.getUsuarioalvaraonline());
            CadastroGeralAisePK id = new CadastroGeralAisePK();
            id.setTipo(Long.valueOf(2L));
            cadastroGeral.setId(id);
            SolicitacaoAlvaraEntity finalSolicitacaoAlvara = solicitacaoAlvara;
            PessoaEntity pessoa = Optional.ofNullable(this.repositoryPessoa.carregaPessoaMaisAntigaPorCpfCnpj(solicitacaoAlvara.getCpfCnpj())).orElseGet(() -> {
                PessoaEntity p = new PessoaEntity();
                p.setCnpjCpf(finalSolicitacaoAlvara.getCpfCnpj());
                p.setNome(finalSolicitacaoAlvara.getNomeRazaoSocial());
                p.setNomeFantasia(finalSolicitacaoAlvara.getFantasia());
                p.setUsuarioInclusao(this.usuarioLogado());
                p.setDataInclusao(new Date());
                p.setObservacao(String.format("Alvar\u00e1 Online - Integra\u00e7\u00e3o com a RedeSim - Protocolo: %s", solicitacaoRedesim.getProtocolo()));
                try {
                    return this.srvPessoa.salvar(p);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
            cadastroGeral.setPessoa(pessoa);
            cadastro.setId(id);
            cadastro.setCadastroGeral(cadastroGeral);
            solicitacaoAlvara.setCadastroMobiliario(cadastro);
        } else {
            this.logger.info((Object)String.format("Sol %d/%s - atualizando cadastro mobili\u00e1rio", solicitacaoRedesim.getId(), solicitacaoRedesim.getProtocolo()));
            cadastro = solicitacaoRedesim.getSolicitacaoAlvara().getCadastroMobiliario();
            cadastro.getMobiliarioCnaes().clear();
            cadastro.getMobiliarioAtividadeMeis().clear();
        }
        NaturezaJuridicaEntity naturezaJuridica = this.getNaturezaJuridica(solicitacaoDTO.getDados_solicitacao().getEmpresa().getCo_natureza_juridica());
        if (Objects.nonNull(naturezaJuridica)) {
            if (solicitacaoAlvara.isSolicitacaoMEI()) {
                solicitacaoAlvara.setPessoaMobiliario(naturezaJuridica.getIdPessoaMobiliarioMEI());
            } else {
                solicitacaoAlvara.setPessoaMobiliario(naturezaJuridica.getIdPessoaMobiliario());
            }
            cadastro.setNaturezaJuridica(naturezaJuridica);
            cadastro.setPessoaMobiliario(solicitacaoAlvara.getPessoaMobiliario());
        }
        this.addComplemento(solicitacaoAlvara, solicitacaoDTO.getDados_solicitacao().getEmpresa().getEndereco().getDs_complemento());
        if (Objects.nonNull(solicitacaoExistente.getContratoSocial()) && Objects.nonNull(solicitacaoAlvara.getContratoSocial())) {
            solicitacaoAlvara.getContratoSocial().setId(solicitacaoExistente.getContratoSocial().getId());
        }
        solicitacaoAlvara = this.srvContratoSocial.preencherContratoSocialBySolicitacao(solicitacaoAlvara);
        solicitacaoAlvara.setVerificaRestricaoCadastroExistente(Boolean.valueOf(false));
        this.carregaDadosAlvaraInicial(solicitacaoAlvara);
        EnderecoPessoaEntity enderecoPessoa = null;
        if (solicitacaoAlvara.getCadastroImobiliario() != null) {
            enderecoPessoa = this.carregaDadosNoEndPessoa(solicitacaoAlvara);
        }
        solicitacaoAlvara.getCadastroMobiliario().getCadastroGeral().getPessoa().setEnderecos(new ArrayList());
        this.logger.info((Object)"adicionaSolicitacaoContratoSocial------- criarCadastroMobiliario -- RedeSim");
        this.adicionaSolicitacaoContratoSocial(solicitacaoAlvara);
        this.atribuirSocioPessoa(solicitacaoAlvara);
        try {
            this.validarPessoaAPIExterna(solicitacaoAlvara);
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new SolicitacaoAlvaraException("Falha ao consultar a integra\u00e7\u00e3o de pessoas do ISS-e", (Throwable)e);
        }
        cadastro = solicitacaoAlvara.getCadastroMobiliario();
        solicitacaoAlvara.setCadastroMobiliario(null);
        solicitacaoAlvara = this.repositorySolicitacaoAlvara.saveOrUpdate(solicitacaoAlvara);
        PessoaEntity pessoa = this.salvarPessoa(cadastro.getCadastroGeral().getPessoa());
        cadastro.getCadastroGeral().setPessoa(pessoa);
        cadastro.getCadastroGeral().setDataAlteracao(new Date());
        cadastro.getCadastroGeral().setDataInclusao(new Date());
        cadastro.setCadastroGeral(this.salvarCadastroGeral(cadastro.getCadastroGeral(), solicitacaoAlvara));
        solicitacaoAlvara.setCadastroMobiliario(this.salvarCadastroMobiliario(cadastro));
        solicitacaoAlvara = this.repositorySolicitacaoAlvara.saveOrUpdate(solicitacaoAlvara);
        if (solicitacaoAlvara.getCadastroImobiliario() != null && enderecoPessoa != null) {
            enderecoPessoa = this.salvarEnderecoPessoa(enderecoPessoa, solicitacaoAlvara.getCadastroMobiliario().getCadastroGeral().getPessoa());
        }
        this.addEnderecoPrincipalPessoa(enderecoPessoa, pessoa);
        this.criarContatoPessoa(solicitacaoAlvara, solicitacaoAlvara.getCadastroMobiliario().getCadastroGeral());
        if (solicitacaoAlvara.isGrauRiscoBaixo() && !solicitacaoAlvara.isMeiInicial()) {
            this.adicionaValidadeAlvaraProvisorio(solicitacaoAlvara);
        }
        this.verificarSeGeraCadastroEmExclusaoLogica(solicitacaoAlvara);
        solicitacaoAlvara.getCadastroMobiliario().setCadastroGeral(this.salvarCadastroGeral(solicitacaoAlvara.getCadastroMobiliario().getCadastroGeral(), solicitacaoAlvara));
        pessoa = this.srvPessoa.findById(pessoa.getId());
        if (Objects.nonNull(pessoa)) {
            this.repositoryPessoa.flush();
            pessoa = this.repositoryPessoa.refresh(pessoa);
        }
        solicitacaoAlvara.getCadastroMobiliario().getCadastroGeral().setPessoa(pessoa);
        cadastro = this.salvarCadastroMobiliario(solicitacaoAlvara.getCadastroMobiliario());
        Hibernate.initialize((Object)cadastro.getContratosSociais());
        cadastro.getContratosSociais().add(this.atualizaContratoSocialCadastroMobiliario(solicitacaoAlvara, true));
        solicitacaoAlvara.setCadastroMobiliario(cadastro);
        this.vincularMobiliarioCnae(solicitacaoAlvara);
        this.getUtilizaMobiliarioAtividade(solicitacaoAlvara);
        this.carregaMobiliarioAtividades(solicitacaoAlvara);
        if (solicitacaoRedesim.isRuralArquivoEmpresa()) {
            this.setEnderecoRural(cadastro.getCadastroGeral(), solicitacaoAlvara);
        }
        solicitacaoAlvara.setCadastroMobiliario(this.salvarCadastroMobiliario(solicitacaoAlvara.getCadastroMobiliario()));
        this.salvarCadastroGeralIsencao(solicitacaoAlvara.getCadastroMobiliario(), solicitacaoAlvara);
        if (solicitacaoAlvara.getCadastroImobiliario() != null) {
            this.salvarCadastroImobiliario(solicitacaoAlvara.getCadastroImobiliario());
        }
        this.atribuirIdAtividadesSolicitacao(solicitacaoAlvara);
        if (solicitacaoAlvara.isMeiInicial() && solicitacaoRedesim.getEventos().contains(this.repositoryEventoRedeSim.load(Long.valueOf(101L)))) {
            ParametroAlvaraEntity paramRegimeFiscalMei = this.srvSolicitacaoAlvara.getParametroAlvara(ParametroAlvaraEnum.REGIME_FISCAL_PADRAO);
            if (Objects.nonNull(paramRegimeFiscalMei) && !EloStringUtils.isEmpty((String)paramRegimeFiscalMei.getValor())) {
                RegimeFiscalEntity regimeFiscalEntity = this.repositoryRegimeFiscal.load(Long.valueOf(paramRegimeFiscalMei.getValor()));
                List regimesFiscaisPeriodosByUnico = this.repositoryRegimeFiscalPeriodoRealAise.findByIdUnico(solicitacaoAlvara.getCadastroMobiliario().getCadastroGeral().getIdUnico());
                RegimeFiscalPeriodoRealAiseEntity regimeFiscalPeriodo = new RegimeFiscalPeriodoRealAiseEntity();
                if (!EloListUtils.safeIsEmpty((List)regimesFiscaisPeriodosByUnico).booleanValue()) {
                    regimeFiscalPeriodo = (RegimeFiscalPeriodoRealAiseEntity)regimesFiscaisPeriodosByUnico.get(0);
                }
                regimeFiscalPeriodo.setDataInicio(EloDateUtils.fromAnsiDateString((String)solicitacaoDTO.getDados_solicitacao().getEmpresa().getDt_constituicao(), (String)"yyyy-MM-dd"));
                regimeFiscalPeriodo.setIdRegimeFiscal(regimeFiscalEntity.getId());
                regimeFiscalPeriodo.setIdCadastro(solicitacaoAlvara.getCadastroMobiliario().getCadastroGeral().getIdUnico());
                this.repositoryRegimeFiscalPeriodoRealAise.saveOrUpdate(regimeFiscalPeriodo);
                this.repositoryRegimeFiscalPeriodoRealAise.flush();
            }
            this.atualizarSituacaoMobiliarioMEI(solicitacaoAlvara);
        } else if (SimNaoEnum.equalSim((String)this.getParametroAlvara(ParametroAlvaraEnum.ENVIA_INSCRICAO_MUNICIPAL_COM_DADOS_ATUALIZADOS).getValor()).booleanValue()) {
            this.saveMobiliarioSituacaoWithEnvioInscricaoMunicipal(solicitacaoAlvara, true);
        } else {
            this.salvarMobiliarioSituacao(solicitacaoAlvara, true);
        }
        this.salvarMobiliarioServico(solicitacaoAlvara);
        this.salvarObservacao(solicitacaoAlvara);
        if (solicitacaoAlvara.isSolicitacaoMEINormal()) {
            this.salvarCategoriaMobiliario(solicitacaoAlvara, ParametroAlvaraEnum.CATEGORIA_MOBILIARIO_MEI);
            this.salvarClassificacaoMobiliario(solicitacaoAlvara, ParametroAlvaraEnum.COD_CLASSIFICACAO_MOBILIARIA_MEI);
            this.salvarNaturezaJuridicaMeiMobiliario(solicitacaoAlvara, ParametroAlvaraEnum.COD_NATUREZA_JURIDICA_MEI);
        } else if (categoria.isPresent()) {
            solicitacaoAlvara.getCadastroMobiliario().setCategoriaMobiliario(categoria.get());
            this.repositoryCadastroMobiliario.saveOrUpdate(solicitacaoAlvara.getCadastroMobiliario());
        }
        List boletinsGerados = this.srvGeraBoletimMobiliarioAlvara.geraBoletimMobiliario(solicitacaoAlvara);
        this.srvGeraBoletimMobiliarioAlvara.salvarBoletinsMobiliario(boletinsGerados);
        solicitacaoAlvara.setFinalizado(SimNaoEnum.SIM.getShortText());
        if (geraLaudos && (this.isMeisECriaLaudosAoRececerDadosEmpresaEnviaInscricaoComDadosAtualizados(solicitacaoAlvara) || !solicitacaoAlvara.isSolicitacaoMEINormal() || SimNaoEnum.equalNao((String)this.getParametroAlvara(ParametroAlvaraEnum.HABILITA_PROCESSO_AUTOMATICO_SOLICITACAO_MEI).getValor()).booleanValue())) {
            this.geraLaudos(solicitacaoAlvara);
        }
        solicitacaoAlvara = this.repositorySolicitacaoAlvara.saveOrUpdate(solicitacaoAlvara);
        this.repositorySolicitacaoAlvara.flush();
        solicitacaoRedesim.setSolicitacaoAlvara(solicitacaoAlvara);
        this.repositoryConsultaRedeSim.saveOrUpdate(solicitacaoRedesim);
        this.logger.info((Object)String.format("Sol %d/%s - finalizando gera\u00e7\u00e3o de empresa ", solicitacaoRedesim.getId(), solicitacaoRedesim.getProtocolo()));
        return solicitacaoAlvara.getCadastroMobiliario();
    }

    private void addEnderecoPrincipalPessoa(EnderecoPessoaEntity enderecoPessoa, PessoaEntity pessoa) {
        if (Objects.isNull(pessoa.getEnderecoPessoaPrincipal())) {
            pessoa.setEnderecoPessoaPrincipal(enderecoPessoa);
        }
    }

    private void validarAtividadesSolicitacaoAlvara(SolicitacaoAlvaraEntity solicitacaoAlvara) throws AtividadeNaoConfiguradaException {
        if (solicitacaoAlvara != null && !EloListUtils.safeIsEmpty((List)solicitacaoAlvara.getSolicitacaoAlvaraAtividades()).booleanValue()) {
            for (SolicitacaoAlvaraAtividadeEntity atividade : solicitacaoAlvara.getSolicitacaoAlvaraAtividades()) {
                atividade.getConfiguracaoAtividade();
            }
        }
    }

    public NaturezaJuridicaEntity getNaturezaJuridica(String codigoNatureza) {
        NaturezaJuridicaEntity naturezaJuridica = this.repositoryNaturezaJuridica.findById(Long.valueOf(codigoNatureza.replace("-", "")));
        if (Objects.isNull(naturezaJuridica)) {
            throw new RuntimeException(new SolicitacaoAlvaraException("N\u00e3o existe cadastro de Natureza Jur\u00eddica com o c\u00f3digo " + codigoNatureza));
        }
        return naturezaJuridica;
    }

    private EnderecoCadastroGeralEntity buscaEnderecoPrincipal(SolicitacaoAlvaraEntity solicitacao) {
        if (Objects.isNull(solicitacao.getCadastroImobiliario())) {
            return null;
        }
        return this.repositoryEnderecoCadastroGeral.buscaEnderecoImobiliarioPrincipal(solicitacao.getCadastroImobiliario().getId().getCodigo());
    }

    public SolicitacaoAlvaraEntity montarObsAlvara(SolicitacaoRedeSimEntity solicitacaoRedeSim) throws SolicitacaoRedeSimException {
        try {
            solicitacaoRedeSim = this.repositoryConsultaRedeSim.saveOrUpdate(solicitacaoRedeSim);
            this.verificaSituacaoVencidoOuDesatualizado(solicitacaoRedeSim.getSolicitacaoAlvara());
            solicitacaoRedeSim.getSolicitacaoAlvara().setObservacoes(this.montaObservacoesAlvara(solicitacaoRedeSim.getSolicitacaoAlvara()));
            solicitacaoRedeSim.setSolicitacaoAlvara(this.atualizarSolicitacaoAlvara(solicitacaoRedeSim.getSolicitacaoAlvara()));
            solicitacaoRedeSim.getSolicitacaoAlvara().getCadastroMobiliario().setObservacaoAlvara(solicitacaoRedeSim.getSolicitacaoAlvara().getObservacoes().replaceAll("\r", " - ").replaceAll("\t", " - ").replaceAll("\n", " - ").replace(" - - - ", " - "));
            if (SimNaoEnum.equalSim((String)solicitacaoRedeSim.getSolicitacaoAlvara().getCadastroMobiliario().getCadastroGeral().getExclusaoLogica()).booleanValue()) {
                solicitacaoRedeSim.getSolicitacaoAlvara().getCadastroMobiliario().getCadastroGeral().setExclusaoLogica(SimNaoEnum.getNaoShortText());
                this.repositoryCadastroGeral.saveOrUpdate(solicitacaoRedeSim.getSolicitacaoAlvara().getCadastroMobiliario().getCadastroGeral());
            }
            return solicitacaoRedeSim.getSolicitacaoAlvara();
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new SolicitacaoRedeSimException("Ocorreu uma falha ao montar as observa\u00e7\u00f5es do Alvar\u00e1 ", e.getCause());
        }
    }

    public void gerarAlvara(SolicitacaoAlvaraEntity solicitacaoAlvara) throws SolicitacaoRedeSimException {
        try {
            List listaValidadeAlvaraNova = this.carregaListaVencimentoAlvara(solicitacaoAlvara);
            if (!EloListUtils.safeIsEmpty((List)listaValidadeAlvaraNova).booleanValue()) {
                listaValidadeAlvaraNova = this.ordenarDataValidadeSolicitacao(listaValidadeAlvaraNova);
                solicitacaoAlvara.getCadastroMobiliario().setDataValidadeAlvara(((SolicitacaoAlvaraValidadeEntity)listaValidadeAlvaraNova.stream().findFirst().get()).getDataValidade());
            } else {
                solicitacaoAlvara.getCadastroMobiliario().setDataValidadeAlvara(null);
            }
            List listaValidadeAlvaraAtual = this.repositorySolicitacaoValidade.retornaValidadeBySolicitacao(solicitacaoAlvara);
            this.gerarEImprimirDocumento(listaValidadeAlvaraAtual, listaValidadeAlvaraNova, solicitacaoAlvara);
            this.verificaSituacaoEmAnalise(solicitacaoAlvara);
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new SolicitacaoRedeSimException("Ocorreu uma falha ao gerar Documento do Alvar\u00e1 pelo servi\u00e7o geraDocumentoGenerico - " + e.getMessage(), (Throwable)e);
        }
    }

    public void enviarTaxas(SolicitacaoRedeSimEntity solicitacaoRedeSim, SituacaoRespostaRedeSimEnum situacao, ImprimirTaxasAlvara taxasAlvara) throws SolicitacaoRedeSimException {
        try {
            if (Objects.nonNull(taxasAlvara)) {
                if (Objects.nonNull(taxasAlvara.getCarne())) {
                    this.srvRespostaDocumentosRedeSim.enviarTaxas(solicitacaoRedeSim, situacao, taxasAlvara, Boolean.TRUE.booleanValue());
                }
                if (Objects.nonNull(taxasAlvara.getBloqueto())) {
                    this.srvRespostaDocumentosRedeSim.enviarTaxas(solicitacaoRedeSim, situacao, taxasAlvara, Boolean.FALSE.booleanValue());
                }
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new SolicitacaoRedeSimException("Ocorreu uma falha a(s) taxa(s) para o servi\u00e7o da Rede Sim - " + e.getMessage(), (Throwable)e);
        }
    }

    public void enviarDocumento(SolicitacaoRedeSimEntity solicitacaoRedeSim, SituacaoRespostaRedeSimEnum situacao, boolean enviaDam, List<DebitoEntity> listaDebitosSelecionadosParaEnvio) throws SolicitacaoRedeSimException {
        try {
            this.srvRespostaDocumentosRedeSim.enviaRespostaDocumentos(solicitacaoRedeSim, situacao, enviaDam, listaDebitosSelecionadosParaEnvio);
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new SolicitacaoRedeSimException(String.format("Ocorreu uma falha ao enviar o documento para o servi\u00e7o da Rede Sim: %s ", e.getMessage()), (Throwable)e);
        }
    }

    public void enviarDocumento(SolicitacaoRedeSimEntity solicitacaoRedeSim, List<HistoricoExigenciaRedeSimEntity> historico, boolean enviaDam, List<DebitoEntity> listaDebitosSelecionadosParaEnvio) throws SolicitacaoRedeSimException {
        try {
            this.srvRespostaDocumentosRedeSim.enviaRespostaDocumentos(solicitacaoRedeSim, SituacaoRespostaRedeSimEnum.EM_EXIGENCIA, historico, enviaDam, listaDebitosSelecionadosParaEnvio);
        }
        catch (Exception e) {
            throw new SolicitacaoRedeSimException(String.format("Ocorreu uma falha ao enviar o documento ou exig\u00eancia para o servi\u00e7o da Rede Sim: %s ", e.getMessage()));
        }
    }

    public void enviarIndeferimentoRedeSim(SolicitacaoRedeSimEntity solicitacaoRedeSim, String observacaoIndeferimento) throws SolicitacaoRedeSimException {
        try {
            this.srvRespostaDocumentosRedeSim.enviaRespostaIndeferimentoRedeSim(solicitacaoRedeSim, observacaoIndeferimento);
        }
        catch (Exception e) {
            throw new SolicitacaoRedeSimException(String.format("Ocorreu uma falha ao enviar o documento ou indeferimento para o servi\u00e7o da Rede Sim: %s ", e.getMessage(), e));
        }
    }

    public List<ReceitaVo> carregarReceitas(GuiaRecolhimentoReceitaFiltro filtro) {
        List guiaReceitas = this.repositoryGuiaRecolhimentoReceita.carregarGuiasRecolhimentoReceita(filtro).stream().sorted(Comparator.comparing(GuiaRecolhimentoReceitaEntity::getOrdem)).collect(Collectors.toList());
        ArrayList receitasVo = Lists.newArrayList();
        for (GuiaRecolhimentoReceitaEntity guiaReceita : guiaReceitas) {
            ReceitaVo receitaVo = new ReceitaVo(guiaReceita.getId().getReceita());
            receitasVo.add(receitaVo);
        }
        return receitasVo;
    }

    public SolicitacaoAlvaraDebitoEntity gerarDebitos(DebitoWebVo debitoWebVo) throws SolicitacaoRedeSimException {
        try {
            if (!debitoWebVo.getSolicitacaoAlvara().getCadastroMobiliario().getMobiliarioSituacaoAtual().getId().equals(SituacaoMobiliarioAlvaraEnum.SITUACAO_NORMAL.getCodigo())) {
                this.srvDebitosPortal.alteraMobiliarioSituacao(debitoWebVo.getSolicitacaoAlvara(), SituacaoMobiliarioAlvaraEnum.SITUACAO_NORMAL);
                this.salvarCadastroMobiliario(debitoWebVo.getSolicitacaoAlvara().getCadastroMobiliario());
                this.repositoryCadastroMobiliario.flush();
            }
            CadastroGeralAiseEntity cadastroGeral = debitoWebVo.getSolicitacaoAlvara().getCadastroMobiliario().getCadastroGeral();
            GeraDebitoWebEnvio geraDebitoWebEnvio = new GeraDebitoWebEnvio();
            geraDebitoWebEnvio.setExercicio(Integer.valueOf((int)this.getExercicio().longValue()));
            geraDebitoWebEnvio.setTipoCadastro(Integer.valueOf((int)cadastroGeral.getId().getTipo().longValue()));
            geraDebitoWebEnvio.setCadastroGeral(Integer.valueOf((int)cadastroGeral.getId().getCodigo().longValue()));
            geraDebitoWebEnvio.setGuiaRecolhimento(Integer.valueOf(debitoWebVo.getGuia()));
            geraDebitoWebEnvio.setDataVencimento(debitoWebVo.getVencimentoPrimeiraParcela());
            geraDebitoWebEnvio.setTelaOrigemDebito("ALVARA ONLINE - REDESIM");
            geraDebitoWebEnvio.setReceitaLista(this.getReceitaDebitoWeb(debitoWebVo.getReceitas()));
            geraDebitoWebEnvio.setParcelas(Integer.valueOf(debitoWebVo.getNumeroParcelas()));
            geraDebitoWebEnvio.setObservacao(debitoWebVo.getObservacao());
            UsuarioEntity usuario = this.repositoryUsuario.getUsuarioIntegraSGO();
            GeraDebitoWeb debitoWebResposta = this.srvDebitosPortal.geraDebitoWeb(usuario.getUsuario(), usuario.getSenha(), geraDebitoWebEnvio);
            return this.createSolicitacaoAlvaraDebito(debitoWebVo.getSolicitacaoAlvara(), Long.valueOf(debitoWebResposta.getIdDebito().longValue()));
        }
        catch (Exception e) {
            throw new SolicitacaoRedeSimException(e.getMessage(), (Throwable)e);
        }
    }

    public boolean possuiDebitoNaSolicitacao(SolicitacaoAlvaraEntity solicitacaoAlvara) {
        List debitos = this.repositoryDebito.carregarDebitosAlvara(solicitacaoAlvara.getSolicitacaoAlvara());
        return EloListUtils.safeIsEmpty((List)debitos) == false;
    }

    protected GeraDebitoWebEnvio getGeraDebitoWebEnvio(DebitoWebVo debitoWebVo) {
        CadastroGeralAiseEntity cadastroGeral = debitoWebVo.getSolicitacaoAlvara().getCadastroMobiliario().getCadastroGeral();
        GeraDebitoWebEnvio geraDebitoWebEnvio = new GeraDebitoWebEnvio();
        geraDebitoWebEnvio.setExercicio(Integer.valueOf(this.getExercicio().intValue()));
        geraDebitoWebEnvio.setTipoCadastro(Integer.valueOf(cadastroGeral.getId().getTipo().intValue()));
        geraDebitoWebEnvio.setCadastroGeral(Integer.valueOf(cadastroGeral.getId().getCodigo().intValue()));
        geraDebitoWebEnvio.setGuiaRecolhimento(Integer.valueOf(debitoWebVo.getGuia()));
        geraDebitoWebEnvio.setDataVencimento(debitoWebVo.getVencimentoPrimeiraParcela());
        geraDebitoWebEnvio.setTelaOrigemDebito("ALVARA ONLINE - REDESIM");
        geraDebitoWebEnvio.setReceitaLista(this.getReceitaDebitoWeb(debitoWebVo.getReceitas()));
        geraDebitoWebEnvio.setParcelas(Integer.valueOf(debitoWebVo.getNumeroParcelas()));
        geraDebitoWebEnvio.setObservacao(debitoWebVo.getObservacao());
        return geraDebitoWebEnvio;
    }

    protected String getReceitaDebitoWeb(List<ReceitaVo> receitas) {
        StringBuilder str = new StringBuilder();
        DecimalFormat df = new DecimalFormat("#######.##", new DecimalFormatSymbols(Locale.GERMANY));
        for (ReceitaVo receita : receitas) {
            str.append(receita.getReceita().getId().getReceita());
            str.append("|");
            str.append(df.format(receita.getValor().setScale(2, 4)));
            str.append("|").append("0").append("|").append("0").append("|").append("0").append(";");
        }
        return str.toString();
    }

    public SolicitacaoRedeSimEntity salvarRespostaExigencia(DadosRetornoExigencia dadosRetornoExigencia) {
        SolicitacaoRedeSimEntity solicitacaoRedeSim = this.repositoryConsultaRedeSim.getConsultaByTipo(dadosRetornoExigencia.getCo_protocolo_redesim(), TipoSolicitacaoRedeSimEnum.SOLICITACAO);
        if (Objects.isNull(solicitacaoRedeSim)) {
            this.logger.error((Object)String.format("Erro WS06: O protocolo %s n\u00e3o foi encontrado na base de dados.", dadosRetornoExigencia.getCo_protocolo_redesim()));
            return null;
        }
        for (ExigenciaRetorno exigenciaRetorno : dadosRetornoExigencia.getExigencias()) {
            HistoricoExigenciaRedeSimEntity historico = this.newHistorico(solicitacaoRedeSim, SituacaoConsultaPreviaRedeSimEnum.RESP_EXIGENCIA, Optional.empty(), this.usuarioLogado(), null);
            historico.setExigenciaRedeSim(this.repositoryExigenciaRedeSim.findByCodigo(Long.valueOf(exigenciaRetorno.getCo_exigencia().longValue())));
            historico.setObservacoes(exigenciaRetorno.getDs_retorno_exigencia());
            this.repositoryHistoricoExigencia.saveOrUpdate(historico);
            if (EloListUtils.safeIsEmpty((List)exigenciaRetorno.getAnexos()).booleanValue()) continue;
            this.salvarHistoricoExigenciaUrlDoc(historico, exigenciaRetorno.getAnexos());
        }
        solicitacaoRedeSim.setSituacao(SituacaoConsultaPreviaRedeSimEnum.RESP_EXIGENCIA.getSigla());
        this.repositoryConsultaRedeSim.saveOrUpdate(solicitacaoRedeSim);
        return solicitacaoRedeSim;
    }

    private void salvarHistoricoExigenciaUrlDoc(HistoricoExigenciaRedeSimEntity historico, List<Arquivo> anexos) {
        for (Arquivo anexo : anexos) {
            HistoricoExigenciaUrlDocEntity historicoUrlDoc = this.newHistoricoUrlDoc(historico, anexo.getDs_url_servico(), null);
            this.repositoryHistoricoExigenciaUrlDoc.saveOrUpdate(historicoUrlDoc);
        }
    }

    protected String usuarioLogado() {
        if (Objects.isNull(SecurityContextHolder.getContext()) || Objects.isNull(SecurityContextHolder.getContext().getAuthentication())) {
            return INTEGRASGO;
        }
        UsuarioEntity usuario = (UsuarioEntity)this.getUsuarioLogado();
        return usuario.getUsuario();
    }

    public void adicionarHistoricoDeAndamento(SolicitacaoRedeSimEntity solicitacaoRedeSim, SituacaoConsultaPreviaRedeSimEnum situacao, Optional<String> obs, Long idResposta) throws BaseException {
        String usuario = this.usuarioLogado();
        HistoricoExigenciaRedeSimEntity historico = this.newHistorico(solicitacaoRedeSim, situacao, obs, usuario, idResposta);
        if (EloListUtils.safeIsEmpty((List)solicitacaoRedeSim.getHistoricosExigencias()).booleanValue()) {
            solicitacaoRedeSim.setHistoricosExigencias(new ArrayList());
        }
        solicitacaoRedeSim.getHistoricosExigencias().add(historico);
        solicitacaoRedeSim.setSituacao(situacao.getSigla());
        if (SituacaoConsultaPreviaRedeSimEnum.INSCRICAO_ENVIADA.equals((Object)situacao) && solicitacaoRedeSim.isMei() && solicitacaoRedeSim.getSolicitacaoAlvara().possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.INICIAL, NaturezaSolicitacaoAlvaraEnum.MUDANCA_ENDERECO}) && !solicitacaoRedeSim.isEnderecoCadastroGeralValido().booleanValue() && SimNaoEnum.equalSim((String)this.getParametroAlvaraNaoTrataValorNull(ParametroAlvaraEnum.INFORMAR_ENDERECO_MEI).getValor()).booleanValue()) {
            HistoricoExigenciaRedeSimEntity historicoEnderecoInconsistente = this.newHistorico(solicitacaoRedeSim, SituacaoConsultaPreviaRedeSimEnum.ENDERECO_INCONSISTENTE, Optional.of(CADASTRO_MOBILIARIO_SEM_ENDERE\u00c7O), usuario, idResposta);
            solicitacaoRedeSim.getHistoricosExigencias().add(historicoEnderecoInconsistente);
            solicitacaoRedeSim.setSituacao(SituacaoConsultaPreviaRedeSimEnum.ENDERECO_INCONSISTENTE.getSigla());
        }
        this.repositoryConsultaRedeSim.saveOrUpdate(solicitacaoRedeSim);
        this.repositoryConsultaRedeSim.flush();
    }

    public void adicionarHistoricoComDocumentos(SolicitacaoRedeSimEntity solicitacaoRedeSim, Optional<String> obs, ArquivosEntidadeRegistro arquivos) {
        HistoricoExigenciaRedeSimEntity historico = this.newHistorico(solicitacaoRedeSim, SituacaoConsultaPreviaRedeSimEnum.AGUARDANDO_SOLICITACAO, obs, this.usuarioLogado(), null);
        if (Objects.nonNull(arquivos) && !EloListUtils.safeIsEmpty((List)arquivos.getArquivo_registro()).booleanValue()) {
            historico.setUrlsDocHistoricoExigencia(new ArrayList());
            arquivos.getArquivo_registro().stream().forEach(p -> historico.getUrlsDocHistoricoExigencia().add(this.newHistoricoUrlDoc(historico, p.getDs_url_servico(), p.getNu_tipo_arquivo())));
        }
        if (EloListUtils.safeIsEmpty((List)solicitacaoRedeSim.getHistoricosExigencias()).booleanValue()) {
            solicitacaoRedeSim.setHistoricosExigencias(new ArrayList());
        }
        solicitacaoRedeSim.getHistoricosExigencias().add(historico);
        solicitacaoRedeSim.setSituacao(SituacaoConsultaPreviaRedeSimEnum.AGUARDANDO_SOLICITACAO.getSigla());
        this.repositoryConsultaRedeSim.saveOrUpdate(solicitacaoRedeSim);
    }

    private HistoricoExigenciaRedeSimEntity newHistorico(SolicitacaoRedeSimEntity solicitacaoRedeSim, SituacaoConsultaPreviaRedeSimEnum situacao, Optional<String> obs, String usuario, Long idResposta) {
        this.logger.info((Object)String.format("Adicionando hist\u00f3rico de andamento no protocolo: %s -> %s", solicitacaoRedeSim.getProtocolo(), situacao.getTexto()));
        HistoricoExigenciaRedeSimEntity historico = new HistoricoExigenciaRedeSimEntity();
        historico.setIdHistorico(this.repositoryHistoricoExigencia.getSequence());
        historico.setSolicitacaoRedeSim(solicitacaoRedeSim);
        historico.setSituacao(situacao.getSigla());
        historico.setDataAndamento(new Date());
        historico.setUsuario(usuario);
        if (obs.isPresent()) {
            historico.setObservacoes(obs.get());
        }
        historico.setIdRespostaServico(idResposta);
        return historico;
    }

    private HistoricoExigenciaUrlDocEntity newHistoricoUrlDoc(HistoricoExigenciaRedeSimEntity historico, String url, Integer tipoArquivo) {
        HistoricoExigenciaUrlDocEntity historicoUrlDoc = new HistoricoExigenciaUrlDocEntity();
        historicoUrlDoc.setId(this.repositoryHistoricoExigenciaUrlDoc.getSequence());
        historicoUrlDoc.setIdHistorico(historico);
        historicoUrlDoc.setUrl(url);
        historicoUrlDoc.setValidado(false);
        if (Objects.nonNull(tipoArquivo)) {
            historicoUrlDoc.setTipoArquivo(TipoArquivoJuntaComercialEnum.fromCodigo((Integer)tipoArquivo));
        }
        return historicoUrlDoc;
    }

    public void imprimeDocumentoAlvara(SolicitacaoAlvaraEntity solicitacao, Long tipoDocumento) throws BaseException {
        DocumentoAiseEntity documento = this.repositoryDocumentoAise.getUltimoDocumentoEmitido(solicitacao.getCadastroMobiliario().getId(), tipoDocumento);
        String numeroDoc = String.valueOf(documento.getId().getDocumento());
        Long exercicioDoc = documento.getId().getExercicio();
        try {
            this.imprimeDocumentoAlvara.imprimirDocumentoAlvara(numeroDoc, exercicioDoc, tipoDocumento, solicitacao);
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new SolicitacaoRedeSimException("Ocorreu uma falha ao imprimir o documento - " + e.getMessage(), (Throwable)e);
        }
    }

    public SolicitacaoRedeSimEntity getSolicitacaoBySolicitacaoAlvara(SolicitacaoAlvaraEntity solicitacaoAlvara) {
        return this.repositoryConsultaRedeSim.getSolicitacaoBySolicitacaoAlvara(solicitacaoAlvara.getSolicitacaoAlvara());
    }

    public void gerarDebitosAlvaraProvisorio(DebitoWebVo debitoWebVo) throws BaseException {
        try {
            this.gerarDebitos(debitoWebVo);
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new SolicitacaoAlvaraException(e.getMessage(), (Throwable)e);
        }
    }

    public void enviarEmailComDebitos(SolicitacaoAlvaraEntity solicitacaoAlvara, List<DebitoEntity> debitosParaEnvio) throws BaseException {
        try {
            GuiaRecolhimentoEntity guiaDeTaxas = this.getGuiaRecolhimentoByTipoInscricao(solicitacaoAlvara);
            if (Objects.nonNull(guiaDeTaxas)) {
                debitosParaEnvio = debitosParaEnvio.stream().filter(debito -> debito.getId().getGuiaRecolhimento().getGuiaRecolhimento().compareTo(guiaDeTaxas.getGuiaRecolhimento()) != 0).collect(Collectors.toList());
            }
            EmailVo email = new EmailVo();
            email.setAssunto("D\u00e9bito referente ao Alvar\u00e1 Online");
            email.setDestinatario(solicitacaoAlvara.getEmail());
            email.setMensagem(EloStringUtils.replaceTemplates((String)this.getMensagemEmail(debitosParaEnvio), (Map)EloStringUtils.HTML_ACENTOS_TEMPLATE));
            ((FacadeSolicitacaoAlvara)SpringContext.getBean(FacadeSolicitacaoAlvara.class)).enviarEmail(email);
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new SolicitacaoAlvaraException(e.getMessage());
        }
    }

    public void enviarEmailComAlvara(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        try {
            EmailVo email = new EmailVo();
            email.setAssunto("Alvar\u00e1 Online");
            email.setDestinatario(solicitacao.getEmail());
            email.setMensagem(EloStringUtils.replaceTemplates((String)this.getMensagemEmailAlvara(solicitacao), (Map)EloStringUtils.HTML_ACENTOS_TEMPLATE));
            ((FacadeSolicitacaoAlvara)SpringContext.getBean(FacadeSolicitacaoAlvara.class)).enviarEmail(email);
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new SolicitacaoAlvaraException(e.getMessage());
        }
    }

    public void atualizarSituacaoParaDebitoPago() throws BaseException {
        List solicitacoes = this.repositoryConsultaRedeSim.getSolicitacaoComDebitoPago();
        for (SolicitacaoRedeSimEntity solicitacaoRedeSim : solicitacoes) {
            if (!solicitacaoRedeSim.getSolicitacaoAlvara().possuiTodosLaudosLiberado()) continue;
            this.adicionarHistoricoDeAndamento(solicitacaoRedeSim, SituacaoConsultaPreviaRedeSimEnum.DEBITO_PAGO, Optional.empty(), null);
        }
    }

    private String getMensagemEmail(List<DebitoEntity> debitos) throws BaseException {
        String urlBloqueto = this.getUrlBloqueto(debitos);
        EntidadeAiseEntity entidade = this.buscarEntidadePrincipal();
        StringBuilder mensagem = new StringBuilder();
        mensagem.append("<div style='font-family: Arial, times, Serif;'>");
        mensagem.append("<b>Prezado(a) Sr.(a):</b>");
        mensagem.append("<br>");
        mensagem.append("<br>");
        mensagem.append("<br>");
        mensagem.append("Segue abaixo o link do bloqueto gerado pela " + entidade.getNome() + ":");
        mensagem.append("<br>");
        mensagem.append("<br>");
        mensagem.append(urlBloqueto);
        mensagem.append("<br>");
        mensagem.append("<br>");
        mensagem.append("Qualquer d\u00favida, entre em contato pelo telefone: " + EloStringUtils.formatFone((String)entidade.getTelefone()) + " - Setor de Alvar\u00e1");
        mensagem.append("<br>");
        mensagem.append("<br>");
        mensagem.append("Atenciosamente,");
        mensagem.append("<br>");
        mensagem.append("<p><b>" + entidade.getNome() + "</b></p>");
        mensagem.append("<br>");
        mensagem.append("<br>");
        mensagem.append("<h5>Obs.: Esta \u00e9 uma mensagem autom\u00e1tica, por favor n\u00e3o responda este e-mail.</h5>");
        mensagem.append("</div>");
        return mensagem.toString();
    }

    private String getMensagemEmailAlvara(SolicitacaoAlvaraEntity solicitacao) throws BaseException, URISyntaxException {
        DocumentoAiseEntity documento = this.repositoryDocumentoAise.getUltimoDocumentoEmitido(solicitacao.getCadastroMobiliario().getId(), DocumentoTipoEnum.ALVARA_LOCALIZACAO.getCodigo());
        String numeroDoc = String.valueOf(documento.getId().getDocumento());
        Long exercicioDoc = documento.getId().getExercicio();
        String urlAlvara = this.imprimeDocumentoAlvara.getUrlDocumentoAlvara(numeroDoc, exercicioDoc, DocumentoTipoEnum.ALVARA_LOCALIZACAO.getCodigo()).toString();
        EntidadeAiseEntity entidade = this.buscarEntidadePrincipal();
        StringBuilder mensagem = new StringBuilder();
        mensagem.append("<div style='font-family: Arial, times, Serif;'>");
        mensagem.append("<b>Prezado(a) Sr.(a):</b>");
        mensagem.append("<br>");
        mensagem.append("<br>");
        mensagem.append("<br>");
        mensagem.append("Segue abaixo o link do Alvar\u00e1 gerado pela " + entidade.getNome() + ":");
        mensagem.append("<br>");
        mensagem.append("<br>");
        mensagem.append(urlAlvara);
        mensagem.append("<br>");
        mensagem.append("Para acompanhar o andamento da solicita\u00e7\u00e3o <a href='" + PortalUtils.getUrlApplicacao() + "/app/acompanhamento'>clique aqui</a>");
        mensagem.append("<br>");
        mensagem.append("Qualquer d\u00favida, entre em contato pelo telefone: " + EloStringUtils.formatFone((String)entidade.getTelefone()) + " - Setor de Alvar\u00e1");
        mensagem.append("<br>");
        mensagem.append("<br>");
        mensagem.append("Atenciosamente,");
        mensagem.append("<br>");
        mensagem.append("<p><b>" + entidade.getNome() + "</b></p>");
        mensagem.append("<br>");
        mensagem.append("<br>");
        mensagem.append("<h5>Obs.: Esta \u00e9 uma mensagem autom\u00e1tica, por favor n\u00e3o responda este e-mail.</h5>");
        mensagem.append("</div>");
        return mensagem.toString();
    }

    private String getUrlBloqueto(List<DebitoEntity> debitos) throws BaseException {
        try {
            List parcelas = debitos.stream().flatMap(debito -> debito.getParcelas().stream()).collect(Collectors.toList());
            Integer idBloqueto = this.srvDebitosPortal.geraBloqueto(parcelas);
            String urlImprimirBloqueto = (String)SpringContext.getBean((String)"urlImprimirBloqueto", String.class);
            return urlImprimirBloqueto + "uid=" + this.srvRespostaDocumentosRedeSim.getUserKey() + "&value=" + idBloqueto + "&exercicio=" + this.getExercicio().toString();
        }
        catch (Exception e) {
            throw new GeraBloquetoException("Falha ao gerar o bloqueto - " + e.getMessage(), (Throwable)e);
        }
    }

    private EntidadeAiseEntity buscarEntidadePrincipal() throws BaseException {
        return ((FacadeEntidade)SpringContext.getBean(FacadeEntidade.class)).buscarEntidadePrincipal();
    }

    public SolicitacaoRedeSimEntity buscarProtocoloComMesmoCnpj(SolicitacaoRedeSimEntity solicitacaoSelecionada) {
        return this.repositoryConsultaRedeSim.buscarProtocoloComMesmoCnpj(solicitacaoSelecionada);
    }

    public void generateTermoDispensa(SolicitacaoRedeSimEntity solicitacaoRedeSim, boolean addHistoricoAndamento) throws BaseException {
        solicitacaoRedeSim = this.reloadSolicitacaoRedeSim(solicitacaoRedeSim.getProtocolo());
        SolicitacaoAlvaraEntity solicitacaoAlvara = solicitacaoRedeSim.getSolicitacaoAlvara();
        this.updateSolicitacao(solicitacaoAlvara);
        solicitacaoRedeSim = this.reloadSolicitacaoRedeSim(solicitacaoRedeSim.getProtocolo());
        this.updateSituacaoMobiliario(solicitacaoAlvara);
        boolean isNovoDocumentoTermoDispensa = this.generateDocumentoLiberdadeEconomica(solicitacaoAlvara, Long.valueOf(this.getParametroAlvara(ParametroAlvaraEnum.TIPODOCUMENTO_LIBERDADE_ECONOMICA).getValor()));
        if (addHistoricoAndamento) {
            solicitacaoAlvara = solicitacaoRedeSim.getSolicitacaoAlvara();
            if (isNovoDocumentoTermoDispensa) {
                if (solicitacaoAlvara.isSolicitacaoMEI()) {
                    this.adicionarHistoricoDeAndamento(solicitacaoRedeSim, SituacaoConsultaPreviaRedeSimEnum.TERMO_DISPENSA_GERADO, Optional.of("Termo de Dispensa Gerado - MEI"), null);
                    return;
                }
                this.adicionarHistoricoDeAndamento(solicitacaoRedeSim, SituacaoConsultaPreviaRedeSimEnum.TERMO_DISPENSA_GERADO, solicitacaoAlvara.isGrauRiscoLiberdadeEconomica() ? Optional.of("Termo de Dispensa Gerado - Liberdade Econ\u00f4mica") : Optional.empty(), null);
            }
        }
    }

    private void updateSituacaoMobiliario(SolicitacaoAlvaraEntity solicitacaoAlvara) {
        if (solicitacaoAlvara.isSolicitacaoMEI()) {
            this.srvDebitosPortal.alteraMobiliarioSituacao(solicitacaoAlvara, SituacaoMobiliarioAlvaraEnum.SITUACAO_EMITEISSNAOEMITETAXAS);
        } else {
            this.srvDebitosPortal.alteraMobiliarioSituacao(solicitacaoAlvara, SituacaoMobiliarioAlvaraEnum.SITUACAO_NORMAL);
        }
    }

    private void updateSolicitacao(SolicitacaoAlvaraEntity solicitacaoAlvara) throws BaseException {
        if (solicitacaoAlvara.isNaturezaInicial() || !solicitacaoAlvara.isGrauRiscoLiberdadeEconomica()) {
            return;
        }
        List cadastrosMobiliarios = this.srvConsultaPreviaImpl.loadCadastroMobiliarioByCpfCnpj(solicitacaoAlvara.getCpfCnpj());
        if (EloListUtils.safeIsEmpty((List)cadastrosMobiliarios).booleanValue() && Objects.isNull(solicitacaoAlvara.getCadastroMobiliario())) {
            throw new SolicitacaoAlvaraException("N\u00e3o ser\u00e1 poss\u00edvel gerar o termo de dispensa. N\u00e3o existe Cadastro Mobili\u00e1rio para essa Solicita\u00e7\u00e3o.");
        }
        if (cadastrosMobiliarios.size() > 1 && Objects.isNull(solicitacaoAlvara.getCadastroMobiliario())) {
            throw new SolicitacaoAlvaraException("N\u00e3o ser\u00e1 poss\u00edvel gerar o termo de dispensa. Existe mais de um Cadastro Mobili\u00e1rio para essa Solicita\u00e7\u00e3o.");
        }
        if (cadastrosMobiliarios.size() == 1 && Objects.isNull(solicitacaoAlvara.getCadastroMobiliario())) {
            solicitacaoAlvara.setCadastroMobiliario((CadastroMobiliarioEntity)cadastrosMobiliarios.get(0));
        }
        if (SimNaoEnum.getNaoShortText().equals(solicitacaoAlvara.getEfetivado())) {
            if (solicitacaoAlvara.isSolicitacaoJuridicaNormal()) {
                this.srvSolicitacaoAlvara.efetivaAlteracaoSolicitacao(solicitacaoAlvara);
            }
            if (solicitacaoAlvara.isSolicitacaoMEINormal()) {
                this.srvSolicitacaoAlvaraMEI.efetivaAlteracaoSolicitacao(solicitacaoAlvara);
            }
        }
    }

    private SolicitacaoRedeSimEntity reloadSolicitacaoRedeSim(String protocolo) {
        this.repositoryConsultaRedeSim.flush();
        return this.srvConsultaPreviaImpl.getSolicitacaoByProtocoloAndTipo(protocolo, TipoSolicitacaoRedeSimEnum.SOLICITACAO);
    }

    public void sendDocumentoTermoDispensa(SolicitacaoRedeSimEntity solicitacaoRedeSim) throws BaseException {
        try {
            this.srvRespostaDocumentosRedeSim.sendRespostaDocumentoTermoDispensa(solicitacaoRedeSim, SituacaoRespostaRedeSimEnum.EM_ANALISE);
            this.srvRespostaDocumentosRedeSim.sendRespostaDocumentoTermoDispensa(solicitacaoRedeSim, SituacaoRespostaRedeSimEnum.EMITIDO);
            if (solicitacaoRedeSim.getSolicitacaoAlvara().isSolicitacaoMEI()) {
                solicitacaoRedeSim.setAlvaraEnviado(TipoAlvaraEnum.MEI);
                solicitacaoRedeSim = this.repositoryConsultaRedeSim.saveOrUpdate(solicitacaoRedeSim);
                this.adicionarHistoricoDeAndamento(solicitacaoRedeSim, SituacaoConsultaPreviaRedeSimEnum.TERMO_DISPENSA_ENVIADO, Optional.of("Termo de Dispensa Enviado - MEI"), null);
                return;
            }
            this.adicionarHistoricoDeAndamento(solicitacaoRedeSim, SituacaoConsultaPreviaRedeSimEnum.TERMO_DISPENSA_ENVIADO, solicitacaoRedeSim.getSolicitacaoAlvara().isGrauRiscoLiberdadeEconomica() ? Optional.of("Termo de Dispensa Enviado - Liberdade Econ\u00f4mica") : Optional.empty(), null);
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new SolicitacaoRedeSimException(String.format("Ocorreu uma falha ao enviar o documento para o servi\u00e7o da Rede Sim: %s ", e.getMessage()));
        }
    }

    public boolean gerarInscricaoMunicipal(SolicitacaoAlvaraEntity solicitacaoAlvara) throws BaseException {
        if (SimNaoEnum.equalNao((String)this.getParametroAlvara(ParametroAlvaraEnum.ENVIA_INSCRICAO_MUNICIPAL_COM_DADOS_ATUALIZADOS).getValor()).booleanValue()) {
            this.updateSituacaoMobiliario(solicitacaoAlvara);
        }
        return this.generateDocumentoLiberdadeEconomica(solicitacaoAlvara, DocumentoTipoEnum.INSCRICAO_MUNICIPAL.getCodigo());
    }

    public void enviarDocumentoInscricaoMunicipal(SolicitacaoRedeSimEntity solicitacaoRedeSim, SituacaoRespostaRedeSimEnum situacao) throws SolicitacaoRedeSimException {
        try {
            this.srvRespostaDocumentosRedeSim.enviaRespostaDocumentoInscricaoMunicipal(solicitacaoRedeSim, situacao);
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new SolicitacaoRedeSimException(String.format("Ocorreu uma falha ao enviar o documento para o servi\u00e7o da Rede Sim: %s ", e.getMessage()), (Throwable)e);
        }
    }

    private boolean generateDocumentoLiberdadeEconomica(SolicitacaoAlvaraEntity solicitacaoAlvara, Long tipoDocumento) throws DocumentoNaoEncontradoException, SolicitacaoAlvaraException {
        Boolean transacaoAtiva = UtilsController.commitTransaction();
        try {
            String userKey;
            Long termoDeDispensa = Long.valueOf(this.getParametroAlvara(ParametroAlvaraEnum.TIPODOCUMENTO_LIBERDADE_ECONOMICA).getValor());
            if (DocumentoTipoEnum.INSCRICAO_MUNICIPAL.getCodigo().equals(tipoDocumento) && this.existsSolicitacaoRedeSimWithSituacao(solicitacaoAlvara.getProtocoloRedeSim(), SituacaoConsultaPreviaRedeSimEnum.INSCRICAO_GERADA) || tipoDocumento.equals(termoDeDispensa) && this.existsSolicitacaoRedeSimWithSituacao(solicitacaoAlvara.getProtocoloRedeSim(), SituacaoConsultaPreviaRedeSimEnum.TERMO_DISPENSA_GERADO)) {
                this.imprimeDocumentoAlvara(solicitacaoAlvara, tipoDocumento);
                boolean bl = Boolean.FALSE;
                return bl;
            }
            EnvioGeraDocumento documentoAlvara = this.getEnvioGeracaoDocumentoLiberdadeEconomica(solicitacaoAlvara, tipoDocumento);
            CommonGeraDocumento documentoGerado = (CommonGeraDocumento)new GeraDocumentoClientAlvara().doPost(CommonGeraDocumento.class, (Object)documentoAlvara, userKey = this.srvDebitosPortal.loginWeb());
            if (documentoGerado == null) {
                throw new DocumentoNaoEncontradoException("Falha no servi\u00e7o de gera\u00e7\u00e3o de documentos.");
            }
            this.imprimeDocumentoAlvara(solicitacaoAlvara, tipoDocumento);
            boolean bl = Boolean.TRUE;
            return bl;
        }
        catch (DocumentoNaoEncontradoException dnee) {
            throw new DocumentoNaoEncontradoException(dnee.getMessage());
        }
        catch (Exception e) {
            this.logger.error((Object)"Ocorreu uma falha de conex\u00e3o com o AISE Tributos (Apache)", (Throwable)e);
            throw new SolicitacaoAlvaraException(String.format("Ocorreu um erro ao Gerar o Documento: %s", e.getMessage()), (Throwable)e);
        }
        finally {
            if (Boolean.TRUE.equals(transacaoAtiva)) {
                UtilsController.startTransaction();
            }
        }
    }

    private boolean existsSolicitacaoRedeSimWithSituacao(String protocolo, SituacaoConsultaPreviaRedeSimEnum situacao) {
        return this.repositoryHistoricoExigencia.existsSolicitacaoRedeSimAndSituacao(protocolo, situacao);
    }

    private EnvioGeraDocumento getEnvioGeracaoDocumentoLiberdadeEconomica(SolicitacaoAlvaraEntity solicitacao, Long tipoDocumento) {
        EnvioGeraDocumento envioDocumento = new EnvioGeraDocumento();
        envioDocumento.setClassName("TDocumentoVO");
        envioDocumento.setExercicio(Integer.valueOf(this.getExercicio().intValue()));
        envioDocumento.setEntidade(Integer.valueOf(this.getEntidadeTributacao().getId().getEntidade().getId().intValue()));
        envioDocumento.setTipoDocumento(Integer.valueOf(tipoDocumento.intValue()));
        Object geraDocumento = null;
        geraDocumento = DocumentoTipoEnum.INSCRICAO_MUNICIPAL.getCodigo().equals(tipoDocumento) ? new GeraDocumentoInscricaoMunicipal(solicitacao, this.getEntidadeTributacao()) : new GeraDocumentoTermoDispensa(solicitacao, this.getEntidadeTributacao(), tipoDocumento);
        envioDocumento.setDocumentoJson(geraDocumento.formatJson());
        return envioDocumento;
    }

    public boolean isCriaLaudosAoReceberArquivoEmpresa() throws SolicitacaoAlvaraException {
        try {
            return this.getParametroAlvara(ParametroAlvaraEnum.CRIA_LAUDOS_AO_RECEBER_DADOS_EMPRESA).getValor().equals(SimNaoEnum.getSimShortText());
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new SolicitacaoAlvaraException(e.getMessage());
        }
    }

    public void renovarAlvaraProvisorio(SolicitacaoAlvaraEntity solicitacaoAlvara) {
        solicitacaoAlvara.setRenovacao(SimNaoEnum.getSimShortText());
        List listaValidadeAlvaraAtual = this.repositorySolicitacaoValidade.retornaValidadeBySolicitacao(solicitacaoAlvara);
        for (SolicitacaoAlvaraValidadeEntity validade : listaValidadeAlvaraAtual) {
            if (validade.getDataValidade().compareTo(solicitacaoAlvara.getDataValidadeProvisorio()) != 0) continue;
            validade.setAtual(SimNaoEnum.getNaoShortText());
            this.repositorySolicitacaoValidade.saveOrUpdate(validade);
        }
        this.repositorySolicitacaoAlvara.saveOrUpdate(solicitacaoAlvara);
    }

    public SolicitacaoAlvaraEntity adicionarAtividadesSolicitacaoMei(SolicitacaoAlvaraRedeSimDTO solicitacaoRedeSimDTO, SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        List listaConsultaVo = this.criarConsultaAtividadeVo(solicitacaoRedeSimDTO, solicitacao);
        ArrayList listaAtividade = new ArrayList();
        for (ConsultaAtividadeVo consultaAtividadeVo : listaConsultaVo) {
            consultaAtividadeVo.setSolicitacaoAlvara(solicitacao);
            this.adicionarAtividade(consultaAtividadeVo);
            consultaAtividadeVo.getListaAtiv().stream().forEach(ativ -> ativ.setExerceNoEndereco(consultaAtividadeVo.isExerceNoEndereco()));
            listaAtividade.addAll(consultaAtividadeVo.getListaAtiv());
        }
        solicitacao.setSolicitacaoAlvaraAtividades(this.atribuiValoresSolicitacaoAtividades(solicitacao, listaAtividade));
        this.atribuiGrauRiscoNaSolicitacao(listaAtividade, solicitacao);
        this.salvarConsultaPreviaSolicitacaoMei(solicitacao);
        return solicitacao;
    }

    private List<ConsultaAtividadeVo> criarConsultaAtividadeVo(SolicitacaoAlvaraRedeSimDTO solicitacaoRedeSimDTO, SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        ArrayList listaConsultaVo = Lists.newArrayList();
        for (Atividades atividadeItem : solicitacaoRedeSimDTO.getDados_solicitacao().getEmpresa().getAtividades()) {
            listaConsultaVo.addAll(this.getAtividadeMei(solicitacao, atividadeItem));
        }
        return listaConsultaVo;
    }

    public void atribuiGrauRiscoNaSolicitacao(List<Atividade> listaAtividade, SolicitacaoAlvaraEntity solicitacao) {
        for (Atividade atividade : listaAtividade) {
            if (GrauDeRiscoEnum.RISCO_ALTO.equals((Object)atividade.getGrauRisco())) {
                solicitacao.setGrauRisco(atividade.getGrauRisco());
                break;
            }
            if (!GrauDeRiscoEnum.RISCO_BAIXO.equals((Object)atividade.getGrauRisco())) continue;
            solicitacao.setGrauRisco(atividade.getGrauRisco());
        }
    }

    private List<ConsultaAtividadeVo> getAtividadeMei(SolicitacaoAlvaraEntity solicitacao, Atividades atividadeItem) throws BaseException {
        String codigoCnae = EloStringUtils.somenteNumeros((String)atividadeItem.getCo_cnae());
        ArrayList listaConsultaVo = Lists.newArrayList();
        List atividadesMei = ((FacadeAlteracaoAtividades)SpringContext.getBean(FacadeAlteracaoAtividades.class)).consultaAtividadeMeiPorCnae(codigoCnae, SimNaoEnum.getNaoShortText());
        for (Atividade atividade : atividadesMei) {
            ConsultaAtividadeVo consultaAtividadeVo = new ConsultaAtividadeVo();
            consultaAtividadeVo.setSolicitacaoAlvara(solicitacao);
            consultaAtividadeVo.setCodigoAtividade(atividade.getCodigo());
            consultaAtividadeVo.setAtividadeSelecionada(atividade);
            consultaAtividadeVo.getAtividadeSelecionada().setSituacao("I");
            if (atividadeItem.isIs_atividade_principal()) {
                consultaAtividadeVo.getAtividadeSelecionada().setPrincipal(SimNaoEnum.SIM.getShortText());
            } else {
                consultaAtividadeVo.getAtividadeSelecionada().setPrincipal(SimNaoEnum.NAO.getShortText());
            }
            consultaAtividadeVo.setExerceNoEndereco(atividadeItem.isIs_exerce_no_endereco());
            listaConsultaVo.add(consultaAtividadeVo);
        }
        return listaConsultaVo;
    }

    protected void adicionarAtividade(ConsultaAtividadeVo consultaAtividadeVo) {
        consultaAtividadeVo.getListaAtiv().add(consultaAtividadeVo.getAtividadeSelecionada());
        consultaAtividadeVo.setCodigoAtividade("");
    }

    public void consultarViabilidadeSolicitacaoMei(SolicitacaoRedeSimEntity solicitacaoRedeSim) throws BaseException {
        try {
            this.integradoGeo = this.integradoGeo();
            SolicitacaoAlvaraRedeSimDTO solicitacaoDTO = PortalUtils.normalizeJson((String)solicitacaoRedeSim.getArquivoDadosEmpresa());
            SolicitacaoAlvaraEntity solicitacaoAlvara = solicitacaoRedeSim.getSolicitacaoAlvara();
            List consultaAtividadeVo = this.criarConsultaAtividadeVo(solicitacaoDTO, solicitacaoAlvara);
            this.verificarCadastroImobiliario(solicitacaoDTO, solicitacaoAlvara);
            ArrayList perguntas = new ArrayList();
            if (Objects.nonNull(solicitacaoDTO.getDados_solicitacao().getClassificacao_risco())) {
                perguntas.addAll(solicitacaoDTO.getDados_solicitacao().getClassificacao_risco().getPergunta_classificacao_risco().stream().map(GrauRiscoPergunta::of).collect(Collectors.toList()));
            }
            SolicitacaoAlvaraEntity solicitacaoAlvaraEntity = this.processaConsulta.consultaAtividade(solicitacaoAlvara, consultaAtividadeVo, solicitacaoDTO.getDados_solicitacao().getEmpresa().getAtividades(), perguntas);
        }
        catch (CadastroImobiliarioNaoEncontradoException cinee) {
            this.logger.error((Object)cinee.getMessage());
            throw new CadastroImobiliarioNaoEncontradoException(cinee.getMessage(), (Throwable)cinee);
        }
        catch (AtividadeNaoConfiguradaException ance) {
            this.logger.error((Object)ance.getMessage(), (Throwable)ance);
            throw new AtividadeNaoConfiguradaException(ance.getMessage());
        }
        catch (AtividadeNaoPermitidaException anpe) {
            this.logger.error((Object)anpe.getMessage(), (Throwable)anpe);
            throw new AtividadeNaoPermitidaException(anpe.getMessage());
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private void verificarCadastroImobiliario(SolicitacaoAlvaraRedeSimDTO solicitacaoDTO, SolicitacaoAlvaraEntity solicitacaoAlvara) throws BaseException {
        CadastroImobiliarioEntity cadastroImobiliario = null;
        if (Objects.isNull(solicitacaoAlvara.getCadastroImobiliario())) {
            try {
                cadastroImobiliario = this.repositoryCadastroImobiliario.getCadastroImobiliarioPorCodigo(Long.valueOf(1L), Long.valueOf(this.getNu_Inscricao(solicitacaoDTO)));
            }
            catch (NumberFormatException nfe) {
                cadastroImobiliario = null;
            }
        } else {
            cadastroImobiliario = solicitacaoAlvara.getCadastroImobiliario();
        }
        if (cadastroImobiliario != null) {
            solicitacaoAlvara.setCadastroImobiliario(cadastroImobiliario);
            if (UtilsController.isTestadaGenerica()) {
                solicitacaoAlvara.setImobiliarioTestadaGenerica(cadastroImobiliario.getTestadaPrincipalGenerica());
            } else {
                if (this.integradoGeo && cadastroImobiliario.getTestadas().size() > 1) {
                    String logradouroDesc = solicitacaoDTO.getDados_solicitacao().getEmpresa().getEndereco().getDs_tipo_logradouro() + " " + solicitacaoDTO.getDados_solicitacao().getEmpresa().getEndereco().getDs_endereco();
                    LogradouroEntity logradouroLocalizado = this.srvFindEnderecoBySimilarity.findDescricaoLogradouroBySimilarity(logradouroDesc);
                    if (Objects.isNull(logradouroLocalizado)) {
                        throw new LogradouroNaoEncontradoException(String.format("O logradouro '%s' n\u00e3o foi localizado na base de dados.", logradouroDesc));
                    }
                    for (CadastroImobiliarioTestadaEntity testada : cadastroImobiliario.getTestadas()) {
                        if (!testada.getLogradouro().getId().getLogradouro().equals(logradouroLocalizado.getId().getLogradouro())) continue;
                        solicitacaoAlvara.setImobiliarioTestada(testada);
                        break;
                    }
                    if (!UtilsController.isUtilizaEnderecoCadastroGeral() && Objects.isNull(solicitacaoAlvara.getImobiliarioTestada())) {
                        throw new TestadaNaoEncontradaException("Testada n\u00e3o encontrada na base de dados.");
                    }
                }
                if (Objects.isNull(solicitacaoAlvara.getImobiliarioTestada())) {
                    solicitacaoAlvara.setImobiliarioTestada(cadastroImobiliario.getTestadaPrincipal());
                }
            }
            if (!solicitacaoAlvara.isSolicitacaoMEIPrestador() && !solicitacaoAlvara.isSolicitacaoPrestadorServico()) {
                solicitacaoAlvara.setAreaUtilizada(this.processaConsulta.getValorNumerico(solicitacaoDTO.getDados_solicitacao().getEmpresa().getEndereco().getNu_area_utilizada()));
                solicitacaoAlvara.setAreaConstruida(this.processaConsulta.getValorNumerico(solicitacaoDTO.getDados_solicitacao().getEmpresa().getEndereco().getNu_area_total()));
            }
        }
    }

    private String getNu_Inscricao(SolicitacaoAlvaraRedeSimDTO solicitacaoRedeSimDto) {
        if (Objects.nonNull(solicitacaoRedeSimDto.getDados_solicitacao().getEmpresa().getEndereco()) && Objects.nonNull(solicitacaoRedeSimDto.getDados_solicitacao().getEmpresa().getEndereco()) && Objects.nonNull(solicitacaoRedeSimDto.getDados_solicitacao().getEmpresa().getEndereco().getNatureza_imovel())) {
            return EloStringUtils.somenteNumerosOuRetornaraNulo((String)solicitacaoRedeSimDto.getDados_solicitacao().getEmpresa().getEndereco().getNatureza_imovel().getNu_inscricao());
        }
        return null;
    }

    private Long getCep(SolicitacaoAlvaraRedeSimDTO solicitacaoRedeSimDto) {
        return new Long(solicitacaoRedeSimDto.getDados_solicitacao().getEmpresa().getEndereco().getCo_cep());
    }

    private boolean integradoGeo() throws BaseException {
        return ((FacadeEntidade)SpringContext.getBean(FacadeEntidade.class)).verificaIntegradoGeo();
    }

    public SolicitacaoEncaminhadaEntity criarSolicitacaoEncaminhada(SolicitacaoAlvaraRedeSimDTO solicitacaoDTO) throws SolicitacaoRedeSimException {
        SolicitacaoEncaminhadaEntity solicitacaoEncaminhada = new SolicitacaoEncaminhadaEntity();
        solicitacaoEncaminhada.setId(this.repositorySolicitacaoEncaminhada.getSequence());
        solicitacaoEncaminhada.setArquivoDadosEmpresa(new Gson().toJson((Object)solicitacaoDTO));
        solicitacaoEncaminhada.setDataSolicitacao(new Date());
        solicitacaoEncaminhada.setProtocolo(solicitacaoDTO.getDados_solicitacao().getCo_protocolo_redesim());
        solicitacaoEncaminhada.setTipoEmpresa(this.verificarTipoEmpresa(solicitacaoDTO));
        solicitacaoEncaminhada.setEventos(this.getEventos(solicitacaoDTO.getDados_solicitacao().getEventos_redesim()));
        solicitacaoEncaminhada.setEncaminhado(false);
        return this.repositorySolicitacaoEncaminhada.saveOrUpdate(solicitacaoEncaminhada);
    }

    private String verificarTipoEmpresa(SolicitacaoAlvaraRedeSimDTO solicitacaoDTO) {
        if (EnquadramentoEmpresaEnum.fromCodigo((Integer)solicitacaoDTO.getDados_solicitacao().getEmpresa().getCo_enquadramento()).equals((Object)EnquadramentoEmpresaEnum.MEI)) {
            return "MEI";
        }
        return "PJ";
    }

    public String getPontoReferencia(List<Atividades> atividades) {
        String pontoReferencia = SimNaoEnum.getNaoShortText();
        if (!EloListUtils.safeIsEmpty(atividades).booleanValue()) {
            for (Atividades atividade : atividades) {
                if (atividade.isIs_exerce_no_endereco()) {
                    return SimNaoEnum.getNaoShortText();
                }
                pontoReferencia = SimNaoEnum.getSimShortText();
            }
        }
        return pontoReferencia;
    }

    private boolean isMobiliarioPrestadorServico(CadastroMobiliarioEntity cadastroMobiliario) {
        List codigos = cadastroMobiliario.getMobiliarioCnaes().stream().map(c -> c.getId().getCnae().getCodigo()).collect(Collectors.toList());
        Boolean isCnaesPrestadorServico = this.repositoryCnaePrestadorServico.verificaCnaePrestadorServico(codigos);
        return isCnaesPrestadorServico != false && cadastroMobiliario.isNaoPossuiArea();
    }

    private boolean isMobiliarioPrestadorServicoMEI(CadastroMobiliarioEntity cadastroMobiliario) {
        Boolean isCnaesPrestadorMei = cadastroMobiliario.getMobiliarioCnaes().stream().noneMatch(atividade -> {
            try {
                return this.processaConsulta.cnaeNaoPermitidoParaMeiPrestador(atividade.getId().getCnae().getCodigo());
            }
            catch (Exception e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
                return false;
            }
        });
        return isCnaesPrestadorMei != false && cadastroMobiliario.isNaoPossuiArea();
    }

    public void fillDadosSolicitante(SolicitacaoAlvaraRedeSimDTO solicitacaoAlvaraRedeSimDTO, SolicitacaoAlvaraEntity solicitacaoAlvara) {
        Solicitante solicitante = solicitacaoAlvaraRedeSimDTO.getDados_solicitacao().getSolicitante();
        if (Objects.nonNull(solicitante)) {
            Optional.ofNullable(solicitante.getDs_email()).ifPresent(dsEmail -> solicitacaoAlvara.setEmail(dsEmail));
            Optional.ofNullable(solicitante.getNu_cpf()).ifPresent(nuCpf -> solicitacaoAlvara.setCpfCnpjConsulta(nuCpf));
            solicitacaoAlvara.setTelefone(this.preencherTelefone(solicitante.getNu_ddd_telefone(), solicitante.getNu_telefone()));
        }
    }

    private SolicitacaoRedeSimEntity reloadSolicitacaoRedeSimEntity(String protocolo) throws BaseException {
        return ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).getConsultaRedeSim(protocolo, TipoSolicitacaoRedeSimEnum.SOLICITACAO);
    }

    private void adicionarSituacaoMobiliario(CadastroMobiliarioEntity cadastroMobiliario, Long situacao) throws BaseException {
        SituacaoMobiliarioEntity situacaoMobiliarioGravar = this.srvSituacaoMobiliario.findSituacaoByCodigo(situacao);
        if (Objects.isNull(situacaoMobiliarioGravar)) {
            throw new SolicitacaoRedeSimException(String.format("Situa\u00e7\u00e3o Mobili\u00e1ria n\u00e3o encontrada - %d", situacao));
        }
        if (Objects.isNull(cadastroMobiliario.getMobiliarioSituacao())) {
            cadastroMobiliario.setMobiliarioSituacao(new ArrayList());
        }
        cadastroMobiliario.getMobiliarioSituacao().stream().filter(mobiliarioSituacao -> SimNaoEnum.equalSim((String)mobiliarioSituacao.getAtual())).forEach(mobiliarioSituacao -> {
            mobiliarioSituacao.setDataAlteracao(new Date());
            mobiliarioSituacao.setUsuarioInclusao(PortalUtils.getUsuarioalvaraonline());
            mobiliarioSituacao.setAtual(SimNaoEnum.NAO.getShortText());
            this.repositoryMobiliarioSituacao.saveOrUpdate(mobiliarioSituacao);
        });
        MobiliarioSituacaoPK id = new MobiliarioSituacaoPK();
        id.setCadastroGeralPK(cadastroMobiliario.getId());
        id.setSequencia(this.repositoryMobiliarioSituacao.getSequencia(cadastroMobiliario.getId()));
        MobiliarioSituacaoEntity mobiliarioSituacaoNovo = new MobiliarioSituacaoEntity();
        mobiliarioSituacaoNovo.setId(id);
        mobiliarioSituacaoNovo.setUsuarioInclusao(PortalUtils.getUsuarioalvaraonline());
        mobiliarioSituacaoNovo.setDataInclusao(new Date());
        mobiliarioSituacaoNovo.setSituacaoMobiliario(situacaoMobiliarioGravar);
        mobiliarioSituacaoNovo.setAtual(SimNaoEnum.SIM.getShortText());
        cadastroMobiliario.addMobiliarioSituacao(this.repositoryMobiliarioSituacao.saveOrUpdate(mobiliarioSituacaoNovo));
    }

    public boolean processarSolicitacaoBaixa(String prefix, String token, String protocolo) throws BaseException {
        SolicitacaoRedeSimEntity solicitacaoRedeSimEntity = this.reloadSolicitacaoRedeSimEntity(protocolo);
        FacadeRedeSim facadeRedeSim = (FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class);
        FacadeEntidade facadeEntidade = (FacadeEntidade)SpringContext.getBean(FacadeEntidade.class);
        SolicitacaoBaixaRedeSimEntity solicitacaoBaixaRedeSim = solicitacaoRedeSimEntity.getSolicitacaoBaixaRedeSim();
        if (Objects.nonNull(solicitacaoBaixaRedeSim) && SimNaoEnum.equalNao((String)solicitacaoBaixaRedeSim.getBaixado()).booleanValue()) {
            boolean gerarDebitoSolicitacaoBaixa = SimNaoEnum.equalSim((String)UtilsController.getValorParametroAlvara((ParametroAlvaraEnum)ParametroAlvaraEnum.SOLICITACAO_BAIXA_GERAR_DEBITO));
            if (gerarDebitoSolicitacaoBaixa && Objects.isNull(solicitacaoBaixaRedeSim.getIdDebito())) {
                this.logger.info((Object)String.format("%s - [%s] Realizando a gera\u00e7\u00e3o d\u00e9bito para baixa do cadastro mobili\u00e1rio! protocolo: %s ", prefix, token, protocolo));
                Long guiaRecolhimento = Long.valueOf(UtilsController.getValorParametroAlvara((ParametroAlvaraEnum)ParametroAlvaraEnum.SOLICITACAO_BAIXA_GUIARECOLHIMENTO));
                int quantidadeDias = Integer.parseInt(UtilsController.getValorParametroAlvara((ParametroAlvaraEnum)ParametroAlvaraEnum.SOLICITACAO_BAIXA_DATA_VENCIMENTO));
                EntidadeTributacaoEntity entidadeTributacao = facadeEntidade.getEntidade();
                GeraDebitoGenericoDTO dto = new GeraDebitoGenericoDTO();
                dto.setEntidade(entidadeTributacao.getIdEntidade());
                dto.setExercicio(entidadeTributacao.getExercicio());
                dto.setTipoCadastro(Long.valueOf(2L));
                dto.setCadastroGeral(solicitacaoRedeSimEntity.getSolicitacaoAlvara().getCadastroMobiliario().getId().getCodigo());
                dto.setGuiaRecolhimento(guiaRecolhimento);
                dto.setObservacao(String.format("D\u00e9bito gerado pela solicita\u00e7\u00e3o de baixa de alvar\u00e1 - protocolo: %s", protocolo));
                dto.setTelaOrigemDebito("Alvar\u00e1 Online");
                dto.setDataVencimento(new SimpleDateFormat("yyyy-MM-dd").format(EloDateUtils.incDay((Date)new Date(), (int)quantidadeDias)));
                String quantidadeProporcional = UtilsController.getValorParametroAlvara((ParametroAlvaraEnum)ParametroAlvaraEnum.QTDE_PROPORCIONAL);
                if (!EloStringUtils.isEmpty((String)quantidadeProporcional)) {
                    dto.getParametrosAdicionais().add(quantidadeProporcional);
                }
                String userKey = this.srvDebitosPortal.loginWeb();
                Long idDebito = this.srvGeraDebitoGenerico.gerarDebitoGenerico(dto, userKey);
                solicitacaoBaixaRedeSim.setIdDebito(idDebito);
                solicitacaoBaixaRedeSim = this.repositorySolicitacaoBaixaRedeSim.saveOrUpdate(solicitacaoBaixaRedeSim);
                this.repositorySolicitacaoBaixaRedeSim.flush();
                this.logger.info((Object)String.format("%s - [%s] D\u00e9bito deferente a baixa do cadastro mobili\u00e1rio gerado com sucesso! idDebito: %d ", prefix, token, idDebito));
                solicitacaoRedeSimEntity = this.reloadSolicitacaoRedeSimEntity(protocolo);
                facadeRedeSim.adicionarHistoricoDeAndamento(solicitacaoRedeSimEntity, SituacaoConsultaPreviaRedeSimEnum.SOLICITACAO_BAIXA, Optional.of("D\u00e9bito gerado"));
            }
            solicitacaoRedeSimEntity = this.reloadSolicitacaoRedeSimEntity(protocolo);
            SolicitacaoAlvaraEntity solicitacaoAlvara = solicitacaoRedeSimEntity.getSolicitacaoAlvara();
            CadastroMobiliarioEntity cadastroMobiliario = solicitacaoAlvara.getCadastroMobiliario();
            this.logger.info((Object)String.format("%s - [%s] Adicionando situa\u00e7\u00e3o de baixa no cadastro mobili\u00e1rio %d. ", prefix, token, cadastroMobiliario.getId().getCodigo()));
            Long situacao = Long.valueOf(UtilsController.getValorParametroAlvara((ParametroAlvaraEnum)ParametroAlvaraEnum.SOLICITACAO_BAIXA_SITUACAO_MOBILIARIO));
            cadastroMobiliario.getCadastroGeral().setDataAlteracao(new Date());
            this.salvarCadastroGeral(cadastroMobiliario.getCadastroGeral(), solicitacaoAlvara);
            this.adicionarSituacaoMobiliario(cadastroMobiliario, situacao);
            this.logger.info((Object)String.format("%s - [%s] Finalizando altera\u00e7\u00f5es da solicita\u00e7\u00e3o de baixa no cadastro mobili\u00e1rio %d. ", prefix, token, cadastroMobiliario.getId().getCodigo()));
            solicitacaoAlvara.setFinalizado(SimNaoEnum.getSimShortText());
            this.repositorySolicitacaoAlvara.saveOrUpdate(solicitacaoAlvara);
            solicitacaoRedeSimEntity = this.reloadSolicitacaoRedeSimEntity(protocolo);
            facadeRedeSim.adicionarHistoricoDeAndamento(solicitacaoRedeSimEntity, SituacaoConsultaPreviaRedeSimEnum.SOLICITACAO_BAIXA, Optional.of("Situa\u00e7\u00e3o do cadastro alterada"));
            solicitacaoBaixaRedeSim.setBaixado(SimNaoEnum.getSimShortText());
            this.repositorySolicitacaoBaixaRedeSim.saveOrUpdate(solicitacaoBaixaRedeSim);
            this.repositorySolicitacaoBaixaRedeSim.flush();
            solicitacaoRedeSimEntity = this.reloadSolicitacaoRedeSimEntity(protocolo);
            facadeRedeSim.adicionarHistoricoDeAndamento(solicitacaoRedeSimEntity, SituacaoConsultaPreviaRedeSimEnum.SOLICITACAO_BAIXA_FINALIZADA, Optional.of("Baixa realizada com sucesso"));
            return true;
        }
        return false;
    }

    public String generateUrlObservacao(Long tipoDocumento, SolicitacaoRedeSimEntity solicitacao) throws BaseException {
        Boolean transacaoAtiva = UtilsController.commitTransaction();
        try {
            String userKey = this.srvDebitosPortal.loginWeb();
            EnvioGeraDocumento envioGeraDocumento = this.getEnvioGeracaoDocumentoObservacao(tipoDocumento, solicitacao.getSolicitacaoAlvara());
            CommonGeraDocumento documentoGerado = (CommonGeraDocumento)new GeraDocumentoClientAlvara().doPost(CommonGeraDocumento.class, (Object)envioGeraDocumento, userKey);
            if (Objects.isNull(documentoGerado)) {
                throw new DocumentoNaoEncontradoException("Falha no servi\u00e7o de gera\u00e7\u00e3o de documentos.");
            }
            String string = this.gerarUrlObservacoes(tipoDocumento, documentoGerado);
            return string;
        }
        catch (Exception e) {
            throw new SolicitacaoAlvaraException(String.format("Ocorreu um erro ao Gerar o Documento: %s", e.getMessage()), (Throwable)e);
        }
        finally {
            if (Boolean.TRUE.equals(transacaoAtiva)) {
                UtilsController.startTransaction();
            }
        }
    }

    private EnvioGeraDocumento getEnvioGeracaoDocumentoObservacao(Long tipoDocumento, SolicitacaoAlvaraEntity solicitacaoAlvara) throws BaseException {
        EnvioGeraDocumento envioDocumento = new EnvioGeraDocumento();
        envioDocumento.setClassName("TDocumentoVO");
        envioDocumento.setExercicio(Integer.valueOf(this.getExercicio().intValue()));
        envioDocumento.setEntidade(Integer.valueOf(this.getEntidadeTributacao().getId().getEntidade().getId().intValue()));
        envioDocumento.setTipoDocumento(Integer.valueOf(tipoDocumento.intValue()));
        GeraDocumentoObservacaoConsulta geraDocumento = new GeraDocumentoObservacaoConsulta(solicitacaoAlvara, this.getEntidadeTributacao(), tipoDocumento);
        envioDocumento.setDocumentoJson(geraDocumento.formatJson());
        return envioDocumento;
    }

    private String gerarUrlObservacoes(Long tipoDocumento, CommonGeraDocumento documentoGerado) throws URISyntaxException {
        return this.imprimeDocumentoAlvara.getUrlDocumentoAlvara(String.valueOf(documentoGerado.getDocumento()), Long.valueOf(documentoGerado.getExercicio().intValue()), tipoDocumento).toString();
    }

    public void generateCadastroMobiliarioAndInscricaoMunicipal(String prefix, String token, String protocolo) throws BaseException {
        FacadeRedeSim facadeRedeSim = (FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class);
        FacadeSituacaoMobiliarioAlvara facadeSituacaoMobiliarioAlvara = (FacadeSituacaoMobiliarioAlvara)SpringContext.getBean(FacadeSituacaoMobiliarioAlvara.class);
        try {
            facadeSituacaoMobiliarioAlvara.existsSituacaoMobiliarioJuntaComercial();
            SolicitacaoRedeSimEntity solicitacaoRedeSimEntity = this.reloadSolicitacaoRedeSimEntity(protocolo);
            this.logger.info((Object)String.format("%s - [%s] Realizando a gera\u00e7\u00e3o do cadastro mobili\u00e1rio, referente ao envio autom\u00e1tico da inscri\u00e7\u00e3o municipal! protocolo: %s ", prefix, token, protocolo));
            if (solicitacaoRedeSimEntity.isMei() && SimNaoEnum.getSimShortText().equals(UtilsController.getValorParametroAlvara((ParametroAlvaraEnum)ParametroAlvaraEnum.CRIA_LAUDOS_AO_RECEBER_DADOS_EMPRESA))) {
                facadeRedeSim.generateCadastroLaudoAutomatico(protocolo, null, true);
            } else {
                facadeRedeSim.generateCadastroLaudoAutomatico(protocolo);
            }
            this.logger.info((Object)String.format("%s - [%s] Finalizando a gera\u00e7\u00e3o do cadastro mobili\u00e1rio, referente ao envio autom\u00e1tico da inscri\u00e7\u00e3o municipal! protocolo: %s ", prefix, token, protocolo));
            solicitacaoRedeSimEntity = this.reloadSolicitacaoRedeSimEntity(protocolo);
            if (facadeRedeSim.processaSolicitacaoBaixaRedeSim(prefix, token, protocolo)) {
                return;
            }
            this.logger.info((Object)String.format("%s - [%s] Realizando a gera\u00e7\u00e3o de inscri\u00e7\u00e3o municipal liberdade economica!", prefix, token));
            solicitacaoRedeSimEntity = facadeRedeSim.generateAndSendInscricaoMunicipalRedeSim(solicitacaoRedeSimEntity);
            this.logger.info((Object)String.format("%s - [%s] Finalizando a gera\u00e7\u00e3o de inscri\u00e7\u00e3o municipal liberdade economica!", prefix, token));
            if (Objects.nonNull(solicitacaoRedeSimEntity) && Objects.nonNull(solicitacaoRedeSimEntity.getSolicitacaoAlvara())) {
                if (solicitacaoRedeSimEntity.getSolicitacaoAlvara().isAlteracao()) {
                    this.logger.info((Object)String.format("%s - [%s] Realizando a altera\u00e7\u00e3o dos dados cadastrais na WEBISS", prefix, token));
                    facadeRedeSim.updateSolicitacaoRedeSimParaWebIss(solicitacaoRedeSimEntity, null);
                    this.logger.info((Object)String.format("%s - [%s] Finalizando a altera\u00e7\u00e3o dos dados cadastrais na WEBISS", prefix, token));
                }
                if (!solicitacaoRedeSimEntity.getSolicitacaoAlvara().isSolicitacaoMEI() && !solicitacaoRedeSimEntity.isSolicitacaoBaixa()) {
                    facadeRedeSim.adicionarHistoricoDeAndamento(solicitacaoRedeSimEntity, SituacaoConsultaPreviaRedeSimEnum.AGUARDANDO_SOLICITACAO, Optional.empty());
                }
            }
            solicitacaoRedeSimEntity = this.reloadSolicitacaoRedeSimEntity(protocolo);
            this.logger.info((Object)String.format("%s - [%s] Atualizando a solicita\u00e7\u00e3o da redesim como inscri\u00e7\u00e3o enviada!", prefix, token));
            facadeRedeSim.updateSolicitacaoEnvioInscricaoMunicipal(solicitacaoRedeSimEntity);
            this.logger.info((Object)String.format("%s - [%s] Finalizando a atualiza\u00e7\u00e3o da solicita\u00e7\u00e3o da redesim como inscri\u00e7\u00e3o enviada!", prefix, token));
        }
        catch (Exception ex) {
            this.logger.info((Object)String.format("%s - [%s] Erro: %s ", prefix, token, ex.getMessage()), (Throwable)ex);
            SolicitacaoRedeSimEntity solicitacaoRedeSimEntity = this.reloadSolicitacaoRedeSimEntity(protocolo);
            facadeRedeSim.adicionarHistoricoDeAndamento(solicitacaoRedeSimEntity, SituacaoConsultaPreviaRedeSimEnum.SOLICITACAO_INCONSISTENTE, Optional.ofNullable(ex.getMessage()));
            throw ex;
        }
    }

    public void setRepositoryDocumentoAise(RepositoryDocumentoAise repositoryDocumentoAise) {
        this.repositoryDocumentoAise = repositoryDocumentoAise;
    }

    public void setImprimeDocumentoAlvara(ImprimeDocumentoAlvara imprimeDocumentoAlvara) {
        this.imprimeDocumentoAlvara = imprimeDocumentoAlvara;
    }
}

