/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.service.impl;

import br.com.elotech.annotations.spring.EloService;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoRedeSimEntity;
import br.com.elotech.portalarrecadacao.domain.helper.CadastroMobiliarioHelper;
import br.com.elotech.portalarrecadacao.domain.vo.FiltroConsultaRedeSim;
import br.com.elotech.portalarrecadacao.enumerator.SituacaoConsultaPreviaRedeSimEnum;
import br.com.elotech.portalarrecadacao.exception.SolicitacaoAlvaraException;
import br.com.elotech.portalarrecadacao.repository.RepositoryConsultaRedeSim;
import br.com.elotech.portalarrecadacao.service.SrvConsultaPrevia;
import br.com.elotech.portalarrecadacao.service.SrvSolicitacaoAlvara;
import br.com.elotech.portalarrecadacao.service.SrvSolicitacaoAlvaraCBO;
import br.com.elotech.portalarrecadacao.service.SrvSolicitacaoAlvaraMEI;
import br.com.elotech.portalarrecadacao.service.SrvSolicitacaoAlvaraPrestadorServico;
import br.com.elotech.portalarrecadacao.service.SrvSolicitacaoAlvaraRedeSim;
import br.com.elotech.portalarrecadacao.service.SrvSolicitacaoAlvaraRedeSimAutomatizado;
import br.com.elotech.portalarrecadacao.service.SrvSolicitacaoDocumentoRedeSim;
import br.com.elotech.portalarrecadacao.service.impl.SrvSolicitacaoAlvaraHelperImpl;
import br.com.elotech.tributacao.domain.aise.CadastroGeralAiseEntity;
import br.com.elotech.tributacao.domain.aise.CadastroMobiliarioEntity;
import br.com.elotech.tributacao.domain.aise.PessoaEntity;
import br.com.elotech.tributacao.exception.CadastroMobiliarioException;
import br.com.elotech.tributacao.repository.RepositoryParametroGeral;
import br.com.elotech.tributacao.repository.aise.RepositoryPessoa;
import br.com.elotech.util.list.EloListUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Resource;

@EloService
public class SrvSolicitacaoAlvaraRedeSimAutomatizadoImpl
implements SrvSolicitacaoAlvaraRedeSimAutomatizado {
    @Resource
    private SrvSolicitacaoDocumentoRedeSim srvSolicitacaoDocumentoRedeSim;
    @Resource
    private RepositoryConsultaRedeSim repositoryConsultaRedeSim;
    @Resource
    private SrvSolicitacaoAlvaraHelperImpl srvSolicitacaoAlvaraHelper;
    @Resource
    private RepositoryPessoa repositoryPessoa;
    @Resource
    private SrvSolicitacaoAlvaraRedeSim srvSolicitacaoAlvaraRedeSim;
    @Resource
    private SrvSolicitacaoAlvara srvSolicitacaoAlvara;
    @Resource
    private SrvSolicitacaoAlvaraMEI srvSolicitacaoAlvaraMEI;
    @Resource
    private SrvSolicitacaoAlvaraCBO srvSolicitacaoAlvaraCBO;
    @Resource
    private SrvSolicitacaoAlvaraPrestadorServico srvSolicitacaoAlvaraPrestadorServico;
    @Resource
    private RepositoryParametroGeral repositoryParametroGeral;
    @Resource
    private SrvConsultaPrevia srvConsultaPrevia;

    public SolicitacaoAlvaraEntity iniciarCriacaoOuAlteracaoDeCadastro(SolicitacaoRedeSimEntity solicitacaoRedeSim) throws CadastroMobiliarioException {
        try {
            SolicitacaoAlvaraEntity solicitacaoAlvara = solicitacaoRedeSim.getSolicitacaoAlvara();
            if (this.repositoryParametroGeral.verificaIntegradoGeo().booleanValue()) {
                this.carregarCadastroMobiliarioNaSolicitacao(solicitacaoAlvara);
            }
            if (solicitacaoRedeSim.getSolicitacaoAlvara().isNaturezaInicial()) {
                this.srvSolicitacaoAlvaraRedeSim.criarCadastroMobiliario(solicitacaoRedeSim, Optional.empty());
            } else {
                if (Objects.isNull(solicitacaoAlvara.getCadastroMobiliario())) {
                    throw new SolicitacaoAlvaraException("N\u00e3o existe um cadastro mobili\u00e1rio com este CNPJ.");
                }
                if (solicitacaoAlvara.isSolicitacaoJuridicaNormal()) {
                    solicitacaoAlvara = this.srvSolicitacaoAlvara.salvarSolicitacaoAlvaraAlteracao(solicitacaoAlvara);
                } else if (solicitacaoAlvara.isSolicitacaoPrestadorServico()) {
                    solicitacaoAlvara = this.srvSolicitacaoAlvaraPrestadorServico.salvarSolicitacaoAlvaraAlteracao(solicitacaoAlvara);
                } else if (solicitacaoAlvara.isSolicitacaoMEI()) {
                    solicitacaoAlvara = this.srvSolicitacaoAlvaraMEI.salvarSolicitacaoAlvaraAlteracao(solicitacaoAlvara);
                } else if (solicitacaoAlvara.isSolicitacaoCBO()) {
                    solicitacaoAlvara = this.srvSolicitacaoAlvaraCBO.salvarSolicitacaoAlvaraAlteracao(solicitacaoAlvara);
                }
            }
            return solicitacaoAlvara;
        }
        catch (BaseException e) {
            throw new CadastroMobiliarioException(String.format("Falha ao gerar ou atualizar cadastro: %s", e.getMessage()), (Throwable)e);
        }
    }

    private void carregarCadastroMobiliarioNaSolicitacao(SolicitacaoAlvaraEntity solicitacaoAlvara) throws CadastroMobiliarioException, BaseException {
        List pessoasCadastradas = this.repositoryPessoa.carregaPessoasPorCpfCnpj(solicitacaoAlvara.getCpfCnpj());
        if (!EloListUtils.safeIsEmpty((List)pessoasCadastradas).booleanValue()) {
            Object cadastroMobiliario = new CadastroMobiliarioEntity();
            if (this.srvSolicitacaoAlvaraHelper.isPermitirPessoaAtivaComCadastroBaixado().booleanValue()) {
                PessoaEntity pessoaExistente = (PessoaEntity)pessoasCadastradas.stream().findFirst().get();
                this.srvSolicitacaoAlvaraHelper.validarPermissaoPessoaAtivaComCadastrosBaixados(pessoaExistente);
                cadastroMobiliario.setCadastroGeral(new CadastroGeralAiseEntity());
                cadastroMobiliario.getCadastroGeral().setPessoa(pessoaExistente);
            } else {
                CadastroMobiliarioHelper cadastroHelper = this.srvSolicitacaoAlvaraHelper.carregaCadastroHelper((PessoaEntity)pessoasCadastradas.stream().findFirst().get(), Boolean.FALSE.booleanValue());
                cadastroMobiliario = cadastroHelper != null ? cadastroHelper.getCadastroMobiliario() : null;
            }
            solicitacaoAlvara.setCadastroMobiliario(cadastroMobiliario);
        }
    }

    public void validaCnpjPJ(SolicitacaoAlvaraEntity solicitacaoAlvara) throws BaseException, CadastroMobiliarioException {
    }

    protected List<SolicitacaoRedeSimEntity> getSolicitacaoAguardandoSolicitacaoDocumento() {
        FiltroConsultaRedeSim filtro = new FiltroConsultaRedeSim.FiltroConsultaRedeSimBuilder().build();
        ArrayList situacao = Lists.newArrayList();
        situacao.add(SituacaoConsultaPreviaRedeSimEnum.ANALISE.getSigla());
        filtro.setSituacao((List)situacao);
        filtro.setTipo("S");
        return this.repositoryConsultaRedeSim.carregarListaConsultaRedeSim(filtro);
    }
}

