/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.service.impl;

import br.com.elotech.annotations.spring.EloService;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.portalarrecadacao.controller.UtilsController;
import br.com.elotech.portalarrecadacao.domain.LaudoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.ParametroAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraAtividadeEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.StatusLaudoAlvara;
import br.com.elotech.portalarrecadacao.domain.helper.ImprimirTaxasAlvara;
import br.com.elotech.portalarrecadacao.enumerator.NaturezaSolicitacaoAlvaraEnum;
import br.com.elotech.portalarrecadacao.enumerator.ParametroAlvaraEnum;
import br.com.elotech.portalarrecadacao.enumerator.ParametroAlvaraNaturezaEnum;
import br.com.elotech.portalarrecadacao.exception.GeraDebitoException;
import br.com.elotech.portalarrecadacao.exception.SolicitacaoAlvaraException;
import br.com.elotech.portalarrecadacao.repository.RepositoryCnaePrestadorServico;
import br.com.elotech.portalarrecadacao.repository.RepositoryLaudoAlvara;
import br.com.elotech.portalarrecadacao.repository.RepositoryParametroAlvara;
import br.com.elotech.portalarrecadacao.repository.RepositorySolicitacaoAlvara;
import br.com.elotech.portalarrecadacao.repository.RepositoryTipoLaudo;
import br.com.elotech.portalarrecadacao.service.SrvContratoSocial;
import br.com.elotech.portalarrecadacao.service.SrvDebitosPortal;
import br.com.elotech.portalarrecadacao.service.SrvSolicitacaoAlvaraPrestadorServico;
import br.com.elotech.portalarrecadacao.service.impl.SrvAndamentoLaudoAlvaraImpl;
import br.com.elotech.portalarrecadacao.service.impl.SrvSolicitacaoAlvaraHelperImpl;
import br.com.elotech.tributacao.domain.aise.CadastroGeralAiseEntity;
import br.com.elotech.tributacao.domain.aise.CadastroImobiliarioSegmentoEntity;
import br.com.elotech.tributacao.domain.aise.DebitoEntity;
import br.com.elotech.tributacao.domain.aise.EntidadeAiseEntity;
import br.com.elotech.tributacao.domain.aise.TipoLaudoEntity;
import br.com.elotech.tributacao.domain.aise.UsuarioEntity;
import br.com.elotech.tributacao.enumerator.SimNaoEnum;
import br.com.elotech.tributacao.enumerator.TipoLaudoEnum;
import br.com.elotech.tributacao.exception.CadastroMobiliarioException;
import br.com.elotech.tributacao.interfaces.Atividade;
import br.com.elotech.tributacao.repository.aise.RepositoryAtividadeMei;
import br.com.elotech.tributacao.repository.aise.RepositoryCadastroGeral;
import br.com.elotech.tributacao.repository.aise.RepositoryCadastroMobiliario;
import br.com.elotech.tributacao.repository.aise.RepositoryDebito;
import br.com.elotech.tributacao.repository.aise.RepositoryEntidadeTributacao;
import br.com.elotech.tributacao.repository.aise.RepositoryImobiliarioSegmento;
import br.com.elotech.tributacao.repository.aise.RepositoryImobiliarioTestada;
import br.com.elotech.tributacao.repository.aise.RepositoryMobiliarioSituacao;
import br.com.elotech.tributacao.repository.aise.RepositoryPessoa;
import br.com.elotech.util.date.EloDateUtils;
import br.com.elotech.util.list.EloListUtils;
import br.com.elotech.util.math.EloNumberUtils;
import br.com.elotech.util.string.EloStringUtils;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Resource;

@EloService(value="srvSolicitacaoAlvaraPrestadorServico")
public class SrvSolicitacaoAlvaraPrestadorServicoImpl
extends SrvSolicitacaoAlvaraHelperImpl
implements SrvSolicitacaoAlvaraPrestadorServico {
    @Resource
    private RepositoryPessoa repositoryPessoa;
    @Resource
    private RepositoryCadastroMobiliario repositoryCadastroMobiliario;
    @Resource
    private RepositoryMobiliarioSituacao repositoryMobiliarioSituacao;
    @Resource
    private RepositoryCadastroGeral repositoryCadastroGeral;
    @Resource
    private RepositoryCnaePrestadorServico repositoryCnaePrestadorServico;
    @Resource
    private RepositoryLaudoAlvara repositoryLaudoAlvara;
    @Resource
    private RepositoryParametroAlvara repositoryParametroAlvara;
    @Resource
    private RepositoryEntidadeTributacao repositoryEntidadeTributacao;
    @Resource
    private RepositoryImobiliarioSegmento repositoryImobiliarioSegmento;
    @Resource
    private RepositoryTipoLaudo repositoryTipoLaudo;
    @Resource
    private RepositoryDebito repositoryDebito;
    @Resource
    private SrvDebitosPortal srvDebitosPortal;
    @Resource
    private RepositorySolicitacaoAlvara repositorySolicitacaoAlvara;
    @Resource
    private RepositoryImobiliarioTestada repositoryImobTestada;
    @Resource
    private SrvContratoSocial srvContratoSocial;
    @Resource
    private RepositoryAtividadeMei repositoryAtividadeMei;
    @Resource
    private SrvAndamentoLaudoAlvaraImpl srvAndamentoLaudoAlvara;

    public void salvarConsultaPrevia(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        this.salvarConsultaPreviaSolicitacao(solicitacao);
    }

    public void salvarConsultaPreviaSolicitacao(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        solicitacao.setRenovacao("N");
        if (solicitacao.isNaturezaInicial() || solicitacao.isNaturezaAlteracaoAtividade()) {
            this.atribuirIdAtividadesSolicitacao(solicitacao);
        }
        this.inserirDataValidadeNaSolicitacao(solicitacao);
        this.salvarSolicitacaoAlvara(solicitacao);
    }

    public void verificarCadastrosDuplicados(SolicitacaoAlvaraEntity solicitacao) throws CadastroMobiliarioException {
        try {
            if (solicitacao.isNaturezaInicial()) {
                List pessoasCadastradas = null;
                pessoasCadastradas = this.repositoryPessoa.carregaListaPessoaPorCpfCnpjNome(solicitacao.getCadastroMobiliario().getCadastroGeral().getPessoa().getCnpjCpf(), null);
                if (pessoasCadastradas != null && !pessoasCadastradas.isEmpty()) {
                    String paramTipoPessoa = this.getParamAlvaraNatureza(ParametroAlvaraNaturezaEnum.VALIDATIPOPESSOAMOBEXISTENTE, this.getNatureza(NaturezaSolicitacaoAlvaraEnum.INICIAL.getValue()), solicitacao.getTipoDeInscricao()).getValor();
                    String paramSitMobiliario = this.getParamAlvaraNatureza(ParametroAlvaraNaturezaEnum.VALIDASITUACAOMOBEXISTENTE, this.getNatureza(NaturezaSolicitacaoAlvaraEnum.INICIAL.getValue()), solicitacao.getTipoDeInscricao()).getValor();
                    if (this.repositoryCadastroMobiliario.verificarTipoPessoaSituacaoMobiliariaParaAlvaraInicial(pessoasCadastradas, EloStringUtils.strToLong((String[])paramTipoPessoa.split(",")), EloStringUtils.strToLong((String[])paramSitMobiliario.split(",")))) {
                        throw new CadastroMobiliarioException("J\u00e1 Existe um cadastro mobili\u00e1rio com este CPF/CNPJ, Entre em contato com o setor de Alvar\u00e1 da Prefeitura. ");
                    }
                }
            }
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new CadastroMobiliarioException(String.format("%s%s", "Ocorreu uma falha na verifica\u00e7\u00e3o do cadastro mobili\u00e1rio. ", e.getMessage()));
        }
    }

    public SolicitacaoAlvaraEntity salvarSolicitacaoInicial(SolicitacaoAlvaraEntity solicitacaoAlvara) throws BaseException {
        solicitacaoAlvara.getCadastroMobiliario().getCadastroGeral().setExclusaoLogica("N");
        this.salvarSolicitacaoAlvaraInicial(solicitacaoAlvara, false);
        Set laudos = this.getLaudosAGerar(solicitacaoAlvara);
        this.geraLaudo(solicitacaoAlvara, laudos);
        return solicitacaoAlvara;
    }

    public SolicitacaoAlvaraEntity salvarSolicitacaoAlvaraAlteracao(SolicitacaoAlvaraEntity solicitacao) throws SolicitacaoAlvaraException {
        return this.saveSolicitacaoAlvaraEventosAlteracao(solicitacao, true);
    }

    public SolicitacaoAlvaraEntity salvarSolicitacaoAlvaraAlteracaoSemLaudo(SolicitacaoAlvaraEntity solicitacao) throws SolicitacaoAlvaraException {
        return this.saveSolicitacaoAlvaraEventosAlteracao(solicitacao, false);
    }

    private SolicitacaoAlvaraEntity saveSolicitacaoAlvaraEventosAlteracao(SolicitacaoAlvaraEntity solicitacao, boolean habilitaGeracaoLaudo) {
        try {
            solicitacao.setDataSolicitacao(Calendar.getInstance().getTime());
            if (solicitacao.isRedeSim() && (solicitacao.isNaturezaAlteracaoSocio() || Objects.isNull(solicitacao.getContratoSocial()))) {
                solicitacao = this.srvContratoSocial.preencherContratoSocialBySolicitacao(solicitacao);
            }
            solicitacao.setDataSolicitacao(Calendar.getInstance().getTime());
            this.carregarEsalvarAtividadesNaSolicitacao(solicitacao);
            this.logger.info((Object)"adicionaSolicitacaoContratoSocial------- salvarSolicitacaoAlvaraAlteracao");
            this.adicionaSolicitacaoContratoSocial(solicitacao);
            solicitacao.atribuirGrauRiscoCadastroMobiliario();
            if (solicitacao.isNaturezaAlteracaoAtividade()) {
                this.alteraAtividadePrincipalDaSolicitacao(solicitacao);
            }
            if (habilitaGeracaoLaudo) {
                if (solicitacao.isAlteracaoRazaoOuSocioOuRazaoESocio()) {
                    if (solicitacao.isSituacaoMobiliarioDesatualizadoOuVencido()) {
                        this.gerarLaudos(solicitacao);
                    }
                } else {
                    this.gerarLaudos(solicitacao);
                }
            }
            if (Objects.nonNull(solicitacao.getCadastroMobiliario())) {
                this.salvarCadastroGeralIsencao(solicitacao.getCadastroMobiliario(), solicitacao);
                this.atualizarNaturezaJuridica(solicitacao);
            }
            solicitacao.setFinalizado(SimNaoEnum.SIM.getShortText());
            solicitacao = this.repositorySolicitacaoAlvara.saveOrUpdate(solicitacao);
            return solicitacao;
        }
        catch (BaseException se) {
            this.logger.error((Object)se.getMessage(), (Throwable)se);
            return null;
        }
    }

    public void gerarLaudos(SolicitacaoAlvaraEntity solicitacao) throws BaseException, SolicitacaoAlvaraException {
        Set laudos = this.getLaudosAGerar(solicitacao);
        if (EloListUtils.safeIsEmpty((List)solicitacao.getLaudos()).booleanValue() && (this.validaGeraLaudoPrestadorServico(solicitacao) || !laudos.isEmpty())) {
            this.geraLaudo(solicitacao, laudos);
        }
    }

    public boolean validaGeraLaudoPrestadorServico(SolicitacaoAlvaraEntity solicitacao) throws BaseException, SolicitacaoAlvaraException {
        if (solicitacao.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.MUDANCA_RAZAO_SOCIAL}) && this.validaAlteracaoGeraLaudo(solicitacao, NaturezaSolicitacaoAlvaraEnum.MUDANCA_RAZAO_SOCIAL)) {
            return true;
        }
        if (solicitacao.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.MUDANCA_ENDERECO})) {
            return true;
        }
        return solicitacao.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.ALTERACAO_ATIVIDADE});
    }

    public void geraLaudo(SolicitacaoAlvaraEntity solicitacao, Set<TipoLaudoEntity> laudos) {
        ArrayList<LaudoAlvaraEntity> listaLaudos = new ArrayList<LaudoAlvaraEntity>();
        if (!laudos.isEmpty()) {
            try {
                for (TipoLaudoEntity tipoLaudo : laudos) {
                    LaudoAlvaraEntity laudoAlvara = new LaudoAlvaraEntity();
                    laudoAlvara.setTipoLaudo(tipoLaudo);
                    laudoAlvara.setIdSolicitacaoAlvara(solicitacao);
                    laudoAlvara.setIdLaudoAlvara(this.repositoryLaudoAlvara.getSequence());
                    laudoAlvara.setUsuario((UsuarioEntity)this.getUsuarioLogado());
                    if (this.gerarLaudoLiberadoRiscoBaixo(solicitacao)) {
                        laudoAlvara.setStatus(StatusLaudoAlvara.LAUDO_LIBERADO_RISCO_B);
                        laudoAlvara.setVistoriar("N");
                    } else {
                        laudoAlvara.setStatus(StatusLaudoAlvara.EM_ANDAMENTO);
                    }
                    laudoAlvara = this.repositoryLaudoAlvara.saveOrUpdate(laudoAlvara);
                    if (this.gerarLaudoLiberadoRiscoBaixo(solicitacao)) {
                        this.srvAndamentoLaudoAlvara.adicionarAndamentoLaudoRiscoBaixo(laudoAlvara, laudoAlvara.getUsuario());
                    }
                    listaLaudos.add(laudoAlvara);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        solicitacao.setLaudos(listaLaudos);
    }

    private EntidadeAiseEntity getEntidade() {
        EntidadeAiseEntity entidade = this.repositoryEntidadeTributacao.getExercicioAtual(Long.valueOf(EloDateUtils.getYear((Date)new Date()))).getId().getEntidade();
        return entidade;
    }

    public Set<TipoLaudoEntity> getLaudosAGerar(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        if (EloListUtils.safeIsEmpty((List)solicitacao.getSolicitacaoAlvaraAtividades()).booleanValue()) {
            throw new SolicitacaoAlvaraException("N\u00e3o existe Atividade para este cadastro mobili\u00e1rio.\nPor gentileza, enviar e-mail para \"" + this.getEmailSetorCadastroAlvara() + "\" informando o cadastro da inscri\u00e7\u00e3o.");
        }
        HashSet<TipoLaudoEntity> laudos = new HashSet<TipoLaudoEntity>();
        for (SolicitacaoAlvaraAtividadeEntity atividade : solicitacao.getSolicitacaoAlvaraAtividades()) {
            if (solicitacao.isSolicitacaoPrestadorServico()) {
                laudos.addAll(this.repositoryCnaePrestadorServico.carregaLaudosPorCnae(atividade.getCnae()));
                continue;
            }
            if (!solicitacao.isSolicitacaoMEIPrestador()) continue;
            laudos.addAll(this.repositoryAtividadeMei.load(atividade.getAtividadeMei().getAtividadeMei()).getTiposLaudo());
        }
        return laudos;
    }

    public TipoLaudoEntity verificarTiposSegmento(SolicitacaoAlvaraEntity solicitacao) throws SolicitacaoAlvaraException {
        EntidadeAiseEntity entidade = this.getEntidade();
        ParametroAlvaraEntity paramSegmentoResidencial = this.repositoryParametroAlvara.getParametroAlvara(entidade, ParametroAlvaraEnum.TIPO_SEGMENTO_RESIDENCIAL);
        String tiposSegmentosResidenciais = paramSegmentoResidencial.getValor();
        Long[] segmentosResidencialLong = EloStringUtils.strToLong((String[])tiposSegmentosResidenciais.split(","));
        ParametroAlvaraEntity paramSegmentoComercial = this.repositoryParametroAlvara.getParametroAlvara(entidade, ParametroAlvaraEnum.TIPO_SEGMENTO_COMERCIAL);
        String tiposSegmentosComerciais = paramSegmentoComercial.getValor();
        Long[] segmentosComercialLong = EloStringUtils.strToLong((String[])tiposSegmentosComerciais.split(","));
        List imobiliarioSegmentos = this.repositoryImobiliarioSegmento.getImobiliarioSegmentoPorCadastroImobiliairo(solicitacao.getCadastroImobiliario().getCadastroGeral());
        Boolean temSegmentoResidencial = false;
        Boolean temSegmentoComercial = false;
        TipoLaudoEntity tipoLaudoPostura = null;
        for (CadastroImobiliarioSegmentoEntity imobSeg : imobiliarioSegmentos) {
            for (Long segmentoComercial : segmentosComercialLong) {
                if (segmentoComercial.compareTo(imobSeg.getTipoSegmento().getTipoSegmento()) != 0) continue;
                temSegmentoComercial = true;
            }
        }
        for (CadastroImobiliarioSegmentoEntity imobSeg : imobiliarioSegmentos) {
            for (Long segmentoResidencial : segmentosResidencialLong) {
                if (segmentoResidencial.compareTo(imobSeg.getTipoSegmento().getTipoSegmento()) != 0) continue;
                temSegmentoResidencial = true;
            }
        }
        if (temSegmentoResidencial.booleanValue() && temSegmentoComercial.booleanValue()) {
            tipoLaudoPostura = this.repositoryTipoLaudo.getTipoLaudoPorCodigo(TipoLaudoEnum.POSTURA);
        } else if (!temSegmentoResidencial.booleanValue() && temSegmentoComercial.booleanValue() || !temSegmentoResidencial.booleanValue() && !temSegmentoComercial.booleanValue()) {
            throw new SolicitacaoAlvaraException("Este im\u00f3vel n\u00e3o possui Tipo de Segmento residencial.");
        }
        return tipoLaudoPostura;
    }

    public ImprimirTaxasAlvara imprimirTaxaPrestadorServico(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        try {
            if (!solicitacao.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.INICIAL}) && !this.verificaSitCadastroParaAlteracoes(solicitacao).booleanValue()) {
                throw new SolicitacaoAlvaraException("Situa\u00e7\u00e3o do Cadastro N\u00e3o \u00e9 v\u00e1lida ou Existe uma data de Validade sem Laudos no alvar\u00e1 online.");
            }
            DebitoEntity debitoAlvara = new DebitoEntity();
            solicitacao = this.repositorySolicitacaoAlvara.buscaSolicitacaoPorCpfCnpjExercicioNumSolic(solicitacao.getNumeroSolicitacao(), solicitacao.getExercicio(), null);
            debitoAlvara = this.geraDebitoSolicitacao(solicitacao);
            UsuarioEntity usuario = this.getUsuarioLogadoFromSolicitacao(solicitacao);
            if (usuario != null) {
                Integer idBloqueto;
                if (debitoAlvara != null && !EloListUtils.safeIsEmpty((List)debitoAlvara.getParcelas()).booleanValue() && EloNumberUtils.isBiggerThanZero((Number)(idBloqueto = this.srvDebitosPortal.geraBloqueto(debitoAlvara.getParcelas()))).booleanValue()) {
                    return new ImprimirTaxasAlvara(idBloqueto.toString(), UtilsController.getExercicio());
                }
                return null;
            }
            throw new GeraDebitoException(" Usu\u00e1rio n\u00e3o Autenticado!");
        }
        catch (SolicitacaoAlvaraException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new SolicitacaoAlvaraException(e.getMessage());
        }
    }

    private boolean verificaSituacaoLaudo(List<LaudoAlvaraEntity> listaLaudos) {
        boolean renderBotao = true;
        if (!EloListUtils.safeIsEmpty(listaLaudos).booleanValue()) {
            for (LaudoAlvaraEntity laudo : listaLaudos) {
                if (StatusLaudoAlvara.LIBERADO_PROVISORIO == laudo.getStatus() || StatusLaudoAlvara.LIBERADO_DEFINITIVO == laudo.getStatus()) continue;
                renderBotao = false;
                break;
            }
        }
        return renderBotao;
    }

    private DebitoEntity geraDebitoSolicitacao(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        DebitoEntity debitosAlvara = this.carregaDebitosSolicitacao(solicitacao, this.getExercicio());
        if ((solicitacao.isNaturezaInicial() || !this.getLaudosAGerar(solicitacao).isEmpty()) && debitosAlvara == null) {
            this.geraDebitoLaudo(solicitacao);
            this.repositoryDebito.flush();
            debitosAlvara = this.carregaDebitosSolicitacao(solicitacao, this.getExercicio());
        }
        return debitosAlvara;
    }

    public CadastroGeralAiseEntity alteraSituacaoCadastroExclusaoLogica(CadastroGeralAiseEntity cadastroGeral, String situacao) {
        cadastroGeral.setExclusaoLogica(situacao);
        return this.repositoryCadastroGeral.saveOrUpdate(cadastroGeral);
    }

    public void imprimirAlvara(SolicitacaoAlvaraEntity solicitacao) throws BaseException, URISyntaxException {
        DebitoEntity debitoAlvara = null;
        debitoAlvara = this.repositoryDebito.possuiDebitoNaSolicitacaoByExercicio(solicitacao.getSolicitacaoAlvara(), this.getExercicio());
        if (debitoAlvara == null && !this.getLaudosAGerar(solicitacao).isEmpty()) {
            throw new GeraDebitoException("Clique no Bot\u00e3o de Imprimir Taxas antes de Imprimir o Alvar\u00e1");
        }
        if (!EloListUtils.safeIsEmpty((List)solicitacao.getLaudos()).booleanValue() && !this.verificaSituacaoLaudo(solicitacao.getLaudos())) {
            throw new SolicitacaoAlvaraException("Todos os Laudos devem estar Liberados");
        }
        if (!this.verificaVencimentoLaudo(solicitacao).booleanValue()) {
            throw new SolicitacaoAlvaraException("N\u00e3o \u00e9 poss\u00edvel imprimir o alvar\u00e1, existem laudos ou documentos vencidos. Acompanhar a libera\u00e7\u00e3o dos laudos.");
        }
        if (!solicitacao.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.INICIAL}) && !this.verificaSitCadastroParaAlteracoes(solicitacao).booleanValue()) {
            throw new SolicitacaoAlvaraException("Situa\u00e7\u00e3o do Cadastro N\u00e3o \u00e9 v\u00e1lida ou Existe uma data de Validade sem Laudos no alvar\u00e1 online.");
        }
        if (!solicitacao.isNaturezaInicial() && solicitacao.getNumeroAlvara() == null && !"S".equals(solicitacao.getEfetivado())) {
            this.efetivaAlteracaoSolicitacao(solicitacao);
        }
        this.verificaSituacaoVencidoOuDesatualizado(solicitacao);
        List listaValidadeAlvaraAtual = this.retornaValidadeAlvaraAtualPorSolitacao(solicitacao);
        List listaValidadeAlvaraCorrente = this.carregaListaVencimentoAlvara(solicitacao);
        solicitacao.setObservacoes("");
        solicitacao.setObservacoes(this.montaObservacoesAlvara(solicitacao));
        solicitacao.setObservacoes(this.concatenarObservacaoPrestadorServico(solicitacao.getObservacoes()));
        if (!EloListUtils.safeIsEmpty((List)solicitacao.getLaudos()).booleanValue() && solicitacao.isTodosLaudosLiberados()) {
            solicitacao.setDataValidadeProvisorio(null);
            solicitacao.getCadastroMobiliario().setDataValidadeAlvara(null);
        }
        solicitacao.getCadastroMobiliario().setObservacaoAlvara(solicitacao.getObservacoes());
        solicitacao.setCadastroMobiliario(this.salvarCadastroMobiliario(solicitacao.getCadastroMobiliario()));
        this.atualizarSolicitacaoAlvara(solicitacao);
        this.gerarEImprimirDocumento(listaValidadeAlvaraAtual, listaValidadeAlvaraCorrente, solicitacao);
        this.atualizarSolicitacaoAlvara(solicitacao);
    }

    public void efetivaAlteracaoSolicitacao(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        solicitacao.getCadastroMobiliario().setAtividadePrincipal(solicitacao.getDescricaoAtividades());
        solicitacao.getCadastroMobiliario().setTelefone(solicitacao.getTelefonePreenchido());
        solicitacao.setEfetivado(SimNaoEnum.SIM.getShortText());
        if (solicitacao.isNaturezaMudancaRazaoSocial()) {
            this.salvarAlteracaoRazaoSocial(solicitacao);
        }
        if (solicitacao.isNaturezaMudancaEndereco()) {
            this.salvarAlteracaoEndereco(solicitacao);
        }
        if (solicitacao.isNaturezaAlteracaoAtividade()) {
            this.salvarAlteracaoAtividade(solicitacao);
        }
        if (solicitacao.isNaturezaAlteracaoSocio()) {
            this.salvarAlteracaoSocio(solicitacao);
        }
        this.atualizarContatoPessoa(solicitacao);
        this.salvarObservacao(solicitacao);
    }

    public void generateLaudos(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        this.gerarLaudos(solicitacao);
    }

    private String concatenarObservacaoPrestadorServico(String obs) {
        StringBuilder sb = new StringBuilder(obs);
        sb.append("ESTA INSCRI\u00c7\u00c3O N\u00c3O AUTORIZA");
        sb.append(" O EXERC\u00cdCIO DE ATIVIDADE NO IM\u00d3VEL");
        sb.append(" CONSTANTE NESTE DOCUMENTO");
        return sb.toString();
    }

    protected void salvarAlteracaoAtividade(SolicitacaoAlvaraEntity solicitacao) {
        this.carregaMobiliarioAtividades(solicitacao);
    }

    public Boolean verificaCnaePrestadorServico(Atividade atividade) {
        return this.repositoryCnaePrestadorServico.verificaCnaePrestadorServico(atividade);
    }

    public Boolean verificaCnaePrestadorServico(List<String> codigos) {
        return this.repositoryCnaePrestadorServico.verificaCnaePrestadorServico(codigos);
    }
}

