/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.service.impl;

import br.com.elotech.annotations.spring.EloService;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.portalarrecadacao.controller.UtilsController;
import br.com.elotech.portalarrecadacao.domain.ClassificacaoTipoInscricaoEntity;
import br.com.elotech.portalarrecadacao.domain.CnaePerimetroEntity;
import br.com.elotech.portalarrecadacao.domain.HistoricoRenovacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.LaudoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.LaudoExigidoEntity;
import br.com.elotech.portalarrecadacao.domain.NaturezaSolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.ParametroAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.ParametroAlvaraNaturezaEntity;
import br.com.elotech.portalarrecadacao.domain.RestricaoConsultaPreviaEntity;
import br.com.elotech.portalarrecadacao.domain.ScriptAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraAtividadeEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraDebitoEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraDocumentoEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraValidadeSefazEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoContratoSocialEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoContratoSocialPessoaEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoDocRedeSimEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoRedeSimEntity;
import br.com.elotech.portalarrecadacao.domain.StatusLaudoAlvara;
import br.com.elotech.portalarrecadacao.domain.helper.ImprimirTaxasAlvara;
import br.com.elotech.portalarrecadacao.domain.vo.ConsultaAtividadeVo;
import br.com.elotech.portalarrecadacao.domain.vo.ConsultaPreviaVo;
import br.com.elotech.portalarrecadacao.domain.vo.DebitoAlvaraVo;
import br.com.elotech.portalarrecadacao.domain.vo.DebitoLaudoVo;
import br.com.elotech.portalarrecadacao.domain.vo.RestricaoAlvaraVo;
import br.com.elotech.portalarrecadacao.dto.VerificacaoGeracaoLaudoDTO;
import br.com.elotech.portalarrecadacao.dto.solicitacaoalvara.SolicitacaoAlvaraObservacaoDTO;
import br.com.elotech.portalarrecadacao.enumerator.GrauDeRiscoEnum;
import br.com.elotech.portalarrecadacao.enumerator.MotivoIndeferimentoRedeSimEnum;
import br.com.elotech.portalarrecadacao.enumerator.NaturezaSolicitacaoAlvaraEnum;
import br.com.elotech.portalarrecadacao.enumerator.ParametroAlvaraEnum;
import br.com.elotech.portalarrecadacao.enumerator.ParametroAlvaraNaturezaEnum;
import br.com.elotech.portalarrecadacao.enumerator.ParametroEntidadeExercicioEnum;
import br.com.elotech.portalarrecadacao.enumerator.TipoScriptAlvaraEnum;
import br.com.elotech.portalarrecadacao.enumerator.TipoSolicitacaoRedeSimEnum;
import br.com.elotech.portalarrecadacao.exception.AtividadeNaoConfiguradaException;
import br.com.elotech.portalarrecadacao.exception.GeraDebitoException;
import br.com.elotech.portalarrecadacao.exception.GuiaRecolhimentoNaoEncontradaException;
import br.com.elotech.portalarrecadacao.exception.IndeferimentoRedeSimException;
import br.com.elotech.portalarrecadacao.exception.ParametroNaoEncontradoException;
import br.com.elotech.portalarrecadacao.exception.ShowMessage;
import br.com.elotech.portalarrecadacao.exception.SolicitacaoAlvaraException;
import br.com.elotech.portalarrecadacao.exception.SolicitacaoAlvaraRedeSimException;
import br.com.elotech.portalarrecadacao.facade.FacadeCadastroImobiliario;
import br.com.elotech.portalarrecadacao.facade.FacadeSolicitacaoAlvara;
import br.com.elotech.portalarrecadacao.factory.SrvConsultaAtividadeFactory;
import br.com.elotech.portalarrecadacao.integration.dto.consulta.Atividades;
import br.com.elotech.portalarrecadacao.integration.dto.consulta.Pergunta;
import br.com.elotech.portalarrecadacao.repository.RepositoryClassificacaoTipoInscricao;
import br.com.elotech.portalarrecadacao.repository.RepositoryCnaePerimetro;
import br.com.elotech.portalarrecadacao.repository.RepositoryConsultaRedeSim;
import br.com.elotech.portalarrecadacao.repository.RepositoryHistoricoRenovacaoAlvara;
import br.com.elotech.portalarrecadacao.repository.RepositoryLaudoAlvara;
import br.com.elotech.portalarrecadacao.repository.RepositoryLaudoExigido;
import br.com.elotech.portalarrecadacao.repository.RepositoryParametroAlvara;
import br.com.elotech.portalarrecadacao.repository.RepositoryParametroAlvaraNatureza;
import br.com.elotech.portalarrecadacao.repository.RepositoryRestricaoConsultaPrevia;
import br.com.elotech.portalarrecadacao.repository.RepositoryScriptAlvara;
import br.com.elotech.portalarrecadacao.repository.RepositorySolicitacaoAlvara;
import br.com.elotech.portalarrecadacao.repository.RepositorySolicitacaoAlvaraAtividade;
import br.com.elotech.portalarrecadacao.repository.RepositorySolicitacaoAlvaraDebito;
import br.com.elotech.portalarrecadacao.repository.RepositorySolicitacaoAlvaraDocumento;
import br.com.elotech.portalarrecadacao.repository.RepositorySolicitacaoAlvaraNumConselho;
import br.com.elotech.portalarrecadacao.repository.RepositorySolicitacaoAlvaraValidade;
import br.com.elotech.portalarrecadacao.repository.RepositorySolicitacaoAlvaraValidadeSefaz;
import br.com.elotech.portalarrecadacao.repository.RepositorySolicitacaoContratoSocial;
import br.com.elotech.portalarrecadacao.repository.RepositorySolicitacaoContratoSocialPessoa;
import br.com.elotech.portalarrecadacao.repository.RepositorySolicitacaoDocRedeSim;
import br.com.elotech.portalarrecadacao.repository.RepositoryTipoLaudo;
import br.com.elotech.portalarrecadacao.rest.dto.SolicitacaoAlvaraRedeSimDTO;
import br.com.elotech.portalarrecadacao.rest.dto.SolicitacaoDocumentosDTO;
import br.com.elotech.portalarrecadacao.service.SrvConsultaAtividade;
import br.com.elotech.portalarrecadacao.service.SrvConsultaPrevia;
import br.com.elotech.portalarrecadacao.service.SrvContratoSocial;
import br.com.elotech.portalarrecadacao.service.SrvDebitosPortal;
import br.com.elotech.portalarrecadacao.service.SrvDesvincularPessoaComCadastro;
import br.com.elotech.portalarrecadacao.service.SrvGeraBoletimMobiliario;
import br.com.elotech.portalarrecadacao.service.SrvMontaObsAlvara;
import br.com.elotech.portalarrecadacao.service.SrvParametroAlvara;
import br.com.elotech.portalarrecadacao.service.SrvSolicitacaoAlvara;
import br.com.elotech.portalarrecadacao.service.SrvSolicitacaoAlvaraPrestadorServico;
import br.com.elotech.portalarrecadacao.service.impl.SrvAndamentoLaudoAlvaraImpl;
import br.com.elotech.portalarrecadacao.service.impl.SrvFindTipoInscricaoAlvaraImpl;
import br.com.elotech.portalarrecadacao.service.impl.SrvSolicitacaoAlvaraHelperImpl;
import br.com.elotech.portalarrecadacao.service.impl.SrvSolicitacaoAlvaraPrestadorServicoImpl;
import br.com.elotech.portalarrecadacao.service.impl.SrvWebServiceGeoImpl;
import br.com.elotech.portalarrecadacao.utils.params.PortalUtils;
import br.com.elotech.portalarrecadacao.ws.oxm.geo.AtividadesPermitidasEnvio;
import br.com.elotech.portalarrecadacao.ws.oxm.geo.AtividadesPermitidasMensagem;
import br.com.elotech.portalarrecadacao.ws.oxm.geo.AtividadesPermitidasResposta;
import br.com.elotech.spring.SpringContext;
import br.com.elotech.tributacao.domain.aise.AtividadeMeiEntity;
import br.com.elotech.tributacao.domain.aise.CadastroGeralAiseEntity;
import br.com.elotech.tributacao.domain.aise.CadastroGeralAisePK;
import br.com.elotech.tributacao.domain.aise.CadastroGeralIsencaoEntity;
import br.com.elotech.tributacao.domain.aise.CadastroGeralIsencaoPK;
import br.com.elotech.tributacao.domain.aise.CadastroImobiliarioEntity;
import br.com.elotech.tributacao.domain.aise.CadastroMobiliarioAtividadeMeiEntity;
import br.com.elotech.tributacao.domain.aise.CadastroMobiliarioCboEntity;
import br.com.elotech.tributacao.domain.aise.CadastroMobiliarioEntity;
import br.com.elotech.tributacao.domain.aise.CategoriaMobiliarioEntity;
import br.com.elotech.tributacao.domain.aise.ClassificacaoMobiliarioEntity;
import br.com.elotech.tributacao.domain.aise.CnaeEntity;
import br.com.elotech.tributacao.domain.aise.ContatoPessoaEntity;
import br.com.elotech.tributacao.domain.aise.DebitoEntity;
import br.com.elotech.tributacao.domain.aise.DebitoParcelaEntity;
import br.com.elotech.tributacao.domain.aise.EnderecoPessoaEntity;
import br.com.elotech.tributacao.domain.aise.GuiaRecolhimentoEntity;
import br.com.elotech.tributacao.domain.aise.MobiliarioCnaeEntity;
import br.com.elotech.tributacao.domain.aise.MobiliarioSituacaoEntity;
import br.com.elotech.tributacao.domain.aise.MobiliarioSituacaoPK;
import br.com.elotech.tributacao.domain.aise.NaturezaJuridicaEntity;
import br.com.elotech.tributacao.domain.aise.PessoaEntity;
import br.com.elotech.tributacao.domain.aise.RhCboEntity;
import br.com.elotech.tributacao.domain.aise.SituacaoMobiliarioEntity;
import br.com.elotech.tributacao.domain.aise.TipoDocumentoEntity;
import br.com.elotech.tributacao.domain.aise.TipoInscricaoAlvaraEntity;
import br.com.elotech.tributacao.domain.aise.TipoLaudoEntity;
import br.com.elotech.tributacao.domain.aise.UsuarioEntity;
import br.com.elotech.tributacao.enumerator.EnderecoTipoEnum;
import br.com.elotech.tributacao.enumerator.SimNaoEnum;
import br.com.elotech.tributacao.enumerator.SituacaoMobiliarioAlvaraEnum;
import br.com.elotech.tributacao.enumerator.TipoDocumentoRedeSimEnum;
import br.com.elotech.tributacao.enumerator.TipoLaudoEnum;
import br.com.elotech.tributacao.interfaces.Atividade;
import br.com.elotech.tributacao.repository.RepositoryParametroGeral;
import br.com.elotech.tributacao.repository.aise.RepositoryAtividadeMei;
import br.com.elotech.tributacao.repository.aise.RepositoryBoletimMobiliario;
import br.com.elotech.tributacao.repository.aise.RepositoryCadastroGeral;
import br.com.elotech.tributacao.repository.aise.RepositoryCadastroGeralIsencao;
import br.com.elotech.tributacao.repository.aise.RepositoryCadastroImobiliario;
import br.com.elotech.tributacao.repository.aise.RepositoryCadastroMobiliario;
import br.com.elotech.tributacao.repository.aise.RepositoryCnae;
import br.com.elotech.tributacao.repository.aise.RepositoryContatoPessoa;
import br.com.elotech.tributacao.repository.aise.RepositoryContratoSocial;
import br.com.elotech.tributacao.repository.aise.RepositoryContratoSocialPessoa;
import br.com.elotech.tributacao.repository.aise.RepositoryDebito;
import br.com.elotech.tributacao.repository.aise.RepositoryDebitoParcela;
import br.com.elotech.tributacao.repository.aise.RepositoryDocumentoAise;
import br.com.elotech.tributacao.repository.aise.RepositoryDocumentoImpresso;
import br.com.elotech.tributacao.repository.aise.RepositoryDocumentoTipo;
import br.com.elotech.tributacao.repository.aise.RepositoryEnderecoPessoa;
import br.com.elotech.tributacao.repository.aise.RepositoryEntidadeTributacao;
import br.com.elotech.tributacao.repository.aise.RepositoryGuiaRecolhimento;
import br.com.elotech.tributacao.repository.aise.RepositoryImobiliarioTestada;
import br.com.elotech.tributacao.repository.aise.RepositoryIsencao;
import br.com.elotech.tributacao.repository.aise.RepositoryMobiliarioCbo;
import br.com.elotech.tributacao.repository.aise.RepositoryMobiliarioSituacao;
import br.com.elotech.tributacao.repository.aise.RepositoryParametroEntidadeExercicio;
import br.com.elotech.tributacao.repository.aise.RepositoryPessoa;
import br.com.elotech.tributacao.repository.aise.RepositoryProprietario;
import br.com.elotech.tributacao.repository.aise.RepositoryRegimeFiscalPeriodoRealAise;
import br.com.elotech.tributacao.repository.aise.RepositoryRhCbo;
import br.com.elotech.tributacao.repository.aise.RepositorySituacaoMobiliario;
import br.com.elotech.tributacao.repository.aise.RepositoryTipoDocTipoInscricaoAlvara;
import br.com.elotech.tributacao.repository.aise.RepositoryTipoDocumento;
import br.com.elotech.util.date.EloDateUtils;
import br.com.elotech.util.list.EloListUtils;
import br.com.elotech.util.math.EloNumberUtils;
import br.com.elotech.util.string.EloStringUtils;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import groovy.lang.GroovyShell;
import groovy.lang.Script;
import java.math.BigDecimal;
import java.net.URISyntaxException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.Hibernate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.security.core.userdetails.UserDetails;

@EloService(value="srvSolicitacaoAlvara")
@Scope(value="prototype")
public class SrvSolicitacaoAlvaraImpl
extends SrvSolicitacaoAlvaraHelperImpl
implements SrvSolicitacaoAlvara {
    private static final long PRIMEIRA_PARCELA = 1L;
    private static final long DEBITO_PAGO = 1L;
    protected static final String TODOS_OS_LAUDOS_DEVEM_ESTAR_LIBERADOS = "Todos os Laudos devem estar liberados!";
    protected static final String TODOS_OS_DOCUMENTOS_DEVEM_ESTAR_VALIDADOS = "Todos os Documentos devem estar validados!";
    protected static final String IMPRIMIR_TAXAS_ANTES_DO_ALVARA = "Clique no bot\u00e3o de Imprimir Taxas antes de Imprimir o Alvar\u00e1";
    protected static final String PAGAMENTO_DEBITOS_PENDENTES = "A impress\u00e3o do alvar\u00e1 s\u00f3 ser\u00e1 permitida ap\u00f3s o pagamento de todos os d\u00e9bitos, favor comparecer \u00e0 Prefeitura para regulariza\u00e7\u00e3o.";
    private static final long ENTIDADE = 1L;
    private static final String TIPO_NATUREZA_RURAL = "1";
    @Resource
    private RepositorySolicitacaoAlvaraDocumento repositorySolicitacaoAlvaraDocumento;
    @Resource
    private RepositoryProprietario repositoryProprietario;
    @Resource
    private RepositorySolicitacaoAlvara repositorySolicitacaoAlvara;
    @Resource
    private RepositoryCadastroMobiliario repositoryCadastroMobiliario;
    @Resource
    private RepositoryCadastroGeral repositoryCadastroGeral;
    @Resource
    private RepositoryPessoa repositoryPessoa;
    @Resource
    private RepositoryContratoSocial repositoryContratoSocial;
    @Resource
    private RepositoryContratoSocialPessoa repositoryContratoSocialPessoa;
    @Resource
    private RepositoryEnderecoPessoa repositoryEnderecoPessoa;
    @Resource
    private RepositoryLaudoExigido repositoryLaudoExigido;
    @Resource
    private RepositoryLaudoAlvara repositoryLaudoAlvara;
    @Resource
    private RepositoryMobiliarioSituacao repositoryMobiliarioSituacao;
    @Resource
    private RepositorySolicitacaoAlvaraAtividade repositorySolicitacaoAlvaraAtividade;
    @Resource
    private RepositorySolicitacaoAlvaraNumConselho repositorySolicitacaoAlvaraNumConselho;
    @Resource
    private RepositorySolicitacaoAlvaraDebito repositorySolicitacaoAlvaraDebito;
    @Resource
    private RepositoryDebito repositoryDebito;
    @Resource
    private SrvDebitosPortal srvDebitosPortal;
    @Resource
    private RepositoryMobiliarioCbo repositoryMobiliarioCbo;
    @Resource
    private SrvWebServiceGeoImpl srvWebServiceGeo;
    @Resource
    private RepositoryTipoLaudo repositoryTipoLaudo;
    @Resource
    private RepositoryImobiliarioTestada repositoryImobTestada;
    @Resource
    private RepositoryIsencao repositoryIsencao;
    @Resource
    private RepositoryBoletimMobiliario repositoryBoletimMobiliario;
    @Resource
    private RepositoryCadastroGeralIsencao repositoryCadastroGeralIsencao;
    @Resource
    private RepositorySituacaoMobiliario repositorySituacaoMobiliario;
    @Resource
    private RepositoryCadastroImobiliario repositoryCadastroImobiliario;
    @Resource
    private RepositoryParametroGeral repositoryParametroGeral;
    @Resource
    private RepositorySolicitacaoAlvaraValidadeSefaz repositoryValidadeSefaz;
    @Resource
    private RepositoryHistoricoRenovacaoAlvara repositoryHistoricoRenovacaoAlvara;
    @Resource
    private RepositoryDocumentoAise repositoryDocumentoAise;
    @Resource
    private RepositoryDocumentoImpresso repositoryDocumentoImpresso;
    @Resource
    private RepositoryCnae repositoryCnae;
    @Resource
    private RepositoryEntidadeTributacao repositoryEntidadeTributacao;
    @Resource
    private RepositoryParametroEntidadeExercicio repositoryParametroEntidadeExercicio;
    @Resource
    private RepositoryGuiaRecolhimento repositoryGuiaRecolhimento;
    @Resource
    private SrvMontaObsAlvara srvMontaObsAlvara;
    @Resource
    private RepositoryDocumentoTipo repositoryDocumentoTipo;
    @Resource
    private RepositorySolicitacaoAlvaraValidade repositorySolicitacaoValidade;
    @Resource
    private RepositoryParametroAlvaraNatureza repositoryParametroAlvaraNatureza;
    @Resource
    private RepositoryParametroAlvara repositoryParametroAlvara;
    @Resource
    protected RepositoryDebitoParcela repositoryDebitoParcela;
    @Resource
    private SrvSolicitacaoAlvaraPrestadorServicoImpl srvSolicitacaoAlvaraPrestadorServicoImpl;
    @Resource
    protected SrvGeraBoletimMobiliario srvGeraBoletimMobiliarioAlvara;
    @Resource
    protected RepositoryRhCbo repositoryRhCbo;
    @Autowired
    private SrvConsultaAtividadeFactory srvConsultaAtividadeFactory;
    @Resource
    private RepositoryCnaePerimetro repositoryCnaePerimetro;
    @Resource
    private RepositoryAtividadeMei repositoryAtividadeMei;
    @Resource
    private RepositoryContatoPessoa repositoryContatoPessoa;
    @Resource
    private RepositoryRestricaoConsultaPrevia repositoryRestricaoConsultaPrevia;
    @Resource
    private SrvDesvincularPessoaComCadastro srvDesvincularPessoaComCadastro;
    @Resource
    private RepositoryRegimeFiscalPeriodoRealAise repositoryRegimeFiscalPeriodoRealAise;
    @Resource
    private RepositoryConsultaRedeSim repositoryConsultaRedeSim;
    @Resource
    private RepositorySolicitacaoContratoSocial repositorySolicitacaoContratoSocial;
    @Resource
    private RepositorySolicitacaoContratoSocialPessoa repositorySolicitacaoContratoSocialPessoa;
    @Resource
    private SrvParametroAlvara srvParametroAlvara;
    @Resource
    private RepositoryTipoDocTipoInscricaoAlvara repositoryTipoDocTipoInscricaoAlvara;
    @Resource
    private RepositoryTipoDocumento repositoryTipoDocumento;
    @Resource
    private SrvSolicitacaoAlvaraPrestadorServico srvSolicitacaoAlvaraPrestadorServico;
    @Resource
    private SrvContratoSocial srvContratoSocial;
    @Resource
    private SrvFindTipoInscricaoAlvaraImpl srvFindTipoInscricaoAlvara;
    @Resource
    private RepositoryClassificacaoTipoInscricao repositoryClassificacaoTipoInscricao;
    @Resource
    private RepositoryScriptAlvara repositoryScriptAlvara;
    @Resource
    private RepositorySolicitacaoDocRedeSim repositorySolicitacaoDocRedeSim;
    @Resource
    private SrvAndamentoLaudoAlvaraImpl srvAndamentoLaudoAlvara;
    @Resource
    private SrvConsultaPrevia srvConsultaPrevia;
    @Resource
    private RepositoryCadastroGeralIsencao cadastroGeralIsencao;

    public void setRepositoryLaudoAlvara(RepositoryLaudoAlvara repositoryLaudoAlvara) {
        this.repositoryLaudoAlvara = repositoryLaudoAlvara;
    }

    public void setRepositoryScriptAlvara(RepositoryScriptAlvara repositoryScriptAlvara) {
        this.repositoryScriptAlvara = repositoryScriptAlvara;
    }

    public void setRepositoryLaudoExigido(RepositoryLaudoExigido repositoryLaudoExigido) {
        this.repositoryLaudoExigido = repositoryLaudoExigido;
    }

    public void setRepositoryIsencao(RepositoryIsencao repositoryIsencao) {
        this.repositoryIsencao = repositoryIsencao;
    }

    public void setRepositoryImobTestada(RepositoryImobiliarioTestada repositoryImobTestada) {
        this.repositoryImobTestada = repositoryImobTestada;
    }

    public void setRepositoryTipoLaudo(RepositoryTipoLaudo repositoryTipoLaudo) {
        this.repositoryTipoLaudo = repositoryTipoLaudo;
    }

    public void setSrvWebServiceGeo(SrvWebServiceGeoImpl srvWebServiceGeo) {
        this.srvWebServiceGeo = srvWebServiceGeo;
    }

    public void setRepositoryMobiliarioCbo(RepositoryMobiliarioCbo repositoryMobiliarioCbo) {
        this.repositoryMobiliarioCbo = repositoryMobiliarioCbo;
    }

    public void setRepositorySolicitacaoAlvaraNumConselho(RepositorySolicitacaoAlvaraNumConselho repositorySolicitacaoAlvaraNumConselho) {
        this.repositorySolicitacaoAlvaraNumConselho = repositorySolicitacaoAlvaraNumConselho;
    }

    public void setRepositorySolicitacaoAlvaraAtividade(RepositorySolicitacaoAlvaraAtividade repositorySolicitacaoAlvaraAtividade) {
        this.repositorySolicitacaoAlvaraAtividade = repositorySolicitacaoAlvaraAtividade;
    }

    public void setRepositorySolicitacaoAlvara(RepositorySolicitacaoAlvara repositorySolicitacaoAlvara) {
        this.repositorySolicitacaoAlvara = repositorySolicitacaoAlvara;
        super.setRepositorySolicitacaoAlvara(repositorySolicitacaoAlvara);
    }

    public void setRepositoryRestricaoConsultaPrevia(RepositoryRestricaoConsultaPrevia repositoryRestricaoConsultaPrevia) {
        this.repositoryRestricaoConsultaPrevia = repositoryRestricaoConsultaPrevia;
        super.setRepositoryRestricaoConsultaPrevia(repositoryRestricaoConsultaPrevia);
    }

    public void setRepositoryParametroGeral(RepositoryParametroGeral repositoryParametroGeral) {
        this.repositoryParametroGeral = repositoryParametroGeral;
        super.setRepositoryParametroGeral(repositoryParametroGeral);
    }

    public void setSrvGeraBoletimMobiliarioAlvara(SrvGeraBoletimMobiliario srvGeraBoletimMobiliarioAlvara) {
        this.srvGeraBoletimMobiliarioAlvara = srvGeraBoletimMobiliarioAlvara;
    }

    public void setRepositoryCadastroMobiliario(RepositoryCadastroMobiliario repositoryCadastroMobiliario) {
        this.repositoryCadastroMobiliario = repositoryCadastroMobiliario;
        super.setRepositoryCadastroMobiliario(repositoryCadastroMobiliario);
    }

    public void setRepositoryCadastroGeral(RepositoryCadastroGeral repositoryCadastroGeral) {
        this.repositoryCadastroGeral = repositoryCadastroGeral;
        super.setRepositoryCadastroGeral(repositoryCadastroGeral);
    }

    public void setRepositorySolicitacaoAlvaraDebito(RepositorySolicitacaoAlvaraDebito repositorySolicitacaoAlvaraDebito) {
        this.repositorySolicitacaoAlvaraDebito = repositorySolicitacaoAlvaraDebito;
    }

    public void setRepositoryDebito(RepositoryDebito repositoryDebito) {
        this.repositoryDebito = repositoryDebito;
    }

    public void setSrvDebitosPortal(SrvDebitosPortal srvDebitosPortal) {
        this.srvDebitosPortal = srvDebitosPortal;
    }

    public void setRepositoryConsultaRedeSim(RepositoryConsultaRedeSim repositoryConsultaRedeSim) {
        this.repositoryConsultaRedeSim = repositoryConsultaRedeSim;
        super.setRepositoryConsultaRedeSim(repositoryConsultaRedeSim);
    }

    public void setRepositoryCnae(RepositoryCnae repositoryCnae) {
        this.repositoryCnae = repositoryCnae;
        super.setRepositoryCnae(repositoryCnae);
    }

    public void setRepositorySolicitacaoContratoSocial(RepositorySolicitacaoContratoSocial repositorySolicitacaoContratoSocial) {
        this.repositorySolicitacaoContratoSocial = repositorySolicitacaoContratoSocial;
        super.setRepositorySolicitacaoContratoSocial(repositorySolicitacaoContratoSocial);
    }

    public void setSrvContratoSocial(SrvContratoSocial srvContratoSocial) {
        this.srvContratoSocial = srvContratoSocial;
        super.setSrvContratoSocial(srvContratoSocial);
    }

    public void setSrvFindTipoInscricaoAlvara(SrvFindTipoInscricaoAlvaraImpl srvFindTipoInscricaoAlvara) {
        this.srvFindTipoInscricaoAlvara = srvFindTipoInscricaoAlvara;
        super.setSrvFindTipoInscricaoAlvara(srvFindTipoInscricaoAlvara);
    }

    public void setRepositorySolicitacaoContratoSocialPessoa(RepositorySolicitacaoContratoSocialPessoa repositorySolicitacaoContratoSocialPessoa) {
        this.repositorySolicitacaoContratoSocialPessoa = repositorySolicitacaoContratoSocialPessoa;
    }

    public SolicitacaoAlvaraEntity salvarSolicitacaoAlvaraAlteracao(SolicitacaoAlvaraEntity solicitacao) throws SolicitacaoAlvaraException, BaseException {
        return this.saveSolicitacaoAlvaraEventosAlteracao(solicitacao, true);
    }

    public SolicitacaoAlvaraEntity salvarSolicitacaoAlvaraAlteracaoSemLaudo(SolicitacaoAlvaraEntity solicitacao) throws SolicitacaoAlvaraException, BaseException {
        return this.saveSolicitacaoAlvaraEventosAlteracao(solicitacao, false);
    }

    private SolicitacaoAlvaraEntity saveSolicitacaoAlvaraEventosAlteracao(SolicitacaoAlvaraEntity solicitacao, boolean habilitaGeracaoLaudo) throws BaseException {
        boolean geraLaudo = false;
        if (solicitacao.isAlteracaoRazaoOuSocioOuRazaoESocio()) {
            if (solicitacao.getCadastroMobiliario().getDataValidadeAlvara() == null || !solicitacao.isSituacaoMobiliarioVencido()) {
                geraLaudo = true;
            }
        } else if (solicitacao.isSituacaoMobiliarioDesatualizadoOuVencido()) {
            geraLaudo = true;
        }
        if (solicitacao.isRedeSim() && (solicitacao.isNaturezaAlteracaoSocio() || Objects.isNull(solicitacao.getContratoSocial()))) {
            try {
                this.srvContratoSocial.preencherContratoSocialBySolicitacao(solicitacao);
                this.formatLogSolicitacaoContratoSocialAlvara("Natureza de altera\u00e7\u00e3o de s\u00f3cio", solicitacao);
                this.atualizaContratoSocialCadastroMobiliario(solicitacao, true);
            }
            catch (Exception e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
                throw new SolicitacaoAlvaraException("Ocorreu uma falha ao preencher o contrato social recebido pela integra\u00e7\u00e3o. " + e.getMessage(), (Throwable)e);
            }
        }
        solicitacao.setDataSolicitacao(Calendar.getInstance().getTime());
        this.carregarEsalvarAtividadesNaSolicitacao(solicitacao);
        this.logger.info((Object)"adicionaSolicitacaoContratoSocial------- salvarSolicitacaoAlvaraAlteracao");
        this.adicionaSolicitacaoContratoSocial(solicitacao);
        if (solicitacao.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.MUDANCA_ENDERECO})) {
            geraLaudo = true;
        }
        if (solicitacao.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.ALTERACAO_ATIVIDADE})) {
            this.alteraAtividadePrincipalDaSolicitacao(solicitacao);
            geraLaudo = true;
        }
        if (solicitacao.isNaturezaMudancaArea()) {
            if (solicitacao.isAreaMaiorQueAtual() || solicitacao.isSituacaoMobiliarioDesatualizadoOuVencido()) {
                solicitacao.setAreaMaiorQueAtual(SimNaoEnum.SIM.getShortText());
                geraLaudo = true;
            } else {
                solicitacao.setAreaMaiorQueAtual(SimNaoEnum.NAO.getShortText());
            }
        }
        if (habilitaGeracaoLaudo && geraLaudo) {
            this.geraLaudos(solicitacao);
        }
        if (solicitacao.isGrauRiscoBaixo()) {
            this.adicionaValidadeAlvaraProvisorio(solicitacao);
        }
        List boletinsGerados = this.srvGeraBoletimMobiliarioAlvara.geraBoletimMobiliario(solicitacao);
        this.srvGeraBoletimMobiliarioAlvara.salvarBoletinsMobiliario(boletinsGerados);
        if (Objects.nonNull(solicitacao.getCadastroMobiliario())) {
            this.salvarCadastroGeralIsencao(solicitacao.getCadastroMobiliario(), solicitacao);
            this.atualizarNaturezaJuridica(solicitacao);
        }
        solicitacao.setFinalizado(SimNaoEnum.SIM.getShortText());
        solicitacao = this.repositorySolicitacaoAlvara.saveOrUpdate(solicitacao);
        this.formatLogSolicitacaoContratoSocialAlvara("M\u00e9todo: salvarSolicitacaoAlvaraAlteracao", solicitacao);
        return solicitacao;
    }

    protected void carregaGrauRiscoDaSolicitacao(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        SrvConsultaAtividade srvConsultaAtividade = this.srvConsultaAtividadeFactory.getConsultaAtividadeInstance(solicitacao);
        srvConsultaAtividade.carregaGrauRiscoDaSolicitacao(solicitacao);
    }

    public void carregaExigenciasProibicaoNaSolicitacao(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        if ((solicitacao.isNaturezaInicial() || solicitacao.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.MUDANCA_ENDERECO, NaturezaSolicitacaoAlvaraEnum.MUDANCA_AREA, NaturezaSolicitacaoAlvaraEnum.ALTERACAO_ATIVIDADE})) && !EloListUtils.safeIsEmpty((List)solicitacao.getSolicitacaoAlvaraAtividades()).booleanValue()) {
            SrvConsultaAtividade srvConsultaAtividade = this.srvConsultaAtividadeFactory.getConsultaAtividadeInstance(solicitacao);
            srvConsultaAtividade.carregaExigenciasProibicaoNaSolicitacao(solicitacao, solicitacao.getSolicitacaoAlvaraAtividades());
        }
    }

    protected void salvarAlteracaoAtividade(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        this.carregaMobiliarioAtividades(solicitacao);
        this.vincularMobiliarioCnae(solicitacao);
        this.getUtilizaMobiliarioAtividade(solicitacao);
        this.carregaGrauRiscoDaSolicitacao(solicitacao);
        this.salvarMobiliarioServico(solicitacao);
    }

    public void consultarWSAtividades(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        Hibernate.initialize((Object)solicitacao.getCadastroMobiliario());
        HashSet listaLaudoExigido = new HashSet();
        for (SolicitacaoAlvaraAtividadeEntity atividade : solicitacao.getSolicitacaoAlvaraAtividades()) {
            if (!this.isSituacaoGeraLaudo(solicitacao)) continue;
            if (solicitacao.isSolicitacaoMEIPrestador()) {
                this.executaVerificacaoLaudoExigidoAtividadeMei(listaLaudoExigido, atividade.getAtividadeMei());
                continue;
            }
            this.executaVerificacaoLaudoExigido(solicitacao, listaLaudoExigido, atividade);
        }
        this.salvarLaudo(new ArrayList(listaLaudoExigido), solicitacao);
        solicitacao.setGerarAlvara(SimNaoEnum.toShortText((Boolean)(!solicitacao.isGrauRiscoAlto() ? 1 : 0)));
    }

    protected void consultarAtividadesNovoGeo(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        HashSet listaLaudoExigido = new HashSet();
        for (SolicitacaoAlvaraAtividadeEntity atividade : solicitacao.getSolicitacaoAlvaraAtividades()) {
            if (!this.isSituacaoGeraLaudo(solicitacao)) continue;
            if (solicitacao.isSolicitacaoMEIPrestador()) {
                this.executaVerificacaoLaudoExigidoAtividadeMei(listaLaudoExigido, atividade.getAtividadeMei());
                continue;
            }
            this.executaVerificacaoLaudoExigido(solicitacao, listaLaudoExigido, atividade);
        }
        this.salvarLaudo(new ArrayList(listaLaudoExigido), solicitacao);
        this.atribuirGerarAlvara(solicitacao);
    }

    private void atribuirGerarAlvara(SolicitacaoAlvaraEntity solicitacao) {
        solicitacao.setGerarAlvara(SimNaoEnum.toShortText((Boolean)(!solicitacao.isGrauRiscoAlto() ? 1 : 0)));
    }

    public boolean isSituacaoGeraLaudo(SolicitacaoAlvaraEntity solicitacao) {
        Optional.ofNullable(solicitacao.getCadastroMobiliario()).ifPresent(cadastroMobiliario -> {
            Hibernate.initialize((Object)cadastroMobiliario.getMobiliarioSituacaoAtual());
            Hibernate.initialize((Object)cadastroMobiliario.getMobiliarioSituacao());
        });
        return solicitacao.isNaturezaInicial() || solicitacao.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.MUDANCA_RAZAO_SOCIAL}) && solicitacao.isSituacaoMobiliarioDesatualizadoOuVencido() || solicitacao.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.ALTERACAO_ATIVIDADE}) || solicitacao.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.MUDANCA_ENDERECO}) || solicitacao.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.MUDANCA_AREA}) && (solicitacao.isAreaMaiorQueAtual() || solicitacao.isSituacaoMobiliarioDesatualizadoOuVencido());
    }

    protected void formatLogSolicitacaoContratoSocialAlvara(String prefixo, SolicitacaoAlvaraEntity solicitacaoAlvaraEntity) {
        this.logger.info((Object)String.format("%s - Preenchido na solicita\u00e7\u00e3o do alvar\u00e1 %d a solicita\u00e7\u00e3o de contrato social %d", prefixo, solicitacaoAlvaraEntity.getSolicitacaoAlvara(), Optional.ofNullable(solicitacaoAlvaraEntity.getContratoSocial()).map(SolicitacaoContratoSocialEntity::getId).orElse(null)));
    }

    private void executaVerificacaoLaudoExigidoAtividadeMei(Set<LaudoExigidoEntity> listaLaudoExigido, AtividadeMeiEntity atividade) throws BaseException {
        List tiposLaudo = ((FacadeSolicitacaoAlvara)SpringContext.getBean(FacadeSolicitacaoAlvara.class)).getTiposLaudoAtividadeMei(atividade);
        for (TipoLaudoEntity tipoLaudo : tiposLaudo) {
            LaudoExigidoEntity laudoExigido = new LaudoExigidoEntity();
            laudoExigido.setTipoLaudo(tipoLaudo);
            if (this.existeTipoLaudoNaLista(laudoExigido.getTipoLaudo(), new ArrayList<LaudoExigidoEntity>(listaLaudoExigido))) continue;
            listaLaudoExigido.add(laudoExigido);
        }
    }

    private void executaVerificacaoLaudoExigido(SolicitacaoAlvaraEntity solicitacaoAlvara, Set<LaudoExigidoEntity> listaLaudoExigido, SolicitacaoAlvaraAtividadeEntity atividade) throws BaseException {
        SrvConsultaAtividade srvConsultaAtividade = this.srvConsultaAtividadeFactory.getConsultaAtividadeInstance(solicitacaoAlvara);
        srvConsultaAtividade.executaVerificacaoLaudoExigido(solicitacaoAlvara, listaLaudoExigido, atividade);
    }

    private boolean existeTipoLaudoNaLista(TipoLaudoEntity tipoLaudo, List<LaudoExigidoEntity> listaLaudoExigido) {
        for (LaudoExigidoEntity laudo : listaLaudoExigido) {
            if (!laudo.getTipoLaudo().getCodigo().equals((Object)tipoLaudo.getCodigo())) continue;
            return true;
        }
        return false;
    }

    public List<LaudoExigidoEntity> removeLaudoRepetidos(List<LaudoExigidoEntity> laudos, Comparator<LaudoExigidoEntity> comparator) {
        TreeSet<LaudoExigidoEntity> t = new TreeSet<LaudoExigidoEntity>(comparator);
        t.addAll(laudos);
        LinkedList<LaudoExigidoEntity> laudosClone = new LinkedList<LaudoExigidoEntity>(t);
        return laudosClone;
    }

    public SolicitacaoAlvaraEntity salvarIdDebitoSolicitacao(SolicitacaoAlvaraEntity solicitacaoAlvara) {
        return this.repositorySolicitacaoAlvara.saveOrUpdate(solicitacaoAlvara);
    }

    public SolicitacaoAlvaraEntity salvarSolicitacaoInicial(SolicitacaoAlvaraEntity solicitacaoAlvara, boolean restricaoCadastroExistente) throws BaseException {
        solicitacaoAlvara.getCadastroMobiliario().getCadastroGeral().setExclusaoLogica(SimNaoEnum.getSimShortText());
        this.salvarSolicitacaoAlvaraInicial(solicitacaoAlvara, restricaoCadastroExistente);
        this.geraLaudos(solicitacaoAlvara);
        return solicitacaoAlvara;
    }

    public List<LaudoExigidoEntity> buscarLaudosExigidosPorAtividade(List<SolicitacaoAlvaraAtividadeEntity> listaAtividades) throws AtividadeNaoConfiguradaException {
        List listaLaudoExigido = this.repositoryLaudoExigido.getLaudoPorAtividade(listaAtividades);
        return listaLaudoExigido;
    }

    public void salvarLaudo(List<LaudoExigidoEntity> listaLaudoExigido, SolicitacaoAlvaraEntity solicitacaoAlvara) throws BaseException {
        ArrayList<LaudoAlvaraEntity> listaLaudos = new ArrayList<LaudoAlvaraEntity>();
        for (LaudoExigidoEntity laudoExigido : listaLaudoExigido) {
            Boolean existeLaudo = Boolean.FALSE;
            if (!EloListUtils.safeIsEmpty(listaLaudos).booleanValue()) {
                existeLaudo = listaLaudos.stream().anyMatch(laudo -> laudo.getTipoLaudo().getIdTipoLaudo().compareTo(laudoExigido.getTipoLaudo().getIdTipoLaudo()) == 0);
            }
            if (!Boolean.FALSE.equals(existeLaudo)) continue;
            this.logger.info((Object)("LAUDO EXIGIDO...." + laudoExigido.getTipoLaudo()));
            LaudoAlvaraEntity laudoAlvara = new LaudoAlvaraEntity();
            laudoAlvara.setTipoLaudo(laudoExigido.getTipoLaudo());
            laudoAlvara.setIdSolicitacaoAlvara(solicitacaoAlvara);
            laudoAlvara.setIdLaudoAlvara(this.repositoryLaudoAlvara.getSequence());
            laudoAlvara.setUsuario((UsuarioEntity)this.getUsuarioLogado());
            if (this.gerarLaudoLiberadoRiscoBaixo(solicitacaoAlvara)) {
                laudoAlvara.setStatus(StatusLaudoAlvara.LAUDO_LIBERADO_RISCO_B);
                laudoAlvara.setVistoriar("N");
            } else if (solicitacaoAlvara.isGrauRiscoLiberdadeEconomica() || this.isMeisECriaLaudosAoRececerDadosEmpresaEnviaInscricaoComDadosAtualizados(solicitacaoAlvara)) {
                laudoAlvara.setStatus(StatusLaudoAlvara.LIBERDADE_ECONOMICA);
            } else {
                laudoAlvara.setStatus(StatusLaudoAlvara.EM_ANDAMENTO);
            }
            laudoAlvara = this.repositoryLaudoAlvara.saveOrUpdate(laudoAlvara);
            this.repositoryLaudoAlvara.flush();
            if (this.gerarLaudoLiberadoRiscoBaixo(solicitacaoAlvara)) {
                this.srvAndamentoLaudoAlvara.adicionarAndamentoLaudoRiscoBaixo(laudoAlvara, laudoAlvara.getUsuario());
            }
            listaLaudos.add(laudoAlvara);
        }
        solicitacaoAlvara.setLaudos(listaLaudos);
    }

    public void alteraSituacaoCadastroExclusaoLogica(CadastroGeralAiseEntity cadastroGeral, String situacao) {
        cadastroGeral.setExclusaoLogica(situacao);
        this.repositoryCadastroGeral.saveOrUpdate(cadastroGeral);
        this.repositoryCadastroGeral.flush();
    }

    public SolicitacaoAlvaraEntity atualizarSolicitacaoAlvara(SolicitacaoAlvaraEntity solicitacaoAlvara) {
        SolicitacaoAlvaraEntity solicitacao = this.repositorySolicitacaoAlvara.saveOrUpdate(solicitacaoAlvara);
        this.repositorySolicitacaoAlvara.flush();
        Hibernate.initialize((Object)solicitacao.getCadastroMobiliario().getMobiliarioSituacao());
        Hibernate.initialize((Object)solicitacao.getLaudos());
        if (Objects.nonNull(solicitacao.getSolicitacaoAlvaraAtividades())) {
            Hibernate.initialize((Object)solicitacao.getSolicitacaoAlvaraAtividades());
            solicitacao.getSolicitacaoAlvaraAtividades().forEach(p -> Hibernate.initialize((Object)p.getNumerosConselho()));
        }
        if (solicitacao.getCadastroMobiliario().getMobiliarioSituacao() != null) {
            for (MobiliarioSituacaoEntity mobiliarioSituacao : solicitacao.getCadastroMobiliario().getMobiliarioSituacao()) {
                Hibernate.initialize((Object)mobiliarioSituacao.getSituacaoMobiliario());
                if (mobiliarioSituacao.getSituacaoMobiliario() == null) continue;
                Hibernate.initialize((Object)mobiliarioSituacao.getSituacaoMobiliario().getSituacoesMobiliarioAlvara());
            }
        }
        return solicitacao;
    }

    public SolicitacaoAlvaraEntity saveSolicitacaoRenovacao(SolicitacaoAlvaraEntity solicitacao, List<LaudoAlvaraEntity> listaLaudos) {
        solicitacao.setSolicitacaoAlvara(this.repositorySolicitacaoAlvara.getSequence());
        solicitacao.setNumeroSolicitacao(this.repositorySolicitacaoAlvara.getNumeroSolicitacao(Long.valueOf(1L), solicitacao.getExercicio()));
        for (SolicitacaoAlvaraAtividadeEntity atividade : solicitacao.getSolicitacaoAlvaraAtividades()) {
            atividade.setIdSolicitacaoAtividade(this.repositorySolicitacaoAlvaraAtividade.getSequence());
            atividade.setSolicitacaoAlvara(solicitacao);
        }
        if (solicitacao.getDocumentos() != null) {
            for (SolicitacaoAlvaraDocumentoEntity documento : solicitacao.getDocumentos()) {
                documento.setSolicitacaoAlvara(solicitacao);
            }
        }
        solicitacao = this.repositorySolicitacaoAlvara.saveOrUpdate(solicitacao);
        if (listaLaudos != null && !listaLaudos.isEmpty()) {
            try {
                for (LaudoAlvaraEntity laudoAlvara : listaLaudos) {
                    LaudoAlvaraEntity laudo = new LaudoAlvaraEntity();
                    laudo.setIdSolicitacaoAlvara(solicitacao);
                    if (this.gerarLaudoLiberadoRiscoBaixo(solicitacao)) {
                        laudo.setStatus(StatusLaudoAlvara.LAUDO_LIBERADO_RISCO_B);
                        laudo.setVistoriar("N");
                    } else {
                        if (laudoAlvara.getDataValidade().before(new Date())) {
                            laudo.setStatus(StatusLaudoAlvara.EM_ANDAMENTO);
                        } else {
                            laudo.setStatus(StatusLaudoAlvara.LIBERADO_PROVISORIO);
                            laudo.setDataValidade(laudoAlvara.getDataValidade());
                        }
                        laudo.setVistoriar(laudoAlvara.getVistoriar());
                    }
                    laudo.setIdLaudoAlvara(this.repositoryLaudoAlvara.getSequence());
                    laudo.setTipoLaudo(laudoAlvara.getTipoLaudo());
                    laudo.setUsuario((UsuarioEntity)this.getUsuarioLogado());
                    laudo = this.repositoryLaudoAlvara.saveOrUpdate(laudo);
                    if (!this.gerarLaudoLiberadoRiscoBaixo(solicitacao)) continue;
                    this.srvAndamentoLaudoAlvara.adicionarAndamentoLaudoRiscoBaixo(laudo, laudo.getUsuario());
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return solicitacao;
    }

    public void salvarValidadeSefaz(SolicitacaoAlvaraValidadeSefazEntity solicitacaoValidadeSefaz) {
        this.atualizarSolicitacaoAlvara(solicitacaoValidadeSefaz.getSolicitacaoAlvara());
        solicitacaoValidadeSefaz.setSolicitacaoValidadeSefaz(this.repositoryValidadeSefaz.getSequence());
        this.repositoryValidadeSefaz.saveOrUpdate(solicitacaoValidadeSefaz);
    }

    public void salvarHistoricoRenovacaoAlvara(List<LaudoAlvaraEntity> listaLaudoAlvara, SolicitacaoAlvaraEntity solicitacao, UserDetails usuario, String descHistorico) {
        this.salvarSolicitacaoDocumentos(solicitacao);
        solicitacao = this.atualizarSolicitacaoAlvara(solicitacao);
        if (listaLaudoAlvara != null) {
            for (LaudoAlvaraEntity laudoAlvara : listaLaudoAlvara) {
                HistoricoRenovacaoAlvaraEntity historico = new HistoricoRenovacaoAlvaraEntity();
                historico.setDescricao(laudoAlvara.getTipoLaudo().getDescricao());
                historico.setSolicitacaoAlvara(solicitacao);
                historico.setDataInclusao(new Date());
                historico.setHistoricoRenovacao(this.repositoryHistoricoRenovacaoAlvara.getSequence());
                historico.setLaudoAlvara(laudoAlvara);
                historico.setUserDetails(usuario);
                this.repositoryHistoricoRenovacaoAlvara.saveOrUpdate(historico);
                this.repositoryLaudoAlvara.saveOrUpdate(laudoAlvara);
            }
        }
        if (descHistorico != null && !descHistorico.isEmpty()) {
            this.newHistoricoRenovacao(solicitacao, usuario, descHistorico);
        }
    }

    protected void newHistoricoRenovacao(SolicitacaoAlvaraEntity solicitacao, UserDetails usuario, String descHistorico) {
        HistoricoRenovacaoAlvaraEntity historico = new HistoricoRenovacaoAlvaraEntity();
        historico.setDescricao(descHistorico);
        historico.setSolicitacaoAlvara(solicitacao);
        historico.setDataInclusao(new Date());
        historico.setHistoricoRenovacao(this.repositoryHistoricoRenovacaoAlvara.getSequence());
        historico.setUserDetails(usuario);
        this.repositoryHistoricoRenovacaoAlvara.saveOrUpdate(historico);
    }

    public void salvarConsultaPreviaSolicitacao(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        this.carregaExigenciasProibicaoNaSolicitacao(solicitacao);
        solicitacao.setFinalizado(SimNaoEnum.getNaoShortText());
        super.salvarConsultaPreviaSolicitacao(solicitacao);
    }

    public void salvarConsultaPreviaSolicitacaoMei(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        solicitacao.setFinalizado(SimNaoEnum.getNaoShortText());
        super.salvarConsultaPreviaSolicitacao(solicitacao);
    }

    private void removerOutrasIsencoes(SolicitacaoAlvaraEntity solicitacaoAlvara) throws BaseException {
        String paramIsencaoDebito = UtilsController.getValorParametroAlvara((ParametroAlvaraEnum)ParametroAlvaraEnum.ISENCAO_DEBITO_PESSOA_JURIDICA_NORMAL);
        List codigosIsencao = Arrays.stream(paramIsencaoDebito.split(",")).filter(StringUtils::isNotEmpty).map(Long::valueOf).collect(Collectors.toList());
        solicitacaoAlvara.getCadastroMobiliario().getCadastroGeral().getIsencoes().removeIf(isencao -> isencao.getId().getIsencao().getId().compareTo(0L) != 0 && !codigosIsencao.contains(isencao.getId().getIsencao().getId()));
        if (EloListUtils.safeIsEmpty((List)solicitacaoAlvara.getCadastroMobiliario().getCadastroGeral().getIsencoes()).booleanValue()) {
            CadastroGeralIsencaoPK idIsencao = new CadastroGeralIsencaoPK();
            idIsencao.setCadastroGeral(solicitacaoAlvara.getCadastroMobiliario().getCadastroGeral());
            idIsencao.setIsencao(this.repositoryIsencao.load(Long.valueOf(0L)));
            CadastroGeralIsencaoEntity isencaoEntity = new CadastroGeralIsencaoEntity();
            isencaoEntity.setId(idIsencao);
            solicitacaoAlvara.getCadastroMobiliario().getCadastroGeral().getIsencoes().add(this.repositoryCadastroGeralIsencao.saveOrUpdate(isencaoEntity));
        }
        solicitacaoAlvara.getCadastroMobiliario().setCadastroGeral(this.repositoryCadastroGeral.saveOrUpdate(solicitacaoAlvara.getCadastroMobiliario().getCadastroGeral()));
        this.repositoryCadastroGeral.flush();
    }

    public void atualizarMobiliarioBoletins(SolicitacaoAlvaraEntity solicitacaoAlvara) throws BaseException {
        List boletinsGerados = this.srvGeraBoletimMobiliarioAlvara.geraBoletimMobiliario(solicitacaoAlvara);
        this.srvGeraBoletimMobiliarioAlvara.salvarBoletinsMobiliario(boletinsGerados);
    }

    public ImprimirTaxasAlvara imprimirTaxas(SolicitacaoAlvaraEntity solicitacao) throws SolicitacaoAlvaraException {
        try {
            Boolean gerarDebito;
            if (SimNaoEnum.equalSim((String)solicitacao.getCadastroMobiliario().getCadastroGeral().getExclusaoLogica()).booleanValue()) {
                this.alteraSituacaoCadastroExclusaoLogica(solicitacao.getCadastroMobiliario().getCadastroGeral(), SimNaoEnum.getNaoShortText());
            }
            if (UtilsController.parametroCriaRegimeFiscalAtivo() && !this.temRegimeFiscal(solicitacao)) {
                throw new SolicitacaoAlvaraException("Nenhum Regime Fiscal vinculado ao Mobili\u00e1rio. Entre em contato com a prefeitura.");
            }
            if (!this.cobrarTaxa(solicitacao)) {
                throw new SolicitacaoAlvaraException("N\u00e3o existe taxas para esta solicita\u00e7\u00e3o.");
            }
            if (!solicitacao.isNaturezaInicial() && solicitacao.isSituacaoMobiliarioDesatualizadoOuVencido() && !solicitacao.possuiTodosLaudosLiberado()) {
                throw new SolicitacaoAlvaraException(TODOS_OS_LAUDOS_DEVEM_ESTAR_LIBERADOS);
            }
            if (!solicitacao.isRedeSim()) {
                this.verificarExistemDocumentosAseremValidados(solicitacao);
            }
            if (Boolean.TRUE.equals(gerarDebito = Boolean.valueOf(!solicitacao.isGrauRiscoLiberdadeEconomica() || SimNaoEnum.equalSim((String)UtilsController.getParametroAlvara((ParametroAlvaraEnum)ParametroAlvaraEnum.PERMITE_GERAR_TAXA_LIBERDADE_ECONOMICA).getValor()) != false))) {
                this.removerOutrasIsencoes(solicitacao);
                this.atualizarMobiliarioBoletins(solicitacao);
            }
            if (Boolean.TRUE.equals(gerarDebito) && !this.isIsento(solicitacao.getCadastroMobiliario().getCadastroGeral().getIsencoes()).booleanValue()) {
                List debitosAlvara = this.processarSolicitacao(solicitacao);
                this.verificaSituacaoVencidoOuDesatualizado(solicitacao);
                if (solicitacao.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.MUDANCA_ENDERECO}) && solicitacao.getNumeroAlvara() == null && SimNaoEnum.equalNao((String)solicitacao.getEfetivado()).booleanValue()) {
                    this.efetivaAlteracaoSolicitacao(solicitacao);
                }
                String carne = null;
                Integer idBloqueto = null;
                if (solicitacao.isRedeSim() || this.getUsuarioLogadoFromSolicitacao(solicitacao) != null) {
                    for (DebitoEntity debito : debitosAlvara) {
                        if (debito == null || debito.getParcelas().size() <= 0) continue;
                        if (debito.getId().getGuiaRecolhimento().getGuiaAlvaraOnline() != null && SimNaoEnum.equalSim((String)debito.getId().getGuiaRecolhimento().getGuiaAlvaraOnline()).booleanValue()) {
                            carne = this.geraCarne(solicitacao, debito);
                        } else {
                            idBloqueto = this.srvDebitosPortal.geraBloqueto(debito.getParcelas());
                        }
                        this.logger.info((Object)(">>>>> GUIA: " + debito.getId().getGuiaRecolhimento().getId().getGuiaRecolhimento()));
                    }
                    if (!solicitacao.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.MUDANCA_RAZAO_SOCIAL}) && carne == null && idBloqueto == null) {
                        solicitacao.setEfetivado(SimNaoEnum.NAO.getShortText());
                        throw new SolicitacaoAlvaraException("N\u00e3o existe taxas a serem impressas para esta solicita\u00e7\u00e3o.");
                    }
                    return new ImprimirTaxasAlvara(carne, idBloqueto != null ? idBloqueto.toString() : null, UtilsController.getExercicio());
                }
                throw new GeraDebitoException(" Usu\u00e1rio n\u00e3o Autenticado!");
            }
            throw new SolicitacaoAlvaraException("Este Cadastro \u00e9 Isento de Taxas. Prossiga para a Impress\u00e3o do Alvar\u00e1!");
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new SolicitacaoAlvaraException(e.getMessage(), (Throwable)e);
        }
    }

    private boolean temRegimeFiscal(SolicitacaoAlvaraEntity solicitacao) {
        return this.repositoryRegimeFiscalPeriodoRealAise.existeRegimeFiscalVigente(solicitacao.getCadastroMobiliario().getCadastroGeral().getIdUnico());
    }

    private List<DebitoEntity> processarSolicitacao(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        List<Object> debitosAlvara = new ArrayList();
        try {
            debitosAlvara = solicitacao.isRenovacaoDeSolicitacao() ? this.processaSolicitacaoRenovacao(solicitacao, debitosAlvara) : this.processaSolicitacaoNaoRenovacao(solicitacao);
            debitosAlvara = debitosAlvara.stream().filter(debito -> this.repositoryDebitoParcela.verificaQtdeParcelasEmAberto(debito.getId().getGuiaRecolhimento().getGuiaRecolhimento(), debito.getExercicio(), debito.getCadastroGeral().getId()).compareTo(0L) != 0).collect(Collectors.toList());
        }
        catch (Exception e) {
            throw new SolicitacaoAlvaraException(e.getMessage());
        }
        return debitosAlvara;
    }

    public void validaSolicitacaoImpressaoTaxas(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        if (solicitacao.isRedeSim() && solicitacao.isGrauRiscoAlto() && !solicitacao.isTodosLaudosLiberados()) {
            return;
        }
        if (!solicitacao.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.INICIAL})) {
            this.verificaLaudoECorrigeDataValidadeAlvara(solicitacao);
            if (!this.verificaSitCadastroParaAlteracoes(solicitacao).booleanValue()) {
                throw new SolicitacaoAlvaraException("Situa\u00e7\u00e3o do Cadastro n\u00e3o \u00e9 v\u00e1lida ou existe uma data de validade sem laudos no alvar\u00e1 online.");
            }
            if (!EloListUtils.safeIsEmpty((List)solicitacao.getLaudos()).booleanValue() && solicitacao.isSituacaoMobiliarioDesatualizado()) {
                this.validarDocumentosParaImpressao(solicitacao);
                if (!this.isTodosLaudosLiberados(solicitacao)) {
                    throw new SolicitacaoAlvaraException(TODOS_OS_LAUDOS_DEVEM_ESTAR_LIBERADOS);
                }
            }
        }
        if (!solicitacao.isRedeSim() && solicitacao.isGrauRiscoAlto()) {
            if (solicitacao.exigeUploadDocumentos() && this.validaDocumentoRiscoC(solicitacao)) {
                this.validarDocumentosParaImpressao(solicitacao);
            }
            if (this.validaLaudoRiscoC(solicitacao) && !this.isTodosLaudosLiberados(solicitacao)) {
                throw new SolicitacaoAlvaraException(TODOS_OS_LAUDOS_DEVEM_ESTAR_LIBERADOS);
            }
        }
        if (!solicitacao.isRedeSim() && solicitacao.isAlteracaoRazaoOuRazaoESocio() && !this.isDocumentoComSituacaoValida(solicitacao.getDocumentos())) {
            throw new SolicitacaoAlvaraException(TODOS_OS_DOCUMENTOS_DEVEM_ESTAR_VALIDADOS);
        }
    }

    public void verificaLaudoECorrigeDataValidadeAlvara(SolicitacaoAlvaraEntity solicitacao) {
        if (solicitacao.isAlteracaoRazaoOuRazaoESocio() && !EloListUtils.safeIsEmpty((List)solicitacao.getLaudos()).booleanValue() && (solicitacao.isSituacaoMobiliarioNormal() || solicitacao.isSituacaoMobiliarioDesatualizadoOuVencido())) {
            if (solicitacao.possuiTodosLaudosLiberadoDefinitivo()) {
                solicitacao.getCadastroMobiliario().setDataValidadeAlvara(null);
            } else {
                Date menorDataLaudoProvisorio = null;
                for (LaudoAlvaraEntity laudo : solicitacao.getLaudos()) {
                    if (!laudo.isLaudoLiberadoProvisorio() || menorDataLaudoProvisorio != null && laudo.getDataValidade().compareTo(menorDataLaudoProvisorio) >= 0) continue;
                    menorDataLaudoProvisorio = laudo.getDataValidade();
                }
                if (menorDataLaudoProvisorio != null) {
                    solicitacao.getCadastroMobiliario().setDataValidadeAlvara(menorDataLaudoProvisorio);
                }
            }
        }
    }

    public boolean validaDocumentoRiscoC(SolicitacaoAlvaraEntity solicitacao) {
        return solicitacao.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.MUDANCA_ENDERECO, NaturezaSolicitacaoAlvaraEnum.ALTERACAO_ATIVIDADE, NaturezaSolicitacaoAlvaraEnum.INICIAL});
    }

    public boolean validaLaudoRiscoC(SolicitacaoAlvaraEntity solicitacao) {
        boolean valida = false;
        if (solicitacao.isNaturezaMudancaArea() && solicitacao.isAreaMaiorQueAtual()) {
            valida = true;
        }
        if (solicitacao.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.MUDANCA_ENDERECO, NaturezaSolicitacaoAlvaraEnum.ALTERACAO_ATIVIDADE, NaturezaSolicitacaoAlvaraEnum.INICIAL})) {
            valida = true;
        }
        return valida;
    }

    protected String geraCarne(SolicitacaoAlvaraEntity solicitacao, DebitoEntity debitoAlvara) {
        if (debitoAlvara != null) {
            StringBuilder envioCarne = new StringBuilder();
            envioCarne.append(debitoAlvara.getExercicio().toString());
            envioCarne.append(";");
            envioCarne.append(debitoAlvara.getId().getCadastroGeral().getId().getTipo().toString());
            envioCarne.append(";");
            envioCarne.append(debitoAlvara.getId().getCadastroGeral().getId().getCodigo().toString());
            envioCarne.append(";");
            envioCarne.append(debitoAlvara.getId().getGuiaRecolhimento().getId().getGuiaRecolhimento().toString());
            envioCarne.append(";");
            envioCarne.append(debitoAlvara.getId().getSubdivida().toString());
            boolean emiteCotaUnica = false;
            GuiaRecolhimentoEntity guia = debitoAlvara.getId().getGuiaRecolhimento();
            CadastroGeralAisePK cadastroGeralId = solicitacao.getCadastroMobiliario().getId();
            Long exercicioAtual = this.getEntidadeTributacao().getId().getExercicioTributacao().getExercicio();
            boolean possuiDebito = this.repositoryDebito.possuiDebitoNoCadastroByGuiaAndExercicio(guia, cadastroGeralId, exercicioAtual);
            if (possuiDebito) {
                if (!this.srvDebitosPortal.possuiDebitoPago(guia.getGuiaRecolhimento(), exercicioAtual, cadastroGeralId).booleanValue()) {
                    emiteCotaUnica = true;
                }
            } else {
                emiteCotaUnica = true;
            }
            return this.srvDebitosPortal.geraCarneAlvaraOnline(envioCarne.toString(), Boolean.valueOf(emiteCotaUnica));
        }
        return null;
    }

    protected List<DebitoEntity> processaSolicitacaoRenovacao(SolicitacaoAlvaraEntity solicitacao, List<DebitoEntity> debitosAlvara) throws BaseException {
        if (!this.verificaVencimentoLaudo(solicitacao).booleanValue()) {
            throw new SolicitacaoAlvaraException("N\u00e3o \u00e9 poss\u00edvel imprimir as taxas, existem laudos ou documentos vencidos. Acompanhar a libera\u00e7\u00e3o dos laudos.");
        }
        this.gerarDebitoAlvaraTaxaMobiliaria(solicitacao);
        this.gerarDebitoAlvaraLaudo(solicitacao);
        if (!solicitacao.isRedeSim()) {
            List debitosAlvaraEmAberto = this.repositoryDebito.carregarDebitosAlvaraEmAberto(solicitacao.getSolicitacaoAlvara());
            if (EloListUtils.safeIsEmpty((List)debitosAlvaraEmAberto).booleanValue()) {
                throw new SolicitacaoAlvaraException("Os d\u00e9bitos para esta solicita\u00e7\u00e3o j\u00e1 foram pagos.");
            }
            return debitosAlvaraEmAberto;
        }
        debitosAlvara = this.repositoryDebito.carregarDebitosAlvara(solicitacao.getSolicitacaoAlvara());
        if (EloListUtils.safeIsEmpty((List)debitosAlvara).booleanValue()) {
            throw new GeraDebitoException("N\u00e3o foram encontrados d\u00e9bitos para esta solicita\u00e7\u00e3o.");
        }
        return debitosAlvara;
    }

    protected SolicitacaoAlvaraDebitoEntity createSolicitacaoAlvaraDebito(SolicitacaoAlvaraEntity solicitacaoAlvara, Long idDebito) throws GeraDebitoException {
        try {
            SolicitacaoAlvaraDebitoEntity solicitacaoDebito = new SolicitacaoAlvaraDebitoEntity();
            solicitacaoDebito.setId(this.repositorySolicitacaoAlvaraDebito.getSequence());
            solicitacaoDebito.setExercicio(solicitacaoAlvara.getExercicio());
            solicitacaoDebito.setIdDebito(idDebito);
            solicitacaoDebito.setSolicitacaoAlvara(solicitacaoAlvara);
            SolicitacaoAlvaraDebitoEntity retorno = this.repositorySolicitacaoAlvaraDebito.saveOrUpdate(solicitacaoDebito);
            this.repositorySolicitacaoAlvaraDebito.flush();
            solicitacaoAlvara.getDebitos().add(retorno);
            return retorno;
        }
        catch (Exception e) {
            throw new GeraDebitoException("Falha ao Salvar o idDebito na SolicitacaoAlvaraDebito - " + e.getMessage(), (Throwable)e);
        }
    }

    protected List<DebitoEntity> processaSolicitacaoNaoRenovacao(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        this.gerarDebitoAlvaraTaxaMobiliaria(solicitacao);
        this.gerarDebitoAlvaraLaudo(solicitacao);
        if (!solicitacao.isRedeSim()) {
            List debitosAlvaraEmAberto = this.repositoryDebito.carregarDebitosAlvaraEmAberto(solicitacao.getSolicitacaoAlvara());
            if (EloListUtils.safeIsEmpty((List)debitosAlvaraEmAberto).booleanValue()) {
                throw new SolicitacaoAlvaraException("Os d\u00e9bitos para esta solicita\u00e7\u00e3o j\u00e1 foram pagos.");
            }
            return debitosAlvaraEmAberto;
        }
        return this.repositoryDebito.carregarDebitosAlvara(solicitacao.getSolicitacaoAlvara());
    }

    protected Boolean existeDebitoTaxaMobiliariaNoCadastroNoExercicioAtual(SolicitacaoAlvaraEntity solicitacao) {
        GuiaRecolhimentoEntity guia = this.getGuiaRecolhimentoByTipoInscricao(solicitacao);
        if (Objects.isNull(guia)) {
            return Boolean.FALSE;
        }
        return this.repositoryDebito.possuiDebitoNoCadastroByGuiaAndExercicio(guia, solicitacao.getCadastroMobiliario().getCadastroGeral().getId(), this.getExercicio());
    }

    protected DebitoEntity carregarDebitoTaxaMobiliariaDaSolicitacao(SolicitacaoAlvaraEntity solicitacao) {
        GuiaRecolhimentoEntity guia = this.getGuiaRecolhimentoByTipoInscricao(solicitacao);
        if (Objects.isNull(guia)) {
            return null;
        }
        return this.repositoryDebito.carregarDebitosAlvara(solicitacao.getSolicitacaoAlvara()).stream().sorted(Comparator.comparing(DebitoEntity::getIdDebito).reversed()).filter(debito -> debito.getId().getGuiaRecolhimento().getGuiaRecolhimento().compareTo(guia.getGuiaRecolhimento()) == 0).findFirst().orElse(null);
    }

    protected DebitoEntity carregarDebitoTaxaMobiliariaDoCadastro(SolicitacaoAlvaraEntity solicitacao) {
        GuiaRecolhimentoEntity guia = this.getGuiaRecolhimentoByTipoInscricao(solicitacao);
        if (Objects.isNull(guia)) {
            return null;
        }
        return this.repositoryDebito.carregarDebitosDoCadastroByGuiaAndExercicio(guia, solicitacao.getCadastroMobiliario().getCadastroGeral().getId(), this.getExercicio()).stream().sorted(Comparator.comparing(DebitoEntity::getIdDebito).reversed()).filter(debito -> debito.getId().getGuiaRecolhimento().getGuiaRecolhimento().compareTo(guia.getGuiaRecolhimento()) == 0).findFirst().orElse(null);
    }

    protected DebitoEntity gerarDebitoAlvaraTaxaMobiliaria(SolicitacaoAlvaraEntity solicitacaoAlvara) throws BaseException {
        try {
            DebitoEntity debitoTaxaMobiliaria = this.carregarDebitoTaxaMobiliariaDaSolicitacao(solicitacaoAlvara);
            if (Objects.nonNull(debitoTaxaMobiliaria)) {
                return debitoTaxaMobiliaria;
            }
            debitoTaxaMobiliaria = this.carregarDebitoTaxaMobiliariaDoCadastro(solicitacaoAlvara);
            if (Objects.nonNull(debitoTaxaMobiliaria) && debitoTaxaMobiliaria.getValorTotal().compareTo(BigDecimal.ZERO) != 0) {
                this.createSolicitacaoAlvaraDebito(solicitacaoAlvara, debitoTaxaMobiliaria.getIdDebito());
                return debitoTaxaMobiliaria;
            }
            if (this.isIsento(solicitacaoAlvara.getCadastroMobiliario().getCadastroGeral().getIsencoes()).booleanValue()) {
                return null;
            }
            DebitoAlvaraVo debitoAlvaraVo = new DebitoAlvaraVo();
            debitoAlvaraVo.setCadastroGeral(solicitacaoAlvara.getCadastroMobiliario().getCadastroGeral());
            debitoAlvaraVo.setEntidadeTributacao(this.getEntidadeTributacao());
            GuiaRecolhimentoEntity guia = this.getGuiaRecolhimentoByTipoInscricao(solicitacaoAlvara);
            if (Objects.isNull(guia)) {
                throw new GuiaRecolhimentoNaoEncontradaException(String.format("N\u00e3o encontramos Guia de Recolhimento para o Exerc\u00edcio:%s e o Tipo de Inscri\u00e7\u00e3o:%s.", EloDateUtils.getYear((Date)new Date()), solicitacaoAlvara.getTipoDeInscricao().getDescricao()));
            }
            debitoAlvaraVo.setGuiaRecolhimento(guia.getId().getGuiaRecolhimento());
            debitoAlvaraVo.setSolicitacaoAlvara(solicitacaoAlvara);
            String vencimentos = this.carregarParametrosVencimentosDebito();
            debitoAlvaraVo.setListaVencimento(vencimentos);
            if (SimNaoEnum.equalSim((String)solicitacaoAlvara.getCadastroMobiliario().getCadastroGeral().getExclusaoLogica()).booleanValue()) {
                this.alteraSituacaoCadastroExclusaoLogica(debitoAlvaraVo.getCadastroGeral(), SimNaoEnum.getNaoShortText());
            }
            Integer idDebito = this.srvDebitosPortal.gerarDebitoAlvara(debitoAlvaraVo, solicitacaoAlvara);
            return this.repositoryDebito.carregaDebito(Long.valueOf(idDebito.longValue()));
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new GeraDebitoException("Erro ao gerar D\u00e9bito de Taxa Mobili\u00e1ria " + e.getMessage(), (Throwable)e);
        }
    }

    protected DebitoEntity gerarDebitoAlvaraLaudo(SolicitacaoAlvaraEntity solicitacaoAlvara) throws BaseException {
        try {
            boolean cobraTaxaLaudo = this.getParametroAlvara(ParametroAlvaraEnum.COBRAR_TAXA_LAUDO).getValor().equals(SimNaoEnum.SIM.getShortText());
            if (!cobraTaxaLaudo) {
                return null;
            }
            if (!solicitacaoAlvara.isRenovacaoDeSolicitacao() && !EloListUtils.safeIsEmpty((List)solicitacaoAlvara.getLaudos()).booleanValue()) {
                String guiaTaxaLaudoValor = this.getValorParametro(ParametroEntidadeExercicioEnum.GUIARECOLHIMENTOLAUDO.name());
                if (EloStringUtils.isEmpty((String)guiaTaxaLaudoValor)) {
                    throw new SolicitacaoAlvaraException("N\u00e3o foi encontrado a configura\u00e7\u00e3o do parametro-entidade-exercicio: GUIARECOLHIMENTOLAUDO");
                }
                Long guiaTaxaLaudo = Long.parseLong(guiaTaxaLaudoValor);
                GuiaRecolhimentoEntity guia = this.repositoryGuiaRecolhimento.carregaGuiaRecolhimentoPorCodigo(this.getExercicio(), guiaTaxaLaudo);
                if (Objects.isNull(guia)) {
                    throw new GuiaRecolhimentoNaoEncontradaException(String.format("N\u00e3o encontramos Guia de Recolhimento %d para o Exerc\u00edcio %d", guiaTaxaLaudo, (long)EloDateUtils.getYear((Date)new Date())));
                }
                DebitoEntity debitoTaxaLaudo = this.repositoryDebito.carregarDebitosAlvara(solicitacaoAlvara.getSolicitacaoAlvara()).stream().sorted(Comparator.comparing(DebitoEntity::getIdDebito).reversed()).filter(debito -> debito.getId().getGuiaRecolhimento().getGuiaRecolhimento().compareTo(guia.getGuiaRecolhimento()) == 0).findFirst().orElse(null);
                if (Objects.nonNull(debitoTaxaLaudo)) {
                    return debitoTaxaLaudo;
                }
                DebitoLaudoVo debitoLaudoVo = new DebitoLaudoVo();
                debitoLaudoVo.setExercicio(this.getEntidadeTributacao().getId().getExercicioTributacao().getExercicio());
                debitoLaudoVo.setGuiaRecolhimento(Integer.valueOf(Integer.parseInt(this.getValorParametro(ParametroEntidadeExercicioEnum.GUIARECOLHIMENTOLAUDO.name()))));
                debitoLaudoVo.setReceita(this.getValorParametro(ParametroEntidadeExercicioEnum.RECEITALAUDO.name()));
                debitoLaudoVo.setValorPrincipal(Double.valueOf(Double.parseDouble(this.getValorParametro(ParametroEntidadeExercicioEnum.VALORLAUDO.name()))));
                debitoLaudoVo.setSolicitacaoAlvara(solicitacaoAlvara);
                Integer idDebito = this.srvDebitosPortal.gerarDebitoLaudo(debitoLaudoVo, solicitacaoAlvara);
                if (Objects.isNull(idDebito)) {
                    return null;
                }
                return this.repositoryDebito.carregaDebito(Long.valueOf(idDebito.longValue()));
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new GeraDebitoException("Erro ao gerar D\u00e9bito de Laudos. " + e.getMessage(), (Throwable)e);
        }
        return null;
    }

    protected boolean isImprimeAlvaraComDebitoPendente() throws BaseException {
        String imprimiAlvara = this.getParametroAlvara(ParametroAlvaraEnum.IMPRIME_ALVARA_COM_DEBITO_PENDENTE).getValor();
        return SimNaoEnum.SIM.getShortText().equals(imprimiAlvara);
    }

    public void imprimirAlvara(SolicitacaoAlvaraEntity solicitacao) throws BaseException, URISyntaxException {
        if (!solicitacao.isGrauRiscoLiberdadeEconomica()) {
            if (Objects.isNull(this.carregarDebitoTaxaMobiliariaDaSolicitacao(solicitacao)) && !this.existeDebitoTaxaMobiliariaNoCadastroNoExercicioAtual(solicitacao).booleanValue() && !this.isIsento(solicitacao.getCadastroMobiliario().getCadastroGeral().getIsencoes()).booleanValue()) {
                throw new GeraDebitoException(IMPRIMIR_TAXAS_ANTES_DO_ALVARA);
            }
            if (!this.isImprimeAlvaraComDebitoPendente() && this.isDebitoPendente(solicitacao)) {
                throw new SolicitacaoAlvaraException(PAGAMENTO_DEBITOS_PENDENTES);
            }
        }
        if (!solicitacao.isRenovacaoDeSolicitacao()) {
            this.validaImpressaoAlvaraNaoRenovacao(solicitacao);
        } else {
            this.validarLaudosParaImpressao(solicitacao);
            if (solicitacao.getDataValidadeSefaz() != null || solicitacao.isGrauRiscoAlto() || solicitacao.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.ALTERACAO_SOCIOS, NaturezaSolicitacaoAlvaraEnum.MUDANCA_RAZAO_SOCIAL})) {
                this.validarDocumentosVazios(solicitacao);
                this.validarDocumentosParaImpressao(solicitacao);
            }
            if (!this.verificaVencimentoLaudo(solicitacao).booleanValue()) {
                throw new SolicitacaoAlvaraException("N\u00e3o \u00e9 poss\u00edvel imprimir o alvar\u00e1, existem laudos ou documentos vencidos. Acompanhar a libera\u00e7\u00e3o dos laudos.");
            }
        }
        this.verificarExistemDocumentosAseremValidados(solicitacao);
        this.verificaSituacaoEmAnalise(solicitacao);
        if (!solicitacao.isNaturezaInicial() && solicitacao.getNumeroAlvara() == null && SimNaoEnum.equalNao((String)solicitacao.getEfetivado()).booleanValue()) {
            this.efetivaAlteracaoSolicitacao(solicitacao);
        }
        this.montarAlvaraOnline(solicitacao);
    }

    private void verificarExistemDocumentosAseremValidados(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        if (solicitacao.isGrauRiscoAlto() || solicitacao.isGrauRiscoBaixo() && solicitacao.isRenovacaoDeSolicitacao()) {
            String msgDocumentos;
            ArrayList tiposDeDocumentosASeremValidados = this.getParamCodTipoDocAseremValidadosNaImpressao(solicitacao);
            if (!EloListUtils.safeIsEmpty((List)tiposDeDocumentosASeremValidados).booleanValue() && !EloStringUtils.isEmpty((String)(msgDocumentos = this.verificarDocumentosASeremValidados(solicitacao, tiposDeDocumentosASeremValidados)))) {
                throw new SolicitacaoAlvaraException(msgDocumentos);
            }
        } else if (solicitacao.isGrauRiscoLiberdadeEconomica() && solicitacao.isNaturezaInicial()) {
            String msgDocumentos;
            String tipoDocumentoInscricaoCadastroMobiliario = UtilsController.getParametroAlvara((ParametroAlvaraEnum)ParametroAlvaraEnum.TIPO_DOCUMENTO_INSCRICAO_CADASTRO_MOBILIARIO).getValor();
            if (solicitacao.getSolicitacaoAlvaraAtividades().stream().anyMatch(SolicitacaoAlvaraAtividadeEntity::obrigaDocumentoInscricaoCadastroMobiliario) && !EloStringUtils.isEmpty((String)(msgDocumentos = this.verificarDocumentosASeremValidados(solicitacao, new ArrayList<String>(Collections.singletonList(tipoDocumentoInscricaoCadastroMobiliario)))))) {
                throw new SolicitacaoAlvaraException(msgDocumentos);
            }
        }
    }

    public String verificarDocumentosASeremValidados(SolicitacaoAlvaraEntity solicitacao, ArrayList<String> tiposDeDocumentosASeremValidados) {
        StringBuilder msgDocBuilder = new StringBuilder();
        ArrayList solicitacaoDocs = Lists.newArrayList();
        for (String tipoDocNoParam : tiposDeDocumentosASeremValidados) {
            Long tipoDocParam = Long.valueOf(tipoDocNoParam);
            SolicitacaoAlvaraDocumentoEntity doc = solicitacao.getDocumentoSolicitacaoByTipo(tipoDocParam);
            if (!Objects.nonNull(doc)) continue;
            solicitacaoDocs.add(solicitacao.getDocumentoSolicitacaoByTipo(tipoDocParam));
        }
        if (solicitacaoDocs.size() != tiposDeDocumentosASeremValidados.size()) {
            Long[] tipos = this.converteTipoDocumentoParaLong(tiposDeDocumentosASeremValidados);
            List tiposDocumentos = this.repositoryTipoDocumento.buscarTiposDocumento(tipos);
            msgDocBuilder.append("Favor Adicionar os documentos na solicita\u00e7\u00e3o: ");
            for (TipoDocumentoEntity tipoDoc : tiposDocumentos) {
                if (this.contemTipoDocNosDocsSolicitacao((List)solicitacaoDocs, tipoDoc)) continue;
                msgDocBuilder.append(tipoDoc.getDescricao()).append(", ");
            }
        } else {
            for (SolicitacaoAlvaraDocumentoEntity documento : solicitacaoDocs) {
                for (String tipoDocNoParam : tiposDeDocumentosASeremValidados) {
                    Long tipoDocParam = Long.valueOf(tipoDocNoParam);
                    if (!documento.getTipoDocumento().getTipoDocumento().equals(tipoDocParam) || documento.isDocumentoValidado() || solicitacao.existeOutroDocumentoValidadoParaTipoDocumento(documento)) continue;
                    msgDocBuilder.append(documento.getTipoDocumento().getDescricao()).append(", ");
                }
            }
            if (!EloStringUtils.isEmpty((String)msgDocBuilder.toString())) {
                msgDocBuilder.insert(0, "Favor Adicionar os documentos na solicita\u00e7\u00e3o: ");
            }
        }
        if (!EloStringUtils.isEmpty((String)msgDocBuilder.toString())) {
            msgDocBuilder.append("(Se j\u00e1 foi adicionado os documentos, favor aguardar a valida\u00e7\u00e3o pelo setor de alvar\u00e1.)");
        }
        return msgDocBuilder.toString();
    }

    private boolean contemTipoDocNosDocsSolicitacao(List<SolicitacaoAlvaraDocumentoEntity> solicitacaoDocs, TipoDocumentoEntity tipoDoc) {
        for (SolicitacaoAlvaraDocumentoEntity doc : solicitacaoDocs) {
            if (!doc.getTipoDocumento().getTipoDocumento().equals(tipoDoc.getTipoDocumento())) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private Long[] converteTipoDocumentoParaLong(ArrayList<String> tiposDeDocumentosASeremValidados) {
        Long[] tipos = new Long[tiposDeDocumentosASeremValidados.size()];
        for (int i = 0; i < tiposDeDocumentosASeremValidados.size(); ++i) {
            tipos[i] = Long.valueOf(tiposDeDocumentosASeremValidados.get(i));
        }
        return tipos;
    }

    private ArrayList<String> getParamCodTipoDocAseremValidadosNaImpressao(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        ArrayList<String> tiposDeDocumentosASeremValidados = new ArrayList<String>();
        for (NaturezaSolicitacaoAlvaraEntity natureza : solicitacao.getNaturezas()) {
            String[] arrParam;
            ParametroAlvaraNaturezaEntity paramNatureza = this.getParametroPorNatureza(natureza, ParametroAlvaraNaturezaEnum.DOCUMENTOS_VALIDADOS_IMPRESSAO, solicitacao.getTipoDeInscricao());
            if (!Objects.nonNull(paramNatureza) || EloStringUtils.isEmpty((String)paramNatureza.getValor())) continue;
            for (String tipoDoc : arrParam = paramNatureza.getValor().split(",")) {
                if (tiposDeDocumentosASeremValidados.contains(tipoDoc)) continue;
                tiposDeDocumentosASeremValidados.add(tipoDoc);
            }
        }
        return tiposDeDocumentosASeremValidados;
    }

    public void montarAlvaraOnline(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        List listaValidadeAlvaraAtual = this.repositorySolicitacaoValidade.retornaValidadeBySolicitacao(solicitacao);
        List listaValidadeAlvaraNova = this.carregaListaVencimentoAlvara(solicitacao);
        this.verificaSituacaoVencidoOuDesatualizado(solicitacao);
        solicitacao.setObservacoes(this.montaObservacoesAlvara(solicitacao));
        solicitacao.getCadastroMobiliario().setObservacaoAlvara(solicitacao.getObservacoes().replaceAll("\r", " - ").replaceAll("\t", " - ").replaceAll("\n", " - ").replaceAll(" - - - ", " - "));
        if (!EloListUtils.safeIsEmpty((List)solicitacao.getLaudos()).booleanValue() && solicitacao.isTodosLaudosLiberados()) {
            solicitacao.setDataValidadeProvisorio(null);
            solicitacao.getCadastroMobiliario().setDataValidadeAlvara(null);
        }
        solicitacao.setCadastroMobiliario(this.salvarCadastroMobiliario(solicitacao.getCadastroMobiliario()));
        this.atualizarSolicitacaoAlvara(solicitacao);
        this.gerarEImprimirDocumento(listaValidadeAlvaraAtual, listaValidadeAlvaraNova, solicitacao);
        this.atualizarSolicitacaoAlvara(solicitacao);
    }

    protected boolean isPrimeiraParcelaPaga(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        boolean primeiraParcelaEmAberto = false;
        ArrayList<DebitoEntity> debitos = new ArrayList<DebitoEntity>();
        for (SolicitacaoAlvaraDebitoEntity debitoAlvara : solicitacao.getDebitos()) {
            debitos.add(this.repositoryDebito.carregaDebito(debitoAlvara.getIdDebito()));
        }
        if (!EloListUtils.safeIsEmpty(debitos).booleanValue()) {
            for (DebitoEntity debito : debitos) {
                List parcelas = this.repositoryDebitoParcela.recuperaParcelas(debito);
                for (DebitoParcelaEntity parcela : parcelas) {
                    if (parcela.getId().getParcela() != 1L || parcela.getSituacaoDebito().getId() != 1L) continue;
                    primeiraParcelaEmAberto = true;
                }
            }
        }
        return primeiraParcelaEmAberto;
    }

    protected boolean isDebitoPendente(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        CadastroMobiliarioEntity cm = solicitacao.getCadastroMobiliario();
        return this.repositoryDebitoParcela.possuiDebitosAPagar(cm.getCadastroGeral().getId().getTipo(), cm.getCadastroGeral().getId().getCodigo());
    }

    public Boolean isIsento(List<CadastroGeralIsencaoEntity> listaIsencoes) throws BaseException {
        String paramIsencaoDebito = UtilsController.getValorParametroAlvara((ParametroAlvaraEnum)ParametroAlvaraEnum.ISENCAO_DEBITO_PESSOA_JURIDICA_NORMAL);
        Long[] codigosIsencao = EloStringUtils.strToLong((String[])paramIsencaoDebito.split(","));
        if (codigosIsencao != null && !EloListUtils.safeIsEmpty(listaIsencoes).booleanValue()) {
            for (CadastroGeralIsencaoEntity isencaoCadastro : listaIsencoes) {
                for (Long codIsencao : codigosIsencao) {
                    if (isencaoCadastro.getId().getIsencao().getId().compareTo(codIsencao) != 0) continue;
                    return Boolean.TRUE;
                }
            }
        }
        return Boolean.FALSE;
    }

    public void efetivaAlteracaoSolicitacao(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        SolicitacaoAlvaraObservacaoDTO solicitacaoAlvaraObservacaoAnterior = SolicitacaoAlvaraObservacaoDTO.of((SolicitacaoAlvaraEntity)solicitacao);
        solicitacao.getCadastroMobiliario().setTelefone(solicitacao.getTelefonePreenchido());
        solicitacao.getCadastroMobiliario().getCadastroGeral().setDataAlteracao(new Date());
        this.srvDesvincularPessoaComCadastro.desvincularPessoaComCadastro(solicitacao);
        try {
            this.validarPessoaAPIExterna(solicitacao);
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new SolicitacaoAlvaraException("Falha ao consultar a integra\u00e7\u00e3o de pessoas do ISS-e. " + e.getMessage(), (Throwable)e);
        }
        if (solicitacao.isNaturezaMudancaRazaoSocial()) {
            this.salvarAlteracaoRazaoSocial(solicitacao);
        }
        if (solicitacao.isNaturezaMudancaEndereco()) {
            if (this.isRural(solicitacao)) {
                CadastroGeralAiseEntity cadastroGeral = solicitacao.getCadastroMobiliario().getCadastroGeral();
                this.setEnderecoRural(solicitacao.getCadastroMobiliario().getCadastroGeral(), solicitacao);
                EnderecoPessoaEntity enderecoPessoa = new EnderecoPessoaEntity();
                enderecoPessoa.setLogradouroEndereco(cadastroGeral.getLogradouro());
                enderecoPessoa.setBairro(cadastroGeral.getBairro());
                enderecoPessoa.setCep(Long.valueOf(cadastroGeral.getCep().longValue()));
                enderecoPessoa.setTipoEndereco(EnderecoTipoEnum.COMERCIAL.getId().toString());
                enderecoPessoa.setComplemento(cadastroGeral.getComplemento());
                this.salvarEnderecoPessoa(enderecoPessoa, cadastroGeral.getPessoa());
                cadastroGeral.setDataAlteracao(new Date());
                CadastroMobiliarioEntity cadastroMobiliario = solicitacao.getCadastroMobiliario();
                cadastroMobiliario.setCadastroGeral(cadastroGeral);
                this.salvarCadastroMobiliario(cadastroMobiliario);
                PessoaEntity pessoaSalva = this.salvarPessoa(cadastroGeral.getPessoa());
                cadastroGeral.setPessoa(pessoaSalva);
                this.salvarCadastroGeral(cadastroGeral, solicitacao);
            } else {
                this.salvarAlteracaoEndereco(solicitacao);
            }
        }
        List cnaesAntigos = Collections.emptyList();
        if (solicitacao.isNaturezaAlteracaoAtividade()) {
            solicitacao.getCadastroMobiliario().setAtividadePrincipal(solicitacao.getDescricaoAtividades());
            cnaesAntigos = this.loadCnaesBySolicitacaoAlvara(solicitacao);
            this.salvarAlteracaoAtividade(solicitacao);
        }
        if (solicitacao.isNaturezaAlteracaoSocio()) {
            this.salvarAlteracaoSocio(solicitacao);
        }
        if (solicitacao.isNaturezaMudancaArea()) {
            this.salvarAlteracaoArea(solicitacao);
        }
        if (solicitacao.isAlteracaoNaturezaJuridica()) {
            this.atualizarNaturezaJuridica(solicitacao);
        }
        this.atualizarContatoPessoa(solicitacao);
        this.salvarObservacao(solicitacao, solicitacaoAlvaraObservacaoAnterior, cnaesAntigos);
        solicitacao.setEfetivado(SimNaoEnum.SIM.getShortText());
        this.atualizarSolicitacaoAlvara(solicitacao);
        SituacaoMobiliarioAlvaraEnum situacaoMobiliarioAlvara = SituacaoMobiliarioAlvaraEnum.SITUACAO_NORMAL;
        if (SimNaoEnum.equalSim((String)this.getParametroAlvara(ParametroAlvaraEnum.ENVIA_INSCRICAO_MUNICIPAL_COM_DADOS_ATUALIZADOS).getValor()).booleanValue()) {
            situacaoMobiliarioAlvara = SituacaoMobiliarioAlvaraEnum.SITUACAO_CADASTRO_ATUALIZADO_PELA_JUNTA;
        }
        this.srvDebitosPortal.alteraMobiliarioSituacao(solicitacao, situacaoMobiliarioAlvara);
    }

    public void alterarNaturezaJuridica(SolicitacaoAlvaraEntity solicitacaoAlvara) throws SolicitacaoAlvaraRedeSimException {
        this.atualizarNaturezaJuridica(solicitacaoAlvara);
    }

    private boolean isRural(SolicitacaoAlvaraEntity solicitacao) throws SolicitacaoAlvaraRedeSimException {
        SolicitacaoRedeSimEntity solicitacaoRedesim = this.repositoryConsultaRedeSim.getConsultaByTipo(solicitacao.getProtocoloRedeSim(), TipoSolicitacaoRedeSimEnum.SOLICITACAO);
        return solicitacaoRedesim.isRuralArquivoEmpresa();
    }

    protected void validaImpressaoAlvaraNaoRenovacao(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        if (solicitacao.isGrauRiscoAlto()) {
            this.validarDocumentosParaImpressao(solicitacao);
            this.validarLaudosParaImpressao(solicitacao);
        } else if (!solicitacao.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.INICIAL, NaturezaSolicitacaoAlvaraEnum.ALTERACAO_ATIVIDADE, NaturezaSolicitacaoAlvaraEnum.MUDANCA_AREA, NaturezaSolicitacaoAlvaraEnum.MUDANCA_ENDERECO})) {
            this.validarDocumentosParaImpressao(solicitacao);
            this.validarLaudosParaImpressao(solicitacao);
        }
        List debitosAlvara = this.carregarDebitosSolicitacaoAlvara(solicitacao);
        if (!solicitacao.isGrauRiscoLiberdadeEconomica() && EloListUtils.safeIsEmpty((List)debitosAlvara).booleanValue()) {
            if (solicitacao.isNaturezaInicial()) {
                throw new GeraDebitoException(IMPRIMIR_TAXAS_ANTES_DO_ALVARA);
            }
            if (Objects.isNull(this.carregarDebitoTaxaMobiliariaDaSolicitacao(solicitacao)) && !this.existeDebitoTaxaMobiliariaNoCadastroNoExercicioAtual(solicitacao).booleanValue() || SimNaoEnum.equalSim((String)this.getParametroAlvara(ParametroAlvaraEnum.COBRAR_TAXA_LAUDO).getValor()).booleanValue()) {
                if (solicitacao.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.ALTERACAO_ATIVIDADE}) && solicitacao.possuiAtividadeNova() || solicitacao.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.MUDANCA_ENDERECO}) || solicitacao.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.MUDANCA_AREA}) && (SimNaoEnum.equalSim((String)solicitacao.getAreaMaiorQueAtual()).booleanValue() || solicitacao.isSituacaoMobiliarioDesatualizadoOuVencido())) {
                    throw new GeraDebitoException(IMPRIMIR_TAXAS_ANTES_DO_ALVARA);
                }
                if (solicitacao.isNaturezaMudancaArea() && (SimNaoEnum.equalSim((String)solicitacao.getAreaMaiorQueAtual()).booleanValue() || solicitacao.isSituacaoMobiliarioDesatualizadoOuVencido())) {
                    throw new GeraDebitoException(IMPRIMIR_TAXAS_ANTES_DO_ALVARA);
                }
                if (solicitacao.isNaturezaMudancaRazaoSocial() && solicitacao.isSituacaoMobiliarioDesatualizadoOuVencido()) {
                    throw new GeraDebitoException(IMPRIMIR_TAXAS_ANTES_DO_ALVARA);
                }
                if (solicitacao.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.ALTERACAO_SOCIOS, NaturezaSolicitacaoAlvaraEnum.MUDANCA_RAZAO_SOCIAL})) {
                    this.validarDocumentosParaImpressao(solicitacao);
                }
            }
            if (!this.verificaSitCadastroParaAlteracoes(solicitacao).booleanValue()) {
                throw new SolicitacaoAlvaraException("Situa\u00e7\u00e3o do Cadastro n\u00e3o \u00e9 v\u00e1lida ou existe uma data de validade sem laudos no alvar\u00e1 online.\nEnviar e-mail para " + this.getEmailSetorCadastroAlvara() + ", informar o n\u00famero da Solicita\u00e7\u00e3o do Alvar\u00e1.");
            }
        }
        if (solicitacao.getDataValidadeSefaz() != null && !solicitacao.isRedeSim()) {
            this.validarDocumentosVazios(solicitacao);
            this.validarDocumentosParaImpressao(solicitacao);
        }
    }

    private void validarLaudosParaImpressao(SolicitacaoAlvaraEntity solicitacao) throws BaseException, SolicitacaoAlvaraException {
        if (!EloListUtils.safeIsEmpty((List)solicitacao.getLaudos()).booleanValue() && !this.isTodosLaudosLiberados(solicitacao)) {
            throw new SolicitacaoAlvaraException(TODOS_OS_LAUDOS_DEVEM_ESTAR_LIBERADOS);
        }
    }

    protected void validarDocumentosParaImpressao(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        if (solicitacao.exigeUploadDocumentos() && !this.isDocumentoComSituacaoValida(solicitacao.getDocumentos()) && !solicitacao.isRedeSim()) {
            throw new SolicitacaoAlvaraException(TODOS_OS_DOCUMENTOS_DEVEM_ESTAR_VALIDADOS);
        }
    }

    protected void validarDocumentosVazios(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        if (solicitacao.exigeUploadDocumentos() && solicitacao.getDocumentos().isEmpty() && !solicitacao.isRedeSim()) {
            throw new SolicitacaoAlvaraException(TODOS_OS_DOCUMENTOS_DEVEM_ESTAR_VALIDADOS);
        }
    }

    protected boolean isTodosLaudosLiberados(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        boolean exigeLaudosLiberados = UtilsController.isValorSimParaAlgumaNaturezaDaSolicitacao((SolicitacaoAlvaraEntity)solicitacao, (ParametroAlvaraNaturezaEnum)ParametroAlvaraNaturezaEnum.EXIGE_TODOS_LAUDOS_LIBERADOS);
        if (exigeLaudosLiberados || solicitacao.isSituacaoMobiliarioDesatualizado()) {
            boolean renderBotao = false;
            renderBotao = EloListUtils.safeIsEmpty((List)solicitacao.getLaudos()) == false ? solicitacao.possuiTodosLaudosLiberado() : true;
            return renderBotao;
        }
        return true;
    }

    protected Boolean getIntegradoGeo() {
        return this.repositoryParametroGeral.verificaIntegradoGeo();
    }

    public Boolean isSituacaoMobiliario(CadastroMobiliarioEntity cadastroMobiliario, String[] situacoes) {
        MobiliarioSituacaoEntity mobiliarioSituacao = this.getMobiliarioSituacaoAtual(cadastroMobiliario);
        if (this.verificarSituacaoMob(mobiliarioSituacao.getSituacaoMobiliario(), EloStringUtils.strToLong((String[])situacoes)).booleanValue()) {
            return true;
        }
        return false;
    }

    public Boolean isTipoPessoaMob(CadastroMobiliarioEntity cadastroMobiliario, String[] tiposPessoas) {
        if (this.verificarTipoPessoaMob(cadastroMobiliario.getPessoaMobiliario(), EloStringUtils.strToLong((String[])tiposPessoas)).booleanValue()) {
            return true;
        }
        return false;
    }

    public void generateLaudos(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        this.geraLaudos(solicitacao);
    }

    protected void geraLaudos(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        if (!UtilsController.isIntegracaoSimplificadaRedeSim() && EloListUtils.safeIsEmpty((List)solicitacao.getLaudos()).booleanValue()) {
            if (solicitacao.isSolicitacaoJuridicaNormal() || solicitacao.isSolicitacaoMEINormal()) {
                if (this.getIntegradoGeo().booleanValue()) {
                    if (!EloListUtils.safeIsEmpty((List)solicitacao.getSolicitacaoAlvaraAtividades()).booleanValue() && Objects.nonNull(solicitacao.carregarCadastroImobiliario())) {
                        this.consultarAtividadesNovoGeo(solicitacao);
                    }
                } else if (this.isSituacaoGeraLaudo(solicitacao)) {
                    List laudosExigidos;
                    List list = laudosExigidos = this.existsScriptsGeracaoLaudoAlvara() ? this.getLaudosExigidosScriptAlvaraDasAtividades(solicitacao, solicitacao.getProtocoloRedeSim()) : this.buscarLaudosExigidosPorAtividade(solicitacao.getSolicitacaoAlvaraAtividades());
                    if (!EloListUtils.safeIsEmpty((List)laudosExigidos).booleanValue()) {
                        this.salvarLaudo(laudosExigidos, solicitacao);
                    }
                }
            } else {
                Set laudos = this.srvSolicitacaoAlvaraPrestadorServico.getLaudosAGerar(solicitacao);
                this.srvSolicitacaoAlvaraPrestadorServico.geraLaudo(solicitacao, laudos);
            }
            if ((solicitacao.isGrauRiscoLiberdadeEconomica() || this.isMeisECriaLaudosAoRececerDadosEmpresaEnviaInscricaoComDadosAtualizados(solicitacao)) && !EloListUtils.safeIsEmpty((List)solicitacao.getLaudos()).booleanValue()) {
                solicitacao = this.liberarLaudosLiberdadeEconomica(solicitacao);
            }
            this.repositorySolicitacaoAlvara.saveOrUpdate(solicitacao);
        }
    }

    public boolean existsScriptsGeracaoLaudoAlvara() {
        List scriptsGeracaoLaudo = this.repositoryScriptAlvara.findAll().stream().filter(scriptAlvara -> Objects.nonNull(scriptAlvara.getTipo()) && Boolean.TRUE.equals(scriptAlvara.getTipo().getLaudo())).filter(scriptAlvara -> Objects.nonNull(scriptAlvara.getCodigoFonte())).collect(Collectors.toList());
        return EloListUtils.safeIsEmpty(scriptsGeracaoLaudo) == false;
    }

    private SolicitacaoAlvaraEntity liberarLaudosLiberdadeEconomica(SolicitacaoAlvaraEntity solicitacao) {
        solicitacao.getLaudos().stream().forEach(laudo -> {
            laudo.setStatus(StatusLaudoAlvara.LIBERDADE_ECONOMICA);
            this.repositoryLaudoAlvara.saveOrUpdate(laudo);
        });
        return solicitacao;
    }

    public void adicionaSituacaoMobiliario(CadastroMobiliarioEntity cadastroMobiliario, SituacaoMobiliarioEntity situacaoMobiliario) {
        MobiliarioSituacaoEntity mobiliarioSituacaoNova = new MobiliarioSituacaoEntity();
        mobiliarioSituacaoNova.setCadastroMobiliario(cadastroMobiliario);
        MobiliarioSituacaoPK id = new MobiliarioSituacaoPK();
        id.setCadastroGeralPK(cadastroMobiliario.getId());
        id.setSequencia(this.repositoryMobiliarioSituacao.getSequencia(cadastroMobiliario.getId()));
        mobiliarioSituacaoNova.setId(id);
        mobiliarioSituacaoNova.setAtual(SimNaoEnum.getSimShortText());
        List listaMobiliario = this.repositoryMobiliarioSituacao.buscaMobiliarioSituacaoPorCodMobiliario(cadastroMobiliario.getId().getCodigo());
        if (listaMobiliario != null) {
            for (MobiliarioSituacaoEntity mobiliarioSituacao : listaMobiliario) {
                mobiliarioSituacao.setAtual(SimNaoEnum.getNaoShortText());
                this.repositoryMobiliarioSituacao.saveOrUpdate(mobiliarioSituacao);
            }
        }
        mobiliarioSituacaoNova.setSituacaoMobiliario(situacaoMobiliario);
        mobiliarioSituacaoNova.setDataInclusao(new Date());
        mobiliarioSituacaoNova.setUsuarioInclusao(PortalUtils.getUsuarioalvaraonline());
        cadastroMobiliario.addMobiliarioSituacao(this.repositoryMobiliarioSituacao.saveOrUpdate(mobiliarioSituacaoNova));
        this.repositoryCadastroMobiliario.saveOrUpdate(cadastroMobiliario);
    }

    public void executeAlteracaoArea(SolicitacaoAlvaraEntity solicitacao) throws SolicitacaoAlvaraException {
        if (solicitacao.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.MUDANCA_ENDERECO, NaturezaSolicitacaoAlvaraEnum.MUDANCA_AREA}) && solicitacao.getNumeroAlvara() == null && !SimNaoEnum.SIM.getShortText().equals(solicitacao.getEfetivado())) {
            this.salvarAlteracaoArea(solicitacao);
        }
    }

    public SolicitacaoAlvaraEntity iniciaConsultaPrevia(ConsultaPreviaVo consultaPreviaVo) throws BaseException {
        if (consultaPreviaVo.getSolicitacaoAlvara() == null) {
            consultaPreviaVo.setSolicitacaoAlvara(new SolicitacaoAlvaraEntity());
        }
        SolicitacaoAlvaraEntity solicitacao = consultaPreviaVo.getSolicitacaoAlvara();
        solicitacao.setTipoDeInscricao(consultaPreviaVo.getTipoInscricaoAlvara());
        solicitacao.setTipoRequerente(consultaPreviaVo.getTipoRequerente());
        this.preencherCadastroMobiliario(consultaPreviaVo, solicitacao);
        solicitacao.setNaturezas(consultaPreviaVo.getNaturezas());
        solicitacao.setCpfCnpjConsulta(Objects.isNull(solicitacao.getCpfCnpjConsulta()) ? consultaPreviaVo.getCpfCnpj() : null);
        if (!solicitacao.isNaturezaInicial() && !solicitacao.isRedeSim()) {
            solicitacao.setCpfCnpjCmcResponsavel(this.retornaCnpjCmcResponsavel(solicitacao.getCadastroMobiliario().getCmcresponsavel()));
            solicitacao.setNomeCmcResponsavel(this.retornaNomeCmcResponsavel(solicitacao.getCadastroMobiliario().getCmcresponsavel()));
            solicitacao.setNomeRazaoSocial(solicitacao.getCadastroMobiliario().getCadastroGeral().getPessoa().getNome());
            solicitacao.setAreaConstruida(solicitacao.getCadastroMobiliario().getAreaConstruida());
            solicitacao.setAreaUtilizada(solicitacao.getCadastroMobiliario().getAreaUtilizada());
            solicitacao.setAreaPatio(solicitacao.getCadastroMobiliario().getAreaPatio());
            this.validaAtividades(solicitacao);
            solicitacao.atribuirGrauRiscoCadastroMobiliario();
            this.validacoesAlteracao(solicitacao);
        }
        if (solicitacao.isSolicitacaoMEI() || this.isPermitirInserirClassificacaoPessoaJuridica().booleanValue()) {
            solicitacao.setClassificacaoTipoInscricao(new ClassificacaoTipoInscricaoEntity(solicitacao));
            if (!solicitacao.isNaturezaInicial() && !solicitacao.isRedeSim()) {
                if (EloNumberUtils.isBiggerThanZero((Number)solicitacao.getCadastroMobiliario().getAreaUtilizada()).booleanValue()) {
                    solicitacao.getClassificacaoTipoInscricao().setPontoReferencia("N");
                } else {
                    solicitacao.getClassificacaoTipoInscricao().setPontoReferencia("S");
                }
            }
        }
        return solicitacao;
    }

    private void preencherCadastroMobiliario(ConsultaPreviaVo consultaPreviaVo, SolicitacaoAlvaraEntity solicitacao) {
        List cadastroMobiliario;
        solicitacao.setCadastroMobiliario(null);
        if (consultaPreviaVo.getCadastroMobiliario() != null) {
            solicitacao.setCadastroMobiliario(consultaPreviaVo.getCadastroMobiliario());
        } else if (solicitacao.isRedeSim() && !EloListUtils.safeIsEmpty((List)(cadastroMobiliario = this.srvConsultaPrevia.loadCadastroMobiliarioByCpfCnpj(consultaPreviaVo.getCpfCnpj()))).booleanValue() && cadastroMobiliario.size() == 1) {
            solicitacao.setCadastroMobiliario((CadastroMobiliarioEntity)cadastroMobiliario.stream().findFirst().get());
        }
    }

    protected Boolean isPermitirInserirClassificacaoPessoaJuridica() throws BaseException {
        try {
            return SimNaoEnum.getSimShortText().equals(this.srvParametroAlvara.getValorParametroAlvara(ParametroAlvaraEnum.PERMITE_INSERIR_CLASSIFICACAO_PESSOA_JURIDICA));
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    protected Boolean isMobiliarioExistente() throws BaseException {
        try {
            return SimNaoEnum.getSimShortText().equals(this.srvParametroAlvara.getValorParametroAlvara(ParametroAlvaraEnum.ALTERACAO_ENDERECO_IMOBILIARIO_OBRIGATORIO));
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    private void validaAtividades(SolicitacaoAlvaraEntity solicitacao) throws SolicitacaoAlvaraException, IndeferimentoRedeSimException {
        String mensagem = "";
        boolean valida = true;
        if (solicitacao.isSolicitacaoCBO()) {
            if (!solicitacao.isNaturezaAlteracaoAtividade() && EloListUtils.safeIsEmpty((List)solicitacao.getCadastroMobiliario().getMobiliarioCbos()).booleanValue()) {
                mensagem = "N\u00e3o existe CBO para este cadastro mobili\u00e1rio, selecione Altera\u00e7\u00e3o de Atividade para incluir os CBOs.";
                valida = false;
            } else {
                for (CadastroMobiliarioCboEntity mobCbo : solicitacao.getCadastroMobiliario().getMobiliarioCbos()) {
                    if (!EloStringUtils.isEmpty((String)mobCbo.getRhCbo().getGrauRisco())) continue;
                    mensagem = "O cadastro mobili\u00e1rio possui CBO sem grau de risco definido.";
                    mensagem = this.montarMensagem(mensagem);
                    valida = false;
                }
            }
        } else if (!solicitacao.isNaturezaAlteracaoAtividade() && solicitacao.isSolicitacaoMEI()) {
            if (EloListUtils.safeIsEmpty((List)solicitacao.getCadastroMobiliario().getMobiliarioAtividadeMeis()).booleanValue()) {
                mensagem = "N\u00e3o existe Atividade MEI para este cadastro mobili\u00e1rio, selecione Altera\u00e7\u00e3o de Atividade para incluir as Atividades MEI.";
                valida = false;
            } else {
                for (CadastroMobiliarioAtividadeMeiEntity mobMei : solicitacao.getCadastroMobiliario().getMobiliarioAtividadeMeis()) {
                    if (!EloStringUtils.isEmpty((String)mobMei.getAtividadeMei().getCnae().getGrauRisco())) continue;
                    mensagem = "O cadastro mobili\u00e1rio possui Atividade MEI sem grau de risco definido.";
                    mensagem = this.montarMensagem(mensagem);
                    valida = false;
                }
            }
        } else if (!solicitacao.isNaturezaAlteracaoAtividade() && EloListUtils.safeIsEmpty((List)solicitacao.getCadastroMobiliario().getMobiliarioCnaes()).booleanValue()) {
            mensagem = "N\u00e3o existe CNAE para este cadastro mobili\u00e1rio, selecione Altera\u00e7\u00e3o de Atividade para incluir os CNAEs.";
            valida = false;
        } else {
            for (MobiliarioCnaeEntity mobCnae : solicitacao.getCadastroMobiliario().getMobiliarioCnaes()) {
                if (!EloStringUtils.isEmpty((String)mobCnae.getId().getCnae().getGrauRisco())) continue;
                mensagem = "O cadastro mobili\u00e1rio possui CNAE sem grau de risco definido.";
                mensagem = this.montarMensagem(mensagem);
                valida = false;
            }
        }
        if (!valida) {
            if (solicitacao.isRedeSim()) {
                throw new IndeferimentoRedeSimException(MotivoIndeferimentoRedeSimEnum.DADOS_INCONSISTENTES, mensagem);
            }
            throw new SolicitacaoAlvaraException(mensagem);
        }
    }

    private String montarMensagem(String mensagem) throws SolicitacaoAlvaraException {
        return String.format("%s Por gentileza, enviar e-mail para \"%s\" informando o cadastro da inscri\u00e7\u00e3o.", mensagem, UtilsController.getEmailSetorAlvara());
    }

    public String retornaCnpjCmcResponsavel(Long cadastroGeral) throws BaseException {
        if (cadastroGeral != null) {
            CadastroMobiliarioEntity cadastroMobiliario = this.repositoryCadastroMobiliario.cadastroMobiliarioByCadastroGeral(cadastroGeral);
            if (cadastroMobiliario != null) {
                return cadastroMobiliario.getCadastroGeral().getPessoa().getCnpjCpf();
            }
            return "";
        }
        return "";
    }

    public String retornaNomeCmcResponsavel(Long cadastroGeral) throws BaseException {
        if (cadastroGeral != null) {
            CadastroMobiliarioEntity cadastroMobiliario = ((FacadeSolicitacaoAlvara)SpringContext.getBean(FacadeSolicitacaoAlvara.class)).carregaCadastroMobiliarioByCadastroGeral(cadastroGeral);
            if (cadastroMobiliario != null) {
                return cadastroMobiliario.getCadastroGeral().getPessoa().getNome();
            }
            return "";
        }
        return "";
    }

    private boolean validacoesAlteracao(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        if (solicitacao.getCadastroMobiliario().getCadastroImobiliario() == null && !solicitacao.isRedeSim()) {
            boolean verificarImobiliarioExistente = this.isMobiliarioExistente();
            if (solicitacao.isNaturezaAlteracaoAtividade() && solicitacao.isNaturezaMudancaEndereco() || verificarImobiliarioExistente) {
                throw new SolicitacaoAlvaraException(EloStringUtils.build((Object[])new Object[]{"Dados do Cadastro Imobili\u00e1rio n\u00e3o foram encontrados.\n Por gentileza, enviar e-mail para ", UtilsController.getEmailSetorAlvara(), " informando o cadastro da inscri\u00e7\u00e3o."}));
            }
        }
        if (solicitacao.isSolicitacaoMEI() && solicitacao.isNaturezaAlteracaoSocio()) {
            throw new SolicitacaoAlvaraException("Altera\u00e7\u00e3o de S\u00f3cios n\u00e3o \u00e9 permitido para Microempreendedor Individual.");
        }
        if (solicitacao.isSolicitacaoPrestadorServico() || solicitacao.isSolicitacaoMEIPrestador()) {
            if (solicitacao.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.MUDANCA_AREA})) {
                throw new SolicitacaoAlvaraException("Altera\u00e7\u00e3o de \u00c1rea n\u00e3o \u00e9 permitida para Prestador de Servi\u00e7o");
            }
            if (EloNumberUtils.isBiggerThanZero((Number)solicitacao.getCadastroMobiliario().getAreaUtilizada()).booleanValue()) {
                throw new SolicitacaoAlvaraException("A \u00e1rea utilizada do Cadastro Mobili\u00e1rio n\u00e3o pode ser maior que 0 (zero)");
            }
        } else if (solicitacao.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.MUDANCA_ENDERECO}) && !solicitacao.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.MUDANCA_AREA})) {
            this.adicionarNaturezaNaSolicitacao(solicitacao, NaturezaSolicitacaoAlvaraEnum.MUDANCA_AREA);
        }
        if (!solicitacao.isRedeSim() && !this.isSituacaoValidaTipoPessoa(solicitacao)) {
            String mensagem = "O Tipo de Pessoa do cadastro selecionado n\u00e3o \u00e9 v\u00e1lida.";
            throw new SolicitacaoAlvaraException(String.format("%s Por gentileza, enviar e-mail para \"%s\" informando o cadastro da inscri\u00e7\u00e3o.", mensagem, UtilsController.getEmailSetorAlvara()));
        }
        if (!solicitacao.isRedeSim() && solicitacao.isNaturezaMudancaRazaoSocial() && !this.isValidaSituacaoCadastroAltRazao(solicitacao).booleanValue()) {
            throw new SolicitacaoAlvaraException("Situa\u00e7\u00e3o do cadastro inv\u00e1lido.");
        }
        if (!solicitacao.isRedeSim() && solicitacao.isNaturezaMudancaEndereco() && !this.isValidaSituacaoCadastroAltEndereco(solicitacao).booleanValue()) {
            throw new SolicitacaoAlvaraException("Situa\u00e7\u00e3o do cadastro inv\u00e1lido.");
        }
        if (!solicitacao.isRedeSim() && solicitacao.isNaturezaAlteracaoAtividade() && !this.isValidaSituacaoCadastroAltAtividade(solicitacao).booleanValue()) {
            throw new SolicitacaoAlvaraException("Situa\u00e7\u00e3o do cadastro inv\u00e1lido.");
        }
        if (solicitacao.isNaturezaAlteracaoSocio()) {
            if (solicitacao.isSolicitacaoCBO()) {
                throw new SolicitacaoAlvaraException("Altera\u00e7\u00e3o de S\u00f3cios n\u00e3o \u00e9 permitida para Classifica\u00e7\u00e3o Brasileira de Ocupa\u00e7\u00f5es.");
            }
            if (!solicitacao.isRedeSim() && !this.isValidaSituacaoCadastroAltSocios(solicitacao).booleanValue()) {
                throw new SolicitacaoAlvaraException("Situa\u00e7\u00e3o do cadastro inv\u00e1lido.");
            }
        }
        if (solicitacao.isNaturezaMudancaArea() && !solicitacao.isRedeSim() && !this.isValidaSituacaoCadastroAltArea(solicitacao).booleanValue()) {
            throw new SolicitacaoAlvaraException("Situa\u00e7\u00e3o do cadastro inv\u00e1lido.");
        }
        solicitacao.setTipoRequerente(solicitacao.getCadastroMobiliario().getCadastroGeral().getPessoa().getTipoPessoa());
        return true;
    }

    public void adicionarNaturezaNaSolicitacao(SolicitacaoAlvaraEntity solicitacao, NaturezaSolicitacaoAlvaraEnum naturezaEnum) {
        NaturezaSolicitacaoAlvaraEntity natureza = this.getNatureza(naturezaEnum.getValue());
        if (!solicitacao.getNaturezas().contains(natureza)) {
            solicitacao.getNaturezas().add(natureza);
        }
    }

    public NaturezaSolicitacaoAlvaraEntity getNatureza(NaturezaSolicitacaoAlvaraEnum naturezaEnum) {
        List naturezas = this.repositoryNaturezaSolicitacaoAlvara.carregaNaturezas();
        for (NaturezaSolicitacaoAlvaraEntity natureza : naturezas) {
            if (!natureza.getCodigo().equals(naturezaEnum.getValue())) continue;
            return natureza;
        }
        return null;
    }

    public boolean cobrarTaxa(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        return UtilsController.isValorSimParaAlgumaNaturezaDaSolicitacao((SolicitacaoAlvaraEntity)solicitacao, (ParametroAlvaraNaturezaEnum)ParametroAlvaraNaturezaEnum.COBRAR_TAXA);
    }

    private boolean isSituacaoValidaTipoPessoa(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        if (solicitacao.isSolicitacaoJuridicaNormal()) {
            return this.isSituacaoValidaTipoPessoaJuridicaNormal(solicitacao.getCadastroMobiliario());
        }
        if (solicitacao.isSolicitacaoPrestadorServico()) {
            return this.isSituacaoValidaTipoPessoaPrestadorServico(solicitacao.getCadastroMobiliario());
        }
        if (solicitacao.isSolicitacaoMEI()) {
            return this.isSituacaoValidaTipoPessoaMEI(solicitacao.getCadastroMobiliario());
        }
        if (solicitacao.isSolicitacaoCBO()) {
            return this.isSituacaoValidaTipoPessoaCBO(solicitacao.getCadastroMobiliario());
        }
        return false;
    }

    private boolean isSituacaoValidaTipoPessoaJuridicaNormal(CadastroMobiliarioEntity cadastroMobiliario) throws BaseException {
        ParametroAlvaraEntity parametro = this.repositoryParametroAlvara.getParametroAlvara(this.getEntidadeTributacao().getId().getEntidade(), ParametroAlvaraEnum.TIPOPESSOA_PESSOA_JURIDICA_NORMAL);
        if (parametro == null) {
            throw new ParametroNaoEncontradoException("Par\u00e2metro " + ParametroAlvaraEnum.TIPOPESSOA_PESSOA_JURIDICA_NORMAL + " n\u00e3o encontrado");
        }
        return this.isPessoaValida(cadastroMobiliario, parametro);
    }

    private boolean isSituacaoValidaTipoPessoaPrestadorServico(CadastroMobiliarioEntity cadastroMobiliario) throws BaseException {
        ParametroAlvaraEntity parametro = this.repositoryParametroAlvara.getParametroAlvara(this.getEntidadeTributacao().getId().getEntidade(), ParametroAlvaraEnum.TIPOPESSOA_PRESTADOR_DE_SERVICO);
        if (parametro == null) {
            throw new ParametroNaoEncontradoException(EloStringUtils.build((Object[])new Object[]{"Par\u00e2metro ", ParametroAlvaraEnum.TIPOPESSOA_PRESTADOR_DE_SERVICO, " n\u00e3o encontrado"}));
        }
        return this.isPessoaValida(cadastroMobiliario, parametro);
    }

    private boolean isSituacaoValidaTipoPessoaCBO(CadastroMobiliarioEntity cadastroMobiliario) throws BaseException {
        ParametroAlvaraEntity parametro = this.repositoryParametroAlvara.getParametroAlvara(this.getEntidadeTributacao().getId().getEntidade(), ParametroAlvaraEnum.TIPOPESSOA_CBO);
        if (parametro == null) {
            throw new ParametroNaoEncontradoException("Par\u00e2metro " + ParametroAlvaraEnum.TIPOPESSOA_CBO + " n\u00e3o encontrado");
        }
        return this.isPessoaValida(cadastroMobiliario, parametro);
    }

    private Boolean isValidaSituacaoCadastroAltRazao(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        return this.isSituacaoValidaCadastro(solicitacao, NaturezaSolicitacaoAlvaraEnum.MUDANCA_RAZAO_SOCIAL, ParametroAlvaraNaturezaEnum.VALIDASITUACAOCADASTRO);
    }

    private Boolean isSituacaoValidaCadastro(SolicitacaoAlvaraEntity solicitacao, NaturezaSolicitacaoAlvaraEnum naturezaEnum, ParametroAlvaraNaturezaEnum parametroEnum) throws BaseException {
        if (solicitacao.isSolicitacaoMEI() && !this.isSituacaoValidaTipoPessoaMEI(solicitacao.getCadastroMobiliario())) {
            return Boolean.FALSE;
        }
        MobiliarioSituacaoEntity situacaoMobiliario = this.verificaSituacao(solicitacao.getCadastroMobiliario().getId().getCodigo());
        ParametroAlvaraNaturezaEntity param = this.getParametroPorNatureza(this.getNaturezaPorCodigo(naturezaEnum.getValue(), solicitacao.getNaturezas()), parametroEnum, solicitacao.getTipoDeInscricao());
        Boolean situacaoValida = false;
        if (param != null) {
            String[] situacoes;
            if (param.getValor() == null) {
                throw new SolicitacaoAlvaraException(String.format("O valor do par\u00e2metro %s da natureza %S est\u00e1 em branco,favor configurar pela tela de Configura\u00e7\u00e3o de Par\u00e2metros", param.getParametro(), naturezaEnum.name()));
            }
            for (String situacao : situacoes = param.getValor().split(",")) {
                if (!situacaoMobiliario.getSituacaoMobiliario().getId().equals(Long.valueOf(situacao))) continue;
                situacaoValida = true;
            }
        } else {
            ShowMessage.addErrorMessage((String)"validacao", (String)("Par\u00e2metro " + parametroEnum.name() + " n\u00e3o encontrado."));
        }
        return situacaoValida;
    }

    private ParametroAlvaraNaturezaEntity getParametroPorNatureza(NaturezaSolicitacaoAlvaraEntity natureza, ParametroAlvaraNaturezaEnum param, TipoInscricaoAlvaraEntity tipoInscricao) throws BaseException {
        return this.repositoryParametroAlvaraNatureza.getParametroAlvaraNatureza(natureza, param, tipoInscricao);
    }

    private Boolean isValidaSituacaoCadastroAltEndereco(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        return this.isSituacaoValidaCadastro(solicitacao, NaturezaSolicitacaoAlvaraEnum.MUDANCA_ENDERECO, ParametroAlvaraNaturezaEnum.VALIDASITUACAOCADASTRO);
    }

    private Boolean isValidaSituacaoCadastroAltAtividade(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        return this.isSituacaoValidaCadastro(solicitacao, NaturezaSolicitacaoAlvaraEnum.ALTERACAO_ATIVIDADE, ParametroAlvaraNaturezaEnum.VALIDASITUACAOCADASTRO);
    }

    private Boolean isValidaSituacaoCadastroAltSocios(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        return this.isSituacaoValidaCadastro(solicitacao, NaturezaSolicitacaoAlvaraEnum.ALTERACAO_SOCIOS, ParametroAlvaraNaturezaEnum.VALIDASITUACAOCADASTRO);
    }

    private Boolean isValidaSituacaoCadastroAltArea(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        return this.isSituacaoValidaCadastro(solicitacao, NaturezaSolicitacaoAlvaraEnum.MUDANCA_AREA, ParametroAlvaraNaturezaEnum.VALIDASITUACAOCADASTRO);
    }

    private MobiliarioSituacaoEntity verificaSituacao(Long codigo) throws BaseException {
        return this.repositoryMobiliarioSituacao.situacaoCadastroMobiliario(codigo);
    }

    private NaturezaSolicitacaoAlvaraEntity getNaturezaPorCodigo(String codigo, List<NaturezaSolicitacaoAlvaraEntity> naturezas) {
        for (NaturezaSolicitacaoAlvaraEntity natureza : naturezas) {
            if (!codigo.equals(natureza.getCodigo())) continue;
            return natureza;
        }
        return null;
    }

    public Atividade consultaAtividadePorCodigo(ConsultaAtividadeVo consultaAtividadeVo) {
        CnaeEntity atividade = null;
        if (consultaAtividadeVo.getSolicitacaoAlvara().isSolicitacaoJuridicaNormal() || consultaAtividadeVo.getSolicitacaoAlvara().isSolicitacaoPrestadorServico()) {
            atividade = this.repositoryCnae.consultaCnaePorCodigo(consultaAtividadeVo.getCodigoAtividade());
        } else if (consultaAtividadeVo.getSolicitacaoAlvara().isSolicitacaoCBO()) {
            atividade = this.repositoryRhCbo.consultaCboPorCodigo(consultaAtividadeVo.getCodigoAtividade());
        }
        return atividade;
    }

    private boolean verificaCnaeNoPerimetro(String codigoAtividade) {
        CnaePerimetroEntity cnaePerimetro = this.repositoryCnaePerimetro.getCnaePorCodigo(codigoAtividade);
        return cnaePerimetro != null;
    }

    private AtividadesPermitidasEnvio atribuiValoresParaEnvio(SolicitacaoAlvaraEntity solicitacao, StringBuilder atividadesEnvio) throws SolicitacaoAlvaraException {
        CadastroImobiliarioEntity cadastroImob = null;
        if (solicitacao.getCadastroMobiliario() != null) {
            try {
                cadastroImob = ((FacadeCadastroImobiliario)SpringContext.getBean(FacadeCadastroImobiliario.class)).getCadastroImobiliarioPorCodigo(Long.valueOf(1L), solicitacao.getCadastroMobiliario().getCadastroImobiliario().getId().getCodigo());
            }
            catch (Exception e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
                throw new SolicitacaoAlvaraException("Houve um erro ao consultar o Cadastro Imobili\u00e1rio");
            }
        }
        AtividadesPermitidasEnvio envio = new AtividadesPermitidasEnvio();
        envio.setAtividade(atividadesEnvio.toString());
        envio.setCodCadastroImobiliario(solicitacao.getCadastroImobiliario().getId().getCodigo().toString());
        if (solicitacao.isNaturezaAlteracaoAtividade() && !solicitacao.isNaturezaMudancaEndereco()) {
            envio.setCodLogradouro(cadastroImob.getTestadaPrincipal().getId().getLogradouroTestada().getLogradouro().getId().getLogradouro().toString());
            envio.setNumeroPredial(Integer.parseInt(cadastroImob.getTestadaPrincipal().getNumero()));
        } else {
            envio.setCodLogradouro(solicitacao.getImobiliarioTestada().getId().getLogradouroTestada().getLogradouro().getId().getLogradouro().toString());
            if (solicitacao.getImobiliarioTestada().getNumero() != null) {
                envio.setNumeroPredial(Integer.parseInt(solicitacao.getImobiliarioTestada().getNumero()));
            }
        }
        return envio;
    }

    public List<Atividade> getAtividadesComRestricaoPerimetro(SolicitacaoAlvaraEntity solicitacao, AtividadesPermitidasResposta resposta) throws BaseException {
        ArrayList<Atividade> atividadesComRestricoes = new ArrayList<Atividade>();
        for (AtividadesPermitidasMensagem atividadePermitidade : resposta.getAtividadesPermitidas().getListaAtividades()) {
            if (solicitacao.isSolicitacaoMEI()) {
                for (SolicitacaoAlvaraAtividadeEntity solAlvAtiv : solicitacao.getSolicitacaoAlvaraAtividades()) {
                    AtividadeMeiEntity ativMei = solAlvAtiv.getAtividadeMei();
                    if (!atividadePermitidade.getCnae().equals(ativMei.getCnae().getCodigo())) continue;
                    AtividadeMeiEntity atividadeRetorno = this.repositoryAtividadeMei.load(ativMei.getAtividadeMei());
                    if (atividadeRetorno != null) {
                        atividadeRetorno.setMensagemRestricao(atividadePermitidade.getMensagem().toString().replaceAll("\\[|]", ""));
                    }
                    atividadesComRestricoes.add((Atividade)atividadeRetorno);
                }
                continue;
            }
            Atividade atividadeRetorno = null;
            ConsultaAtividadeVo consultaAtividadeVo = new ConsultaAtividadeVo();
            consultaAtividadeVo.setSolicitacaoAlvara(solicitacao);
            consultaAtividadeVo.setCodigoAtividade(atividadePermitidade.getCnae());
            atividadeRetorno = this.consultaAtividadePorCodigo(consultaAtividadeVo);
            if (atividadeRetorno != null) {
                atividadeRetorno.setMensagemRestricao(atividadePermitidade.getMensagem().toString().replaceAll("\\[|]", ""));
            }
            atividadesComRestricoes.add(atividadeRetorno);
        }
        return atividadesComRestricoes;
    }

    public Integer getTaxaLocalizacao(SolicitacaoAlvaraEntity solicitacao, List<Atividade> listaCompletaAtividades) throws BaseException {
        Integer codTaxa = null;
        if (this.naoEPrestadorEIntegradoGeo(solicitacao)) {
            for (Atividade atividade : listaCompletaAtividades) {
                if (codTaxa == null) {
                    codTaxa = atividade.getTaxaLocalizacao();
                    continue;
                }
                if (atividade.getTaxaLocalizacao() <= codTaxa) continue;
                codTaxa = atividade.getTaxaLocalizacao();
            }
        }
        return codTaxa;
    }

    public List<SolicitacaoAlvaraAtividadeEntity> atribuiValoresSolicitacaoAtividades(SolicitacaoAlvaraEntity solicitacao, List<Atividade> listaCompletaAtividades) throws BaseException {
        ArrayList<SolicitacaoAlvaraAtividadeEntity> lista = new ArrayList<SolicitacaoAlvaraAtividadeEntity>();
        for (Atividade atividade : listaCompletaAtividades) {
            SolicitacaoAlvaraAtividadeEntity solicitacaoAtividade = new SolicitacaoAlvaraAtividadeEntity();
            solicitacaoAtividade.setSituacao(atividade.getSituacao());
            if (atividade instanceof CnaeEntity) {
                solicitacaoAtividade.setCnae((CnaeEntity)atividade);
                solicitacaoAtividade.setCodigoAtividade(solicitacaoAtividade.getCnae().getCodigo());
            } else if (atividade instanceof RhCboEntity) {
                solicitacaoAtividade.setSequenciaCbo((RhCboEntity)atividade);
                solicitacaoAtividade.setCodigoAtividade(solicitacaoAtividade.getSequenciaCbo().getCodigo());
            } else if (atividade instanceof AtividadeMeiEntity) {
                solicitacaoAtividade.setAtividadeMei((AtividadeMeiEntity)atividade);
                solicitacaoAtividade.setCodigoAtividade(solicitacaoAtividade.getAtividadeMei().getCodigo());
            }
            solicitacaoAtividade.setAreaProcessamento(atividade.getAreaProcessamento());
            solicitacaoAtividade.setSomenteEscritorio(atividade.getSomenteEscritorio());
            solicitacaoAtividade.setSomenteEscrConcomitanteRes(atividade.getSomenteEscrConcomitanteRes());
            solicitacaoAtividade.setAtividadeConcomitanteRes(atividade.getAtividadeConcomitanteRes());
            if (EloStringUtils.isEmpty((String)atividade.getResponsavelTecnico())) {
                solicitacaoAtividade.setResponsavelTec("N");
            } else {
                solicitacaoAtividade.setResponsavelTec(atividade.getResponsavelTecnico());
            }
            solicitacaoAtividade.setObservacao(atividade.getObservacao());
            solicitacaoAtividade.setPrincipal(atividade.getPrincipal());
            solicitacaoAtividade.setSolicitacaoAlvara(solicitacao);
            solicitacaoAtividade.setExerceNoEndereco(atividade.isExerceNoEndereco() ? SimNaoEnum.getSimShortText() : SimNaoEnum.getNaoShortText());
            solicitacaoAtividade.setIdSolicitacaoAtividade(this.repositorySolicitacaoAlvaraAtividade.getSequence());
            lista.add(solicitacaoAtividade);
        }
        return lista;
    }

    private boolean naoEPrestadorEIntegradoGeo(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        return !solicitacao.isSolicitacaoPrestadorServico() && !solicitacao.isSolicitacaoMEIPrestador() && this.getIntegradoGeo() != false;
    }

    public SolicitacaoAlvaraEntity carregaDadosCadastroNaSolicitacao(SolicitacaoAlvaraEntity solicitacao) {
        solicitacao.setNomeRazaoSocial(solicitacao.getCadastroMobiliario().getCadastroGeral().getPessoa().getNome());
        solicitacao.setFantasia(solicitacao.getCadastroMobiliario().getCadastroGeral().getPessoa().getNomeFantasia());
        solicitacao.setCpfCnpj(solicitacao.getCadastroMobiliario().getCadastroGeral().getPessoa().getCnpjCpf());
        solicitacao.setTelefone(solicitacao.getCadastroMobiliario().getTelefone());
        solicitacao.setDescricaoAtividades(solicitacao.getCadastroMobiliario().getAtividadePrincipal());
        solicitacao.setPessoaMobiliario(solicitacao.getCadastroMobiliario().getPessoaMobiliario());
        ContatoPessoaEntity contato = solicitacao.getCadastroMobiliario().getCadastroGeral().getPessoa().getPessoaContatoPrincipalOuMaisRecente();
        if (contato != null) {
            solicitacao.setEmail(contato.getEmail());
            solicitacao.setTelefoneCelular(contato.getTelefoneCelular());
        }
        this.carregarEsalvarAtividadesNaSolicitacao(solicitacao);
        return solicitacao;
    }

    public RestricaoConsultaPreviaEntity adicionarRestricaoConsultaPrevia(RestricaoAlvaraVo restricaoAlvaraVo, SolicitacaoAlvaraEntity solicitacao) {
        RestricaoConsultaPreviaEntity restricaoConsultaPrevia = new RestricaoConsultaPreviaEntity();
        if (!EloStringUtils.isEmpty((String)restricaoAlvaraVo.getDescricaoRestricao()) || !EloStringUtils.isEmpty((String)restricaoAlvaraVo.getObservacao())) {
            restricaoConsultaPrevia.setDescricao(restricaoAlvaraVo.getDescricaoRestricao());
            restricaoConsultaPrevia.setObservacao(restricaoAlvaraVo.getObservacao());
            restricaoConsultaPrevia.setIdRestricao(this.repositoryRestricaoConsultaPrevia.getSequence());
            restricaoConsultaPrevia.setSolicitacaoAlvara(solicitacao);
            solicitacao.setRestricaoConsultaPrevia(restricaoConsultaPrevia);
        }
        return restricaoConsultaPrevia;
    }

    public boolean isSituacaoMobiliarioValidaParaAlteracao(MobiliarioSituacaoEntity mobiliarioSituacao) throws BaseException {
        ParametroAlvaraEntity parametro = this.repositoryParametroAlvara.getParametroAlvara(this.getEntidadeTributacao().getId().getEntidade(), ParametroAlvaraEnum.SITUACOES_MOBILIARIO_INVALIDAS_PARA_ALTERACAO);
        if (parametro == null) {
            throw new ParametroNaoEncontradoException("Par\u00e2metro " + ParametroAlvaraEnum.SITUACOES_MOBILIARIO_INVALIDAS_PARA_ALTERACAO + " n\u00e3o encontrado");
        }
        String[] invalidos = null;
        if (!EloStringUtils.isEmpty((String)parametro.getValor())) {
            for (String invalido : invalidos = parametro.getValor().split(",")) {
                if (!invalido.equals(mobiliarioSituacao.getId().toString())) continue;
                return false;
            }
        }
        return true;
    }

    private boolean condominioValidoParaRetirarAlvara(CadastroImobiliarioEntity cadastroImobiliario) throws SolicitacaoAlvaraException {
        List listaCadastroGeralIsencao = this.repositoryCadastroGeralIsencao.getIsencaoPorCadastroGeral(cadastroImobiliario.getId());
        if (this.possuiParamIsencaoCondominios(listaCadastroGeralIsencao)) {
            if (cadastroImobiliario.getCondominio() == null) {
                return false;
            }
            ParametroAlvaraEntity paramCondominios = this.repositoryParametroAlvara.getParametroAlvara(this.getEntidadeTributacao().getId().getEntidade(), ParametroAlvaraEnum.GERAALVARACONDOMINIOS);
            if (paramCondominios != null) {
                Long[] param;
                for (Long condominio : param = EloStringUtils.strToLong((String[])paramCondominios.getValor().split(","))) {
                    if (!condominio.equals(cadastroImobiliario.getCondominio().getId().getCondominio())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean possuiParamIsencaoCondominios(List<CadastroGeralIsencaoEntity> listaCadastroGeralIsencao) {
        ParametroAlvaraEntity paramIsencao = this.repositoryParametroAlvara.getParametroAlvara(this.getEntidadeTributacao().getId().getEntidade(), ParametroAlvaraEnum.ISENCAOCONDOMINIOS);
        if (paramIsencao != null) {
            Long[] param = EloStringUtils.strToLong((String[])paramIsencao.getValor().split(","));
            for (CadastroGeralIsencaoEntity cadastroGeralIsencao : listaCadastroGeralIsencao) {
                for (Long param_isencao : param) {
                    if (!param_isencao.equals(cadastroGeralIsencao.getId().getIsencao().getId())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean possuiRestricaoIsencaoECondominio(CadastroImobiliarioEntity cadastroImobiliario) throws SolicitacaoAlvaraException {
        boolean existeRestricaoIsencao = this.repositoryCadastroGeralIsencao.verificaCodIsencaoCadImobiliarioParaGerarAlvara(cadastroImobiliario);
        if (existeRestricaoIsencao) {
            return !this.condominioValidoParaRetirarAlvara(cadastroImobiliario);
        }
        return false;
    }

    public String carregarParametrosVencimentosDebito() throws BaseException {
        ParametroAlvaraEntity paramQtdeParc = this.getParametroAlvara(ParametroAlvaraEnum.QTDE_PARCELAS);
        Integer qtdeParcelas = new Integer(paramQtdeParc.getValor());
        ParametroAlvaraEntity paramQtdeDiasPrimeiroVencimento = null;
        try {
            paramQtdeDiasPrimeiroVencimento = this.getParametroAlvaraNaoTrataValorNull(ParametroAlvaraEnum.QTDE_DIAS_PRIMEIRO_VENCIMENTO);
        }
        catch (Exception e) {
            this.logger.warn((Object)e.getMessage(), (Throwable)e);
        }
        ParametroAlvaraEntity paramDiaVencimentoFixo = null;
        try {
            paramDiaVencimentoFixo = this.getParametroAlvaraNaoTrataValorNull(ParametroAlvaraEnum.DIA_VENCIMENTO_FIXO);
        }
        catch (Exception e) {
            this.logger.warn((Object)e.getMessage(), (Throwable)e);
        }
        if ((Objects.isNull(paramQtdeDiasPrimeiroVencimento) || EloStringUtils.isEmpty((String)paramQtdeDiasPrimeiroVencimento.getValor())) && (Objects.isNull(paramDiaVencimentoFixo) || EloStringUtils.isEmpty((String)paramDiaVencimentoFixo.getValor()))) {
            throw new SolicitacaoAlvaraException(String.format(" Os par\u00e2metros %s e %s n\u00e3o foram configurados,  favor configure ao menos um para realizar a gera\u00e7\u00e3o dos d\u00e9bitos.", ParametroAlvaraEnum.DIA_VENCIMENTO_FIXO.name(), ParametroAlvaraEnum.QTDE_DIAS_PRIMEIRO_VENCIMENTO.name()));
        }
        Integer qtdeDiasPrimeiroVencimento = null;
        if (Objects.nonNull(paramQtdeDiasPrimeiroVencimento) && !EloStringUtils.isEmpty((String)paramQtdeDiasPrimeiroVencimento.getValor())) {
            qtdeDiasPrimeiroVencimento = new Integer(paramQtdeDiasPrimeiroVencimento.getValor());
        }
        Integer diaVencimentoFixo = null;
        if (Objects.nonNull(paramDiaVencimentoFixo) && !EloStringUtils.isEmpty((String)paramDiaVencimentoFixo.getValor())) {
            diaVencimentoFixo = new Integer(paramDiaVencimentoFixo.getValor());
        }
        return this.carregarVencimentosDebito(qtdeParcelas, qtdeDiasPrimeiroVencimento, diaVencimentoFixo);
    }

    protected String carregarVencimentosDebito(Integer qtdeParcelas, Integer qtdeDiasPrimeiroVenc, Integer diaVencimentoFixo) throws BaseException {
        StringBuilder vencimentos = new StringBuilder();
        LocalDate data = LocalDate.now();
        boolean qtdeDias = false;
        for (int i = 0; i < qtdeParcelas; ++i) {
            if (!vencimentos.toString().isEmpty()) {
                vencimentos.append(";");
            }
            if (qtdeDiasPrimeiroVenc == null) {
                data = LocalDate.now().plusMonths(i + 1);
            } else if (!qtdeDias) {
                data = data.plusDays(qtdeDiasPrimeiroVenc.intValue());
                qtdeDias = true;
            } else {
                data = data.plusMonths(i);
            }
            if (qtdeDiasPrimeiroVenc == null && diaVencimentoFixo != null) {
                data = data.withDayOfMonth(diaVencimentoFixo);
            }
            DateTimeFormatter format = DateTimeFormatter.ofPattern("dd/MM/yyyy");
            vencimentos.append(data.format(format));
        }
        return vencimentos.toString();
    }

    public void validarImobiliarioVinculadoMobiliario(CadastroMobiliarioEntity cadastroMobiliario) throws BaseException {
        ParametroAlvaraEntity parametroAlvara = this.getParametroAlvara(ParametroAlvaraEnum.ALTERACAO_ENDERECO_IMOBILIARIO_OBRIGATORIO);
        if (SimNaoEnum.equalSim((String)parametroAlvara.getValor()).booleanValue()) {
            if (!cadastroMobiliario.possuiImobiliario() && !cadastroMobiliario.possuiLogradouro()) {
                throw new SolicitacaoAlvaraException("A localiza\u00e7\u00e3o do Cadastro Mobili\u00e1rio est\u00e1 incompleta, \u00e9 necess\u00e1rio informar seu Cadastro Imobili\u00e1rio e Logradouro.Entre em contato pelo e-mail: " + this.getEmailSetorCadastro() + " informando esta mensagem de erro.");
            }
            if (!cadastroMobiliario.possuiImobiliario()) {
                throw new SolicitacaoAlvaraException("A localiza\u00e7\u00e3o do Cadastro Mobili\u00e1rio est\u00e1 incompleta, \u00e9 necess\u00e1rio informar seu Cadastro Imobili\u00e1rio.Entre em contato pelo e-mail: " + this.getEmailSetorCadastro() + " informando esta mensagem de erro.");
            }
            if (this.imobiliarioNaoPossuiTestada(cadastroMobiliario)) {
                throw new SolicitacaoAlvaraException("O Cadastro Imobili\u00e1rio n\u00e3o possui testada.Entre em contato pelo e-mail: " + this.getEmailSetorCadastro() + " informando esta mensagem de erro.");
            }
        }
    }

    private boolean imobiliarioNaoPossuiTestada(CadastroMobiliarioEntity cadastroMobiliario) {
        return cadastroMobiliario.getCadastroImobiliario().getTestadaPrincipalOuPrimeira() == null;
    }

    public String getEmailSetorCadastro() throws BaseException {
        ParametroAlvaraEntity parametroEmailSetorCadastro = this.getParametroAlvara(ParametroAlvaraEnum.EMAILSETORCADASTROALVARA);
        return Objects.nonNull(parametroEmailSetorCadastro) ? parametroEmailSetorCadastro.getValor() : "";
    }

    public SolicitacaoAlvaraDocumentoEntity adicionarSolicitacaoAlvaraDocumento(SolicitacaoAlvaraDocumentoEntity solicitacaoAlvaraDocumento) {
        if (solicitacaoAlvaraDocumento.idIsNull()) {
            solicitacaoAlvaraDocumento.setSolicitacaoAlvaraDocumento(this.repositorySolicitacaoAlvaraDocumento.getSequence());
        }
        return this.repositorySolicitacaoAlvaraDocumento.saveOrUpdate(solicitacaoAlvaraDocumento);
    }

    public void removerSolicitacaoAlvaraDocumento(SolicitacaoAlvaraDocumentoEntity solicitacaoAlvaraDocumento) {
        this.repositorySolicitacaoAlvaraDocumento.remove(solicitacaoAlvaraDocumento);
    }

    protected void salvarCategoriaMobiliario(SolicitacaoAlvaraEntity solicitacao, ParametroAlvaraEnum parametro) throws BaseException {
        ParametroAlvaraEntity codigoCategoriaMobiliario = this.getParametroAlvaraNaoTrataValorNull(parametro);
        if (!EloStringUtils.isEmpty((String)codigoCategoriaMobiliario.getValor())) {
            CategoriaMobiliarioEntity categoriaMobiliario = this.carregarCategoriaMobiliario(codigoCategoriaMobiliario.getValor());
            solicitacao.getCadastroMobiliario().setCategoriaMobiliario(categoriaMobiliario);
            this.repositoryCadastroMobiliario.saveOrUpdate(solicitacao.getCadastroMobiliario());
        }
    }

    private CategoriaMobiliarioEntity carregarCategoriaMobiliario(String valor) {
        return this.repositoryCategoriaMobiliario.recuperarCategoriaMobiliario(Long.valueOf(valor));
    }

    protected void salvarClassificacaoMobiliario(SolicitacaoAlvaraEntity solicitacao, ParametroAlvaraEnum parametro) throws BaseException {
        ParametroAlvaraEntity codigoClassificacaoMobiliario = this.getParametroAlvaraNaoTrataValorNull(parametro);
        if (!EloStringUtils.isEmpty((String)codigoClassificacaoMobiliario.getValor())) {
            ClassificacaoMobiliarioEntity classificacaoMobiliario = this.carregarClassificacaoMobiliaria(codigoClassificacaoMobiliario.getValor());
            solicitacao.getCadastroMobiliario().setClassificacaoMobiliario(classificacaoMobiliario);
            this.repositoryCadastroMobiliario.saveOrUpdate(solicitacao.getCadastroMobiliario());
        }
    }

    private ClassificacaoMobiliarioEntity carregarClassificacaoMobiliaria(String valor) {
        return this.repositoryClassificacaoMobiliario.recuperarClassificacaoMobiliario(Long.valueOf(valor));
    }

    protected void salvarNaturezaJuridicaMeiMobiliario(SolicitacaoAlvaraEntity solicitacaoAlvara, ParametroAlvaraEnum codNaturezaJuridicaMei) throws BaseException {
        ParametroAlvaraEntity param = this.getParametroAlvara(codNaturezaJuridicaMei);
        if (Objects.isNull(param)) {
            throw new SolicitacaoAlvaraException(String.format("Par\u00e2metro  %s n\u00e3o configurado.", codNaturezaJuridicaMei));
        }
        if (!EloStringUtils.isEmpty((String)param.getValor()) && StringUtils.isNumeric((CharSequence)param.getValor())) {
            NaturezaJuridicaEntity naturezaJuridicaEntity = this.repositoryNaturezaJuridica.findById(Long.valueOf(param.getValor()));
            solicitacaoAlvara.getCadastroMobiliario().setNaturezaJuridica(naturezaJuridicaEntity);
            this.repositoryCadastroMobiliario.saveOrUpdate(solicitacaoAlvara.getCadastroMobiliario());
        }
    }

    public SolicitacaoAlvaraEntity clonarSolicitacaoNaRenovacao(SolicitacaoAlvaraEntity solicitacaoAlvara) throws SolicitacaoAlvaraException {
        SolicitacaoAlvaraEntity solicitacao = null;
        try {
            UsuarioEntity usuarioLogado = (UsuarioEntity)this.getUsuarioLogado();
            solicitacao = (SolicitacaoAlvaraEntity)solicitacaoAlvara.clone();
            solicitacao.setLaudos(null);
            solicitacao.setNumeroSolicitacao(null);
            solicitacao.setExercicio(this.getExercicio());
            solicitacao.setSolicitacaoAlvara(null);
            solicitacao.setNumeroAlvara(null);
            solicitacao.setDataSolicitacao(new Date());
            solicitacao.setRenovacao(SimNaoEnum.getNaoShortText());
            solicitacao.setUsuario(usuarioLogado);
            solicitacao.setSolicitacaoAlvara(this.repositorySolicitacaoAlvara.getSequence());
            solicitacao.setNumeroSolicitacao(this.repositorySolicitacaoAlvara.getNumeroSolicitacao(Long.valueOf(1L), this.getExercicio()));
            solicitacao.setSolicitacaoAlvaraAtividades(this.getSolicitacaoAtividades(solicitacao));
            this.getSolicitacaoContratoSocial(solicitacao);
            this.repositorySolicitacaoAlvara.saveOrUpdate(solicitacao);
            this.geraLaudos(solicitacao);
            this.newHistoricoRenovacao(solicitacao, (UserDetails)usuarioLogado, "Solicita\u00e7\u00e3o de Alvar\u00e1 Definitivo");
            SolicitacaoRedeSimEntity solicitacaoRedeSim = this.repositoryConsultaRedeSim.getConsultaByTipo(solicitacao.getProtocoloRedeSim(), TipoSolicitacaoRedeSimEnum.SOLICITACAO);
            solicitacaoRedeSim.setSolicitacaoAlvara(solicitacao);
            this.repositoryConsultaRedeSim.saveOrUpdate(solicitacaoRedeSim);
            return solicitacao;
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new SolicitacaoAlvaraException("N\u00e3o foi poss\u00edvel criar a nova Solicita\u00e7\u00e3o", e.getCause());
        }
    }

    private void getSolicitacaoContratoSocial(SolicitacaoAlvaraEntity solicitacao) throws CloneNotSupportedException {
        SolicitacaoContratoSocialEntity solicitacaoContratoSocial = new SolicitacaoContratoSocialEntity();
        solicitacaoContratoSocial.setId(this.repositorySolicitacaoContratoSocial.getSequence());
        solicitacaoContratoSocial.setSolicitacaoAlvara(solicitacao);
        ArrayList contratoPessoas = Lists.newArrayList();
        if (Objects.nonNull(solicitacao.getContratoSocial()) && !EloListUtils.safeIsEmpty((List)solicitacao.getContratoSocial().getPessoas()).booleanValue()) {
            for (SolicitacaoContratoSocialPessoaEntity contratoPessoa : solicitacao.getContratoSocial().getPessoas()) {
                SolicitacaoContratoSocialPessoaEntity newContratoPessoa = (SolicitacaoContratoSocialPessoaEntity)contratoPessoa.clone();
                newContratoPessoa.setId(this.repositorySolicitacaoContratoSocialPessoa.getSequence());
                newContratoPessoa.setContratoSocial(solicitacaoContratoSocial);
                contratoPessoas.add(newContratoPessoa);
            }
        }
        solicitacao.setContratoSocial(solicitacaoContratoSocial);
        solicitacaoContratoSocial.setPessoas((List)contratoPessoas);
    }

    private List<SolicitacaoAlvaraAtividadeEntity> getSolicitacaoAtividades(SolicitacaoAlvaraEntity solicitacao) {
        ArrayList atividades = Lists.newArrayList();
        for (SolicitacaoAlvaraAtividadeEntity atividade : solicitacao.getSolicitacaoAlvaraAtividades()) {
            SolicitacaoAlvaraAtividadeEntity ati = new SolicitacaoAlvaraAtividadeEntity();
            ati = atividade;
            ati.setSolicitacaoAlvara(solicitacao);
            ati.setIdSolicitacaoAtividade(this.repositorySolicitacaoAlvaraAtividade.getSequence());
            atividades.add(ati);
        }
        return atividades;
    }

    protected String preencherTelefone(String ddd, String telefone) {
        if (!EloStringUtils.isEmpty((String)ddd) && !EloStringUtils.isEmpty((String)telefone)) {
            return ddd.concat(telefone);
        }
        return null;
    }

    public void verificarIdClassificacaoTipoInscricao(SolicitacaoAlvaraEntity solicitacao) {
        if (solicitacao != null && solicitacao.getClassificacaoTipoInscricao() != null && solicitacao.getClassificacaoTipoInscricao().getIdClassificacaoTipoInscricao() == null) {
            solicitacao.getClassificacaoTipoInscricao().setIdClassificacaoTipoInscricao(this.repositoryClassificacaoTipoInscricao.getSequence());
        }
    }

    private List<LaudoExigidoEntity> getLaudosExigidosScriptAlvaraDasAtividades(SolicitacaoAlvaraEntity solicitacaoAlvara, String protocoloRedeSim) {
        try {
            SolicitacaoAlvaraRedeSimDTO solicitacaoDTO;
            SolicitacaoRedeSimEntity solicitacao;
            ArrayList<LaudoExigidoEntity> laudos = new ArrayList<LaudoExigidoEntity>();
            List solicitacoesDocByProtocolo = this.repositorySolicitacaoDocRedeSim.findSolicitacaoDocumentoByProtocoloAndTipoDocumento(protocoloRedeSim, TipoDocumentoRedeSimEnum.ALVARA_LOCALIZACAO.getCodigo());
            if (!(solicitacaoAlvara.isGrauRiscoBaixo() && SimNaoEnum.getNaoShortText().equals(UtilsController.getValorParametroAlvara((ParametroAlvaraEnum)ParametroAlvaraEnum.GERA_LAUDO_RISCO_B)) || !EloListUtils.safeIsEmpty((List)solicitacoesDocByProtocolo).booleanValue())) {
                return laudos;
            }
            List atividades = solicitacaoAlvara.getSolicitacaoAlvaraAtividades().stream().map(SolicitacaoAlvaraAtividadeEntity::getCodigoAtividade).collect(Collectors.toList());
            if (EloListUtils.safeIsEmpty(atividades).booleanValue() && Objects.nonNull(solicitacao = this.repositoryConsultaRedeSim.getConsultaByTipo(protocoloRedeSim, TipoSolicitacaoRedeSimEnum.SOLICITACAO)) && Objects.nonNull(solicitacaoDTO = SolicitacaoAlvaraRedeSimDTO.of((String)solicitacao.getArquivoDadosEmpresa()))) {
                atividades = solicitacaoDTO.getDados_solicitacao().getEmpresa().getAtividades().stream().map(Atividades::getCo_cnae).collect(Collectors.toList());
            }
            List perguntas = this.getPerguntas(solicitacoesDocByProtocolo);
            SolicitacaoAlvaraRedeSimDTO solicitacaoRedeSim = this.getSolicitacaoRedeSim(protocoloRedeSim);
            VerificacaoGeracaoLaudoDTO verificacaoGeracaoLaudoDto = new VerificacaoGeracaoLaudoDTO(atividades, perguntas, solicitacaoRedeSim);
            List scriptsGeracaoLaudo = this.repositoryScriptAlvara.findAll().stream().filter(scriptAlvara -> !scriptAlvara.getTipo().equals((Object)TipoScriptAlvaraEnum.ZONEAMENTO_LOCACIONAL) && Objects.nonNull(scriptAlvara.getCodigoFonte())).collect(Collectors.toList());
            Map tiposLaudo = this.repositoryTipoLaudo.getTipoLaudo().stream().collect(Collectors.toMap(TipoLaudoEntity::getCodigo, Function.identity()));
            ArrayList<GrauDeRiscoEnum> grausDeRiscos = new ArrayList<GrauDeRiscoEnum>();
            for (ScriptAlvaraEntity scriptAlvara2 : scriptsGeracaoLaudo) {
                TipoLaudoEntity tipoLaudo = (TipoLaudoEntity)tiposLaudo.get(TipoLaudoEnum.fromCodigo((String)scriptAlvara2.getTipo().getSigla()));
                if (!Objects.nonNull(tipoLaudo)) continue;
                GrauDeRiscoEnum grauRisco = this.execScriptGroovy(scriptAlvara2, verificacaoGeracaoLaudoDto);
                grausDeRiscos.add(grauRisco);
                if (!GrauDeRiscoEnum.RISCO_ALTO.equals((Object)grauRisco) && !GrauDeRiscoEnum.RISCO_BAIXO.equals((Object)grauRisco)) continue;
                LaudoExigidoEntity laudo = new LaudoExigidoEntity();
                laudo.setTipoLaudo(tipoLaudo);
                laudos.add(laudo);
            }
            this.updateGrauRiscoSolicitcaoAlvara(solicitacaoAlvara, grausDeRiscos);
            return laudos;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private List<Pergunta> getPerguntas(List<SolicitacaoDocRedeSimEntity> solicitacoesDocumentosRedeSim) {
        if (EloListUtils.safeIsEmpty(solicitacoesDocumentosRedeSim).booleanValue()) {
            return Collections.emptyList();
        }
        SolicitacaoDocumentosDTO solicitacaoDocumentosDTO = (SolicitacaoDocumentosDTO)new Gson().fromJson(((SolicitacaoDocRedeSimEntity)solicitacoesDocumentosRedeSim.stream().findFirst().get()).getArquivoSolicitacao(), SolicitacaoDocumentosDTO.class);
        return solicitacaoDocumentosDTO.getDados_solicitacao_documento().getQuestionario();
    }

    public SolicitacaoAlvaraRedeSimDTO getSolicitacaoRedeSim(String protocoloRedeSim) {
        SolicitacaoRedeSimEntity solicitacaoRedeSimEntity = this.repositoryConsultaRedeSim.getConsultaByTipo(protocoloRedeSim, TipoSolicitacaoRedeSimEnum.SOLICITACAO);
        if (Objects.isNull(solicitacaoRedeSimEntity)) {
            return new SolicitacaoAlvaraRedeSimDTO();
        }
        return SolicitacaoAlvaraRedeSimDTO.of((String)solicitacaoRedeSimEntity.getArquivoDadosEmpresa());
    }

    private GrauDeRiscoEnum execScriptGroovy(ScriptAlvaraEntity scriptAlvara, VerificacaoGeracaoLaudoDTO verificacaoGeracaoLaudoDTO) {
        GroovyShell shell = new GroovyShell();
        Script script = shell.parse(scriptAlvara.getCodigoFonte());
        shell.setVariable("scriptLaudo", (Object)script);
        shell.setVariable("verificacaoGeracaoLaudoDTO", (Object)verificacaoGeracaoLaudoDTO);
        return GrauDeRiscoEnum.fromString((String)((String)shell.evaluate("scriptLaudo.verifyGeracaoLaudo(verificacaoGeracaoLaudoDTO)")));
    }

    private void updateGrauRiscoSolicitcaoAlvara(SolicitacaoAlvaraEntity solicitacaoAlvara, List<GrauDeRiscoEnum> grausDeRiscos) {
        if (!EloListUtils.safeIsEmpty(grausDeRiscos).booleanValue()) {
            if (grausDeRiscos.stream().anyMatch(arg_0 -> GrauDeRiscoEnum.RISCO_ALTO.equals(arg_0))) {
                solicitacaoAlvara.setGrauRisco(GrauDeRiscoEnum.RISCO_ALTO.getSigla());
                this.repositorySolicitacaoAlvara.saveOrUpdate(solicitacaoAlvara);
                return;
            }
            solicitacaoAlvara.setGrauRisco(GrauDeRiscoEnum.RISCO_LIBERDADE_ECONOMICA.getSigla());
            if (grausDeRiscos.stream().anyMatch(arg_0 -> GrauDeRiscoEnum.RISCO_BAIXO.equals(arg_0))) {
                solicitacaoAlvara.setGrauRisco(GrauDeRiscoEnum.RISCO_BAIXO.getSigla());
            }
            this.repositorySolicitacaoAlvara.saveOrUpdate(solicitacaoAlvara);
        }
    }

    public boolean isMeisECriaLaudosAoRececerDadosEmpresaEnviaInscricaoComDadosAtualizados(SolicitacaoAlvaraEntity solicitacaoAlvara) throws BaseException {
        return solicitacaoAlvara.isSolicitacaoMEI() && SimNaoEnum.getSimShortText().equals(this.getParametroAlvara(ParametroAlvaraEnum.CRIA_LAUDOS_AO_RECEBER_DADOS_EMPRESA).getValor()) && SimNaoEnum.getSimShortText().equals(this.getParametroAlvara(ParametroAlvaraEnum.ENVIA_INSCRICAO_MUNICIPAL_COM_DADOS_ATUALIZADOS).getValor());
    }
}

