/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.service.impl;

import br.com.elotech.annotations.spring.EloService;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.portalarrecadacao.exception.SolicitacaoAlvaraException;
import br.com.elotech.portalarrecadacao.service.SrvSituacaoMobiliarioAlvara;
import br.com.elotech.tributacao.domain.aise.SituacaoMobiliarioAlvaraEntity;
import br.com.elotech.tributacao.domain.aise.SituacaoMobiliarioEntity;
import br.com.elotech.tributacao.enumerator.SituacaoMobiliarioAlvaraEnum;
import br.com.elotech.tributacao.repository.aise.RepositorySituacaoMobiliarioAlvara;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Resource;

@EloService(value="srvSituacaoMobiliarioAlvara")
public class SrvSituacaoMobiliarioAlvaraImpl
implements SrvSituacaoMobiliarioAlvara {
    private static final String PARAMETRIZACAO_SITUACAO_MOBILIARIA_REFERENTE_A_JUNTA_COMERCIAL_INEXISTENTE = "N\u00e3o existe parametriza\u00e7\u00e3o de situa\u00e7\u00e3o mobili\u00e1ria referente a Junta comercial!";
    @Resource
    private RepositorySituacaoMobiliarioAlvara repositorySituacaoMobiliarioAlvara;

    public List<SituacaoMobiliarioAlvaraEntity> buscaSituacaoMobiliarioAlvaraPorDescricao(String descricao) throws BaseException {
        return this.repositorySituacaoMobiliarioAlvara.findSituacaoMobiliarioAlvaraByDescricao(descricao);
    }

    public SituacaoMobiliarioAlvaraEntity alterarSituacaoMobiliarioAlvara(SituacaoMobiliarioAlvaraEntity situacaoMobiliarioAlvara) {
        return this.repositorySituacaoMobiliarioAlvara.saveOrUpdate(situacaoMobiliarioAlvara);
    }

    public Long getSituacaoMobiliarioAlvara(SituacaoMobiliarioAlvaraEnum situacaoMobiliarioAlvara) throws SolicitacaoAlvaraException {
        Long situacaoMobiliario = Optional.ofNullable(this.repositorySituacaoMobiliarioAlvara.load(SituacaoMobiliarioAlvaraEnum.SITUACAO_CADASTRO_ATUALIZADO_PELA_JUNTA.getCodigo())).map(SituacaoMobiliarioAlvaraEntity::getSituacaoMobiliario).map(SituacaoMobiliarioEntity::getId).orElse(null);
        if (Objects.isNull(situacaoMobiliario)) {
            throw new SolicitacaoAlvaraException(PARAMETRIZACAO_SITUACAO_MOBILIARIA_REFERENTE_A_JUNTA_COMERCIAL_INEXISTENTE);
        }
        return situacaoMobiliario;
    }
}

