/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.service.impl;

import br.com.elotech.logLayer.EloLogger;
import br.com.elotech.portalarrecadacao.domain.RestricaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.exception.SolicitacaoAlvaraException;
import br.com.elotech.portalarrecadacao.repository.RepositoryRestricaoAlvara;
import br.com.elotech.portalarrecadacao.service.SrvRestricaoAlvara;
import br.com.elotech.portalarrecadacao.utils.params.PortalUtils;
import br.com.elotech.tributacao.domain.aise.CadastroRestricaoAlvaraEntity;
import br.com.elotech.tributacao.domain.aise.EntidadeTributacaoEntity;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="srvRestricaoAlvara")
public class SrvRestricaoAlvaraImpl
extends EloLogger
implements SrvRestricaoAlvara {
    @Resource
    private RepositoryRestricaoAlvara repositoryRestricaoAlvara;

    public void salvarRestricaoAlvara(List<RestricaoAlvaraEntity> listaRestricaoAlvaraExistente, List<CadastroRestricaoAlvaraEntity> listaRestricaoAlvaraAtual, SolicitacaoAlvaraEntity solicitacaoAlvara, EntidadeTributacaoEntity entidadeTributacao) throws SolicitacaoAlvaraException {
        try {
            if (listaRestricaoAlvaraExistente != null && !listaRestricaoAlvaraExistente.isEmpty()) {
                ArrayList<CadastroRestricaoAlvaraEntity> listaCadRestricaoExistente = new ArrayList<CadastroRestricaoAlvaraEntity>();
                for (RestricaoAlvaraEntity restricaoAlvaraEntity : listaRestricaoAlvaraExistente) {
                    listaCadRestricaoExistente.add(restricaoAlvaraEntity.getCadastroRestricaoAlvara());
                }
                ArrayList<CadastroRestricaoAlvaraEntity> listaCadInsert = new ArrayList<CadastroRestricaoAlvaraEntity>();
                for (CadastroRestricaoAlvaraEntity cadastroRestricao : listaRestricaoAlvaraAtual) {
                    if (listaCadRestricaoExistente.contains(cadastroRestricao)) continue;
                    listaCadInsert.add(cadastroRestricao);
                }
                for (CadastroRestricaoAlvaraEntity cadastroRestricao : listaCadInsert) {
                    RestricaoAlvaraEntity restricaoAlvara = new RestricaoAlvaraEntity();
                    restricaoAlvara.setCadastroImobiliario(solicitacaoAlvara.getCadastroImobiliario());
                    if (Objects.nonNull(solicitacaoAlvara.getCadastroMobiliario()) && Objects.nonNull(solicitacaoAlvara.getCadastroMobiliario().getId().getCodigo())) {
                        restricaoAlvara.setCadastroMobiliario(solicitacaoAlvara.getCadastroMobiliario());
                    }
                    restricaoAlvara.setAutorizado("N");
                    restricaoAlvara.setDescricao(cadastroRestricao.getDescricao());
                    restricaoAlvara.setData(Calendar.getInstance().getTime());
                    restricaoAlvara.setSolicitacaoAlvara(solicitacaoAlvara);
                    restricaoAlvara.setExercicio(entidadeTributacao);
                    restricaoAlvara.setRestricaoAlvara(solicitacaoAlvara.getNumeroSolicitacao());
                    restricaoAlvara.setCadastroRestricaoAlvara(cadastroRestricao);
                    if (restricaoAlvara.getIdRestricaoAlvara() == null) {
                        restricaoAlvara.setIdRestricaoAlvara(this.repositoryRestricaoAlvara.getSequence());
                    }
                    if (restricaoAlvara.getCadastroRestricaoAlvara().getIdRestricao().equals(PortalUtils.getCodRestricaocadPessoaJaExistente())) {
                        restricaoAlvara.setCampoVerificacao(solicitacaoAlvara.getCpfCnpj());
                    }
                    this.repositoryRestricaoAlvara.saveOrUpdate(restricaoAlvara);
                }
            } else {
                for (CadastroRestricaoAlvaraEntity cadastro : listaRestricaoAlvaraAtual) {
                    RestricaoAlvaraEntity restricaoAlvaraEntity = new RestricaoAlvaraEntity();
                    restricaoAlvaraEntity.setCadastroImobiliario(solicitacaoAlvara.getCadastroImobiliario());
                    restricaoAlvaraEntity.setCadastroMobiliario(solicitacaoAlvara.getCadastroMobiliario());
                    restricaoAlvaraEntity.setAutorizado("N");
                    restricaoAlvaraEntity.setDescricao(cadastro.getDescricao());
                    restricaoAlvaraEntity.setData(Calendar.getInstance().getTime());
                    restricaoAlvaraEntity.setSolicitacaoAlvara(solicitacaoAlvara);
                    restricaoAlvaraEntity.setExercicio(entidadeTributacao);
                    restricaoAlvaraEntity.setRestricaoAlvara(solicitacaoAlvara.getNumeroSolicitacao());
                    restricaoAlvaraEntity.setCadastroRestricaoAlvara(cadastro);
                    if (restricaoAlvaraEntity.getIdRestricaoAlvara() == null) {
                        restricaoAlvaraEntity.setIdRestricaoAlvara(this.repositoryRestricaoAlvara.getSequence());
                    }
                    if (restricaoAlvaraEntity.getCadastroRestricaoAlvara().getIdRestricao().equals(PortalUtils.getCodRestricaocadPessoaJaExistente())) {
                        restricaoAlvaraEntity.setCampoVerificacao(solicitacaoAlvara.getCpfCnpj());
                    }
                    this.repositoryRestricaoAlvara.saveOrUpdate(restricaoAlvaraEntity);
                }
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new SolicitacaoAlvaraException("Falha ao gravar restricao de alvara: ", e.getCause());
        }
    }
}

