/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.service.impl;

import br.com.elotech.annotations.spring.EloService;
import br.com.elotech.exception.common.ValidacaoException;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.portalarrecadacao.domain.ArquivoDocumentoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.HistoricoExigenciaRedeSimEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoRedeSimEntity;
import br.com.elotech.portalarrecadacao.domain.helper.ImprimirTaxasAlvara;
import br.com.elotech.portalarrecadacao.enumerator.ModeloDocumentoRedeSimEnum;
import br.com.elotech.portalarrecadacao.enumerator.ParametroAlvaraEnum;
import br.com.elotech.portalarrecadacao.enumerator.SituacaoConsultaPreviaRedeSimEnum;
import br.com.elotech.portalarrecadacao.enumerator.SituacaoRespostaRedeSimEnum;
import br.com.elotech.portalarrecadacao.enumerator.TipoAlvaraEnum;
import br.com.elotech.portalarrecadacao.exception.DeferirRedeSimException;
import br.com.elotech.portalarrecadacao.exception.GeraBloquetoException;
import br.com.elotech.portalarrecadacao.exception.RespostaRedeSimException;
import br.com.elotech.portalarrecadacao.exception.SolicitacaoAlvaraRedeSimException;
import br.com.elotech.portalarrecadacao.facade.FacadeRedeSim;
import br.com.elotech.portalarrecadacao.integration.dto.consulta.Controle;
import br.com.elotech.portalarrecadacao.integration.dto.consulta.DadosRespostaWS21;
import br.com.elotech.portalarrecadacao.integration.dto.consulta.Dados_resposta;
import br.com.elotech.portalarrecadacao.integration.dto.dadosEmpresa.Exigencia;
import br.com.elotech.portalarrecadacao.integration.dto.dadosEmpresa.RespostaDocumento;
import br.com.elotech.portalarrecadacao.repository.RepositoryArquivoDocumentoAlvara;
import br.com.elotech.portalarrecadacao.repository.RepositoryHistoricoExigenciaRedeSim;
import br.com.elotech.portalarrecadacao.rest.imprimirdocumento.ImprimeDocumentoAlvara;
import br.com.elotech.portalarrecadacao.rest.response.RedeSimErrorMessage;
import br.com.elotech.portalarrecadacao.rest.service.RestRequestService;
import br.com.elotech.portalarrecadacao.service.SrvArquivoDocumentoAlvara;
import br.com.elotech.portalarrecadacao.service.SrvDebitosPortal;
import br.com.elotech.portalarrecadacao.service.SrvRespostaDocumentosRedeSim;
import br.com.elotech.portalarrecadacao.service.SrvSolicitacaoAlvara;
import br.com.elotech.portalarrecadacao.service.SrvSolicitacaoAlvaraRedeSim;
import br.com.elotech.portalarrecadacao.service.impl.SrvRespostaDocumentosRedeSimImpl;
import br.com.elotech.portalarrecadacao.service.impl.SrvSolicitacaoAlvaraHelperImpl;
import br.com.elotech.spring.SpringContext;
import br.com.elotech.tributacao.domain.aise.DebitoEntity;
import br.com.elotech.tributacao.domain.aise.DocumentoAiseEntity;
import br.com.elotech.tributacao.domain.aise.GuiaRecolhimentoEntity;
import br.com.elotech.tributacao.domain.aise.UsuarioEntity;
import br.com.elotech.tributacao.enumerator.DocumentoTipoEnum;
import br.com.elotech.tributacao.enumerator.SimNaoEnum;
import br.com.elotech.tributacao.repository.aise.RepositoryDebito;
import br.com.elotech.tributacao.repository.aise.RepositoryDocumentoAise;
import br.com.elotech.tributacao.repository.aise.RepositoryUsuario;
import br.com.elotech.tributacao.repository.alvara.RepositoryDocumentoAiseAlvara;
import br.com.elotech.util.date.EloDateUtils;
import br.com.elotech.util.json.EloJsonUtils;
import br.com.elotech.util.jwt.JwtUtils;
import br.com.elotech.util.list.EloListUtils;
import com.google.gson.Gson;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.fluent.Request;
import org.apache.http.client.fluent.Response;
import org.apache.http.client.utils.URIBuilder;
import org.apache.poi.util.IOUtils;
import org.json.JSONObject;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.ResourceAccessException;

@EloService
public class SrvRespostaDocumentosRedeSimImpl
extends SrvSolicitacaoAlvaraHelperImpl
implements SrvRespostaDocumentosRedeSim {
    private static final String HEADER_AUTH = "auth-token";
    private static final String API_IMPRESSAO = "/app/api/v1/integracao/imprimir-documento";
    private final String URL_IMPRESSAO_TAXAS = "<a class=\"linkTaxas\" onclick=\"window.open('%s', '_blank')\">%s</a>";
    @Resource
    private SrvSolicitacaoAlvara srvSolicitacaoAlvara;
    @Resource
    private RepositoryDocumentoAiseAlvara repositoryDocumentoAiseAlvara;
    @Resource
    private RepositoryUsuario repositoryUsuario;
    @Resource
    private SrvDebitosPortal srvDebitosPortal;
    @Resource
    private RepositoryDebito repositoryDebito;
    @Resource
    private RepositoryDocumentoAise repositoryDocumentoAise;
    @Resource
    private RepositoryArquivoDocumentoAlvara repositoryArquivoDocumentoAlvara;
    @Resource
    private RepositoryHistoricoExigenciaRedeSim repositoryHistoricoExigenciaRedeSim;
    @Resource
    private SrvSolicitacaoAlvaraRedeSim srvSolicitacaoAlvaraRedeSim;
    @Resource
    private SrvArquivoDocumentoAlvara srvArquivoDocumentoAlvara;
    @Resource
    private ImprimeDocumentoAlvara imprimeDocumentoAlvara;

    public JSONObject enviarTaxas(SolicitacaoRedeSimEntity solicitacaoRedeSim, SituacaoRespostaRedeSimEnum situacao, ImprimirTaxasAlvara taxasAlvara, boolean carne) throws BaseException {
        String url;
        UsuarioEntity usuario = this.repositoryUsuario.getUsuarioIntegraSGO();
        String userKey = this.srvDebitosPortal.loginWSTributosWeb(usuario.getUsuario(), usuario.getPassword());
        if (carne) {
            url = (String)SpringContext.getBean((String)"urlImprimirCarne", String.class);
            url = url + "uid=" + userKey + "&value=" + taxasAlvara.getCarne();
        } else {
            url = (String)SpringContext.getBean((String)"urlImprimirBloqueto", String.class);
            url = url + "uid=" + this.getUserKey() + "&value=" + taxasAlvara.getBloqueto() + "&exercicio=" + taxasAlvara.getExercicioBloqueto();
        }
        String impressao = carne ? "Carn\u00ea " + taxasAlvara.getCarne() + "/" + taxasAlvara.getExercicioCarne() : "Bloqueto " + taxasAlvara.getBloqueto() + "/" + taxasAlvara.getExercicioBloqueto();
        String urlImpressao = String.format("<a class=\"linkTaxas\" onclick=\"window.open('%s', '_blank')\">%s</a>", url, impressao);
        this.srvSolicitacaoAlvaraRedeSim.adicionarHistoricoDeAndamento(solicitacaoRedeSim, SituacaoConsultaPreviaRedeSimEnum.DEBITOS_GERADOS, Optional.of(urlImpressao), null);
        JSONObject jsonBody = this.montarBodyTaxas(solicitacaoRedeSim, situacao, url);
        String uri = this.getParametroAlvara(ParametroAlvaraEnum.URL_RESPOSTA_DOCUMENTOS_REDESIM).getValor();
        Dados_resposta dados = this.post(solicitacaoRedeSim.getProtocolo(), jsonBody, uri);
        Long idResposta = Optional.ofNullable(dados).filter(item -> Objects.nonNull(item.getId())).map(Dados_resposta::getId).map(Long::valueOf).orElse(null);
        this.srvSolicitacaoAlvaraRedeSim.adicionarHistoricoDeAndamento(solicitacaoRedeSim, SituacaoConsultaPreviaRedeSimEnum.DEBITOS_ENVIADOS, Optional.empty(), idResposta);
        return jsonBody;
    }

    public JSONObject enviarAnulacaoDocumento(SolicitacaoRedeSimEntity solicitacaoRedeSim, ModeloDocumentoRedeSimEnum modeloDocumento) throws BaseException {
        String uri = this.getParametroAlvara(ParametroAlvaraEnum.URL_RESPOSTA_DOCUMENTOS_REDESIM).getValor();
        JSONObject jsonBody = this.montarBodyAnulacao(solicitacaoRedeSim, SituacaoRespostaRedeSimEnum.ANULADO, modeloDocumento);
        this.post(solicitacaoRedeSim.getProtocolo(), jsonBody, uri);
        jsonBody = this.montarBodyAnulacao(solicitacaoRedeSim, SituacaoRespostaRedeSimEnum.EM_ANALISE, modeloDocumento);
        this.post(solicitacaoRedeSim.getProtocolo(), jsonBody, uri);
        return jsonBody;
    }

    public JSONObject enviaRespostaDocumentos(SolicitacaoRedeSimEntity solicitacaoRedeSim, SituacaoRespostaRedeSimEnum situacao, boolean enviaDam, List<DebitoEntity> listaDebitosSelecionadosParaEnvio) throws BaseException {
        if (Boolean.TRUE.equals(enviaDam) && !EloListUtils.safeIsEmpty(listaDebitosSelecionadosParaEnvio).booleanValue()) {
            this.srvSolicitacaoAlvaraRedeSim.adicionarHistoricoDeAndamento(solicitacaoRedeSim, SituacaoConsultaPreviaRedeSimEnum.DEBITOS_GERADOS, Optional.empty(), null);
        }
        JSONObject jsonBody = this.montarBody(solicitacaoRedeSim, situacao, enviaDam, listaDebitosSelecionadosParaEnvio);
        String uri = this.getParametroAlvara(ParametroAlvaraEnum.URL_RESPOSTA_DOCUMENTOS_REDESIM).getValor();
        Dados_resposta dados = this.post(solicitacaoRedeSim.getProtocolo(), jsonBody, uri);
        this.salvarHistoricoAndamentoComRespostaEnvio(solicitacaoRedeSim, situacao, enviaDam, listaDebitosSelecionadosParaEnvio, dados);
        return jsonBody;
    }

    public JSONObject enviaRespostaIndeferimentoRedeSim(SolicitacaoRedeSimEntity solicitacaoRedeSim, String observacaoIndeferimento) throws BaseException {
        JSONObject jsonBody = this.montarBodyIndeferimento(solicitacaoRedeSim, observacaoIndeferimento);
        String uri = this.getParametroAlvara(ParametroAlvaraEnum.URL_RESPOSTA_DOCUMENTOS_REDESIM).getValor();
        Dados_resposta dados = this.post(solicitacaoRedeSim.getProtocolo(), jsonBody, uri);
        this.salvarHistoricoAndamentoComRespostaEnvio(solicitacaoRedeSim, SituacaoRespostaRedeSimEnum.INDEFERIDO, false, null, dados);
        return jsonBody;
    }

    private JSONObject montarBodyIndeferimento(SolicitacaoRedeSimEntity solicitacaoRedeSim, String observacaoIndeferimento) throws SolicitacaoAlvaraRedeSimException {
        try {
            Controle controle = this.getControle();
            Dados_resposta dados_resposta = this.getDadosRespostaComum(solicitacaoRedeSim);
            dados_resposta.setCo_situacao(Integer.valueOf(SituacaoRespostaRedeSimEnum.INDEFERIDO.getCodigo()));
            dados_resposta.setNu_documento(solicitacaoRedeSim.getSolicitacaoAlvara().getNumeroAlvara() != null ? solicitacaoRedeSim.getSolicitacaoAlvara().getNumeroAlvara().toString() : null);
            dados_resposta.setDs_observacao(observacaoIndeferimento);
            dados_resposta.setCo_tipo_modelo_documento(ModeloDocumentoRedeSimEnum.ALVARA_LOCALIZACAO.getCodigo());
            RespostaDocumento resposta = new RespostaDocumento(controle, dados_resposta);
            Gson gson = new Gson();
            this.logger.info((Object)gson.toJson((Object)resposta));
            return EloJsonUtils.getJson((String)gson.toJson((Object)resposta));
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new SolicitacaoAlvaraRedeSimException(String.format("Ocorreu uma falha ao montar o Body de envio do indeferimento: %s", e.getMessage()), e.getCause());
        }
    }

    private void salvarHistoricoAndamentoComRespostaEnvio(SolicitacaoRedeSimEntity solicitacaoRedeSim, SituacaoRespostaRedeSimEnum situacao, boolean enviaDam, List<DebitoEntity> listaDebitosSelecionadosParaEnvio, Dados_resposta dados) throws BaseException {
        Long idResposta = Optional.ofNullable(dados).filter(item -> Objects.nonNull(item.getId())).map(Dados_resposta::getId).map(Long::valueOf).orElse(null);
        if (Boolean.TRUE.equals(enviaDam) && !EloListUtils.safeIsEmpty(listaDebitosSelecionadosParaEnvio).booleanValue()) {
            this.srvSolicitacaoAlvaraRedeSim.adicionarHistoricoDeAndamento(solicitacaoRedeSim, SituacaoConsultaPreviaRedeSimEnum.DEBITOS_ENVIADOS, Optional.empty(), idResposta);
        }
        switch (1.$SwitchMap$br$com$elotech$portalarrecadacao$enumerator$SituacaoRespostaRedeSimEnum[situacao.ordinal()]) {
            case 1: {
                if (solicitacaoRedeSim.getSolicitacaoAlvara().isGrauRiscoLiberdadeEconomica()) {
                    this.srvSolicitacaoAlvaraRedeSim.adicionarHistoricoDeAndamento(solicitacaoRedeSim, SituacaoConsultaPreviaRedeSimEnum.INSCRICAO_ENVIADA, Optional.of("Inscri\u00e7\u00e3o Municipal enviada para REDESIM - Liberdade Econ\u00f4mica"), idResposta);
                    break;
                }
                if (TipoAlvaraEnum.FUNCIONAMENTO_PROVISORIO.equals((Object)solicitacaoRedeSim.getAlvaraEnviado())) {
                    this.srvSolicitacaoAlvaraRedeSim.adicionarHistoricoDeAndamento(solicitacaoRedeSim, SituacaoConsultaPreviaRedeSimEnum.ALVARA_FUNCIONAMENTO_PROVISORIO_ENVIADO, Optional.of("Alvar\u00e1 Provis\u00f3rio enviado para o portal da REDESIM"), idResposta);
                    break;
                }
                this.srvSolicitacaoAlvaraRedeSim.adicionarHistoricoDeAndamento(solicitacaoRedeSim, SituacaoConsultaPreviaRedeSimEnum.ALVARA_ENVIADO, Optional.of("Alvar\u00e1 enviado para o portal da REDESIM"), idResposta);
                break;
            }
            case 2: {
                this.srvSolicitacaoAlvaraRedeSim.adicionarHistoricoDeAndamento(solicitacaoRedeSim, SituacaoConsultaPreviaRedeSimEnum.SUSPENSO, Optional.empty(), Long.valueOf(dados.getId().longValue()));
                break;
            }
            case 3: {
                this.srvSolicitacaoAlvaraRedeSim.adicionarHistoricoDeAndamento(solicitacaoRedeSim, SituacaoConsultaPreviaRedeSimEnum.ANULADO, Optional.empty(), Long.valueOf(dados.getId().longValue()));
                break;
            }
            case 4: {
                this.srvSolicitacaoAlvaraRedeSim.adicionarHistoricoDeAndamento(solicitacaoRedeSim, SituacaoConsultaPreviaRedeSimEnum.INDEFERIDO, Optional.empty(), Long.valueOf(dados.getId().longValue()));
            }
        }
    }

    private boolean isModoSimplificadoRiscoAlto(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        return this.getParametroAlvara(ParametroAlvaraEnum.INTEGRADO_REDESIM_SIMPLIFICADO).getValor().equals(SimNaoEnum.getSimShortText()) && solicitacao.isGrauRiscoAlto();
    }

    public JSONObject enviaRespostaDocumentos(SolicitacaoRedeSimEntity solicitacaoRedeSim, SituacaoRespostaRedeSimEnum situacao, List<HistoricoExigenciaRedeSimEntity> historicoExigenciaRedeSim, boolean enviaDam, List<DebitoEntity> listaDebitosSelecionadosParaEnvio) throws BaseException {
        if (Boolean.TRUE.equals(enviaDam) && !EloListUtils.safeIsEmpty(listaDebitosSelecionadosParaEnvio).booleanValue()) {
            this.srvSolicitacaoAlvaraRedeSim.adicionarHistoricoDeAndamento(solicitacaoRedeSim, SituacaoConsultaPreviaRedeSimEnum.DEBITOS_GERADOS, Optional.empty(), null);
        }
        JSONObject jsonBody = this.montarBody(solicitacaoRedeSim, situacao, historicoExigenciaRedeSim);
        String uri = this.getParametroAlvara(ParametroAlvaraEnum.URL_RESPOSTA_DOCUMENTOS_REDESIM).getValor();
        Dados_resposta dados = this.post(solicitacaoRedeSim.getProtocolo(), jsonBody, uri);
        if (SimNaoEnum.equalNao((String)this.getParametroAlvara(ParametroAlvaraEnum.MODO_TESTE_ENVIOS).getValor()).booleanValue()) {
            for (HistoricoExigenciaRedeSimEntity historico : historicoExigenciaRedeSim) {
                historico.setIdRespostaServico(Long.valueOf(dados.getId().longValue()));
            }
        }
        if (Boolean.TRUE.equals(enviaDam) && !EloListUtils.safeIsEmpty(listaDebitosSelecionadosParaEnvio).booleanValue()) {
            Long idResposta = Optional.ofNullable(dados).filter(item -> Objects.nonNull(item.getId())).map(Dados_resposta::getId).map(Long::valueOf).orElse(null);
            this.srvSolicitacaoAlvaraRedeSim.adicionarHistoricoDeAndamento(solicitacaoRedeSim, SituacaoConsultaPreviaRedeSimEnum.DEBITOS_ENVIADOS, Optional.empty(), idResposta);
        }
        return jsonBody;
    }

    protected JSONObject montarBody(SolicitacaoRedeSimEntity solicitacaoRedeSim, SituacaoRespostaRedeSimEnum situacao, List<HistoricoExigenciaRedeSimEntity> historicoExigenciaRedeSim) throws SolicitacaoAlvaraRedeSimException {
        try {
            Controle controle = this.getControle();
            Dados_resposta dados_resposta = this.getDadosRespostaComum(solicitacaoRedeSim);
            dados_resposta.setCo_situacao(Integer.valueOf(situacao.getCodigo()));
            ArrayList<Exigencia> listaExigencias = new ArrayList<Exigencia>();
            for (HistoricoExigenciaRedeSimEntity historico : historicoExigenciaRedeSim) {
                Exigencia exigencia = new Exigencia();
                exigencia.setCo_exigencia(Integer.valueOf(historico.getExigenciaRedeSim().getCodigo().intValue()));
                exigencia.setDs_motivo_exigencia(historico.getObservacoes());
                listaExigencias.add(exigencia);
            }
            dados_resposta.setExigencias(listaExigencias);
            if (!listaExigencias.isEmpty()) {
                dados_resposta.setCo_tipo_modelo_documento(ModeloDocumentoRedeSimEnum.ALVARA_LOCALIZACAO.getCodigo());
            }
            RespostaDocumento resposta = new RespostaDocumento(controle, dados_resposta);
            Gson gson = new Gson();
            this.logger.info((Object)gson.toJson((Object)resposta));
            return EloJsonUtils.getJson((String)gson.toJson((Object)resposta));
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new SolicitacaoAlvaraRedeSimException("Ocorreu uma falha ao montar o Body de envio ", e.getCause());
        }
    }

    private Controle getControle() throws NumberFormatException, BaseException {
        Controle controle = new Controle();
        int codOrgao = Integer.parseInt(this.getParametroAlvara(ParametroAlvaraEnum.COD_ORGAO_RESPOSTA_DOC_REDESIM).getValor());
        controle.setNu_identificador_orgao(Integer.valueOf(codOrgao));
        controle.setDs_orgao("Secretaria Municipal da Fazenda");
        return controle;
    }

    protected JSONObject montarBody(SolicitacaoRedeSimEntity solicitacaoRedeSim, SituacaoRespostaRedeSimEnum situacao, boolean enviaDam, List<DebitoEntity> listaDebitosSelecionadosParaEnvio) throws SolicitacaoAlvaraRedeSimException {
        try {
            Controle controle = this.getControle();
            Dados_resposta dados_resposta = this.getDadosRespostaComum(solicitacaoRedeSim);
            dados_resposta.setCo_situacao(Integer.valueOf(situacao.getCodigo()));
            dados_resposta.setNu_documento(solicitacaoRedeSim.getSolicitacaoAlvara().getNumeroAlvara() != null ? solicitacaoRedeSim.getSolicitacaoAlvara().getNumeroAlvara().toString() : null);
            if (SituacaoRespostaRedeSimEnum.EMITIDO.getCodigo().equals(situacao.getCodigo())) {
                if (Objects.nonNull(solicitacaoRedeSim.getSolicitacaoAlvara().getCadastroMobiliario().getDataValidadeAlvara())) {
                    String dataValidade = EloDateUtils.toAnsiDateString((Date)solicitacaoRedeSim.getSolicitacaoAlvara().getCadastroMobiliario().getDataValidadeAlvara(), (String)"yyyy-MM-dd' 'HH:mm:ss");
                    dados_resposta.setDt_validade(dataValidade);
                }
                this.montarLinkDocumento(solicitacaoRedeSim, dados_resposta);
            }
            if (enviaDam) {
                GuiaRecolhimentoEntity guiaDeTaxas = this.getGuiaRecolhimentoByTipoInscricao(solicitacaoRedeSim.getSolicitacaoAlvara());
                if (Objects.nonNull(guiaDeTaxas)) {
                    listaDebitosSelecionadosParaEnvio = listaDebitosSelecionadosParaEnvio.stream().filter(debito -> debito.getId().getGuiaRecolhimento().getGuiaRecolhimento().compareTo(guiaDeTaxas.getGuiaRecolhimento()) != 0).collect(Collectors.toList());
                }
                dados_resposta.setDs_url_dam_proprio(this.getUrlBloqueto(listaDebitosSelecionadosParaEnvio));
                dados_resposta.setCo_tipo_modelo_documento(ModeloDocumentoRedeSimEnum.ALVARA_LOCALIZACAO.getCodigo());
            }
            RespostaDocumento resposta = new RespostaDocumento(controle, dados_resposta);
            Gson gson = new Gson();
            this.logger.info((Object)gson.toJson((Object)resposta));
            return EloJsonUtils.getJson((String)gson.toJson((Object)resposta));
        }
        catch (BaseException | IOException | URISyntaxException e) {
            this.logger.error((Object)e.getMessage(), e);
            throw new SolicitacaoAlvaraRedeSimException(String.format("Ocorreu uma falha ao montar o Body de envio: %s", e.getMessage()), e.getCause());
        }
    }

    protected JSONObject montarBodyAnulacao(SolicitacaoRedeSimEntity solicitacaoRedeSim, SituacaoRespostaRedeSimEnum situacao, ModeloDocumentoRedeSimEnum modeloDocumento) throws SolicitacaoAlvaraRedeSimException {
        try {
            Controle controle = this.getControle();
            Dados_resposta dados_resposta = this.getDadosRespostaComum(solicitacaoRedeSim);
            dados_resposta.setCo_situacao(Integer.valueOf(situacao.getCodigo()));
            dados_resposta.setNu_documento(solicitacaoRedeSim.getSolicitacaoAlvara().getNumeroAlvara() != null ? solicitacaoRedeSim.getSolicitacaoAlvara().getNumeroAlvara().toString() : null);
            dados_resposta.setCo_tipo_modelo_documento(modeloDocumento.getCodigo());
            dados_resposta.setIs_retorno_documento(Boolean.TRUE.booleanValue());
            RespostaDocumento resposta = new RespostaDocumento(controle, dados_resposta);
            Gson gson = new Gson();
            this.logger.info((Object)gson.toJson((Object)resposta));
            return EloJsonUtils.getJson((String)gson.toJson((Object)resposta));
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new SolicitacaoAlvaraRedeSimException(String.format("Ocorreu uma falha ao montar o Body de envio: %s", e.getMessage()), (Throwable)e);
        }
    }

    private Boolean integracaoSimplificadaRedeSim() throws BaseException {
        return SimNaoEnum.equalSim((String)this.getParametroAlvaraNaoTrataValorNull(ParametroAlvaraEnum.INTEGRADO_REDESIM_SIMPLIFICADO).getValor());
    }

    private void montarLinkDocumento(SolicitacaoRedeSimEntity solicitacaoRedeSim, Dados_resposta dados_resposta) throws BaseException, URISyntaxException, ClientProtocolException, IOException {
        ArquivoDocumentoAlvaraEntity arquivoDocumentoAlvara;
        if (this.integracaoSimplificadaRedeSim().booleanValue()) {
            DocumentoAiseEntity alvara = this.repositoryDocumentoAise.getUltimoDocumentoEmitido(solicitacaoRedeSim.getSolicitacaoAlvara().getCadastroMobiliario().getId(), DocumentoTipoEnum.ALVARA_LOCALIZACAO.getCodigo());
            if (alvara == null) {
                throw new ValidacaoException("Cadastro mobili\u00e1rio n\u00e3o tem alvar\u00e1 para ser enviado para REDESIM");
            }
            dados_resposta.setNu_documento(String.valueOf(alvara.getId().getDocumento()));
            URI uri = this.imprimeDocumentoAlvara.getUrlDocumentoAlvara(String.valueOf(alvara.getId().getDocumento()), alvara.getId().getExercicio(), alvara.getId().getTipoDocumento().getTipoDocumento());
            Response response = Request.Get((URI)uri).execute();
            byte[] content = IOUtils.toByteArray((InputStream)response.returnResponse().getEntity().getContent());
            arquivoDocumentoAlvara = this.srvArquivoDocumentoAlvara.salvarArquivoAlvara(content, solicitacaoRedeSim.getSolicitacaoAlvara(), alvara);
        } else {
            arquivoDocumentoAlvara = this.repositoryArquivoDocumentoAlvara.buscarUltimoArquivoAlvaraPelaSolicitacao(solicitacaoRedeSim.getSolicitacaoAlvara());
        }
        dados_resposta.setDs_url(this.getUrlDocumentoAlvara(arquivoDocumentoAlvara));
    }

    private Dados_resposta getDadosRespostaComum(SolicitacaoRedeSimEntity solicitacaoRedeSim) throws BaseException {
        Dados_resposta dados_resposta = new Dados_resposta();
        dados_resposta.setCo_protocolo_redesim(solicitacaoRedeSim.getProtocolo());
        dados_resposta.setCo_processo_sistema_proprio(solicitacaoRedeSim.getSolicitacaoAlvara().getNumeroSolicitacaoExercicio());
        dados_resposta.setDt_resposta(EloDateUtils.toAnsiDateTimeString((Date)new Date()));
        dados_resposta.setIs_retorno_documento(Boolean.TRUE.booleanValue());
        if (solicitacaoRedeSim.getSolicitacaoAlvara().isGrauRiscoLiberdadeEconomica()) {
            if (!((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).existsSolicitacaoRedeSimWithSituacao(solicitacaoRedeSim.getProtocolo(), SituacaoConsultaPreviaRedeSimEnum.INSCRICAO_ENVIADA)) {
                dados_resposta.setCo_tipo_modelo_documento(ModeloDocumentoRedeSimEnum.INSCRICAO_MUNICIPAL.getCodigo());
            } else {
                dados_resposta.setCo_tipo_modelo_documento(ModeloDocumentoRedeSimEnum.ALVARA_LOCALIZACAO.getCodigo());
            }
        } else if (TipoAlvaraEnum.FUNCIONAMENTO_PROVISORIO.equals((Object)solicitacaoRedeSim.getAlvaraEnviado())) {
            dados_resposta.setCo_tipo_modelo_documento(ModeloDocumentoRedeSimEnum.ALVARA_FUNCIONAMENTO_PROVISORIO.getCodigo());
        } else {
            dados_resposta.setCo_tipo_modelo_documento(ModeloDocumentoRedeSimEnum.ALVARA_LOCALIZACAO.getCodigo());
        }
        return dados_resposta;
    }

    public String getUrlDocumentoAlvara(ArquivoDocumentoAlvaraEntity arquivoDocumentoAlvara) throws BaseException {
        try {
            if (arquivoDocumentoAlvara != null) {
                URIBuilder uri = new URIBuilder(this.getParametroAlvara(ParametroAlvaraEnum.URL_APLICACAO).getValor() + API_IMPRESSAO);
                uri.setParameter("token", JwtUtils.montarTokenJwtParaEnvioArquivoDoc((Long)arquivoDocumentoAlvara.getId()));
                return uri.build().toString();
            }
            throw new SolicitacaoAlvaraRedeSimException("N\u00e3o foi poss\u00edvel gerar a URL do documento, favor entre em contato com o suporte!");
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new SolicitacaoAlvaraRedeSimException("N\u00e3o foi poss\u00edvel gerar a URL do documento. " + e.getMessage(), (Throwable)e);
        }
    }

    public String getUrlDocumento(DocumentoAiseEntity documento, DocumentoTipoEnum tipoDocumento) throws SolicitacaoAlvaraRedeSimException {
        if (documento != null) {
            String urlImprimirDoc = (String)SpringContext.getBean((String)"urlImprimirDocumento", String.class);
            StringBuilder urlDoc = new StringBuilder();
            urlDoc.append(urlImprimirDoc).append("uid=").append(this.getUserKey()).append("&value=").append(documento.getId().getDocumento()).append("&valuetipo=").append(tipoDocumento.getCodigo().toString()).append("&valueexercicio=").append(documento.getId().getExercicio());
            return urlDoc.toString();
        }
        throw new SolicitacaoAlvaraRedeSimException("N\u00e3o foi poss\u00edvel gerar o documento de alvar\u00e1 ");
    }

    public String getUserKey() {
        UsuarioEntity usuarioAlvara = this.repositoryUsuario.getUsuarioIntegraSGO();
        return this.srvDebitosPortal.loginWSTributosWeb(usuarioAlvara.getUsuario(), usuarioAlvara.getPassword());
    }

    public Dados_resposta post(String protocolo, JSONObject body, String uri) throws BaseException {
        this.logger.info((Object)String.format("WS21 - Enviando resposta do documento, protocolo: %s -> %s -> %s", protocolo, body.toString(), uri));
        if (SimNaoEnum.equalSim((String)this.getParametroAlvara(ParametroAlvaraEnum.MODO_TESTE_ENVIOS).getValor()).booleanValue()) {
            this.logger.info((Object)"Modo de testes ativado, portanto, n\u00e3o vai enviar a resposta para RedeSim");
            return null;
        }
        try {
            RestRequestService restRequestService = new RestRequestService();
            HttpHeaders headers = new HttpHeaders();
            String token = this.getParametroAlvara(ParametroAlvaraEnum.SERVER_TOKEN_SOLICITACAO_REDESIM).getValor();
            headers.add(HEADER_AUTH, token);
            HttpEntity httpEntity = new HttpEntity((Object)body.toString(), (MultiValueMap)headers);
            ResponseEntity response = restRequestService.postWithBody(uri, httpEntity, String.class);
            int status = response.getStatusCode().value();
            if (status != HttpStatus.OK.value() && status != HttpStatus.CREATED.value()) {
                throw new DeferirRedeSimException(String.format("%s%s", "Ocorreu uma falha ao enviar requisi\u00e7\u00e3o: ", response.getStatusCode()));
            }
            return ((DadosRespostaWS21)EloJsonUtils.fromJson((String)((String)response.getBody()), DadosRespostaWS21.class)).getDados_resposta();
        }
        catch (ResourceAccessException e) {
            throw new RespostaRedeSimException(" N\u00e3o houve \u00eaxito ao enviar a resposta da consulta, provavelmente o Servidor da Rede Sim est\u00e1 fora do ar! Tente mais tarde!");
        }
        catch (HttpClientErrorException e) {
            RedeSimErrorMessage message = (RedeSimErrorMessage)EloJsonUtils.fromJson((String)e.getResponseBodyAsString(), RedeSimErrorMessage.class);
            throw new RespostaRedeSimException(message.getErro(), (Throwable)e);
        }
        catch (Exception e) {
            throw new RespostaRedeSimException(String.format("Ocorreu uma Falha ao enviar a resposta. %s", e.getMessage()), (Throwable)e);
        }
    }

    public String getUrlBloqueto(List<DebitoEntity> listaDebitosSelecionadosParaEnvio) throws BaseException {
        try {
            Integer idBloqueto = this.srvDebitosPortal.geraBloquetoAgrupado(listaDebitosSelecionadosParaEnvio);
            String urlImprimirBloqueto = (String)SpringContext.getBean((String)"urlImprimirBloqueto", String.class);
            return urlImprimirBloqueto + "uid=" + this.getUserKey() + "&value=" + idBloqueto + "&exercicio=" + this.getExercicio().toString();
        }
        catch (Exception e) {
            throw new GeraBloquetoException("Falha ao gerar o bloqueto - " + e.getMessage(), (Throwable)e);
        }
    }

    public JSONObject enviaRespostaDocumentoInscricaoMunicipal(SolicitacaoRedeSimEntity solicitacaoRedeSim, SituacaoRespostaRedeSimEnum situacao) throws BaseException {
        return this.sendDocumentoLiberdadeEconomica(solicitacaoRedeSim, this.getBodyDocumentoLiberdadeEconomica(solicitacaoRedeSim, situacao, ModeloDocumentoRedeSimEnum.INSCRICAO_MUNICIPAL));
    }

    public JSONObject sendRespostaDocumentoTermoDispensa(SolicitacaoRedeSimEntity solicitacaoRedeSim, SituacaoRespostaRedeSimEnum situacao) throws BaseException {
        return this.sendDocumentoLiberdadeEconomica(solicitacaoRedeSim, this.getBodyDocumentoLiberdadeEconomica(solicitacaoRedeSim, situacao, ModeloDocumentoRedeSimEnum.ALVARA_LOCALIZACAO));
    }

    private JSONObject sendDocumentoLiberdadeEconomica(SolicitacaoRedeSimEntity solicitacaoRedeSim, JSONObject bodyDocumentoLiberdadeEconomica) throws BaseException {
        String uri = this.getParametroAlvara(ParametroAlvaraEnum.URL_RESPOSTA_DOCUMENTOS_REDESIM).getValor();
        this.post(solicitacaoRedeSim.getProtocolo(), bodyDocumentoLiberdadeEconomica, uri);
        return bodyDocumentoLiberdadeEconomica;
    }

    private JSONObject getBodyDocumentoLiberdadeEconomica(SolicitacaoRedeSimEntity solicitacaoRedeSim, SituacaoRespostaRedeSimEnum situacao, ModeloDocumentoRedeSimEnum modeloDocumentoRedeSim) throws SolicitacaoAlvaraRedeSimException {
        try {
            Controle controle = this.getControle();
            Dados_resposta dados_resposta = this.getDadosRespostaComum(solicitacaoRedeSim);
            dados_resposta.setCo_situacao(Integer.valueOf(situacao.getCodigo()));
            dados_resposta.setCo_tipo_modelo_documento(modeloDocumentoRedeSim.getCodigo());
            Long tipoDocumentoLiberdadeEconomica = DocumentoTipoEnum.INSCRICAO_MUNICIPAL.getCodigo();
            if (ModeloDocumentoRedeSimEnum.ALVARA_LOCALIZACAO.equals((Object)modeloDocumentoRedeSim)) {
                tipoDocumentoLiberdadeEconomica = Long.valueOf(this.getParametroAlvara(ParametroAlvaraEnum.TIPODOCUMENTO_LIBERDADE_ECONOMICA).getValor());
            }
            DocumentoAiseEntity documento = this.repositoryDocumentoAise.getUltimoDocumentoEmitido(solicitacaoRedeSim.getSolicitacaoAlvara().getCadastroMobiliario().getId(), tipoDocumentoLiberdadeEconomica);
            String numeroDoc = String.valueOf(documento.getId().getDocumento());
            dados_resposta.setNu_documento(numeroDoc);
            this.montarLinkDocumento(solicitacaoRedeSim, dados_resposta);
            RespostaDocumento resposta = new RespostaDocumento(controle, dados_resposta);
            Gson gson = new Gson();
            this.logger.info((Object)gson.toJson((Object)resposta));
            return EloJsonUtils.getJson((String)gson.toJson((Object)resposta));
        }
        catch (BaseException | IOException | URISyntaxException e) {
            this.logger.error((Object)e.getMessage(), e);
            throw new SolicitacaoAlvaraRedeSimException("Ocorreu uma falha ao montar o Body de envio ", e.getCause());
        }
    }

    public JSONObject montarBodyTaxas(SolicitacaoRedeSimEntity solicitacaoRedeSim, SituacaoRespostaRedeSimEnum situacao, String url) throws SolicitacaoAlvaraRedeSimException {
        try {
            Controle controle = this.getControle();
            Dados_resposta dados_resposta = this.getDadosRespostaComum(solicitacaoRedeSim);
            dados_resposta.setCo_situacao(Integer.valueOf(situacao.getCodigo()));
            dados_resposta.setCo_tipo_modelo_documento(ModeloDocumentoRedeSimEnum.ALVARA_LOCALIZACAO.getCodigo());
            dados_resposta.setIs_retorno_documento(Boolean.TRUE.booleanValue());
            if (SituacaoRespostaRedeSimEnum.EMITIDO.getCodigo().equals(situacao.getCodigo())) {
                if (Objects.nonNull(solicitacaoRedeSim.getSolicitacaoAlvara().getCadastroMobiliario().getDataValidadeAlvara())) {
                    String dataValidade = EloDateUtils.toAnsiDateString((Date)solicitacaoRedeSim.getSolicitacaoAlvara().getCadastroMobiliario().getDataValidadeAlvara(), (String)"yyyy-MM-dd' 'HH:mm:ss");
                    dados_resposta.setDt_validade(dataValidade);
                }
                this.montarLinkDocumento(solicitacaoRedeSim, dados_resposta);
                dados_resposta.setNu_documento(solicitacaoRedeSim.getSolicitacaoAlvara().getNumeroAlvara().toString());
            } else {
                dados_resposta.setNu_documento(solicitacaoRedeSim.getSolicitacaoAlvara().getNumeroAlvara() != null ? solicitacaoRedeSim.getSolicitacaoAlvara().getNumeroAlvara().toString() : null);
            }
            dados_resposta.setDs_url_dam_proprio(url);
            RespostaDocumento resposta = new RespostaDocumento(controle, dados_resposta);
            Gson gson = new Gson();
            this.logger.info((Object)gson.toJson((Object)resposta));
            return EloJsonUtils.getJson((String)gson.toJson((Object)resposta));
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new SolicitacaoAlvaraRedeSimException("Erro ao montar o Body de envio de taxas - " + e.getMessage(), (Throwable)e);
        }
    }
}

