/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.service.impl;

import br.com.elotech.annotations.spring.EloService;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.portalarrecadacao.domain.IndeferimentoRedeSimEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoRedeSimEntity;
import br.com.elotech.portalarrecadacao.enumerator.ErroRespostaRedeSimEnum;
import br.com.elotech.portalarrecadacao.enumerator.ParametroAlvaraEnum;
import br.com.elotech.portalarrecadacao.exception.DeferimentoRedeSimSigFacilException;
import br.com.elotech.portalarrecadacao.exception.DeferirRedeSimException;
import br.com.elotech.portalarrecadacao.exception.IndeferimentoRedeSimSigFacilException;
import br.com.elotech.portalarrecadacao.exception.RespostaRedeSimException;
import br.com.elotech.portalarrecadacao.integration.dto.consulta.ConsultaPreviaRespostaDTO;
import br.com.elotech.portalarrecadacao.integration.dto.consulta.Controle;
import br.com.elotech.portalarrecadacao.integration.dto.consulta.DadosRespostaConsultaPrevia;
import br.com.elotech.portalarrecadacao.integration.dto.consulta.Mensagem;
import br.com.elotech.portalarrecadacao.repository.RepositoryConsultaRedeSim;
import br.com.elotech.portalarrecadacao.rest.response.Erro;
import br.com.elotech.portalarrecadacao.rest.response.RedeSimErrorMessage;
import br.com.elotech.portalarrecadacao.rest.service.RestRequestService;
import br.com.elotech.portalarrecadacao.service.SrvRedeSim;
import br.com.elotech.portalarrecadacao.service.impl.SrvSolicitacaoAlvaraHelperImpl;
import br.com.elotech.tributacao.enumerator.SimNaoEnum;
import br.com.elotech.util.date.EloDateUtils;
import br.com.elotech.util.json.EloJsonUtils;
import br.com.elotech.util.string.EloStringUtils;
import com.google.gson.Gson;
import java.util.Collections;
import java.util.Date;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Resource;
import org.json.JSONObject;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;

@EloService
public class SrvRespostaConsultaPreviaRedeSimImpl
extends SrvSolicitacaoAlvaraHelperImpl
implements SrvRedeSim {
    public static final int CO_TIPO_CONSULTA = 2;
    public static final int CO_SITUACAO_DEFERIDA = 2;
    public static final int CO_SITUACAO_INDEFERIDA = 3;
    private static final String HEADER_AUTH = "auth-token";
    private static final String MENSAGEM_ERRO_ENVIO_RESPOSTA_PADRAO = "N\u00e3o foi poss\u00edvel enviar a resposta para a REDESIM. Entre em contato com o suporte!";
    private static final String MENSAGEM_ERRO_NOVA_SITUACAO_NAO_PERMITIDA = "N\u00e3o foi poss\u00edvel enviar a resposta para a REDESIM. Nova situa\u00e7\u00e3o da Consulta n\u00e3o permitida. Consulta j\u00e1 respondida pelo Empresa F\u00e1cil.";
    private static final String MENSAGEM_ERRO_ORGAO_NAO_RESPONDE_CONSULTA = "N\u00e3o foi poss\u00edvel enviar a resposta para a REDESIM. \u00d3rg\u00e3o n\u00e3o responde a consulta pr\u00e9via.";
    @Resource
    private RepositoryConsultaRedeSim repositoryRedeSim;

    public ConsultaPreviaRespostaDTO enviaResposta(SolicitacaoRedeSimEntity solicitacao) throws BaseException {
        JSONObject jsonBody = this.montarBody(solicitacao);
        String uri = this.getParametroAlvara(ParametroAlvaraEnum.URL_RESPOSTA_CONSULTA_PREVIA_REDESIM).getValor();
        ConsultaPreviaRespostaDTO respostaConsulta = this.post(solicitacao.getProtocolo(), jsonBody, uri, SimNaoEnum.SIM.getShortText().equalsIgnoreCase(solicitacao.getIndeferido()));
        Optional.ofNullable(respostaConsulta).map(ConsultaPreviaRespostaDTO::getDados_resposta_consulta_previa).map(DadosRespostaConsultaPrevia::getId).ifPresent(arg_0 -> ((SolicitacaoRedeSimEntity)solicitacao).setIdRespostaConsulta(arg_0));
        this.repositoryRedeSim.saveOrUpdate(solicitacao);
        return respostaConsulta;
    }

    protected JSONObject montarBody(SolicitacaoRedeSimEntity solicitacao) throws BaseException {
        Controle controle = new Controle();
        DadosRespostaConsultaPrevia dadosRespostaconsultaPrevia = new DadosRespostaConsultaPrevia();
        Gson gson = new Gson();
        int codOrgao = Integer.parseInt(this.getParametroAlvara(ParametroAlvaraEnum.COD_ORGAO_RESPOSTA_REDESIM).getValor());
        controle.setNu_identificador_orgao(Integer.valueOf(codOrgao));
        controle.setDs_orgao("Secretaria Municipal da Fazenda");
        dadosRespostaconsultaPrevia.setCo_protocolo_redesim(solicitacao.getProtocolo());
        dadosRespostaconsultaPrevia.setDt_evento(EloDateUtils.toAnsiDateTimeString((Date)new Date()));
        dadosRespostaconsultaPrevia.setCo_tipo_consulta(Integer.valueOf(2));
        if (SimNaoEnum.SIM.getShortText().equalsIgnoreCase(solicitacao.getIndeferido())) {
            dadosRespostaconsultaPrevia.setDs_observacao(solicitacao.getMotivoIndeferimento());
            dadosRespostaconsultaPrevia.setCo_motivo_indeferimento(Integer.valueOf(((IndeferimentoRedeSimEntity)solicitacao.getIndeferimentos().stream().findFirst().get()).getCodigo().intValue()));
            dadosRespostaconsultaPrevia.setCo_situacao_consulta(Integer.valueOf(3));
        } else {
            dadosRespostaconsultaPrevia.setCo_situacao_consulta(Integer.valueOf(2));
            if (!EloStringUtils.isEmpty((String)solicitacao.getObservacao())) {
                dadosRespostaconsultaPrevia.setDs_observacao(solicitacao.getObservacao());
            }
        }
        Mensagem mensagem = new Mensagem(controle, dadosRespostaconsultaPrevia);
        return EloJsonUtils.getJson((String)gson.toJson((Object)mensagem));
    }

    public ConsultaPreviaRespostaDTO post(String protocolo, JSONObject body, String uri, boolean isIndeferido) throws BaseException {
        this.logger.info((Object)String.format("WS20 - Enviando resposta, protocolo: %s -> %s ", protocolo, body.toString()));
        if (SimNaoEnum.equalSim((String)this.getParametroAlvara(ParametroAlvaraEnum.MODO_TESTE_ENVIOS).getValor()).booleanValue()) {
            this.logger.info((Object)"Modo de testes ativado, portanto, n\u00e3o vai enviar a resposta para RedeSim");
            return null;
        }
        try {
            RestRequestService restRequestService = new RestRequestService();
            HttpHeaders headers = new HttpHeaders();
            String token = this.getParametroAlvara(ParametroAlvaraEnum.SERVER_TOKEN_CONSULTA_PREVIA_REDESIM).getValor();
            headers.add(HEADER_AUTH, token);
            HttpEntity httpEntity = new HttpEntity((Object)body.toString(), (MultiValueMap)headers);
            ResponseEntity response = restRequestService.postWithBody(uri, httpEntity, String.class);
            int status = response.getStatusCode().value();
            if (status != HttpStatus.OK.value() && status != HttpStatus.CREATED.value()) {
                throw new DeferirRedeSimException(String.format("%s%s", "Ocorreu uma falha ao enviar requisi\u00e7\u00e3o: ", response.getStatusCode()));
            }
            return (ConsultaPreviaRespostaDTO)EloJsonUtils.fromJson((String)((String)response.getBody()), ConsultaPreviaRespostaDTO.class);
        }
        catch (HttpClientErrorException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            if (HttpStatus.NOT_FOUND.equals((Object)e.getStatusCode())) {
                throw new RespostaRedeSimException(MENSAGEM_ERRO_ENVIO_RESPOSTA_PADRAO);
            }
            RedeSimErrorMessage message = (RedeSimErrorMessage)EloJsonUtils.fromJson((String)e.getResponseBodyAsString(), RedeSimErrorMessage.class);
            if (this.validateCodigoErroEnvioRespostaConsultaPrevia(message, ErroRespostaRedeSimEnum.WS20_NOVA_SITUACAO_NAO_PERMITIDA.getCodigo())) {
                if (isIndeferido) {
                    throw new IndeferimentoRedeSimSigFacilException(MENSAGEM_ERRO_NOVA_SITUACAO_NAO_PERMITIDA);
                }
                throw new DeferimentoRedeSimSigFacilException(MENSAGEM_ERRO_NOVA_SITUACAO_NAO_PERMITIDA);
            }
            if (this.validateCodigoErroEnvioRespostaConsultaPrevia(message, ErroRespostaRedeSimEnum.WS20_ORGAO_NAO_RESPONDE_CONSULTA.getCodigo())) {
                throw new RespostaRedeSimException(MENSAGEM_ERRO_ORGAO_NAO_RESPONDE_CONSULTA);
            }
            throw new RespostaRedeSimException(MENSAGEM_ERRO_ENVIO_RESPOSTA_PADRAO);
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new RespostaRedeSimException(MENSAGEM_ERRO_ENVIO_RESPOSTA_PADRAO);
        }
    }

    private boolean validateCodigoErroEnvioRespostaConsultaPrevia(RedeSimErrorMessage message, Long codigoErroVerificacao) {
        return Optional.ofNullable(message.getErros()).orElse(Collections.singletonList(new Erro())).stream().filter(Objects::nonNull).map(Erro::getCo_retorno).anyMatch(codigoErroVerificacao::equals);
    }
}

