/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.service.impl;

import br.com.elotech.annotations.spring.EloService;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.portalarrecadacao.controller.UtilsController;
import br.com.elotech.portalarrecadacao.domain.LaudoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.vo.ProcessoFiscalizacao;
import br.com.elotech.portalarrecadacao.enumerator.ParametroAlvaraEnum;
import br.com.elotech.portalarrecadacao.exception.ProcessoFiscalizacaoException;
import br.com.elotech.portalarrecadacao.factory.SrvFiscalizacaoFactory;
import br.com.elotech.portalarrecadacao.service.SrvFiscalizacao;
import br.com.elotech.portalarrecadacao.service.SrvProcessoFiscalizacao;
import br.com.elotech.portalarrecadacao.service.SrvSolicitacaoAlvara;
import br.com.elotech.tributacao.enumerator.SimNaoEnum;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Resource;

@EloService(value="srvProcessoFiscalizacao")
public class SrvProcessoFiscalizacaoImpl
implements SrvProcessoFiscalizacao {
    @Resource
    private SrvSolicitacaoAlvara srvSolicitacaoAlvara;
    @Resource
    private SrvFiscalizacaoFactory srvFiscalizacaoFactory;

    public List<ProcessoFiscalizacao> abrirProcesso(SolicitacaoAlvaraEntity solicitacao, Optional<Integer> idAssunto) throws BaseException, URISyntaxException {
        SrvFiscalizacao fiscalizacao = this.srvFiscalizacaoFactory.getFiscalizacaoInstance();
        List laudos = this.getLaudosIntegracaoEmAndamento(solicitacao);
        List processos = fiscalizacao.abrirProcesso(solicitacao, laudos, idAssunto);
        solicitacao.setProcessoGerado(SimNaoEnum.SIM.getShortText());
        this.srvSolicitacaoAlvara.atualizarSolicitacaoAlvara(solicitacao);
        fiscalizacao.salvarInformacoesProcesso(solicitacao, processos);
        return processos;
    }

    public List<LaudoAlvaraEntity> getLaudosIntegracaoEmAndamento(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        String tiposLaudosParam = UtilsController.getValorParametroAlvara((ParametroAlvaraEnum)ParametroAlvaraEnum.INTEGRACAO_FISCALIZACAO_TIPOS_LAUDOS);
        String[] tiposLaudos = tiposLaudosParam.split(",");
        ArrayList<LaudoAlvaraEntity> laudos = new ArrayList<LaudoAlvaraEntity>();
        for (String tipoLaudo : tiposLaudos) {
            Optional<LaudoAlvaraEntity> laudo = solicitacao.getLaudos().stream().filter(item -> item.getTipoLaudo().getCodigo() != null && item.getTipoLaudo().getCodigo().getValue().equals(tipoLaudo.trim())).findFirst();
            if (!laudo.isPresent()) continue;
            laudos.add(laudo.get());
        }
        if (laudos.isEmpty()) {
            throw new ProcessoFiscalizacaoException("Nenhum laudo encontrado para esta a\u00e7\u00e3o");
        }
        return laudos;
    }

    public void cancelar(SolicitacaoAlvaraEntity solicitacao, String motivo) throws BaseException {
        List laudos = this.getLaudosIntegracaoEmAndamento(solicitacao);
        SrvFiscalizacao fiscalizacao = this.srvFiscalizacaoFactory.getFiscalizacaoInstance();
        fiscalizacao.cancelarProcessoFiscalizacao(laudos, motivo);
    }
}

