/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.service.impl;

import br.com.elotech.annotations.spring.EloService;
import br.com.elotech.portalarrecadacao.domain.ParametroAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.ParametroAlvaraNaturezaEntity;
import br.com.elotech.portalarrecadacao.enumerator.ParametroAlvaraEnum;
import br.com.elotech.portalarrecadacao.exception.FiltroParametroException;
import br.com.elotech.portalarrecadacao.exception.ParametroNaoConfiguradoException;
import br.com.elotech.portalarrecadacao.exception.ParametroNaoEncontradoException;
import br.com.elotech.portalarrecadacao.filter.FiltroParametro;
import br.com.elotech.portalarrecadacao.repository.RepositoryParametroAlvara;
import br.com.elotech.portalarrecadacao.service.SrvParametroAlvara;
import br.com.elotech.tributacao.domain.aise.EntidadeTributacaoEntity;
import br.com.elotech.tributacao.repository.aise.RepositoryEntidadeTributacao;
import br.com.elotech.util.date.EloDateUtils;
import br.com.elotech.util.string.EloStringUtils;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;

@EloService
public class SrvParametroAlvaraImpl
implements SrvParametroAlvara {
    @Resource
    private RepositoryParametroAlvara repositoryParametroAlvara;
    @Resource
    private RepositoryEntidadeTributacao repositoryEntidadeTributacao;

    public List<ParametroAlvaraNaturezaEntity> carregarParametrosNaturezaPorFiltro(FiltroParametro filtroParametro) throws FiltroParametroException {
        return this.repositoryParametroAlvara.carregarParametrosNaturezaPorFiltro(filtroParametro);
    }

    public String getValorParametroAlvara(ParametroAlvaraEnum parametro) throws ParametroNaoEncontradoException, ParametroNaoConfiguradoException {
        ParametroAlvaraEntity parametroAlvara = this.repositoryParametroAlvara.getParametroAlvara(this.getEntidadeTributacao().getId().getEntidade(), parametro);
        if (Objects.isNull(parametroAlvara)) {
            throw new ParametroNaoEncontradoException(String.format("O par\u00e2metro %s n\u00e3o foi encontrado", parametro.name()));
        }
        if (EloStringUtils.isEmpty((String)parametroAlvara.getValor())) {
            throw new ParametroNaoConfiguradoException("O parametro " + parametroAlvara.getParametro().name() + " n\u00e3o est\u00e1 configurado. ");
        }
        return parametroAlvara.getValor();
    }

    public EntidadeTributacaoEntity getEntidadeTributacao() {
        return this.repositoryEntidadeTributacao.getExercicioAtual(Long.valueOf(EloDateUtils.getYear((Date)new Date())));
    }
}

