/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.service.impl;

import br.com.elotech.annotations.spring.EloService;
import br.com.elotech.exception.common.ValidacaoException;
import br.com.elotech.portalarrecadacao.domain.IndeferimentoRedeSimEntity;
import br.com.elotech.portalarrecadacao.domain.vo.FiltroIndeferimentoRedeSim;
import br.com.elotech.portalarrecadacao.repository.RepositoryIndeferimentoRedeSim;
import br.com.elotech.portalarrecadacao.service.SrvIndeferimentoRedeSim;
import java.util.List;
import javax.annotation.Resource;

@EloService(value="srvIndeferimentoRedeSim")
public class SrvIndeferimentoRedeSimImpl
implements SrvIndeferimentoRedeSim {
    @Resource
    private RepositoryIndeferimentoRedeSim repositoryIndeferimentoRedeSim;

    public void salvarMotivoIndeferimento(IndeferimentoRedeSimEntity motivoIndeferimento) throws ValidacaoException {
        motivoIndeferimento.validar();
        if (!motivoIndeferimento.getEdicao().booleanValue() && this.repositoryIndeferimentoRedeSim.existeCodigoIndeferimento(motivoIndeferimento).booleanValue()) {
            throw new ValidacaoException("O c\u00f3digo informado j\u00e1 existe.");
        }
        this.repositoryIndeferimentoRedeSim.saveOrUpdate(motivoIndeferimento);
    }

    public void removerMotivoIndeferimento(IndeferimentoRedeSimEntity motivoIndeferimento) {
        this.repositoryIndeferimentoRedeSim.remove(motivoIndeferimento);
    }

    public List<IndeferimentoRedeSimEntity> carregarListaMotivosIndeferimentoRedeSim(FiltroIndeferimentoRedeSim filtro) {
        return this.repositoryIndeferimentoRedeSim.carregarListaMotivosIndeferimentoRedeSim(filtro);
    }
}

